/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHForeignKey
extends ExportHandler {
    public EHForeignKey(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("FK_Name").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("Child_Table_Name").append(",");
        sb.append("Referred_Table_Name").append(",");
        sb.append("Engineer").append(",");
        sb.append("Delete_Rule").append(",");
        sb.append("Child_Table_ID").append(",");
        sb.append("Num_Child_Table_ID").append(",");
        sb.append("Referred_Table_ID").append(",");
        sb.append("Num_Referred_Table_ID").append(",");
        sb.append("Referred_Key_ID").append(",");
        sb.append("Num_Referred_Key_ID").append(",");
        sb.append("Number_Of_Columns");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getFKIndexAssociationSet().iterator();
            while (tit.hasNext()) {
                FKIndexAssociation fkIndex = (FKIndexAssociation)tit.next();
                if (fkIndex.getRemoteTable() != null && fkIndex.getContainerWithKeyObject() != null) {
                    sb = new StringBuffer();
                }
                sb.append(this.replaceAndQuoteString(fkIndex.getName())).append(",");
                sb.append(phDesign.getObjectID()).append(",");
                sb.append(phDesign.getNumID()).append(",");
                sb.append(fkIndex.getObjectID()).append(",");
                sb.append(fkIndex.getNumID()).append(",");
                sb.append(fkIndex.getImportedId() != null ? fkIndex.getImportedId() : EMPTY_STR).append(",");
                sb.append(fkIndex.getContainerWithKeyObject().getName()).append(",");
                sb.append(fkIndex.getRemoteTable().getName()).append(",");
                sb.append(fkIndex.getShouldEngineer() ? YES : NO).append(",");
                sb.append(fkIndex.getDeleteRule()).append(",");
                sb.append(fkIndex.getContainerWithKeyObject().getObjectID()).append(",");
                sb.append(fkIndex.getContainerWithKeyObject().getNumID()).append(",");
                sb.append(fkIndex.getRemoteTable().getObjectID()).append(",");
                sb.append(fkIndex.getRemoteTable().getNumID()).append(",");
                sb.append(fkIndex.getRemoteIndex().getObjectID()).append(",");
                sb.append(fkIndex.getRemoteIndex().getNumID()).append(",");
                sb.append(fkIndex.getRemoteIndex().getElements().length).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(fkIndex.getObjectID(), fkIndex.getNumID(), "ForeignKey", fkIndex.getNotes());
                this.getCsvExporter().addComment(fkIndex.getObjectID(), fkIndex.getNumID(), "ForeignKey", fkIndex.getComment());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_ForeignKeys.csv";
    }
}

