/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHEntity
extends ExportHandler {
    public EHEntity(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Entity_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("Number_Data_Elements").append(",");
        sb.append("Classification_Type").append(",");
        sb.append("Allow_Type_Substitution").append(",");
        sb.append("Min_Volume").append(",");
        sb.append("Expected_Volume").append(",");
        sb.append("Max_Volume").append(",");
        sb.append("Growth_Rate_Percents").append(",");
        sb.append("Growth_Rate_Interval").append(",");
        sb.append("Normal_Form").append(",");
        sb.append("Temporary_Object_Scope").append(",");
        sb.append("Adequately_Normalized").append(",");
        sb.append("Substitution_Parent").append(",");
        sb.append("Num_Substitution_Parent").append(",");
        sb.append("Synonyms").append(",");
        sb.append("Synonym_To_Display").append(",");
        sb.append("Preferred_Abbreviation").append(",");
        sb.append("SuperTypeEntity_ID").append(",");
        sb.append("Num_SuperTypeEntity_ID").append(",");
        sb.append("Engineering_Strategy").append(",");
        sb.append("Owner").append(",");
        sb.append("Entity_Source");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getEntitySet().iterator();
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(entity.getName())).append(",");
                sb.append(entity.getObjectID()).append(",");
                sb.append(entity.getNumID()).append(",");
                sb.append(entity.getImportedId() != null ? entity.getImportedId() : EMPTY_STR).append(",");
                sb.append(logDesign.getObjectID()).append(",");
                sb.append(logDesign.getNumID()).append(",");
                if (entity.isBST()) {
                    sb.append(entity.getBasedOnStructuredType().getObjectID()).append(",");
                    sb.append(entity.getBasedOnStructuredType().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(entity.getBasedOnStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(entity.getElements().length).append(",");
                sb.append(entity.getTypeID()).append(",");
                sb.append(entity.isAllowTypeSubstitution() ? YES : NO).append(",");
                sb.append(entity.getMinVolumes()).append(",");
                sb.append(entity.getExpectedVolumes()).append(",");
                sb.append(entity.getMaxVolumes()).append(",");
                sb.append(entity.getGrowthPercent()).append(",");
                sb.append(entity.getGrowthType()).append(",");
                sb.append(entity.getNormalForm()).append(",");
                sb.append(entity.getScope()).append(",");
                sb.append(entity.getAdequatelyNormalized().charAt(0)).append(",");
                if (entity.getTypeSubstitution() != null) {
                    sb.append(entity.getTypeSubstitution().getObjectID()).append(",");
                    sb.append(entity.getTypeSubstitution().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(this.quotedString(entity.getSynonym())).append(",");
                sb.append(entity.getSynonymToDisplay()).append(",");
                sb.append(entity.getPreferredAbbreviation()).append(",");
                if (entity.getHierarchicalParent() != null) {
                    sb.append(entity.getHierarchicalParent().getObjectID()).append(",");
                    sb.append(entity.getHierarchicalParent().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (entity.isHierarchicalEntityType()) {
                    sb.append(entity.getFwdEngineeringStrategyName()).append(",");
                } else {
                    sb.append("").append(",");
                }
                sb.append(entity.getOwner()).append(",");
                sb.append(entity.getSource()).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(entity.getObjectID(), entity.getNumID(), "Entity", entity.getNotes());
                this.getCsvExporter().addComment(entity.getObjectID(), entity.getNumID(), "Entity", entity.getComment());
                this.getCsvExporter().addCommentRDBMS(entity.getObjectID(), entity.getNumID(), "Entity", entity.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Entities.csv";
    }
}

