/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import oracle.ide.file.InvalidFileTableException;

final class DataBlock {
    static final int BLOCK_SIZE = 20;
    private static final int DATA_LENGTH = 21;
    private boolean dirty;
    private final byte[] data;
    private final int baseId;
    private int size;

    static DataBlock getInstance(int baseId) {
        return new DataBlock(null, baseId, 0);
    }

    static DataBlock getInstance(byte[] data, int baseId) {
        return new DataBlock(data, baseId, data.length / 21);
    }

    private DataBlock(byte[] data, int baseId, int size) {
        this.baseId = baseId;
        this.size = size;
        if (size == 20) {
            this.data = data;
        } else {
            this.data = new byte[420];
            if (size > 0) {
                System.arraycopy(data, 0, this.data, 0, data.length);
            }
        }
    }

    boolean isDirty() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    void add(int version, long lastModified, long length, boolean isNodeTimestamp) throws InvalidFileTableException {
        if (this.size >= 20) {
            throw new InvalidFileTableException("Data block already full");
        }
        int id = this.baseId + this.size++;
        this.setLastModified(id, version, lastModified, length, isNodeTimestamp);
    }

    int getVersion(int id) throws InvalidFileTableException {
        return this.getInt(this.getIndex(id));
    }

    long getLastModified(int id) throws InvalidFileTableException {
        return this.getLong(this.getIndex(id) + 4);
    }

    long getLength(int id) throws InvalidFileTableException {
        return this.getLong(this.getIndex(id) + 12);
    }

    boolean isNodeTimestamp(int id) throws InvalidFileTableException {
        return this.data[this.getIndex(id) + 20] == 1;
    }

    void setLastModified(int id, int version, long lastModified, long length, boolean isNodeTimestamp) throws InvalidFileTableException {
        this.dirty = true;
        int i = this.getIndex(id);
        this.putInt(i, version);
        this.putLong(i + 4, lastModified);
        this.putLong(i + 12, length);
        this.data[i + 20] = isNodeTimestamp ? (byte)1 : 0;
    }

    byte[] toByteArray() {
        if (this.size == 20) {
            return this.data;
        }
        byte[] copy = new byte[this.size * 21];
        System.arraycopy(this.data, 0, copy, 0, copy.length);
        return copy;
    }

    int getBaseId() {
        return this.baseId;
    }

    private int getIndex(int id) throws InvalidFileTableException {
        if (id < this.baseId) {
            throw new InvalidFileTableException("ID " + id + " is below base ID " + this.baseId);
        }
        int i = (id - this.baseId) * 21;
        if (i > this.data.length - 21) {
            throw new InvalidFileTableException("invalid id " + id);
        }
        return i;
    }

    private int getInt(int offset) {
        return ((this.data[offset + 3] & 0xFF) << 0) + ((this.data[offset + 2] & 0xFF) << 8) + ((this.data[offset + 1] & 0xFF) << 16) + (this.data[offset + 0] << 24);
    }

    private void putInt(int offset, int value) {
        this.data[offset + 3] = (byte)(value >>> 0);
        this.data[offset + 2] = (byte)(value >>> 8);
        this.data[offset + 1] = (byte)(value >>> 16);
        this.data[offset + 0] = (byte)(value >>> 24);
    }

    private long getLong(int offset) {
        return (((long)this.data[offset + 7] & 0xFFL) << 0) + (((long)this.data[offset + 6] & 0xFFL) << 8) + (((long)this.data[offset + 5] & 0xFFL) << 16) + (((long)this.data[offset + 4] & 0xFFL) << 24) + (((long)this.data[offset + 3] & 0xFFL) << 32) + (((long)this.data[offset + 2] & 0xFFL) << 40) + (((long)this.data[offset + 1] & 0xFFL) << 48) + ((long)this.data[offset + 0] << 56);
    }

    private void putLong(int offset, long value) {
        this.data[offset + 7] = (byte)(value >>> 0);
        this.data[offset + 6] = (byte)(value >>> 8);
        this.data[offset + 5] = (byte)(value >>> 16);
        this.data[offset + 4] = (byte)(value >>> 24);
        this.data[offset + 3] = (byte)(value >>> 32);
        this.data[offset + 2] = (byte)(value >>> 40);
        this.data[offset + 1] = (byte)(value >>> 48);
        this.data[offset + 0] = (byte)(value >>> 56);
    }
}

