/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.util.Collection;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.AbstractFileScope;
import oracle.ide.file.ContentSetKey;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.file.Path;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.WeakCache;

public final class ContentSetScope
extends AbstractFileScope {
    @GuardedBy(value="itself")
    private static final WeakCache<ContentSetKey, ContentSetScope> INSTANCES = new WeakCache();
    private final Workspace workspace;
    private final Project project;
    private final String contentSetKey;
    private WorkspaceObserver workspaceObserver;
    private ProjectObserver projectObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSetScope getInstance(Workspace workspace) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        WeakCache<ContentSetKey, ContentSetScope> weakCache = INSTANCES;
        synchronized (weakCache) {
            ContentSetKey key = ContentSetKey.getInstance(workspace);
            ContentSetScope scope = (ContentSetScope)INSTANCES.get((Object)key);
            if (scope == null) {
                scope = new ContentSetScope(workspace, null, null);
                INSTANCES.put((Object)key, (Object)scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSetScope getInstance(Workspace workspace, String contentSetKey) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (contentSetKey == null) {
            throw new NullArgumentException("null content set key");
        }
        WeakCache<ContentSetKey, ContentSetScope> weakCache = INSTANCES;
        synchronized (weakCache) {
            ContentSetKey key = ContentSetKey.getInstance(workspace, contentSetKey);
            ContentSetScope scope = (ContentSetScope)INSTANCES.get((Object)key);
            if (scope == null) {
                scope = new ContentSetScope(workspace, null, contentSetKey);
                INSTANCES.put((Object)key, (Object)scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSetScope getInstance(Workspace workspace, Project project) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        WeakCache<ContentSetKey, ContentSetScope> weakCache = INSTANCES;
        synchronized (weakCache) {
            ContentSetKey key = ContentSetKey.getInstance(workspace, project);
            ContentSetScope scope = (ContentSetScope)INSTANCES.get((Object)key);
            if (scope == null) {
                scope = new ContentSetScope(workspace, project, null);
                INSTANCES.put((Object)key, (Object)scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSetScope getInstance(Workspace workspace, Project project, String contentSetKey) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        if (contentSetKey == null) {
            throw new NullArgumentException("null content set key");
        }
        WeakCache<ContentSetKey, ContentSetScope> weakCache = INSTANCES;
        synchronized (weakCache) {
            ContentSetKey key = ContentSetKey.getInstance(workspace, project, contentSetKey);
            ContentSetScope scope = (ContentSetScope)INSTANCES.get((Object)key);
            if (scope == null) {
                scope = new ContentSetScope(workspace, project, contentSetKey);
                INSTANCES.put((Object)key, (Object)scope);
            }
            return scope;
        }
    }

    private ContentSetScope(Workspace workspace, Project project, String contentSetKey) {
        this.workspace = workspace;
        this.project = project;
        this.contentSetKey = contentSetKey;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Project getProject() {
        return this.project;
    }

    public ContentSet getContentSet() {
        if (this.project == null) {
            return this.contentSetKey == null ? ApplicationContent.getInstance((PropertyStorage)this.workspace).getAllContents() : ApplicationContent.getInstance((PropertyStorage)this.workspace).getContentSet(this.contentSetKey);
        }
        return this.contentSetKey == null ? ProjectContent.getInstance((PropertyStorage)this.project).getAllContents() : ContentSet.getInstance((PropertyStorage)this.project, (String)this.contentSetKey);
    }

    @Override
    protected void activate() {
        if (this.project == null) {
            this.workspaceObserver = new WorkspaceObserver();
            this.workspace.attach((Observer)this.workspaceObserver);
        } else {
            this.projectObserver = new ProjectObserver();
            if (this.contentSetKey == null) {
                this.project.attach((Observer)this.projectObserver);
            } else {
                Project.addProjectChangeListener((String)this.contentSetKey, (ProjectChangeListener)this.projectObserver);
            }
        }
    }

    @Override
    protected void deactivate() {
        if (this.workspaceObserver != null) {
            this.workspace.detach((Observer)this.workspaceObserver);
            this.workspaceObserver = null;
        }
        if (this.projectObserver != null) {
            if (this.contentSetKey == null) {
                this.project.detach((Observer)this.projectObserver);
            } else {
                Project.removeProjectChangeListener((String)this.contentSetKey, (ProjectChangeListener)this.projectObserver);
            }
            this.projectObserver = null;
        }
    }

    @Override
    protected Storage getStorage() {
        return Storages.getApplicationStorage((Workspace)this.workspace);
    }

    @Override
    protected Path getPath() {
        Collection<ContentSetRoot> roots = this.project == null ? ContentSetRoot.getContentSetRoots(this.workspace, this.getContentSet()) : ContentSetRoot.getContentSetRoots(this.project, this.getContentSet());
        Path path = Path.getInstance(roots.size());
        for (ContentSetRoot root : roots) {
            path.add(root.asFileSet());
        }
        return path;
    }

    private final class WorkspaceObserver
    implements Observer {
        private WorkspaceObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.PROPERTY_SET && change.containsProperty("contentProvidersPath")) {
                ContentSetScope.this.notifyPathChanged();
            }
        }
    }

    private final class ProjectObserver
    extends ProjectChangeListener
    implements Observer {
        private ProjectObserver() {
        }

        public final void projectPropertiesChanged(ProjectChangeEvent event) {
            ContentSetScope.this.notifyPathChanged();
        }

        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.PROPERTY_SET && change.containsProperty("contentProvidersPath")) {
                ContentSetScope.this.notifyPathChanged();
            }
        }
    }
}

