/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileSetFilters;
import oracle.ide.file.Path;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLKey;
import oracle.ide.util.PatternFilters;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;

public final class ContentSetRoot {
    private static final int CACHE_SIZE = 100;
    @GuardedBy(value="itself")
    private static final Map<ContentSetRoot, Integer> openProjectRoots = new HashMap<ContentSetRoot, Integer>();
    @GuardedBy(value="openProjectRoots")
    private static final Map<URLKey, Collection<ContentSetRoot>> cache = new Maps.CacheMap(100, Maps.CacheMap.NOT_CANONICAL);
    private final Project project;
    private final FileSet fileSet;

    public static Collection<ContentSetRoot> getContentSetRoots(@NotNull Workspace workspace) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        return ContentSetRoot.getContentSetRoots(workspace, ApplicationContent.getInstance((PropertyStorage)workspace).getAllContents());
    }

    public static Collection<ContentSetRoot> getContentSetRoots(@NotNull Workspace workspace, @NotNull ContentSet contentSet) {
        if (workspace == null) {
            throw new NullArgumentException("null workspace");
        }
        return ContentSetRoot.getContentSetRootsImpl(null, contentSet);
    }

    public static Collection<ContentSetRoot> getContentSetRoots(@NotNull Project project) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        return ContentSetRoot.getContentSetRoots(project, ProjectContent.getInstance((PropertyStorage)project).getAllContents());
    }

    public static Collection<ContentSetRoot> getContentSetRoots(@NotNull Project project, @NotNull ContentSet contentSet) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        if (contentSet == null) {
            throw new NullArgumentException("null content set");
        }
        return ContentSetRoot.getContentSetRootsImpl(project, contentSet);
    }

    private static Collection<ContentSetRoot> getContentSetRootsImpl(Project project, ContentSet contentSet) {
        ArrayList<ContentSetRoot> roots = new ArrayList<ContentSetRoot>();
        LinkedList<ContentSet> sets = new LinkedList<ContentSet>();
        sets.add(contentSet);
        while (!sets.isEmpty()) {
            ContentSet current = (ContentSet)sets.removeFirst();
            PatternFilters filters = current.getPatternFilters();
            for (URL url : current.getURLPath()) {
                roots.add(new ContentSetRoot(project, FileSet.getInstance(url, FileSetFilters.getFileSetFilter(filters))));
            }
            int count = current.countContentSets();
            for (int i = 0; i < count; ++i) {
                sets.add(current.getContentSet(i));
            }
        }
        roots.trimToSize();
        return Collections.unmodifiableList(roots);
    }

    public static Path asPath(Collection<ContentSetRoot> roots) {
        if (roots == null) {
            throw new NullArgumentException("null roots");
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>(roots.size());
        for (ContentSetRoot root : roots) {
            fileSets.add(root.asFileSet());
        }
        return Path.getInstance(fileSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addOpenProjectRoot(ContentSetRoot root) {
        Map<ContentSetRoot, Integer> map = openProjectRoots;
        synchronized (map) {
            Integer count = openProjectRoots.get(root);
            if (count != null) {
                openProjectRoots.put(root, count + 1);
            } else {
                openProjectRoots.put(root, 1);
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeOpenProjectRoot(ContentSetRoot root) {
        Map<ContentSetRoot, Integer> map = openProjectRoots;
        synchronized (map) {
            Integer count = openProjectRoots.get(root);
            if (count != null) {
                if (count == 1) {
                    openProjectRoots.remove(root);
                    cache.clear();
                } else {
                    openProjectRoots.put(root, count - 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ContentSetRoot> getContentSetRootsContaining(@NotNull URL url) {
        if (url == null) {
            throw new NullArgumentException("null url");
        }
        URLKey key = URLKey.getInstance((URL)url);
        Map<ContentSetRoot, Integer> map = openProjectRoots;
        synchronized (map) {
            Collection<ContentSetRoot> cachedRoots = cache.get(key);
            if (cachedRoots != null) {
                return cachedRoots;
            }
            ArrayList<ContentSetRoot> roots = new ArrayList<ContentSetRoot>();
            for (ContentSetRoot root : openProjectRoots.keySet()) {
                if (!root.contains(url)) continue;
                roots.add(root);
            }
            roots.trimToSize();
            cache.put(key, roots);
            return roots;
        }
    }

    public static Collection<ContentSetRoot> getContentSetRootsContaining(@NotNull Project project, @NotNull URL url) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        if (url == null) {
            throw new NullArgumentException("null url");
        }
        ArrayList<ContentSetRoot> roots = new ArrayList<ContentSetRoot>();
        for (ContentSetRoot root : ContentSetRoot.getContentSetRoots(project)) {
            if (!root.contains(url)) continue;
            roots.add(root);
        }
        return roots;
    }

    public static ContentSetRoot getInstance(Project project, FileSet fileSet) {
        return new ContentSetRoot(project, fileSet);
    }

    private ContentSetRoot(Project project, FileSet fileSet) {
        this.project = project;
        this.fileSet = fileSet;
    }

    public Project getProject() {
        return this.project;
    }

    public URL getURL() {
        return this.fileSet.getRoot();
    }

    public FileSetFilter getFilter() {
        return this.fileSet.getFilter();
    }

    public boolean contains(URL url) {
        return this.fileSet.contains(url);
    }

    public FileSet asFileSet() {
        return this.fileSet;
    }

    public int hashCode() {
        int hashCode = this.fileSet.hashCode();
        if (this.project != null) {
            hashCode = hashCode * 31 + this.project.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentSetRoot)) {
            return false;
        }
        ContentSetRoot other = (ContentSetRoot)object;
        return (this.project == null ? other.project == null : this.project.equals((Object)other.project)) && this.fileSet.equals(other.fileSet);
    }
}

