/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.naming.RefAddr;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.xml.bind.DatatypeConverter;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.DatabaseProviderFactory;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public abstract class ReferenceWorker {
    public static final String KEY = ReferenceWorker.class.getName();

    public RefAddr encrypt(String name, char[] value, String connectionName) {
        return new SecureRefAddr(name, value);
    }

    public char[] decrypt(RefAddr addr, String connectionName) {
        char[] retval = null;
        if (addr instanceof SecureRefAddr) {
            retval = ((SecureRefAddr)addr).getCharValue();
        }
        return retval;
    }

    public Class<? extends ObjectFactory> getFactoryClass() {
        return DatabaseProviderFactory1212.class;
    }

    public static ReferenceWorker createDefaultWorker(String key) {
        return new PBEWorker(key);
    }

    public static ReferenceWorker createLegacyWorker() {
        return new LegacyWorker();
    }

    private static class PBEWorker
    extends ReferenceWorker {
        private final AlgorithmParameterSpec m_paramSpec;
        private final SecretKey m_key;
        private Cipher m_encoder;
        private Cipher m_decoder;

        public PBEWorker(String passPhrase) {
            PBEParameterSpec paramSpec = null;
            SecretKey key = null;
            try {
                byte[] salt = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
                int iterationCount = 42;
                PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, 42);
                key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
                paramSpec = new PBEParameterSpec(salt, 42);
            }
            catch (Exception e) {
                DatabaseProviderHelper.getLogger().log(Level.SEVERE, "setup failure", e);
            }
            this.m_paramSpec = paramSpec;
            this.m_key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RefAddr encrypt(String name, char[] value, String connectionName) {
            String encStr = null;
            if (this.m_key != null) {
                try {
                    if (this.m_encoder == null) {
                        this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
                    }
                    String str = new String(value);
                    byte[] utf8 = str.getBytes("UTF8");
                    byte[] enc = this.m_encoder.doFinal(utf8);
                    Thread currentThread = Thread.currentThread();
                    ClassLoader oldCL = currentThread.getContextClassLoader();
                    try {
                        currentThread.setContextClassLoader(this.getClass().getClassLoader());
                        encStr = DatatypeConverter.printBase64Binary((byte[])enc);
                    }
                    finally {
                        currentThread.setContextClassLoader(oldCL);
                    }
                }
                catch (Exception e) {
                    Logger logger = DatabaseProviderHelper.getLogger();
                    String msg = "Password encryption failed for connection " + connectionName;
                    logger.severe(msg);
                    logger.log(Level.FINE, msg, e);
                    this.m_encoder = null;
                }
            }
            RefAddr retval = encStr == null ? super.encrypt(name, value, connectionName) : new StringRefAddr(name, encStr);
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] decrypt(RefAddr addr, String connectionName) {
            char[] retval = null;
            if (this.m_key != null && addr instanceof StringRefAddr) {
                try {
                    byte[] dec;
                    if (this.m_decoder == null) {
                        this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
                    }
                    Thread currentThread = Thread.currentThread();
                    ClassLoader oldCL = currentThread.getContextClassLoader();
                    try {
                        currentThread.setContextClassLoader(this.getClass().getClassLoader());
                        dec = DatatypeConverter.parseBase64Binary((String)((String)addr.getContent()));
                    }
                    finally {
                        currentThread.setContextClassLoader(oldCL);
                    }
                    byte[] utf8 = this.m_decoder.doFinal(dec);
                    retval = new String(utf8, "UTF8").toCharArray();
                }
                catch (Exception e) {
                    Logger logger = DatabaseProviderHelper.getLogger();
                    String msg = "Password decryption failed for connection " + connectionName;
                    logger.severe(msg);
                    logger.log(Level.FINE, msg, e);
                    this.m_decoder = null;
                }
            }
            if (retval == null) {
                return super.decrypt(addr, connectionName);
            }
            return retval;
        }
    }

    private static class LegacyWorker
    extends ReferenceWorker {
        private LegacyWorker() {
        }

        @Override
        public Class<? extends ObjectFactory> getFactoryClass() {
            return DatabaseProviderFactory.class;
        }

        @Override
        public char[] decrypt(RefAddr addr, String connectionName) {
            String str;
            char[] retval = addr instanceof StringRefAddr ? ((str = DatabaseProviderHelper.comingIn((String)addr.getContent())) == null ? null : str.toCharArray()) : super.decrypt(addr, connectionName);
            return retval;
        }

        @Override
        public RefAddr encrypt(String name, char[] value, String connectionName) {
            return new StringRefAddr(name, DatabaseProviderHelper.goingOut(new String(value)));
        }
    }
}

