/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.ssh.SSHConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnelConfiguration;
import oracle.jdeveloper.db.ssh.SSHTunnelException;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class MySQLConnectionCreator
extends AbstractConnectionCreator
implements SSHConnectionCreator {
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String SUBTYPE_MYSQL = "MYSQL";

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    @Override
    public Connection getConnection(Properties props) throws SQLException {
        return super.getConnection(props);
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return MYSQL_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String retval;
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            retval = customURL;
        } else {
            String hostname = this.getPropertyOrThrow(props, "hostname");
            String port = props.getProperty("port");
            String dbase = this.getPropertyOrThrow(props, "dataSourceName");
            StringBuilder url = new StringBuilder("jdbc:mysql://");
            url.append(hostname);
            if (port != null) {
                url.append(':').append(port);
            }
            url.append('/').append(dbase);
            retval = url.toString();
        }
        return retval;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add("hostname");
        retval.add("port");
        retval.add("dataSourceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("hostname");
        retval.add("dataSourceName");
        return retval;
    }

    @Override
    public SSHTunnelConfiguration getConfiguration(DatabaseProvider pro) throws SQLException {
        SSHTunnelConfiguration retval;
        Pattern simplePattern;
        Matcher m;
        String url = pro.getConnectionURL();
        Pattern portlessPattern = Pattern.compile("(?i)jdbc:mysql://([^,:\\s]+)/.*");
        Matcher m2 = portlessPattern.matcher(url);
        if (m2.matches()) {
            url = url.substring(0, m2.end(1)) + ":3306" + url.substring(m2.end(1));
        }
        if ((m = (simplePattern = Pattern.compile("(?i)jdbc:mysql://([^,:\\s]+):([0-9]+)/.*")).matcher(url)).matches()) {
            retval = SSHTunnelConfiguration.createFromMatcher(url, m, 1, 2);
        } else if (url.toLowerCase().startsWith("jdbc:mysql://address=(")) {
            retval = SSHTunnelConfiguration.parseAddressSyntax(url);
        } else {
            throw new SSHTunnelException(DBAdapterBundle.get("SSH_URL_PARSE_FAILED"));
        }
        return retval;
    }
}

