/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;

public class DerbyConnectionCreator
extends AbstractConnectionCreator {
    public static final String DERBY_EMBEDDED_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DERBY_CLIENT_DRIVER_CLASS = "org.apache.derby.jdbc.ClientDriver";
    public static final String SUBTYPE_DERBY = "derby";
    public static final String SUBPROTOCOL_CLASS_REFTYPE = "subprotocol";

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String retval = super.getDriverClassName(props);
        if (!this.hasLength(retval)) {
            retval = DERBY_EMBEDDED_DRIVER_CLASS;
        }
        return retval;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String retval = super.getConnectionURL(props);
        if (!this.hasLength(retval)) {
            StringBuilder buff = new StringBuilder("jdbc:derby:");
            if (DERBY_CLIENT_DRIVER_CLASS.equals(this.getDriverClassName(props))) {
                buff.append("//").append(this.getPropertyOrThrow(props, "hostname"));
                String port = props.getProperty("port");
                if (this.hasLength(port)) {
                    buff.append(":").append(port);
                }
                buff.append("/");
            } else {
                String subprotocol = props.getProperty(SUBPROTOCOL_CLASS_REFTYPE);
                if (this.hasLength(subprotocol)) {
                    try {
                        DerbySubprotocol.valueOf(subprotocol);
                        buff.append(subprotocol).append(":");
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SQLException(iae.getMessage());
                    }
                }
            }
            String databaseName = this.getPropertyOrThrow(props, "dataSourceName");
            buff.append(databaseName);
            retval = buff.toString();
        }
        return retval;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add(SUBPROTOCOL_CLASS_REFTYPE);
        retval.add("dataSourceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        return Collections.singleton("dataSourceName");
    }

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    @Override
    public Collection<JDBCParameterInfo> listJDBCParameterInfos(Properties connectionProps) throws SQLException {
        ArrayList<JDBCParameterInfo> retval = new ArrayList<JDBCParameterInfo>();
        retval.add(new JDBCParameterInfo("bootPassword", null));
        retval.add(new JDBCParameterInfo("collation", null));
        retval.add(new JDBCParameterInfo("create", "true"));
        retval.add(new JDBCParameterInfo("createFrom", null));
        retval.add(new JDBCParameterInfo("dataEncryption", "true"));
        retval.add(new JDBCParameterInfo("drop", "true"));
        retval.add(new JDBCParameterInfo("encryptionKey", null));
        retval.add(new JDBCParameterInfo("encryptionProvider", null));
        retval.add(new JDBCParameterInfo("encryptionAlgorithm", null));
        retval.add(new JDBCParameterInfo("failover", "true"));
        retval.add(new JDBCParameterInfo("logDevice", null));
        retval.add(new JDBCParameterInfo("newEncryptionKey", null));
        retval.add(new JDBCParameterInfo("newBootPassword", null));
        retval.add(new JDBCParameterInfo("restoreFrom", null));
        retval.add(new JDBCParameterInfo("rollForwardRecoveryFrom", null));
        retval.add(new JDBCParameterInfo("securityMechanism", null));
        retval.add(new JDBCParameterInfo("shutdown", "true"));
        retval.add(new JDBCParameterInfo("slaveHost", null));
        retval.add(new JDBCParameterInfo("slavePort", null));
        retval.add(new JDBCParameterInfo("ssl", null));
        retval.add(new JDBCParameterInfo("startMaster", "true"));
        retval.add(new JDBCParameterInfo("startSlave", "true"));
        retval.add(new JDBCParameterInfo("stopMaster", "true"));
        retval.add(new JDBCParameterInfo("stopSlave", "true"));
        retval.add(new JDBCParameterInfo("territory", null));
        retval.add(new JDBCParameterInfo("traceDirectory", null));
        retval.add(new JDBCParameterInfo("traceFile", null));
        retval.add(new JDBCParameterInfo("traceFileAppend", "true"));
        retval.add(new JDBCParameterInfo("traceLevel", null));
        retval.add(new JDBCParameterInfo("upgrade", "true"));
        return retval;
    }

    public static enum DerbySubprotocol {
        directory,
        memory,
        classpath,
        jar;

    }
}

