/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;

class XQPrintDriver
extends XMLPrintDriver {
    XQPrintDriver(PrintWriter printWriter) {
        super(printWriter);
    }

    public final void printNode(XMLNode xMLNode) throws IOException {
        switch (xMLNode.getNodeType()) {
            case 1: {
                this.printTopElement((XMLElement)xMLNode);
                break;
            }
            case 9: {
                this.printDocument((XMLDocument)xMLNode);
                break;
            }
            case 11: {
                this.printDocumentFragment((XMLDocumentFragment)xMLNode);
                break;
            }
            case 3: {
                this.printTextNode((XMLText)xMLNode);
                break;
            }
            case 8: {
                this.printComment((XMLComment)xMLNode);
                break;
            }
            case 4: {
                this.printCDATASection((XMLCDATA)xMLNode);
                break;
            }
            case 7: {
                this.printProcessingInstruction((XMLPI)xMLNode);
                break;
            }
            case 2: {
                this.printAttribute((XMLAttr)xMLNode);
                break;
            }
        }
    }

    public void printTopElement(XMLElement xMLElement) throws IOException {
        boolean bl = true;
        boolean bl2 = this.out.isMixed();
        int n = this.out.getOutputStyle();
        int n2 = this.nsVector.size();
        int n3 = this.prefixCount;
        this.prevSize = n2;
        this.nsDeclToPrint.clear();
        this.out.writeIndent();
        this.out.writeChars("<");
        this.getNSDecls(xMLElement);
        String string = xMLElement.getNodePrefix();
        String string2 = xMLElement.getNamespace();
        string = this.checkConflicts(string, string2, true);
        if (string == null) {
            this.out.writeChars(xMLElement.getNodeName());
        } else {
            if (!string.equals("")) {
                this.out.writeChars(string);
                this.out.write(58);
            }
            this.out.writeChars(xMLElement.getNodeLocalName());
        }
        if (xMLElement.hasAttributes()) {
            this.printAttributeNodes(xMLElement);
        }
        this.printNsDecls(xMLElement);
        if (xMLElement.hasChildNodes()) {
            this.out.writeChars(">");
            bl = false;
            if (xMLElement.isNodeFlag(65536)) {
                this.out.setMixed(true);
            } else if (!xMLElement.isNodeFlag(131072)) {
                for (XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                    short s = xMLNode.getNodeType();
                    if (s != 3 && s != 5) continue;
                    this.out.setMixed(true);
                    break;
                }
            }
            this.out.writeNewLine();
            this.out.addIndent(1);
            this.printChildNodes((XMLNode)xMLElement);
            this.out.addIndent(-1);
            this.out.writeIndent();
            this.out.setMixed(bl2);
        }
        if (bl) {
            this.out.writeChars("/>");
        } else {
            this.out.writeChars("</");
            if (string == null) {
                this.out.writeChars(xMLElement.getNodeName());
            } else {
                if (!string.equals("")) {
                    this.out.writeChars(string);
                    this.out.write(58);
                }
                this.out.writeChars(xMLElement.getNodeLocalName());
            }
            this.out.writeChars(">");
        }
        this.out.writeNewLine();
        this.out.setOutputStyle(n);
        this.out.flush();
        this.prefixCount = n3;
        this.nsVector.setSize(n2);
        this.prefixVector.setSize(n2);
    }

    private void getNSDecls(XMLElement xMLElement) throws IOException {
        this.scanNSDecls(xMLElement, false);
        for (Node node = xMLElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1) continue;
            this.scanNSDecls((XMLElement)node, true);
        }
    }

    private void scanNSDecls(XMLElement xMLElement, boolean bl) throws IOException {
        String string;
        String string2;
        if (bl) {
            string2 = xMLElement.getPrefix();
            string = xMLElement.getNamespaceURI();
            if (string != null && !string.equals("")) {
                this.addNsDeclPrinted(string2 == null ? "" : string2, string);
            }
        }
        for (string2 = (XMLAttr)xMLElement.getFirstAttribute(); string2 != null; string2 = string2.getNextAttribute()) {
            if (!string2.isNodeFlag(262144)) continue;
            string = string2.getNodePrefix();
            String string3 = string2.getLocalName();
            if ("xmlns".equals(string)) {
                this.addNsDeclPrinted(string3, string2.getNodeValue());
                continue;
            }
            this.addNsDeclPrinted("", string2.getNodeValue());
        }
    }

    protected void addNsDeclPrinted(String string, String string2) throws IOException {
        String string3 = (String)this.nsDeclToPrint.get(string);
        if (string3 == null) {
            this.prefixVector.addElement(string);
            this.nsVector.addElement(string2);
            this.nsDeclToPrint.put(string, string2);
        }
    }
}

