/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.HashMap;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.ParserUtil;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLElem
extends Expr {
    Expr elemNameExpr;
    private String elemName;
    private String elemNamespaceURI;
    HashMap namespaceHT;
    String defaultNamespaceURI;
    private byte type;
    public static final byte DIRECT_ELEMENT_CONSTRUCTOR = 1;
    public static final byte COMPUTED_ELEMENT_CONSTRUCTOR = 2;

    public XMLElem(byte by, String string, Expr[] exprArray, HashMap hashMap, String string2) {
        super(exprArray);
        this.type = by;
        this.elemName = string;
        this.namespaceHT = hashMap;
        this.defaultNamespaceURI = string2;
    }

    public XMLElem(byte by, Expr expr, Expr[] exprArray, HashMap hashMap, String string) {
        super(exprArray);
        this.type = by;
        this.elemNameExpr = expr;
        this.namespaceHT = hashMap;
        this.defaultNamespaceURI = string;
    }

    public XMLElem() {
    }

    public void setElementName(String string) {
        this.elemName = string;
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = this.type == 1 ? (XMLElement)XMLElem.getDoc().createElement("DirectXMLElem") : (XMLElement)XMLElem.getDoc().createElement("ComputedXMLElem");
        if (this.elemName != null) {
            xMLElement.setAttribute("name", this.elemName);
        }
        if (this.elemNameExpr != null) {
            xMLElement.appendChild((Node)ConvertXMLUtils.toXMLAndTag(XMLElem.getDoc(), this.elemNameExpr, "tagname"));
        }
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        this.elemName = xMLElement.getAttribute("name");
        this.elemNameExpr = (Expr)ConvertXMLUtils.fromXMLUntag(xMLElement, "tagname");
        this.fromXMLKids(xMLElement);
        return this;
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        if (this.elemNameExpr != null) {
            throw new XQException("tag expressions not implemented");
        }
        if (this.elemName != null) {
            boolean bl = false;
            boolean bl2 = false;
            xQXGen.startElement("xmlElem");
            xQXGen.startElement("xmlElemName");
            xQXGen.characters(this.elemName);
            xQXGen.endElement("xmlElemName");
        } else {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "xmlconcat"));
            this.toSqlDefault(xQXGen);
            xQXGen.endElement("function");
        }
    }

    @Override
    public Expr normalize() {
        if (this.elemNameExpr != null) {
            this.elemNameExpr = this.elemNameExpr.normalize();
        }
        return super.normalize();
    }

    @Override
    public Expr optimize(OptimizeContext optimizeContext) {
        if (this.elemNameExpr != null) {
            this.elemNameExpr = this.elemNameExpr.optimize(optimizeContext);
        }
        return super.optimize(optimizeContext);
    }

    private void normalizeLiteral(QueryState queryState) {
        Expr[] exprArray = new Expr[this.kids.length];
        int n = 0;
        for (int i = 0; i < this.kids.length; ++i) {
            boolean bl = false;
            if (this.kids[i] instanceof ConstantExpr && ((ConstantExpr)this.kids[i]).getDatatype() == 1) {
                String string = ((ConstantExpr)this.kids[i]).getValue();
                if (!queryState.getWhiteSpacePreserve() && string.trim().length() == 0) continue;
                try {
                    string = ParserUtil.resolveEntityRefAndCharRef(string);
                }
                catch (Exception exception) {
                    throw new XQException(queryState.getMesg().getMessage0("XPST0003"), exception.getMessage());
                }
                this.kids[i] = new ConstantExpr(string);
                bl = true;
            } else {
                bl = true;
            }
            if (!bl) continue;
            exprArray[n++] = this.kids[i];
        }
        if (n == this.kids.length) {
            return;
        }
        this.kids = new Expr[n];
        System.arraycopy(exprArray, 0, this.kids, 0, n);
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        if (this.type == 2) {
            return this.EvalCompCons(queryState);
        }
        return this.EvalDirectCons(queryState);
    }

    private OXMLSequence EvalDirectCons(QueryState queryState) {
        OXMLItem oXMLItem;
        boolean bl = false;
        XMLDocument xMLDocument = new XMLDocument();
        xMLDocument.setDocumentURI(queryState.getBaseURI());
        if (this.namespaceHT != null) {
            queryState.pushNamespaceHT(this.namespaceHT);
        }
        if (this.defaultNamespaceURI != null) {
            queryState.pushDefaultElemNS(this.defaultNamespaceURI);
        }
        XMLElement xMLElement = this.createElement(xMLDocument, queryState);
        if (this.kids != null) {
            this.normalizeLiteral(queryState);
            XMLNode xMLNode = null;
            Text text = null;
            boolean bl2 = false;
            for (int i = 0; i < this.kids.length; ++i) {
                bl2 = false;
                oXMLItem = this.kids[i].Evaluate(queryState);
                while (oXMLItem.next()) {
                    OXMLItem oXMLItem2 = oXMLItem.getItem();
                    if (oXMLItem2.getPrimitiveType() == 90) {
                        xMLNode = oXMLItem2.getNode();
                        short s = xMLNode.getNodeType();
                        if (s == 2) {
                            if (bl) {
                                throw new XQException(queryState.getMesg().getMessage0("XQTY0024"));
                            }
                        } else {
                            bl = true;
                        }
                        if (text != null) {
                            xMLElement.appendChild(text);
                            text = null;
                        }
                        this.addNodeToElement(xMLDocument, xMLNode, xMLElement, queryState.isPreserveMode());
                    } else {
                        bl = true;
                        OXMLItem oXMLItem3 = queryState.createItem();
                        oXMLItem3.copyItem(oXMLItem2);
                        XQueryUtils.convert(oXMLItem3, OXMLSequenceType.TSTRING);
                        String string = oXMLItem3.getString();
                        if (text == null) {
                            text = xMLDocument.createTextNode(string);
                        } else if (bl2) {
                            text.appendData(" " + string);
                        } else {
                            text.appendData(string);
                        }
                    }
                    bl2 = true;
                }
            }
            if (text != null) {
                xMLElement.appendChild(text);
            }
        }
        if (this.namespaceHT != null) {
            queryState.popNamespaceHT();
        }
        if (this.defaultNamespaceURI != null) {
            queryState.popDefaultElemNS();
        }
        XQueryUtils.normalizeText((XMLNode)xMLElement);
        oXMLItem = queryState.createItem();
        this.setNode(queryState, xMLElement, oXMLItem);
        return queryState.createSequence(oXMLItem);
    }

    private OXMLSequence EvalCompCons(QueryState queryState) {
        Text text = null;
        boolean bl = false;
        XMLDocument xMLDocument = new XMLDocument();
        xMLDocument.setDocumentURI(queryState.getBaseURI());
        if (this.namespaceHT != null) {
            queryState.pushNamespaceHT(this.namespaceHT);
        }
        XMLElement xMLElement = this.createElement(xMLDocument, queryState);
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                OXMLSequence oXMLSequence = this.kids[i].Evaluate(queryState);
                while (oXMLSequence.next()) {
                    OXMLItem oXMLItem = oXMLSequence.getItem();
                    if (oXMLItem.getPrimitiveType() == 90) {
                        XMLNode xMLNode = oXMLItem.getNode();
                        if (bl && xMLNode.getNodeType() == 2) {
                            throw new XQException(queryState.getMesg().getMessage0("XQTY0024"));
                        }
                        if (!bl && xMLNode.getNodeType() != 2) {
                            bl = true;
                        }
                        if (text != null) {
                            xMLElement.appendChild(text);
                            text = null;
                        }
                        this.addNodeToElement(xMLDocument, xMLNode, xMLElement, queryState.isPreserveMode());
                        continue;
                    }
                    bl = true;
                    OXMLItem oXMLItem2 = queryState.createItem();
                    oXMLItem2.copyItem(oXMLItem);
                    XQueryUtils.convert(oXMLItem2, OXMLSequenceType.TSTRING);
                    String string = oXMLItem2.getString();
                    if (text == null) {
                        text = xMLDocument.createTextNode(string);
                        continue;
                    }
                    text.appendData(" " + string);
                }
                if (text == null) continue;
                xMLElement.appendChild(text);
            }
        }
        if (this.namespaceHT != null) {
            queryState.popNamespaceHT();
        }
        XQueryUtils.normalizeText((XMLNode)xMLElement);
        OXMLItem oXMLItem = queryState.createItem();
        this.setNode(queryState, xMLElement, oXMLItem);
        return queryState.createSequence(oXMLItem);
    }

    private void setNode(QueryState queryState, XMLElement xMLElement, OXMLItem oXMLItem) {
        if (queryState.isPreserveMode()) {
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)xMLElement.getQName(), null, (int)1, (boolean)false, (int)1);
            oXMLItem.setNode(oXMLSequenceType, (XMLNode)xMLElement);
        } else {
            oXMLItem.setNode((XMLNode)xMLElement);
        }
    }

    private XMLElement createElement(XMLDocument xMLDocument, QueryState queryState) {
        XMLElement xMLElement;
        if (this.elemName == null && this.elemNameExpr == null) {
            xMLElement = (XMLElement)xMLDocument.createDocumentFragment();
        } else if (this.elemNameExpr != null) {
            OXMLItem oXMLItem;
            OXMLSequence oXMLSequence = this.elemNameExpr.Evaluate(queryState);
            boolean bl = this.elemNameExpr.needAtomization();
            OXMLSequence oXMLSequence2 = bl ? oXMLSequence.atomize() : oXMLSequence;
            try {
                oXMLItem = XQueryUtils.getSingleItem(oXMLSequence2);
            }
            catch (XQException xQException) {
                throw xQException;
            }
            catch (Exception exception) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"), exception);
            }
            QName qName = null;
            switch (oXMLItem.getPrimitiveType()) {
                case 0: 
                case 1: {
                    try {
                        oXMLItem = XQueryUtils.convert(oXMLItem, OXMLSequenceType.TQNAME, queryState);
                    }
                    catch (XQException xQException) {
                        throw new XQException(queryState.getMesg().getMessage0("XQDY0074"), xQException);
                    }
                    qName = oXMLItem.getQName();
                    break;
                }
                case 18: {
                    qName = oXMLItem.getQName();
                    break;
                }
                default: {
                    throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
                }
            }
            xMLElement = (XMLElement)xMLDocument.createElementNS(qName.getNamespaceURI(), oXMLItem.getLexicalValue());
            if (bl) {
                queryState.returnSequence(oXMLSequence2);
            }
        } else {
            String string = this.getElemNamespaceURI(queryState);
            xMLElement = (XMLElement)xMLDocument.createElementNS(string, this.elemName);
            if (this.defaultNamespaceURI != null) {
                xMLElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.defaultNamespaceURI);
            }
            if (this.namespaceHT != null) {
                for (String string2 : this.namespaceHT.keySet()) {
                    String string3 = (String)this.namespaceHT.get(string2);
                    xMLElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string3);
                }
            }
        }
        xMLElement.setPrimitiveTypeId(0);
        return xMLElement;
    }

    private void addNodeToElement(XMLDocument xMLDocument, XMLNode xMLNode, XMLElement xMLElement, boolean bl) {
        switch (xMLNode.getNodeType()) {
            case 2: {
                String string = "";
                string = xMLElement.getAttributeNS(((XMLAttr)xMLNode).getNamespaceURI(), ((XMLAttr)xMLNode).getLocalName());
                if (string.length() == 0) {
                    xMLNode = xMLNode.copyNode(xMLDocument, bl);
                    xMLElement.setAttributeNodeNS((Attr)((XMLAttr)xMLNode));
                    break;
                }
                throw new XQException(XQMesg.getInstance().getMessage0("XQDY0025"));
            }
            case 9: 
            case 11: {
                for (Node node = xMLNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.addNodeToElement(xMLDocument, (XMLNode)node, xMLElement, bl);
                }
                break;
            }
            default: {
                xMLNode = XQueryUtils.copyNode((XMLNode)xMLElement, xMLNode, xMLDocument, bl, true);
                xMLElement.appendChild((Node)xMLNode);
            }
        }
    }

    QName getElementQName(QueryState queryState) {
        if (this.elemName != null) {
            return new QName(this.getElemNamespaceURI(queryState), XQueryUtils.getLocalName(this.elemName));
        }
        return null;
    }

    private String getElemNamespaceURI(QueryState queryState) {
        if (this.elemNamespaceURI != null) {
            return this.elemNamespaceURI;
        }
        if (this.elemName != null) {
            String string = XQueryUtils.getPrefix(this.elemName);
            String string2 = null;
            if (string != null && string != "") {
                string2 = queryState.resolveNamespacePrefix(string);
                if (string2 == null) {
                    throw new XQException(queryState.getMesg().getMessage0("XPST0081"), queryState.getMesg().getMessage1("XQE-0501", string));
                }
            } else if (this.defaultNamespaceURI != null) {
                string2 = this.defaultNamespaceURI;
            } else if (!queryState.emptyDefaultElemNS()) {
                string2 = queryState.getDefaultElemNS();
            }
            if (string2 == "") {
                throw new XQException(XQMesg.getInstance().getMessage0("XQST0085"));
            }
            this.elemNamespaceURI = string2;
        }
        return this.elemNamespaceURI;
    }

    byte getType() {
        return this.type;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitElementConstructor(this);
    }
}

