/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;

public class ValidateExpr
extends Expr {
    private String mode = "strict";

    public ValidateExpr(Expr expr) {
        super(expr);
    }

    public ValidateExpr(String string, Expr expr) {
        super(expr);
        this.mode = string;
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)ValidateExpr.getDoc().createElement("ValidateExpr");
        xMLElement.setAttribute("mode", this.mode);
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        OXMLItem oXMLItem = XQueryUtils.getSingleItem(oXMLSequence, "XQTY0030");
        if (!FNUtil.isNode((OXMLItem)oXMLItem)) {
            throw new XQException(queryState.getMesg().getMessage0("XQTY0030"));
        }
        XMLNode xMLNode = oXMLItem.getNode();
        short s = xMLNode.getNodeType();
        if (s != 9 && s != 1) {
            throw new XQException(queryState.getMesg().getMessage0("XQTY0030"));
        }
        OXMLSequence oXMLSequence2 = queryState.createSequence();
        XMLSchema xMLSchema = queryState.getSchema();
        if (xMLSchema == null) {
            oXMLSequence2.appendItem(oXMLItem);
            oXMLSequence2.setKnownType(oXMLItem.getItemType());
            return oXMLSequence2;
        }
        OXMLItem oXMLItem2 = queryState.createItem();
        XMLNode xMLNode2 = ValidateExpr.validate(queryState, xMLNode, this.mode, true);
        oXMLItem2.setNode(xMLNode2);
        oXMLSequence2.appendItem(oXMLItem2);
        oXMLSequence2.setKnownType(oXMLItem2.getItemType());
        return oXMLSequence2;
    }

    static XMLNode validate(QueryState queryState, XMLNode xMLNode, String string, boolean bl) {
        XMLNode xMLNode2 = null;
        try {
            XSDValidator xSDValidator = new XSDValidator();
            xSDValidator.setXMLProperty("fixedSchema", (Object)queryState.getSchema());
            String string2 = XQueryUtils.getXSDValidationMode(string);
            xSDValidator.setXMLProperty("validationMode", (Object)string2);
            XMLError xMLError = new XMLError();
            xSDValidator.setError(xMLError);
            xMLNode2 = ((XMLElement)xMLNode).validateContent(xSDValidator, bl);
            if (xMLError.getFirstError() != -1) {
                xMLError.flushErrors();
            }
        }
        catch (Exception exception) {
            throw new XQException(queryState.getMesg().getMessage0("XQDY0027"), exception);
        }
        return xMLNode2;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitValidateExpr(this);
    }
}

