/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ExpectedSequenceType;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.XQueryUtils;

public class OXQuerySequence
extends OXMLSequence {
    private Entry head;
    private Entry tail;
    private Entry curr;
    protected OXMLItem currItem;
    private ExprResultIterator iter;
    private boolean isMaterialized;
    private boolean started;
    private ExpectedSequenceType expectedType;
    private OXMLSequenceType knownType;
    protected QueryState ctx;

    public OXQuerySequence(boolean bl) {
        this.started = false;
        this.setMaterialized(bl);
    }

    public OXQuerySequence(QueryState queryState, Expr expr) throws XQException {
        this.isMaterialized = false;
        this.started = false;
        this.ctx = queryState;
        this.iter = expr.getIterator(queryState);
    }

    OXQuerySequence(OXMLItem oXMLItem) {
        this.started = false;
        this.setFirstItem(oXMLItem);
    }

    void setExprIterator(ExprResultIterator exprResultIterator) {
        this.iter = exprResultIterator;
    }

    public void setContext(QueryState queryState) {
        this.ctx = queryState;
    }

    public void setKnownType(OXMLSequenceType oXMLSequenceType) {
        this.knownType = oXMLSequenceType;
    }

    void setExpectedType(OXMLSequenceType oXMLSequenceType, int n) {
        this.expectedType = new ExpectedSequenceType(oXMLSequenceType, n);
    }

    public void appendNode(XMLNode xMLNode) {
        OXMLItem oXMLItem = this.ctx.createItem();
        oXMLItem.setNode(xMLNode);
        this.appendItem(oXMLItem);
    }

    public void appendItem(OXMLItem oXMLItem) {
        if (this.isMaterialized) {
            Entry entry = new Entry(oXMLItem);
            if (this.tail != null) {
                this.tail.next = entry;
                this.tail = entry;
            } else {
                this.head = this.tail = entry;
            }
        } else {
            throw new XQException("OXQuerySequence:appendItem() not supported on non-materialized sequences");
        }
    }

    public void atomizeInPlace() {
        throw new XQException("OXQuerySequence:atomizeInPlace() not supported ");
    }

    public OXMLSequence atomize() {
        if (this.hasStarted()) {
            throw new XQException("OXQuerySequence:atomize() - cannot atomize a sequence which has already been started");
        }
        OXQuerySequence oXQuerySequence = (OXQuerySequence)this.ctx.createSequence();
        while (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            oXMLItem.atomize((OXMLSequence)oXQuerySequence);
        }
        return oXQuerySequence;
    }

    public boolean next() {
        if (this.expectedType != null && this.expectedType.hasNext()) {
            this.currItem = this.expectedType.nextItem();
            return true;
        }
        boolean bl = false;
        if (this.isMaterialized) {
            if (!this.started) {
                this.started = true;
                this.curr = this.head;
            } else if (this.curr != null) {
                this.curr = this.curr.next;
            }
            if (this.curr == null) {
                bl = false;
            } else {
                this.currItem = this.curr.item;
                bl = true;
            }
        } else {
            if (!this.started) {
                this.iter.Restart();
                this.started = true;
            }
            this.currItem = this.iter.Fetch();
            boolean bl2 = bl = this.currItem != null;
        }
        if (this.expectedType != null) {
            if (bl) {
                this.expectedType.incrementItemCount();
            }
            this.typeCheck();
        }
        return bl;
    }

    private void typeCheck() {
        boolean bl = true;
        OXMLSequenceType oXMLSequenceType = this.expectedType.getExpectedType();
        int n = oXMLSequenceType.getOccurence();
        switch (this.expectedType.getItemCount()) {
            case 0: {
                if (n != 1 && n != 3) break;
                bl = false;
                break;
            }
            case 1: {
                if (n != 0) break;
                bl = false;
                break;
            }
            default: {
                if (n != 2 && n != 0) break;
                bl = false;
            }
        }
        if (!bl) {
            throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
        }
        if (this.currItem == null) {
            return;
        }
        if (this.expectedType.isOfAtomicType()) {
            Object object;
            XMLNode xMLNode = null;
            if (this.expectedType.needAtomization()) {
                if (FNUtil.isNode((OXMLItem)this.currItem)) {
                    xMLNode = this.currItem.getNode();
                }
                object = this.currItem.atomize();
                object.next();
                this.currItem = object.getItem();
                this.expectedType.setAtomizedSequence((OXMLSequence)object);
            }
            if (this.expectedType.isAnyAtomic()) {
                return;
            }
            try {
                if (this.expectedType.needCast() && this.currItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                    if (this.expectedType.isNumeric_zero_or_one()) {
                        this.currItem.convert(OXMLSequenceType.TDOUBLE);
                    } else if (oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TQNAME)) {
                        object = XQueryUtils.convertString2QName(this.currItem.getString(), this.ctx, xMLNode);
                        this.currItem.setQName(OXMLSequenceType.TQNAME, (QName)object);
                    } else {
                        this.currItem.convert(oXMLSequenceType);
                    }
                    return;
                }
                if (this.expectedType.needTypePromotion() && this.expectedType.isOfNumericType()) {
                    if (this.expectedType.isDouble()) {
                        if (this.currItem.matchesType(OXMLSequenceType.TFLOAT) || this.currItem.matchesType(OXMLSequenceType.TDECIMAL)) {
                            this.currItem.convert(OXMLSequenceType.TDOUBLE);
                            return;
                        }
                    } else if (this.expectedType.isFloat() && this.currItem.matchesType(OXMLSequenceType.TDECIMAL)) {
                        this.currItem.convert(OXMLSequenceType.TFLOAT);
                        return;
                    }
                } else if (this.expectedType.needTypePromotion() && this.expectedType.isString() && this.currItem.matchesType(OXMLSequenceType.TANYURI)) {
                    this.currItem.convert(OXMLSequenceType.TSTRING);
                }
            }
            catch (oracle.xml.xqxp.XQException xQException) {
                String string = xQException.getMessage();
                String string2 = xQException.getErrorCode();
                if (string.equals("FORG0008")) {
                    throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"), XQMesg.getInstance().getMessage0(string2));
                }
                if (string.equals("FOTY0001")) {
                    throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"), XQMesg.getInstance().getMessage0(string2));
                }
                throw new XQException(XQMesg.getInstance().getMessage0(string2));
            }
        }
        if (this.expectedType.unknownStaticType() && !this.currItem.matchesType(oXMLSequenceType)) {
            throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
        }
    }

    public OXMLItem getItem() {
        return this.currItem;
    }

    public Object clone() {
        OXQuerySequence oXQuerySequence;
        if (this.hasStarted()) {
            throw new XQException("OXQuerySequence:clone() - cannot clone a sequence which has already been started");
        }
        if (this.isMaterialized) {
            oXQuerySequence = (OXQuerySequence)this.ctx.createSequence();
            oXQuerySequence.head = this.head;
            oXQuerySequence.tail = this.tail;
        } else {
            oXQuerySequence = (OXQuerySequence)this.materializeIt();
        }
        return oXQuerySequence;
    }

    public void materializeMe() {
        if (this.isMaterialized) {
            return;
        }
        OXMLSequence oXMLSequence = this.materializeIt();
        this.ctx.returnSequence(oXMLSequence);
    }

    OXMLSequence materializeIt() {
        if (this.isMaterialized) {
            return this;
        }
        if (this.hasStarted()) {
            throw new XQException("OXQuerySequence:materializeIt() - cannot materialize a sequence which has already been started");
        }
        OXMLSequence oXMLSequence = this.ctx.createSequence();
        while (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            oXMLSequence.appendItem(oXMLItem);
        }
        this.started = false;
        this.isMaterialized = true;
        this.iter = null;
        this.head = ((OXQuerySequence)oXMLSequence).head;
        this.tail = ((OXQuerySequence)oXMLSequence).tail;
        return oXMLSequence;
    }

    public boolean getEffectiveBooleanValue() {
        boolean bl = true;
        if (!this.next()) {
            bl = false;
        } else {
            OXMLItem oXMLItem = this.getItem();
            if (FNUtil.isNode((OXMLItem)oXMLItem)) {
                bl = true;
            } else {
                if (this.next()) {
                    throw new XQException(XQMesg.getInstance().getMessage0("FORG0006"));
                }
                switch (oXMLItem.getPrimitiveType()) {
                    case 2: {
                        bl = oXMLItem.getBoolean();
                        break;
                    }
                    case 3: 
                    case 4: {
                        double d = oXMLItem.getDouble();
                        if (Double.isNaN(d)) {
                            bl = false;
                            break;
                        }
                        bl = d != 0.0;
                        break;
                    }
                    case 5: 
                    case 22: {
                        if (oXMLItem.withinRange()) {
                            bl = oXMLItem.getInt() != 0;
                            break;
                        }
                        bl = oXMLItem.getDecimal().doubleValue() != 0.0;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 17: {
                        bl = oXMLItem.getString().length() != 0;
                        break;
                    }
                    default: {
                        throw new XQException(XQMesg.getInstance().getMessage0("FORG0006"));
                    }
                }
            }
        }
        if (this.isMaterialized) {
            this.restart();
        }
        return bl;
    }

    public boolean contains(XMLNode xMLNode) {
        throw new XQException("OXQuerySequence:contains() not supported ");
    }

    public OXMLItem atomizeItem() {
        throw new XQException("OXQuerySequence:atomizeItem() not supported ");
    }

    public void concatSequence(OXMLSequence oXMLSequence) {
        throw new XQException("OXQuerySequence:concatSequence() not supported ");
    }

    public void removeItem(OXMLItem oXMLItem) {
        throw new XQException("OXQuerySequence:removeItem() not supported ");
    }

    public void appendString(String string) {
        throw new XQException("OXQuerySequence:appendString() not supported ");
    }

    public void appendBoolean(boolean bl) {
        throw new XQException("OXQuerySequence:appendBoolean() not supported ");
    }

    public void appendNumber(double d) {
        throw new XQException("OXQuerySequence:appendNumber() not supported ");
    }

    public OXMLItem createItem() {
        throw new XQException("OXQuerySequence:createItem() not supported ");
    }

    public boolean matches(XSDNode xSDNode) {
        throw new XQException("OXQuerySequence:matches() not supported ");
    }

    public boolean isOfType(OXMLSequenceType oXMLSequenceType) {
        if (this.knownType != null && this.knownType.isOfType(oXMLSequenceType)) {
            return true;
        }
        this.materializeMe();
        boolean bl = true;
        int n = oXMLSequenceType.getOccurence();
        if (!this.next()) {
            switch (n) {
                case 0: 
                case 2: 
                case 4: {
                    bl = true;
                    break;
                }
                case 1: 
                case 3: {
                    bl = false;
                }
            }
            this.knownType = OXMLSequenceType.EMPTY_SEQUENCE;
        } else if (n == 0) {
            bl = false;
        } else {
            OXMLItem oXMLItem = this.getItem();
            if (this.next()) {
                if (n == 1 || n == 2) {
                    bl = false;
                } else if (!oXMLItem.matchesType(oXMLSequenceType)) {
                    bl = false;
                } else {
                    do {
                        OXMLItem oXMLItem2;
                        if ((oXMLItem2 = this.getItem()).matchesType(oXMLSequenceType)) continue;
                        bl = false;
                        break;
                    } while (this.next());
                }
                if (this.knownType == null) {
                    this.knownType = OXMLSequenceType.ITEM_ONE_OR_MORE;
                }
            } else {
                bl = oXMLItem.matchesType(oXMLSequenceType);
                this.knownType = oXMLItem.getItemType();
            }
        }
        this.restart();
        return bl;
    }

    public void reset() {
        this.isMaterialized = false;
        this.started = false;
        this.curr = null;
        this.tail = null;
        this.head = null;
        this.currItem = null;
        this.iter = null;
        this.expectedType = null;
        this.knownType = null;
    }

    public void appendSequence(OXMLSequence oXMLSequence) {
        if (this.isMaterialized) {
            while (oXMLSequence.next()) {
                OXMLItem oXMLItem = oXMLSequence.getItem();
                this.appendItem(oXMLItem);
            }
        } else {
            throw new XQException("OXQuerySequence:appendSequence() not supported on non-materialized sequences");
        }
    }

    public void restart() {
        if (!this.hasStarted()) {
            return;
        }
        if (!this.isMaterialized) {
            throw new XQException("OXQuerySequence:restart() not supported on non-materialized sequences");
        }
        this.started = false;
        this.expectedType = null;
    }

    private boolean hasStarted() {
        return this.started;
    }

    void setMaterialized(boolean bl) {
        this.isMaterialized = bl;
    }

    boolean isMaterialized() {
        return this.isMaterialized;
    }

    void setFirstItem(OXMLItem oXMLItem) {
        Entry entry;
        this.head = this.tail = (entry = new Entry(oXMLItem));
        this.isMaterialized = true;
    }

    public int getItemOccurrence() {
        this.materializeMe();
        int n = -1;
        n = !this.next() ? 0 : (!this.next() ? 1 : 2);
        this.restart();
        return n;
    }

    public OXMLItemList getItemList() {
        OXMLItemList oXMLItemList = new OXMLItemList();
        OXMLItem oXMLItem = null;
        while (this.next()) {
            oXMLItem = this.getItem();
            oXMLItemList.addItem(oXMLItem);
        }
        return oXMLItemList;
    }

    public void close() {
        Trace.trace(1, (Object)this, "Entering close");
        if (this.iter != null) {
            this.iter.Close();
        }
    }

    private class Entry {
        OXMLItem item;
        Entry next;

        Entry(OXMLItem oXMLItem) {
            this.item = oXMLItem;
            this.next = null;
        }
    }
}

