/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.XQueryUtils;

class ExpectedSequenceType {
    private OXMLSequenceType expectedType;
    private int itemCount;
    private OXMLSequence atomizedSequence;
    private boolean isOfAtomicType;
    private boolean isAnyAtomic;
    private boolean isOfNumericType;
    private boolean isNumeric_zero_or_one;
    private boolean isDouble;
    private boolean isFloat;
    private boolean isString;
    private int staticTypingStatus;

    ExpectedSequenceType(OXMLSequenceType oXMLSequenceType, int n) {
        this.expectedType = oXMLSequenceType;
        this.itemCount = 0;
        this.isOfAtomicType = oXMLSequenceType.isOfType(OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE);
        this.isAnyAtomic = oXMLSequenceType == OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE || oXMLSequenceType == OXMLSequenceType.ANYATOMIC_ONE || oXMLSequenceType == OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE;
        this.isOfNumericType = oXMLSequenceType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_MORE);
        this.isNumeric_zero_or_one = oXMLSequenceType == OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        this.isDouble = oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TDOUBLE);
        this.isFloat = oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TFLOAT);
        this.isString = oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TSTRING);
        this.staticTypingStatus = n;
    }

    final OXMLSequenceType getExpectedType() {
        return this.expectedType;
    }

    final boolean isOfAtomicType() {
        return this.isOfAtomicType;
    }

    final boolean isAnyAtomic() {
        return this.isAnyAtomic;
    }

    final boolean isOfNumericType() {
        return this.isOfNumericType;
    }

    final boolean isNumeric_zero_or_one() {
        return this.isNumeric_zero_or_one;
    }

    final boolean isDouble() {
        return this.isDouble;
    }

    final boolean isFloat() {
        return this.isFloat;
    }

    final boolean isString() {
        return this.isString;
    }

    final int getItemCount() {
        return this.itemCount;
    }

    final void incrementItemCount() {
        ++this.itemCount;
    }

    final OXMLItem nextItem() {
        return this.atomizedSequence.getItem();
    }

    final boolean hasNext() {
        if (this.atomizedSequence != null) {
            boolean bl = this.atomizedSequence.next();
            if (!bl) {
                this.atomizedSequence = null;
            }
            return bl;
        }
        return false;
    }

    final void setAtomizedSequence(OXMLSequence oXMLSequence) {
        this.atomizedSequence = oXMLSequence;
    }

    final boolean needCast() {
        return XQueryUtils.needCast(this.staticTypingStatus);
    }

    final boolean needTypePromotion() {
        return XQueryUtils.needTypePromotion(this.staticTypingStatus);
    }

    final boolean needAtomization() {
        return XQueryUtils.needAtomization(this.staticTypingStatus);
    }

    final boolean unknownStaticType() {
        return XQueryUtils.unknownStaticType(this.staticTypingStatus);
    }
}

