/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.xquery.XQException;

public class HashStack {
    private ArrayList array = new ArrayList();
    private HashMap hash = new HashMap();
    private int pos = 0;

    public void push(Object object) {
        this.hash.put(object, object);
        int n = this.array.size();
        if (this.pos < n) {
            this.array.set(this.pos, object);
        } else if (this.pos == n) {
            this.array.add(object);
        } else if (this.pos > n) {
            throw new XQException("ArrayIndexOutOfBound: " + this.pos + " size: " + n);
        }
        ++this.pos;
    }

    public Object pop() {
        --this.pos;
        Object e = this.array.get(this.pos);
        this.hash.remove(e);
        return e;
    }

    public boolean contains(Object object) {
        return this.hash.containsKey(object);
    }

    public boolean isEmpty() {
        return this.pos == 0;
    }

    public void print() {
        for (int i = 0; i < this.pos; ++i) {
            System.out.print(this.array.get(i));
            System.out.print(' ');
        }
    }

    public static void main(String[] stringArray) {
        HashStack hashStack = new HashStack();
        hashStack.push("a");
        hashStack.push("b");
        hashStack.push("c");
        hashStack.push("d");
        hashStack.push("e");
        hashStack.print();
        System.out.println();
        String string = (String)hashStack.pop();
        System.out.println("pop " + string);
        string = (String)hashStack.pop();
        System.out.println("pop " + string);
        hashStack.print();
        System.out.println();
        System.out.println("contains d: " + hashStack.contains("d"));
        hashStack.push("f");
        hashStack.push("g");
        hashStack.print();
        System.out.println();
        hashStack.push("h");
        hashStack.print();
        System.out.println("contains f: " + hashStack.contains("f"));
        while (!hashStack.isEmpty()) {
            string = (String)hashStack.pop();
            System.out.println("pop " + string);
        }
    }
}

