/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public final class JavaText {
    public static final Color PARAMETER_TYPE_FOREGROUND = new Color(0, 70, 120);
    public static final Color PARAMETER_NAME_FOREGROUND = new Color(110, 90, 40);
    public static final Map<TextAttribute, Object> NAME_POSTFIX_ATTRIBUTES;
    public static final Map<TextAttribute, Object> TYPE_PRETFIX_ATTRIBUTES;
    public static final Map<TextAttribute, Object> NAME_POSTFIX_ATTRIBUTES_BOLD;
    public static final Map<TextAttribute, Object> KEYWORD_ATTRIBUTES;
    private static final CodingStyleOptions codingStyleOptions;

    public static AttributedString methodText(JavaMethod method, String methodNameAddition, Flag ... flags) {
        String packageName;
        String methodName = method.isConstructor() ? method.getOwningClass().getName() : method.getName();
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".");
        }
        if (Flag.PREFIX_CLASS.isPresent(flags)) {
            if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
                asb.append(method.getOwningClass().getName(), (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
            } else {
                asb.append(method.getOwningClass().getName());
            }
            asb.append(".");
        }
        if (Flag.THIS_CONSTRUCTOR.isPresent(flags)) {
            asb.append("this");
        } else if (Flag.SUPER_CONSTRUCTOR.isPresent(flags)) {
            asb.append("super");
        } else if (method.isConstructor() && Flag.BOLD_CLASSNAME.isPresent(flags)) {
            asb.append(methodName, (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
        } else {
            asb.append(methodName);
        }
        if (Flag.DIAMOND.isPresent(flags) && method.isConstructor()) {
            asb.append("<>");
        }
        HashMap<TextAttribute, Serializable> paramAttrs = new HashMap<TextAttribute, Serializable>();
        paramAttrs.put(TextAttribute.FOREGROUND, PARAMETER_TYPE_FOREGROUND);
        if (Flag.ITALIC_LOCALS.isPresent(flags)) {
            paramAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        HashMap<TextAttribute, Serializable> paramNameAttrs = new HashMap<TextAttribute, Serializable>();
        paramNameAttrs.put(TextAttribute.FOREGROUND, PARAMETER_NAME_FOREGROUND);
        if (Flag.ITALIC_LOCALS.isPresent(flags)) {
            paramNameAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        asb.append("(");
        boolean needComma = false;
        for (Tuple<String, String> param : JavaText.getParameterTypesAndNames(method)) {
            if (needComma) {
                asb.append(", ", paramAttrs);
            }
            asb.append((String)param.object1(), paramAttrs);
            if (param.object2() != null) {
                asb.append(" " + (String)param.object2(), paramNameAttrs);
            }
            needComma = true;
        }
        asb.append(")");
        if (Flag.DEFINING_CLASS.isPresent(flags)) {
            if (Flag.PACKAGE.isPresent(flags)) {
                asb.append(" - " + method.getOwningClass().getQualifiedName(), NAME_POSTFIX_ATTRIBUTES);
            } else {
                asb.append(" - " + method.getOwningClass().getName(), NAME_POSTFIX_ATTRIBUTES);
            }
        } else if (Flag.PACKAGE.isPresent(flags) && (packageName = method.getOwningClass().getPackageName()).length() > 0) {
            asb.append(" - " + packageName, NAME_POSTFIX_ATTRIBUTES);
        }
        if (methodNameAddition != null && !"".equals(methodNameAddition)) {
            asb.append(" " + methodNameAddition, NAME_POSTFIX_ATTRIBUTES_BOLD);
        }
        if (Flag.ARRAY_ELLIPSES.isPresent(flags)) {
            asb.append("[");
            asb.append("...", paramNameAttrs);
            asb.append("]");
        }
        AttributedString as = asb.toAttributedString();
        return as;
    }

    public static AttributedString methodText(JavaMethod method, Flag ... flags) {
        return JavaText.methodText(method, null, flags);
    }

    public static AttributedString methodTextShort(JavaMethod method, Flag ... flags) {
        String methodName = method.isConstructor() ? method.getOwningClass().getName() : method.getName();
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".");
        }
        asb.append(methodName);
        if (method.getParameters().isEmpty()) {
            asb.append("()");
        } else {
            asb.append("(...)");
        }
        if (Flag.DEFINING_CLASS.isPresent(flags)) {
            asb.append(" - " + method.getOwningClass().getName(), NAME_POSTFIX_ATTRIBUTES);
        }
        return asb.toAttributedString();
    }

    public static AttributedString classText(JavaClass javaClass, Flag ... flags) {
        String packageName;
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.PREFIX_PIPE.isPresent(flags)) {
            asb.append("|" + (codingStyleOptions == null ? " " : (codingStyleOptions.getSpaceAroundBinaryOperator() ? " " : "")));
        }
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".");
        }
        if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
            asb.append(javaClass.getName(), (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
        } else {
            asb.append(javaClass.getName());
        }
        if (Flag.DIAMOND.isPresent(flags)) {
            asb.append("<>");
        }
        if ((packageName = javaClass.getPackageName()).length() > 0) {
            asb.append(" " + packageName, NAME_POSTFIX_ATTRIBUTES);
        }
        return asb.toAttributedString();
    }

    public static List<Tuple<String, String>> getParameterTypesAndNames(JavaMethod method) {
        Collection javaMethodParameters = method.getParameters();
        int numParameters = javaMethodParameters.size();
        Iterator iter = javaMethodParameters.iterator();
        ArrayList<Tuple<String, String>> results = new ArrayList<Tuple<String, String>>();
        for (int i = 0; i < numParameters; ++i) {
            JavaVariable param = (JavaVariable)iter.next();
            if (param.isSynthetic() && (!method.isSynthetic() || method.isConstructor() && (method.getOwningClass().isMemberClass() || method.getOwningClass().isAnonymousClass()))) continue;
            JavaType type = param.getResolvedType();
            String typeName = null;
            if (type != null) {
                if (i == numParameters - 1 && method.isVarargs() && type.isArray() && type.getBaseComponentType() != null) {
                    typeName = type.getBaseComponentType().getUnqualifiedName() + "...";
                }
                if (typeName == null) {
                    typeName = type.getUnqualifiedName();
                }
            } else {
                typeName = "<unknown>";
            }
            String paramName = param.getName();
            results.add((Tuple<String, String>)new Tuple((Object)typeName, (Object)paramName));
        }
        return results;
    }

    public static AttributedString defaultText(JavaElement element, Flag ... flags) {
        return JavaText.defaultText(element, JavaText.getName(element, Flag.PREFIX_CLASS), flags);
    }

    public static AttributedString defaultText(JavaElement element, String name, Flag ... flags) {
        if (element instanceof JavaMethod) {
            flags = Flag.addFlags(flags, Flag.PREFIX_CLASS);
            return JavaText.methodText((JavaMethod)element, flags);
        }
        if (element instanceof JavaClass) {
            return JavaText.classText((JavaClass)element, new Flag[0]);
        }
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".");
        }
        if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
            asb.append(name, (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
        } else {
            asb.append(name);
        }
        if (element instanceof JavaMember) {
            CharSequence postName;
            if (Flag.DEFINING_CLASS.isPresent(flags)) {
                String packageName;
                postName = new StringBuilder(((JavaMember)element).getOwningClass().getName());
                if (Flag.PACKAGE.isPresent(flags) && (packageName = ((JavaMember)element).getOwningClass().getPackageName()).length() > 0) {
                    if (((StringBuilder)postName).length() > 0) {
                        ((StringBuilder)postName).append(" ");
                    }
                    ((StringBuilder)postName).append(packageName);
                }
                if (((StringBuilder)postName).length() > 0) {
                    asb.append(" - " + ((StringBuilder)postName).toString() + name, NAME_POSTFIX_ATTRIBUTES);
                }
            } else if (Flag.PACKAGE.isPresent(flags) && ((String)(postName = ((JavaMember)element).getOwningClass().getPackageName())).length() > 0) {
                asb.append(" - " + name, NAME_POSTFIX_ATTRIBUTES);
            }
        }
        if (Flag.ARRAY_ELLIPSES.isPresent(flags)) {
            HashMap<TextAttribute, Serializable> paramNameAttrs = new HashMap<TextAttribute, Serializable>();
            paramNameAttrs.put(TextAttribute.FOREGROUND, PARAMETER_NAME_FOREGROUND);
            if (Flag.ITALIC_LOCALS.isPresent(flags)) {
                paramNameAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            asb.append("[");
            asb.append("...", paramNameAttrs);
            asb.append("]");
        }
        AttributedString aText = asb.toAttributedString();
        if (element instanceof JavaLocalVariable && Flag.ITALIC_LOCALS.isPresent(flags) && !element.isFinal() && aText.getIterator().getEndIndex() > 0) {
            aText.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return aText;
    }

    public static String getName(JavaElement element, Flag ... flags) {
        if (element instanceof JavaHasName) {
            if (element instanceof JavaMethod && ((JavaMethod)element).isConstructor()) {
                if (Flag.THIS_CONSTRUCTOR.isPresent(flags)) {
                    return "this";
                }
                if (Flag.SUPER_CONSTRUCTOR.isPresent(flags)) {
                    return "super";
                }
                return ((JavaMethod)element).getOwningClass().getName();
            }
            StringBuilder sb = new StringBuilder(((JavaHasName)element).getName());
            if (element instanceof JavaMember && Flag.PREFIX_CLASS.isPresent(flags)) {
                JavaMember member = (JavaMember)element;
                sb.insert(0, ".");
                sb.insert(0, member.getOwningClass().getName());
            }
            if (element.getElementKind() == 9) {
                String name = sb.toString();
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1) {
                    return name.substring(lastDot + 1);
                }
                return name;
            }
            if (Flag.SUPER.isPresent(flags)) {
                sb.insert(0, "super.");
            }
            if (Flag.DIAMOND.isPresent(flags)) {
                sb.append("<>");
            }
            if (Flag.PREFIX_PIPE.isPresent(flags)) {
                sb.insert(0, "|" + (codingStyleOptions == null ? " " : (codingStyleOptions.getSpaceAroundBinaryOperator() ? " " : "")));
            }
            return sb.toString();
        }
        return "";
    }

    public static AttributedString dereferenceText(String referenceType, String realType) {
        AttributedStringBuilder typeBuilder = new AttributedStringBuilder(referenceType, TYPE_PRETFIX_ATTRIBUTES);
        typeBuilder.append(" ");
        typeBuilder.append(realType);
        return typeBuilder.toAttributedString();
    }

    static {
        codingStyleOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions();
        Color foreground = new Color(100, 100, 100);
        KEYWORD_ATTRIBUTES = new HashMap<TextAttribute, Object>();
        KEYWORD_ATTRIBUTES.put(TextAttribute.FOREGROUND, new Color(0, 99, 148));
        KEYWORD_ATTRIBUTES.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        NAME_POSTFIX_ATTRIBUTES = new HashMap<TextAttribute, Object>();
        NAME_POSTFIX_ATTRIBUTES.put(TextAttribute.FOREGROUND, foreground);
        NAME_POSTFIX_ATTRIBUTES.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_BOLD = new HashMap<TextAttribute, Object>();
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.FOREGROUND, foreground);
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        TYPE_PRETFIX_ATTRIBUTES = new HashMap<TextAttribute, Object>();
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.FOREGROUND, foreground);
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.SIZE, 11);
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
    }

    public static enum Flag {
        SUPER,
        DIAMOND,
        DEFINING_CLASS,
        PREFIX_CLASS,
        PACKAGE,
        ITALIC_LOCALS,
        PREFIX_PIPE,
        THIS_CONSTRUCTOR,
        SUPER_CONSTRUCTOR,
        BOLD_CLASSNAME,
        ARRAY_ELLIPSES;


        public boolean isPresent(Flag[] flags) {
            if (flags == null) {
                return false;
            }
            for (Flag flag : flags) {
                if (flag != this) continue;
                return true;
            }
            return false;
        }

        public static Flag[] addFlags(Flag[] flags, Flag ... additionalFlags) {
            Flag[] newFlags = new Flag[flags.length + additionalFlags.length];
            System.arraycopy(flags, 0, newFlags, 0, flags.length);
            System.arraycopy(additionalFlags, 0, newFlags, flags.length, additionalFlags.length);
            return newFlags;
        }
    }
}

