/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.iconoverlay;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.java.annotation.HookJavaIconAnnotation;

public class JavaIconOverlayHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdevimpl/java/iconoverlay", "java-icon-overlay-hook");
    private static HashStructureHook hashStructureHook;
    private static List<HookJavaIconAnnotation> javaAnnotations;

    static synchronized List<HookJavaIconAnnotation> getJavaAnnotations() {
        JavaIconOverlayHook.primeHook();
        return javaAnnotations;
    }

    private static void primeHook() {
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    JavaIconOverlayHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    JavaIconOverlayHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        List javaAnnotationDefinitionObjects;
        if (javaAnnotations == null) {
            javaAnnotations = new ArrayList<HookJavaIconAnnotation>();
        }
        if ((javaAnnotationDefinitionObjects = hashStructure.getAsList("java-annotation")) == null || javaAnnotationDefinitionObjects.size() == 0) {
            return;
        }
        for (Object javaAnnotationDefinitionObject : javaAnnotationDefinitionObjects) {
            if (!(javaAnnotationDefinitionObject instanceof HashStructure)) {
                assert (javaAnnotationDefinitionObject instanceof HashStructure) : "java-annotation is not of type HashStructure";
                continue;
            }
            HashStructure hash = (HashStructure)javaAnnotationDefinitionObject;
            String extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
            javaAnnotations.add(new HookJavaIconAnnotation(hash, extensionId));
        }
    }
}

