/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.annotation;

import java.net.URL;
import javax.ide.extension.Extension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.java.annotation.HookJavaAnnotation;

public class HookJavaIconAnnotation
extends HookJavaAnnotation {
    private static final String iconElementName = "navigator-overlay-icon/#text";
    private static final String initializeExtensionElementName = "initialize-extension/#text";
    private static final String ruleName = "rule";
    private String extensionId;
    private Icon icon;
    private String rule;

    public HookJavaIconAnnotation(HashStructure hash, String extensionId) {
        super(hash);
        this.extensionId = extensionId;
    }

    public String getIconName() {
        Object object;
        if (this._hash.containsKey(iconElementName) && (object = this._hash.getObject(iconElementName)) != null) {
            return object.toString();
        }
        return null;
    }

    private boolean initializeExtension() {
        Object object;
        return !this._hash.containsKey(initializeExtensionElementName) || (object = this._hash.getObject(initializeExtensionElementName)) == null || !"false".equals(object.toString());
    }

    public String getRule() {
        Object object;
        if (this.rule == null && this._hash.containsKey(ruleName) && (object = this._hash.getObject(ruleName)) != null) {
            this.rule = object.toString();
        }
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Icon getIcon() {
        String iconName;
        if (this.icon == null && (iconName = this.getIconName()) != null) {
            ExtensionRegistry registry;
            Extension extension;
            String loadName = iconName;
            if (loadName.startsWith("res:")) {
                loadName = loadName.substring(4);
            }
            URL iconURL = this.getClassLoader().getResource(loadName);
            this.icon = this.loadIcon(iconURL);
            if (this.icon == null) {
                iconURL = URLFactory.newURL((String)iconName);
                this.icon = this.loadIcon(iconURL);
            }
            if (this.icon != null && this.initializeExtension() && (extension = (registry = ExtensionRegistry.getExtensionRegistry()).findExtension(this.extensionId)) != null && !registry.isFullyLoaded(extension)) {
                registry.fullyLoadExtension(extension, "Loaded by HookJavaIconAnnotation");
            }
        }
        return this.icon;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = null;
        if (this.extensionId != null) {
            loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extensionId);
        }
        if (loader == null) {
            loader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return loader;
    }

    private Icon loadIcon(URL iconURL) {
        if (iconURL != null) {
            return new ImageIcon(iconURL);
        }
        return null;
    }
}

