/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.annotation;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.index.Index;
import oracle.ide.index.QueryCriteria;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdevimpl.java.annotation.HookAnnotationCombo;
import oracle.jdevimpl.java.annotation.HookAnnotations;
import oracle.jdevimpl.java.annotation.HookJavaAnnotation;

public class AnnotationSearcher<T extends HookJavaAnnotation> {
    private T javaAnnotation;
    private List<String> requiredAnnotationNames;
    private List<String> disallowedAnnotationNames;
    private List<String> urlsWithRequiredAnnotations = new ArrayList<String>();

    public static <T extends HookJavaAnnotation> List<AnnotationSearcher<T>> makeSearchers(List<T> javaAnnotations) {
        ArrayList<AnnotationSearcher<T>> searchers = new ArrayList<AnnotationSearcher<T>>();
        for (HookJavaAnnotation javaAnnotation : javaAnnotations) {
            AnnotationSearcher<HookJavaAnnotation> searcher;
            HookAnnotations annotations = javaAnnotation.getAnnotations();
            if (annotations == null) continue;
            List<String> annotationNames = annotations.getAnnotations();
            for (String annotationName : annotationNames) {
                ArrayList<String> requiredAnnotationNames = new ArrayList<String>();
                requiredAnnotationNames.add(annotationName);
                searcher = new AnnotationSearcher<HookJavaAnnotation>(javaAnnotation, requiredAnnotationNames, null);
                searchers.add(searcher);
            }
            List<HookAnnotationCombo> annotationCombos = annotations.getAnnotationCombos();
            for (HookAnnotationCombo combo : annotationCombos) {
                searcher = new AnnotationSearcher<HookJavaAnnotation>(javaAnnotation, combo.getRequiredAnnotations(), combo.getDisallowedAnnotations());
                searchers.add(searcher);
            }
        }
        return searchers;
    }

    private AnnotationSearcher(T javaAnnotation, List<String> requiredAnnotationNames, List<String> disallowedAnnotationNames) {
        this.javaAnnotation = javaAnnotation;
        this.requiredAnnotationNames = requiredAnnotationNames;
        this.disallowedAnnotationNames = disallowedAnnotationNames;
    }

    public T getAnnotation() {
        return this.javaAnnotation;
    }

    public void searchForAnnotations(QueryCriteria criteria, Index index) {
        this.urlsWithRequiredAnnotations.clear();
        for (String longName : this.requiredAnnotationNames) {
            int dotIndex = longName.lastIndexOf(46);
            String shortName = dotIndex >= 0 ? longName.substring(dotIndex + 1) : longName;
            URL[] result = this.query(criteria, index, shortName);
            if (this.urlsWithRequiredAnnotations.size() == 0) {
                for (URL url : result) {
                    this.urlsWithRequiredAnnotations.add(url.toExternalForm());
                }
                continue;
            }
            for (int i = this.urlsWithRequiredAnnotations.size() - 1; i >= 0; --i) {
                String requiredUrl = this.urlsWithRequiredAnnotations.get(i);
                boolean found = false;
                for (URL url : result) {
                    if (!url.toExternalForm().equals(requiredUrl)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.urlsWithRequiredAnnotations.remove(i);
            }
        }
    }

    public boolean foundAnnotations(String nodeUrl) {
        return this.urlsWithRequiredAnnotations.contains(nodeUrl);
    }

    private URL[] query(QueryCriteria criteria, Index indexer, String name) {
        try {
            criteria.clear();
            criteria.put((Object)"java.annotation", (Object)name);
            return indexer.blockingQuery(criteria);
        }
        catch (Exception ex) {
            return new URL[0];
        }
    }

    public boolean confirmAnnotations(JavaManager javaManager, JavaNode node, boolean primaryClassOnly) {
        JavaFile javaFile = javaManager.getFile(node.getURL());
        if (javaFile == null) {
            return false;
        }
        if (primaryClassOnly) {
            JavaClass primaryClass = javaFile.getPrimaryClass();
            if (primaryClass != null) {
                ArrayList<JavaClass> classes = new ArrayList<JavaClass>(1);
                classes.add(primaryClass);
                return this.processClasses(classes, true);
            }
            return false;
        }
        return this.processClasses(javaFile.getClasses(), true);
    }

    private boolean processClasses(Collection classes, boolean isToplevel) {
        for (JavaClass javaClass : classes) {
            boolean result;
            boolean doClass;
            boolean bl = doClass = !isToplevel || ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeTopLevelType();
            if (doClass && this.processClass(javaClass)) {
                return true;
            }
            if (!((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeInnerType() || !(result = this.processClasses(javaClass.getDeclaredClasses(), false))) continue;
            return true;
        }
        return false;
    }

    private boolean processClass(JavaClass javaClass) {
        Collection methods;
        boolean checkedAnnotations = false;
        if (((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeAnnotation() || ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeEnum() || ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeInterface() || ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeClass()) {
            checkedAnnotations = true;
            if (!this.acceptableClass(javaClass)) {
                return false;
            }
        }
        if (((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeField()) {
            checkedAnnotations = true;
            Collection fields = javaClass.getDeclaredFields();
            if (!this.processMembers(fields)) {
                return false;
            }
        }
        if (((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeMethod()) {
            checkedAnnotations = true;
            methods = javaClass.getDeclaredMethods();
            if (!this.processMembers(methods)) {
                return false;
            }
        }
        if (((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeParameter()) {
            checkedAnnotations = true;
            methods = javaClass.getDeclaredMethods();
            if (!this.processParameters(methods)) {
                return false;
            }
        }
        return checkedAnnotations;
    }

    private boolean processParameters(Collection methods) {
        for (JavaMethod method : methods) {
            Collection parameters = method.getParameters();
            for (JavaVariable param : parameters) {
                if (!this.processAnnotations(param.getDeclaredAnnotations())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean processMembers(Collection members) {
        for (JavaMember member : members) {
            if (!this.acceptableAccess(member) || !this.processAnnotations(member.getDeclaredAnnotations())) continue;
            return true;
        }
        return false;
    }

    private boolean processAnnotations(Collection annotations) {
        ArrayList<String> required = new ArrayList<String>(this.requiredAnnotationNames);
        boolean notAllowed = false;
        block0: for (JavaAnnotation annotation : annotations) {
            String fqName;
            JavaType type = annotation.getResolvedType();
            if (type == null || (fqName = type.getQualifiedName()) == null) continue;
            if (this.disallowedAnnotationNames != null) {
                for (String disAllowed : this.disallowedAnnotationNames) {
                    boolean wildcard = disAllowed.endsWith("*");
                    if ((!wildcard || !fqName.startsWith(disAllowed.substring(0, disAllowed.length() - 1))) && !fqName.equals(disAllowed)) continue;
                    notAllowed = true;
                    break block0;
                }
            }
            required.remove(fqName);
        }
        return required.size() == 0 && !notAllowed;
    }

    private boolean acceptableClass(JavaClass javaClass) {
        boolean accept = this.acceptableAccess((JavaMember)javaClass);
        if (!accept) {
            return false;
        }
        boolean bl = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeAnnotation() && javaClass.isAnnotation();
        if (!accept) {
            boolean bl2 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeEnum() && javaClass.isEnum();
            if (!accept) {
                boolean bl3 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeInterface() && javaClass.isInterface();
                if (!accept) {
                    accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeClass();
                }
            }
        }
        if (accept) {
            return this.processAnnotations(javaClass.getDeclaredAnnotations());
        }
        return false;
    }

    private boolean acceptableAccess(JavaMember javaMember) {
        boolean accept;
        boolean bl = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeStatic() && javaMember.isStatic();
        if (!accept) {
            boolean bl2 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeNonStatic() && !javaMember.isStatic();
        }
        if (!accept) {
            return false;
        }
        boolean bl3 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludePublic() && javaMember.isPublic();
        if (!accept) {
            boolean bl4 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludePackagePrivate() && javaMember.isPackagePrivate();
            if (!accept) {
                boolean bl5 = accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludeProtected() && javaMember.isProtected();
                if (!accept) {
                    accept = ((HookJavaAnnotation)((Object)this.javaAnnotation)).isIncludePrivate() && javaMember.isPrivate();
                }
            }
        }
        return accept;
    }
}

