/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.URLPathField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.config.JProjectPaths;

public class JProjectPathsPanel
extends ProjectSettingsTraversablePanel {
    JLabel outputDirLabel = new JLabel();
    URLTextField outputDirTextField = new URLTextField(null, true, false);
    JLabel additionalClassPathLabel = new JLabel();
    URLPathField additionalClassPathTextField = new URLPathField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton outputDirButton = new JButton();
    JButton additionalClassPathButton = new JButton();
    JLabel spacerLabel = new JLabel();
    private static final String[] PROPERTY_KEYS = new String[]{"outputDirectory", "additionalClassPath"};

    public JProjectPathsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_idedprojsetpaths_html");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDataKey() {
        return JProjectPaths.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        JavaProject javaProject = this.getJavaProject(tc);
        JProjectPaths projectPaths = this.getJProjectPaths(tc);
        boolean isDefaultProject = JProjectPathsPanel.isDefaultProject((Namespace)tc);
        this.loadFrom(javaProject, projectPaths, isDefaultProject);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaProject javaProject = this.getJavaProject(tc);
        JProjectPaths projectPaths = this.getJProjectPaths(tc);
        boolean isDefaultProject = JProjectPathsPanel.isDefaultProject((Namespace)tc);
        this.commitTo(javaProject, projectPaths, isDefaultProject);
    }

    private JavaProject getJavaProject(TraversableContext tc) {
        Project project = (Project)tc.find("Project");
        PropertyStorage propertyData = JProjectPathsPanel.getPropertyData((Namespace)tc);
        return JavaProject.getInstance(project, propertyData.getProperties());
    }

    private JProjectPaths getJProjectPaths(TraversableContext tc) {
        PropertyStorage propertyData = JProjectPathsPanel.getPropertyData((Namespace)tc);
        return JProjectPaths.getInstance((PropertyStorage)propertyData);
    }

    private void loadFrom(JavaProject javaProject, JProjectPaths projectPaths, boolean isDefaultProject) {
        URL outputDir = javaProject.getOutputDirectory();
        if (isDefaultProject) {
            URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.outputDirTextField.setBaseURL(defaultProjectDir);
        } else {
            this.outputDirTextField.setBaseURL(null);
        }
        this.outputDirTextField.setURL(outputDir);
        URLPath extraCP = projectPaths.getAdditionalClassPath();
        this.additionalClassPathTextField.setURLPath(extraCP);
    }

    private void commitTo(JavaProject javaProject, JProjectPaths projectPaths, boolean isDefaultProject) throws TraversalException {
        URL outputDirURL = this.outputDirTextField.getURL();
        if (isDefaultProject) {
            URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            if (outputDirURL == null || URLFileSystem.toRelativeSpec((URL)outputDirURL, (URL)defaultProjectDir, (boolean)true) == null) {
                throw new TraversalException(JProjectArb.format((int)137, (Object)JProjectArb.getString((int)138), (Object)this.outputDirTextField.getText()));
            }
            javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)outputDirURL));
        } else {
            if (outputDirURL == null) {
                if (!ModelUtil.hasLength((String)this.outputDirTextField.getText())) {
                    throw new TraversalException(JProjectArb.getString((int)148), JProjectArb.getString((int)145));
                }
                throw new TraversalException(JProjectArb.format((int)130, (Object)JProjectArb.getString((int)146), (Object)this.outputDirTextField.getText().trim()), JProjectArb.getString((int)145));
            }
            if (URLFileSystem.isReadOnly((URL)outputDirURL)) {
                throw new TraversalException(JProjectArb.getString((int)149), JProjectArb.getString((int)145));
            }
            if (!URLFileSystem.isValid((URL)outputDirURL)) {
                String fileName = URLFileSystem.getPlatformPathName((URL)outputDirURL);
                if (fileName.length() > 80) {
                    fileName = StringUtil.truncateFileNameForMessage((String)fileName);
                }
                this.outputDirTextField.requestFocus();
                throw new TraversalException(JProjectArb.format((int)130, (Object)JProjectArb.getString((int)146), (Object)fileName), JProjectArb.getString((int)145));
            }
            javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)outputDirURL));
        }
        try {
            URLPath addClsPath = this.additionalClassPathTextField.getURLPath();
            projectPaths.setAdditionalClassPath(addClsPath);
        }
        catch (URLPathField.BadEntryException bee) {
            throw new TraversalException(ControlsArb.format((int)55, (Object)bee.getBadEntry()));
        }
    }

    public static void promptForDirectoryValue(Component parent, JTextField dirField, String dirName) {
        URLChooser chooser = DialogUtil.newURLChooser((Context)Context.newIdeContext());
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(1);
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            URL dir = chooser.getSelectedURL();
            if (dir != null) {
                dirField.setText(URLFileSystem.getPlatformPathName((URL)dir));
            } else {
                dirField.setText("");
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.outputDirLabel, (Component)this.outputDirTextField, (String)JProjectArb.getString((int)142));
        ResourceUtils.resLabel((JLabel)this.additionalClassPathLabel, (Component)this.additionalClassPathTextField, (String)JProjectArb.getString((int)141));
        ResourceUtils.resButton((AbstractButton)this.outputDirButton, (String)JProjectArb.getString((int)41));
        ResourceUtils.resButton((AbstractButton)this.additionalClassPathButton, (String)JProjectArb.getString((int)144));
        this.outputDirTextField.setDialogTitle(JProjectArb.getString((int)143));
        this.outputDirButton.addActionListener((ActionListener)this.outputDirTextField);
        this.additionalClassPathButton.addActionListener((ActionListener)this.additionalClassPathTextField);
        this.additionalClassPathTextField.setEditTitle(JProjectArb.getString((int)140));
        this.add(this.outputDirLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.outputDirTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.outputDirButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.additionalClassPathLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.additionalClassPathTextField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.additionalClassPathButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.spacerLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

