/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSelectionEvent;
import oracle.jdeveloper.cmt.CmtSelectionListener;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdevimpl.cmtimpl.JbComponent;

public final class JbSelectionModel
implements CmtSelectionModel {
    private ArrayList selection = new ArrayList();
    private ArrayList listeners = new ArrayList();
    private JbComponent owner;
    private boolean stale;

    public JbSelectionModel(JbComponent owner) {
        this.owner = owner;
    }

    @Override
    public boolean isSelected(CmtModelNode node) {
        this.refresh();
        return node != null && this.selection.contains(node);
    }

    @Override
    public int getSelectionCount() {
        this.refresh();
        return this.selection.size();
    }

    @Override
    public CmtModelNode[] getSelection() {
        this.refresh();
        CmtModelNode[] result = new CmtModelNode[this.selection.size()];
        this.selection.toArray(result);
        return result;
    }

    @Override
    public void clearSelection() {
        this.refresh();
        if (this.selection.size() > 0) {
            this.selection.clear();
            if (!this.stale) {
                this.owner.setLastDesignedNodes(null, null);
            }
            this.fireSelectionChanged(new CmtSelectionEvent(this));
        }
    }

    @Override
    public void setSelection(CmtModelNode[] newSelection) {
        int i;
        Assert.check((!this.stale ? 1 : 0) != 0, (String)"Stale JbSelectionModel");
        this.refresh();
        boolean different = false;
        if (newSelection != null) {
            if (newSelection.length == this.selection.size()) {
                for (i = 0; i < newSelection.length; ++i) {
                    if (newSelection[i] == this.selection.get(i)) continue;
                    different = true;
                    break;
                }
            } else {
                different = true;
            }
        } else if (this.selection.size() > 0) {
            different = true;
        }
        if (different) {
            this.selection.clear();
            if (newSelection != null) {
                for (i = 0; i < newSelection.length; ++i) {
                    this.selection.add(newSelection[i]);
                }
            }
            this.owner.setLastDesignedNodes(null, (Element[])newSelection);
            this.fireSelectionChanged(new CmtSelectionEvent(this));
        }
    }

    @Override
    public void addCmtSelectionListener(CmtSelectionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeCmtSelectionListener(CmtSelectionListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    void release() {
        this.stale = true;
        this.selection.clear();
    }

    private void refresh() {
        CmtModelNode[] nodes;
        if (this.stale && !this.owner.isStale() && (nodes = (CmtModelNode[])this.owner.getLastDesignedNodes(null)) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                this.selection.add(nodes[i]);
            }
            this.stale = false;
        }
    }

    private void fireSelectionChanged(CmtSelectionEvent e) {
        List list = (List)this.listeners.clone();
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            ((CmtSelectionListener)list.get(i)).selectionChanged(e);
        }
    }
}

