/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.beans.MethodDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.jdeveloper.cmt.CmtEventSet;
import oracle.jdeveloper.cmt.CmtMethod;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtMethodSource;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.cmtimpl.JbFeature;
import oracle.jdevimpl.cmtimpl.JbMethodCall;
import oracle.jdevimpl.cmtimpl.JbPropertySetting;
import oracle.jdevimpl.cmtimpl.JbSubcomponent;
import oracle.jdevimpl.cmtimpl.JbValue;

final class JbMethod
extends JbFeature
implements CmtMethodSource {
    private static final String EXTENSION_SUPPORT = "jbInitExtensionSupport";
    private static final Object EXTENSION_MARKER = new Object();
    private JavaMethod method;
    private String methodName;
    private String signature;
    private HashMap settingsMap;
    private boolean supportExtensions = System.getProperty("jbInitExtensionSupport", null) != null;
    private ArrayList propertySettings;
    private ArrayList methodCalls;
    private ArrayList extensions;
    private static String[] containerProps = new String[]{"setLayout", "add"};

    public JbMethod(JbComponent component, JavaMethod method) {
        super(component, method.getName());
        this.method = method;
        this.methodName = method != null ? method.getName() : null;
    }

    public JbMethod(JbComponent component, MethodDescriptor md) {
        super(component, md);
        this.methodName = md.getMethod().getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.getJotMethodSource() != null) {
            ((SourceMethod)this.method).setName(name);
        }
    }

    @Override
    public synchronized JavaMethod getJotMethod() {
        if (this.method == null && this.methodName != null) {
            MethodDescriptor md = (MethodDescriptor)this.getFeatureDescriptor();
            Collection methods = md != null ? Jot2Utils.getMethods(this.component.getType(), md.getMethod().getName()) : null;
            Iterator mIter = methods != null ? methods.iterator() : null;
            this.method = mIter != null && mIter.hasNext() ? (JavaMethod)mIter.next() : null;
        }
        return this.method;
    }

    public SourceMethod getJotMethodSource() {
        JavaMethod m = this.getJotMethod();
        return m != null && m.isSourceElement() ? (SourceMethod)m : null;
    }

    @Override
    public CmtPropertySetting[] getPropertySettings() {
        List list = this.getPropertySettings(false);
        CmtPropertySetting[] pss = new JbPropertySetting[list.size()];
        list.toArray(pss);
        return pss;
    }

    @Override
    public List getPropertySettings(boolean recurse) {
        return this.getPropertySettings(null, recurse);
    }

    @Override
    public CmtPropertySetting[] getPropertySettings(CmtSubcomponent subcomponent) {
        List list = this.getPropertySettings(subcomponent, false);
        CmtPropertySetting[] pss = new JbPropertySetting[list.size()];
        list.toArray(pss);
        return pss;
    }

    @Override
    public List getPropertySettings(CmtSubcomponent subcomponent, boolean recurse) {
        int i;
        if (this.propertySettings == null) {
            this.annotate();
        }
        List<Object> scProperties = null;
        if (subcomponent == null) {
            scProperties = (ArrayList)this.propertySettings.clone();
        } else if (this.supportExtensions) {
            ArrayList list = (ArrayList)this.settingsMap.get(subcomponent);
            if (list != null) {
                scProperties = (List)list.clone();
            } else {
                scProperties = new ArrayList();
                if (this.extensions != null) {
                    for (i = this.extensions.size() - 1; i >= 0; --i) {
                        scProperties.add(EXTENSION_MARKER);
                    }
                }
            }
        } else {
            scProperties = new ArrayList();
            int size = this.propertySettings.size();
            for (i = 0; i < size; ++i) {
                JbPropertySetting ps = (JbPropertySetting)this.propertySettings.get(i);
                if (ps.getSubcomponent() != subcomponent) continue;
                scProperties.add(ps);
            }
        }
        if (this.supportExtensions) {
            int marker = 0;
            int index = scProperties.indexOf(EXTENSION_MARKER);
            while (index >= 0) {
                JbMethod extension;
                List subList;
                scProperties.remove(index);
                if (recurse && (subList = (extension = (JbMethod)this.extensions.get(marker++)).getPropertySettings(subcomponent, recurse)) != null) {
                    scProperties.addAll(index, subList);
                }
                index = scProperties.indexOf(EXTENSION_MARKER);
            }
        }
        return scProperties;
    }

    @Override
    public CmtPropertySetting getPropertySetting(CmtSubcomponent subcomponent, String name) {
        return this.getPropertySetting(subcomponent, name, false);
    }

    @Override
    public CmtPropertySetting getPropertySetting(CmtSubcomponent subcomponent, String name, boolean recurse) {
        List settings = this.getPropertySettings(subcomponent, recurse);
        int size = settings.size();
        for (int i = 0; i < size; ++i) {
            String propName;
            CmtPropertySetting setting = (CmtPropertySetting)settings.get(i);
            CmtProperty prop = setting != null ? setting.getProperty() : null;
            String string = propName = prop != null ? prop.getName() : null;
            if (propName == null || !propName.equals(name)) continue;
            return setting;
        }
        return null;
    }

    @Override
    public CmtPropertySetting addPropertySetting(CmtSubcomponent subcomponent, CmtProperty property, String valueText) {
        return this.addPropertySetting(null, subcomponent, property, valueText);
    }

    public CmtPropertySetting addPropertySetting(JbPropertySetting setting, CmtSubcomponent subcomponent, CmtProperty property, String valueText) {
        if (this.propertySettings == null) {
            this.annotate();
        }
        JbPropertySetting propertySetting = this.insertPropertySetterCall(setting, subcomponent, property, valueText);
        return propertySetting;
    }

    @Override
    public void removePropertySetting(CmtPropertySetting setting) {
        SourceExpressionStatement elem;
        CmtMethodCall cmtCall = setting != null ? setting.getMethodCall() : null;
        SourceMethodCallExpression jotCall = cmtCall != null ? cmtCall.getJotMethodCall() : null;
        boolean transactionCreated = this.ensureTransaction();
        if (jotCall != null && (elem = Jot2Utils.getEnclosingStatement((SourceExpression)jotCall)) != null) {
            elem.removeSelf();
        }
        this.recursiveRemovePropertySetting(setting);
        if (transactionCreated) {
            this.component.commit("Remove property setting");
        }
    }

    boolean recursiveRemovePropertySetting(CmtPropertySetting setting) {
        Iterator i;
        if (setting == null) {
            return false;
        }
        if (this.propertySettings != null && this.propertySettings.contains(setting)) {
            this.propertySettings.remove(setting);
            if (this.supportExtensions) {
                List list;
                CmtSubcomponent sub = setting.getSubcomponent();
                List list2 = list = this.settingsMap != null ? (List)this.settingsMap.get(sub) : null;
                if (list != null) {
                    list.remove(setting);
                }
            }
            return true;
        }
        boolean removed = false;
        if (this.extensions != null && (i = this.extensions.iterator()) != null) {
            while (!removed && i.hasNext()) {
                JbMethod extension = (JbMethod)i.next();
                removed = extension.recursiveRemovePropertySetting(setting);
            }
        }
        return removed;
    }

    void clearMethodCalls() {
        if (this.methodCalls != null) {
            this.methodCalls.clear();
            this.methodCalls = null;
            if (this.extensions != null) {
                Iterator i = this.extensions.iterator();
                if (i != null) {
                    while (i.hasNext()) {
                        JbMethod extension = (JbMethod)i.next();
                        extension.clearMethodCalls();
                    }
                }
                if (this.propertySettings == null) {
                    this.extensions.clear();
                    this.extensions = null;
                }
            }
        }
    }

    @Override
    public CmtMethodCall[] getMethodCalls() {
        List list = this.getMethodCalls(false);
        CmtMethodCall[] calls = new CmtMethodCall[list.size()];
        list.toArray(calls);
        return calls;
    }

    @Override
    public List getMethodCalls(boolean recurse) {
        return this.getMethodCalls(null, null, recurse);
    }

    @Override
    public CmtMethodCall[] getMethodCalls(CmtSubcomponent subcomponent, String methodName) {
        List list = this.getMethodCalls(subcomponent, methodName, false);
        CmtMethodCall[] calls = new CmtMethodCall[list.size()];
        list.toArray(calls);
        return calls;
    }

    @Override
    public List getMethodCalls(CmtSubcomponent subcomponent, String methodName, boolean recurse) {
        List<JbMethodCall> matchingCalls;
        block10: {
            int marker;
            block9: {
                if (this.methodCalls == null) {
                    this.buildMethodCalls();
                }
                matchingCalls = null;
                marker = 0;
                if (subcomponent != null || methodName != null) break block9;
                if (this.extensions == null || this.extensions.size() == 0) {
                    matchingCalls = (List)this.methodCalls.clone();
                } else {
                    matchingCalls = new ArrayList();
                    int size = this.methodCalls.size();
                    for (int i = 0; i < size; ++i) {
                        JbMethod extension;
                        List calls;
                        Iterator j;
                        Object call = this.methodCalls.get(i);
                        if (call != EXTENSION_MARKER) {
                            matchingCalls.add((JbMethodCall)call);
                            continue;
                        }
                        if (!recurse || (j = (calls = (extension = (JbMethod)this.extensions.get(marker++)).getMethodCalls(subcomponent, methodName, recurse)).iterator()) == null) continue;
                        while (j.hasNext()) {
                            matchingCalls.add((JbMethodCall)j.next());
                        }
                    }
                }
                break block10;
            }
            matchingCalls = new ArrayList();
            Iterator iter = this.methodCalls.iterator();
            if (iter == null) break block10;
            while (iter.hasNext()) {
                JbMethod extension;
                List calls;
                Iterator i;
                Object call = iter.next();
                if (call != EXTENSION_MARKER) {
                    JbMethodCall mc = (JbMethodCall)call;
                    if (subcomponent != null && mc.getSubcomponent() != subcomponent || methodName != null && !mc.getMethodName().equals(methodName)) continue;
                    matchingCalls.add(mc);
                    continue;
                }
                if (!recurse || (i = (calls = (extension = (JbMethod)this.extensions.get(marker++)).getMethodCalls(subcomponent, methodName, recurse)).iterator()) == null) continue;
                while (i.hasNext()) {
                    JbMethodCall mc = (JbMethodCall)i.next();
                    if (subcomponent != null && mc.getSubcomponent() != subcomponent || methodName != null && !mc.getMethodName().equals(methodName)) continue;
                    matchingCalls.add(mc);
                }
            }
        }
        return matchingCalls;
    }

    @Override
    public CmtMethodCall addMethodCall(CmtSubcomponent subcomponent, String methodName) {
        return this.addMethodCall(null, false, true, subcomponent, methodName);
    }

    @Override
    public CmtMethodCall addMethodCall(CmtMethodCall marker, boolean before, boolean subcomponentRelative, CmtSubcomponent subcomponent, String methodName) {
        return this.addOrMoveMethodCall(marker, before, subcomponentRelative, subcomponent, null, methodName);
    }

    private CmtMethodCall addOrMoveMethodCall(CmtMethodCall marker, boolean before, boolean subcomponentRelative, CmtSubcomponent subcomponent, CmtMethodCall methodCall, String methodName) {
        SourceExpressionStatement relative;
        CmtMethodSource caller;
        if (this.methodCalls == null) {
            this.buildMethodCalls();
        }
        CmtMethodSource cmtMethodSource = caller = marker != null ? marker.getParent() : null;
        if (caller != this) {
            marker = null;
        }
        if (marker == null) {
            if (subcomponentRelative) {
                marker = before ? this.getFirstMethodCall(subcomponent) : this.getLastMethodCall(subcomponent);
            } else {
                CmtMethodCall cmtMethodCall = marker = before ? this.getFirstMethodCall(methodName) : this.getLastMethodCall(methodName);
            }
        }
        if (marker == null && before) {
            int size;
            List settings = this.getPropertySettings(false);
            int n = size = settings != null ? settings.size() : -1;
            if (size > 0) {
                marker = ((CmtPropertySetting)settings.get(size - 1)).getMethodCall();
            }
            before = false;
        }
        SourceMethodCallExpression call = marker != null ? marker.getJotMethodCall() : null;
        SourceExpressionStatement sourceExpressionStatement = relative = call != null ? Jot2Utils.getEnclosingStatement((SourceExpression)call) : null;
        if (methodCall == null) {
            methodCall = this.makeMethodCall(subcomponent, (SourceElement)relative, before, methodName, null, false);
            if (methodCall != null) {
                this.insertMethodCall(marker, before, methodCall);
            }
        } else {
            SourceMethod jMethod = this.getJotMethodSource();
            SourceBlock jCodeBlock = jMethod.getBlock();
            List list = jCodeBlock.getCodeElements();
            SourceMethodCallExpression jCall = methodCall.getJotMethodCall();
            SourceExpressionStatement jStmt = Jot2Utils.getEnclosingStatement((SourceExpression)jCall);
            if (jStmt != relative) {
                int currentIndex = list.indexOf(jStmt);
                int targetIndex = list.indexOf(relative);
                if (before) {
                    if (currentIndex < targetIndex) {
                        --targetIndex;
                    }
                } else if (currentIndex > targetIndex) {
                    ++targetIndex;
                }
                list.remove(jStmt);
                list.add(targetIndex, jStmt);
                this.recursiveRemoveMethodCall(methodCall);
                this.insertMethodCall(marker, before, methodCall);
            }
        }
        return methodCall;
    }

    @Override
    public void removeMethodCall(CmtMethodCall methodCall) {
        SourceExpressionStatement elem;
        SourceMethodCallExpression mc;
        SourceMethodCallExpression sourceMethodCallExpression = mc = methodCall != null ? methodCall.getJotMethodCall() : null;
        if (mc != null && (elem = Jot2Utils.getEnclosingStatement((SourceExpression)mc)) != null) {
            this.ensureTransaction();
            elem.removeSelf();
        }
        this.recursiveRemoveMethodCall(methodCall);
    }

    boolean recursiveRemoveMethodCall(CmtMethodCall methodCall) {
        Iterator i;
        if (methodCall == null) {
            return false;
        }
        if (this.methodCalls != null && this.methodCalls.contains(methodCall)) {
            this.methodCalls.remove(methodCall);
            return true;
        }
        boolean removed = false;
        if (this.extensions != null && (i = this.extensions.iterator()) != null) {
            while (!removed && i.hasNext()) {
                JbMethod extension = (JbMethod)i.next();
                removed = extension.recursiveRemoveMethodCall(methodCall);
            }
        }
        return removed;
    }

    @Override
    public CmtMethodCall moveMethodCall(CmtMethodCall marker, boolean before, boolean subcomponentRelative, CmtMethodCall methodCall) {
        return this.addOrMoveMethodCall(marker, before, subcomponentRelative, methodCall.getSubcomponent(), methodCall, methodCall.getMethodName());
    }

    void insertMethodCall(CmtMethodCall marker, boolean before, CmtMethodCall methodCall) {
        int index;
        if (this.methodCalls != null && marker != null && (index = this.methodCalls.indexOf(marker)) >= 0) {
            if (!before) {
                ++index;
            }
            this.methodCalls.add(index, methodCall);
            return;
        }
        this.methodCalls.add(methodCall);
    }

    JbPropertySetting insertPropertySetting(JbPropertySetting propertySetting, Object relativeSetting, boolean before, JbMethodCall methodCall, CmtSubcomponent subcomponent, CmtProperty property) {
        if (propertySetting == null) {
            propertySetting = new JbPropertySetting(subcomponent, property, methodCall);
        } else {
            propertySetting.setMethodCall(methodCall);
        }
        if (relativeSetting == null) {
            if (before) {
                this.propertySettings.add(0, propertySetting);
                if (this.supportExtensions) {
                    ArrayList<JbPropertySetting> list;
                    CmtSubcomponent sub = propertySetting.getSubcomponent();
                    ArrayList<JbPropertySetting> arrayList = list = this.settingsMap != null ? (ArrayList<JbPropertySetting>)this.settingsMap.get(sub) : null;
                    if (list != null) {
                        list.add(0, propertySetting);
                    } else if (this.settingsMap == null) {
                        this.settingsMap = new HashMap();
                        list = new ArrayList();
                        list.add(propertySetting);
                        this.settingsMap.put(sub, list);
                    } else {
                        list = new ArrayList<JbPropertySetting>();
                        list.add(propertySetting);
                        this.settingsMap.put(sub, list);
                    }
                }
            } else {
                this.propertySettings.add(propertySetting);
                if (this.supportExtensions) {
                    ArrayList<JbPropertySetting> list;
                    CmtSubcomponent sub = propertySetting.getSubcomponent();
                    ArrayList<JbPropertySetting> arrayList = list = this.settingsMap != null ? (ArrayList<JbPropertySetting>)this.settingsMap.get(sub) : null;
                    if (list != null) {
                        list.add(propertySetting);
                    } else if (this.settingsMap == null) {
                        this.settingsMap = new HashMap();
                        list = new ArrayList();
                        list.add(propertySetting);
                        this.settingsMap.put(sub, list);
                    } else {
                        list = new ArrayList<JbPropertySetting>();
                        list.add(propertySetting);
                        this.settingsMap.put(sub, list);
                    }
                }
            }
        } else {
            int offset;
            int index = this.propertySettings.indexOf(relativeSetting);
            if (index == -1 && this.extensions != null && (offset = this.extensions.indexOf(relativeSetting)) >= 0) {
                for (int i = 0; i < this.propertySettings.size(); ++i) {
                    if (this.propertySettings.get(i) != EXTENSION_MARKER || --offset >= 0) continue;
                    index = i;
                    break;
                }
            }
            if (!before) {
                ++index;
            }
            if (index < 0) {
                index = 0;
            }
            this.propertySettings.add(index, propertySetting);
            if (this.supportExtensions) {
                ArrayList<JbPropertySetting> list;
                CmtSubcomponent sub = propertySetting.getSubcomponent();
                ArrayList<JbPropertySetting> arrayList = list = this.settingsMap != null ? (ArrayList<JbPropertySetting>)this.settingsMap.get(sub) : null;
                if (list != null) {
                    boolean added = false;
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        if (this.propertySettings.indexOf(list.get(i)) <= index) continue;
                        list.add(i, propertySetting);
                        added = true;
                        break;
                    }
                    if (!added) {
                        list.add(propertySetting);
                    }
                } else if (this.settingsMap == null) {
                    this.settingsMap = new HashMap();
                    list = new ArrayList();
                    list.add(propertySetting);
                    this.settingsMap.put(sub, list);
                } else {
                    list = new ArrayList<JbPropertySetting>();
                    list.add(propertySetting);
                    this.settingsMap.put(sub, list);
                }
            }
        }
        return propertySetting;
    }

    static boolean isDelegatedCall(CmtSubcomponent subcomponent, String methodName) {
        boolean b = false;
        if (subcomponent.getComponent().getContainerDelegate() != null) {
            for (int i = 0; i < containerProps.length; ++i) {
                if (!methodName.equals(containerProps[i])) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    private JbMethodCall makeMethodCall(CmtSubcomponent subcomponent, SourceElement marker, boolean before, String methodName, String valueText, boolean constrain) {
        if (marker == null) {
            SourceElement mustBeBefore = this.firstMarkerAfterSettings();
            SourceElement mustBeAfter = this.lastMarkerBeforeSettings();
            if (before && mustBeAfter != null) {
                before = false;
                marker = mustBeAfter;
            }
            if (!before && mustBeBefore != null && constrain) {
                before = true;
                marker = mustBeBefore;
            }
        }
        SourceFile jFile = (SourceFile)this.component.getFile();
        boolean transactionCreated = this.ensureTransaction();
        SourceFactory jFactory = jFile.getFactory();
        SourceMethod jMethod = this.getJotMethodSource();
        SourceBlock jCodeBlock = jMethod.getBlock();
        SourceExpression jExpr = jFactory.createExpression(subcomponent.getName());
        if (JbMethod.isDelegatedCall(subcomponent, methodName)) {
            jExpr = jFactory.createMethodCall(jExpr, subcomponent.getComponent().getContainerDelegate(), null);
        }
        JbMethodCall jbMethodCall = null;
        SourceMethodCallExpression jMethodCall = jFactory.createMethodCall(jExpr, methodName, null);
        SourceExpressionStatement jExprStmt = jFactory.createExpressionStatement((SourceExpression)jMethodCall);
        List list = jCodeBlock.getCodeElements();
        int count = list.size();
        if (count == 0 || marker == null) {
            list.add(before ? 0 : count, jExprStmt);
        } else {
            for (int i = 0; i < count; ++i) {
                Object obj = list.get(i);
                if (obj != marker) continue;
                if (before) {
                    list.add(i, jExprStmt);
                } else {
                    list.add(i + 1, jExprStmt);
                }
                marker = null;
                break;
            }
            if (marker != null) {
                Assert.printStackTrace((boolean)true, (String)"Marker not found in block");
                list.add(jExprStmt);
            }
        }
        jFile.getTransaction().savepoint();
        if (jMethodCall != null && (jbMethodCall = new JbMethodCall(this, jMethodCall)) != null && valueText != null) {
            jbMethodCall.addArgument(null, false, valueText);
        }
        if (transactionCreated) {
            this.component.commit("Make method call");
        }
        return jbMethodCall;
    }

    private boolean ensureTransaction() {
        if (this.component.hasTrans()) {
            return false;
        }
        this.component.beginTrans();
        return true;
    }

    JbPropertySetting insertPropertySetterCall(JbPropertySetting setting, CmtSubcomponent subcomponent, CmtProperty property, String valueText) {
        SourceMethod ms;
        SourceBlock codeBlock;
        Object calls;
        SourceExpressionStatement element;
        SourceMethodCallExpression jMethodCall;
        CmtMethodCall cmtMethodCall;
        int i;
        int size;
        String methodName = property.getWriteMethod().getName();
        if (methodName != null && (methodName.equals("setModel") || methodName.equals("setDocument"))) {
            JbMethodCall methodCall = this.makeMethodCall(subcomponent, null, false, methodName, valueText, false);
            this.insertMethodCall(null, false, methodCall);
            return this.insertPropertySetting(setting, null, false, methodCall, subcomponent, property);
        }
        Object relativeSetting = null;
        JbMethod relativeMethod = null;
        boolean before = false;
        List settings = this.getPropertySettings(subcomponent, true);
        int n = size = settings != null ? settings.size() : -1;
        if (size > 0) {
            CmtPropertySetting candidateSetting = null;
            SourceMethod candidateMethod = null;
            SourceBlock candidateCodeBlock = null;
            JavaType[] noArgs = new JavaType[]{};
            for (i = size - 1; i >= 0; --i) {
                SourceExpressionStatement jParent;
                String propName;
                CmtPropertySetting propSet = (CmtPropertySetting)settings.get(i);
                CmtProperty prop = propSet != null ? propSet.getProperty() : null;
                String string = propName = prop != null ? prop.getName() : null;
                if (propName != null && (propName.equals("document") || propName.equals("model"))) continue;
                cmtMethodCall = propSet != null ? propSet.getMethodCall() : null;
                jMethodCall = cmtMethodCall != null ? cmtMethodCall.getJotMethodCall() : null;
                for (jParent = element = jMethodCall != null ? Jot2Utils.getEnclosingStatement((SourceExpression)jMethodCall) : null; jParent != null && !(jParent instanceof SourceMethod); jParent = jParent.getParent()) {
                }
                if (jParent == null) continue;
                if (jParent != candidateMethod) {
                    String name = ((SourceMethod)jParent).getName();
                    relativeMethod = (JbMethod)this.component.getDeclaredMethod(name, noArgs);
                    candidateMethod = (SourceMethod)jParent;
                    candidateCodeBlock = candidateMethod.getBlock();
                    if (candidateCodeBlock == null) {
                        relativeMethod = null;
                        candidateMethod = null;
                        candidateSetting = null;
                        continue;
                    }
                }
                if (!property.isEvent()) {
                    if (!propSet.isEventSetting()) {
                        relativeSetting = propSet;
                        break;
                    }
                    candidateSetting = propSet;
                    continue;
                }
                relativeSetting = propSet;
                break;
            }
            if (relativeSetting == null && candidateSetting != null) {
                relativeSetting = candidateSetting;
                before = true;
            }
        }
        if (relativeSetting == null && this.extensions != null) {
            String name = "jbInit_" + subcomponent.getName();
            block2: for (int j = 0; j < this.extensions.size(); ++j) {
                Iterator k;
                CmtMethod extension = (CmtMethod)this.extensions.get(j);
                if (!name.equals(extension.getName()) || (k = (calls = this.getMethodCalls(this.component.getSubcomponent(null), name, false)).iterator()) == null) continue;
                while (k.hasNext()) {
                    CmtMethodCall call = (CmtMethodCall)k.next();
                    CmtValue[] args = call.getArguments();
                    if (args != null && args.length != 0) continue;
                    relativeMethod = this;
                    relativeSetting = call;
                    continue block2;
                }
            }
        }
        SourceBlock sourceBlock = codeBlock = (ms = this.getJotMethodSource()) != null ? ms.getBlock() : null;
        if (relativeSetting == null && codeBlock != null) {
            CmtValue[] args;
            CmtMethodCall call;
            Iterator k;
            List calls2;
            CmtMethod extension;
            String name;
            CmtSubcomponent sibling;
            int scIndex = this.component.getSubcomponentIndex(subcomponent);
            int scCount = this.component.getSubcomponentCount();
            block4: for (i = scIndex - 1; i >= 0 && relativeSetting == null; --i) {
                sibling = this.component.getSubcomponent(i);
                settings = this.getPropertySettings(sibling, false);
                int n2 = size = settings != null ? settings.size() : -1;
                if (size > 0) {
                    for (int j = size - 1; j >= 0; --j) {
                        CmtPropertySetting propSet = (CmtPropertySetting)settings.get(j);
                        cmtMethodCall = propSet != null ? propSet.getMethodCall() : null;
                        jMethodCall = cmtMethodCall != null ? cmtMethodCall.getJotMethodCall() : null;
                        SourceExpressionStatement sourceExpressionStatement = element = jMethodCall != null ? Jot2Utils.getEnclosingStatement((SourceExpression)jMethodCall) : null;
                        if (element == null) continue;
                        relativeMethod = this;
                        relativeSetting = propSet;
                        break;
                    }
                    if (relativeSetting != null) break;
                }
                if (relativeSetting != null || this.extensions == null) continue;
                name = "jbInit_" + sibling.getName();
                for (int j = 0; j < this.extensions.size(); ++j) {
                    extension = (CmtMethod)this.extensions.get(j);
                    if (!name.equals(extension.getName())) continue;
                    calls2 = this.getMethodCalls(this.component.getSubcomponent(null), name, false);
                    k = calls2.iterator();
                    if (k != null) {
                        while (k.hasNext()) {
                            call = (CmtMethodCall)k.next();
                            args = call.getArguments();
                            if (args != null && args.length != 0) continue;
                            relativeMethod = this;
                            relativeSetting = call;
                            break;
                        }
                    }
                    if (relativeSetting != null) continue block4;
                }
            }
            if (relativeSetting == null) {
                block8: for (i = scIndex + 1; i < scCount && relativeSetting == null; ++i) {
                    sibling = this.component.getSubcomponent(i);
                    settings = this.getPropertySettings(sibling, false);
                    int n3 = size = settings != null ? settings.size() : -1;
                    if (size > 0) {
                        SourceExpressionStatement element2;
                        CmtPropertySetting propSet = (CmtPropertySetting)settings.get(0);
                        CmtMethodCall cmtMethodCall2 = propSet != null ? propSet.getMethodCall() : null;
                        SourceMethodCallExpression jMethodCall2 = cmtMethodCall2 != null ? cmtMethodCall2.getJotMethodCall() : null;
                        SourceExpressionStatement sourceExpressionStatement = element2 = jMethodCall2 != null ? Jot2Utils.getEnclosingStatement((SourceExpression)jMethodCall2) : null;
                        if (element2 == null) continue;
                        relativeMethod = this;
                        relativeSetting = propSet;
                        before = true;
                        break;
                    }
                    if (relativeSetting != null || this.extensions == null) continue;
                    name = "jbInit_" + sibling.getName();
                    for (int j = 0; j < this.extensions.size(); ++j) {
                        extension = (CmtMethod)this.extensions.get(j);
                        if (!name.equals(extension.getName())) continue;
                        calls2 = this.getMethodCalls(this.component.getSubcomponent(null), name, false);
                        k = calls2.iterator();
                        if (k != null) {
                            while (k.hasNext()) {
                                call = (CmtMethodCall)k.next();
                                args = call.getArguments();
                                if (args != null && args.length != 0) continue;
                                relativeMethod = this;
                                relativeSetting = call;
                                before = true;
                                break;
                            }
                        }
                        if (relativeSetting != null) continue block8;
                    }
                }
            }
        }
        if (relativeSetting != null) {
            CmtMethodCall cmtMethodCall3 = relativeSetting instanceof CmtPropertySetting ? ((CmtPropertySetting)relativeSetting).getMethodCall() : (CmtMethodCall)relativeSetting;
            SourceMethodCallExpression jMethodCall3 = cmtMethodCall3 != null ? cmtMethodCall3.getJotMethodCall() : null;
            SourceExpressionStatement element3 = jMethodCall3 != null ? Jot2Utils.getEnclosingStatement((SourceExpression)jMethodCall3) : null;
            JbMethodCall jbMethodCall = super.makeMethodCall(subcomponent, (SourceElement)element3, before, methodName, valueText, true);
            relativeMethod.insertMethodCall(cmtMethodCall3, before, jbMethodCall);
            return relativeMethod.insertPropertySetting(setting, relativeSetting, before, jbMethodCall, subcomponent, property);
        }
        SourceExpression lastSuper = null;
        calls = Jot2Utils.getMethodCalls(codeBlock, null);
        for (i = 0; i < ((SourceExpression[])calls).length; ++i) {
            if (!JbMethod.isASuperCall(calls[i])) continue;
            lastSuper = calls[i];
            break;
        }
        JbMethodCall methodCall = this.makeMethodCall(subcomponent, null, lastSuper == null, methodName, valueText, true);
        this.insertMethodCall(null, lastSuper == null, methodCall);
        return this.insertPropertySetting(setting, null, true, methodCall, subcomponent, property);
    }

    CmtMethodCall getFirstAddCall() {
        return this.getFirstMethodCall("add");
    }

    SourceElement lastMarkerBeforeSettings() {
        SourceElement jMethodCall;
        SourceElement jBlockElement = this.lastSubcomponentAssign();
        if (jBlockElement == null && (jMethodCall = this.lastSuperCall()) instanceof SourceExpression) {
            jBlockElement = Jot2Utils.getEnclosingStatement((SourceExpression)jMethodCall);
        }
        return jBlockElement;
    }

    SourceElement firstMarkerAfterSettings() {
        CmtMethodCall call = this.getFirstAddCall();
        return call != null ? Jot2Utils.getEnclosingStatement((SourceExpression)call.getJotMethodCall()) : null;
    }

    SourceElement lastSubcomponentAssign() {
        CmtSubcomponent[] subs = this.component.getSubcomponents();
        SourceVariableDeclaration best = null;
        int bestLoc = -1;
        try {
            for (int i = 0; i < subs.length; ++i) {
                SourceAssignmentExpression assn;
                int iLoc;
                SourceVariable var = subs[i].getVariable();
                if (var != null) {
                    SourceVariableDeclaration decl = var.getOwningDeclaration();
                    int n = iLoc = decl instanceof SourceLocalVariableDeclaration ? decl.getStartOffset() : -1;
                    if (iLoc >= 0 && (best == null || iLoc > bestLoc)) {
                        best = decl;
                        bestLoc = iLoc;
                    }
                }
                if ((assn = subs[i].getAssignment()) == null || var != null && assn.getSecondOperand() == var.getInitializer() || (iLoc = assn.getStartOffset()) < 0 || best != null && assn.getStartOffset() <= bestLoc) continue;
                best = Jot2Utils.getEnclosingStatement((SourceExpression)assn);
                bestLoc = iLoc;
            }
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
        return best;
    }

    SourceElement lastSuperCall() {
        SourceMethod ms = this.getJotMethodSource();
        SourceBlock cb = ms.getBlock();
        SourceExpression[] calls = Jot2Utils.getMethodCalls(cb, null);
        SourceExpression best = null;
        for (int i = 0; i < calls.length; ++i) {
            if (!JbMethod.isASuperCall(calls[i]) || best != null && best.getStartOffset() >= calls[i].getStartOffset()) continue;
            best = calls[i];
        }
        return best != null ? best : null;
    }

    static boolean isASuperCall(SourceExpression jExpr) {
        jExpr = jExpr != null ? ((SourceMethodCallExpression)jExpr).getLhsOperand() : null;
        String caller = jExpr != null ? jExpr.getText() : "";
        return caller.equals("super");
    }

    @Override
    public boolean isPropertySetting(CmtMethodCall call) {
        SourceMethodCallExpression marker = call.getJotMethodCall();
        List settings = this.getPropertySettings(null, true);
        int size = settings != null ? settings.size() : -1;
        for (int i = 0; i < size; ++i) {
            CmtPropertySetting ps = (CmtPropertySetting)settings.get(i);
            CmtMethodCall mc = ps.getMethodCall();
            if (mc == null || mc.getJotMethodCall() != marker) continue;
            return true;
        }
        return false;
    }

    CmtMethodCall getFirstMethodCall(CmtSubcomponent subcomponent) {
        Iterator i;
        if (this.methodCalls == null) {
            this.buildMethodCalls();
        }
        if ((i = this.methodCalls.iterator()) != null) {
            while (i.hasNext()) {
                CmtMethodCall mc;
                Object call = i.next();
                if (call == EXTENSION_MARKER || (mc = (CmtMethodCall)call).getSubcomponent() != subcomponent || this.isPropertySetting(mc)) continue;
                return mc;
            }
        }
        return null;
    }

    CmtMethodCall getLastMethodCall(CmtSubcomponent subcomponent) {
        if (this.methodCalls == null) {
            this.buildMethodCalls();
        }
        int size = this.methodCalls.size();
        for (int i = size - 1; i >= 0; --i) {
            CmtMethodCall mc;
            Object call = this.methodCalls.get(i);
            if (call == EXTENSION_MARKER || (mc = (CmtMethodCall)call).getSubcomponent() != subcomponent || this.isPropertySetting(mc)) continue;
            return mc;
        }
        return null;
    }

    CmtMethodCall getFirstMethodCall(String name) {
        Iterator i;
        if (this.methodCalls == null) {
            this.buildMethodCalls();
        }
        if ((i = this.methodCalls.iterator()) != null) {
            while (i.hasNext()) {
                Object call = i.next();
                if (call == EXTENSION_MARKER) continue;
                CmtMethodCall cmtCall = (CmtMethodCall)call;
                SourceMethodCallExpression jotCall = cmtCall.getJotMethodCall();
                try {
                    if (JbMethod.isASuperCall((SourceExpression)jotCall) || !jotCall.getName().equals(name)) continue;
                    return cmtCall;
                }
                catch (Throwable t) {
                    Assert.printStackTrace((Throwable)t);
                }
            }
        }
        return null;
    }

    CmtMethodCall getLastMethodCall(String name) {
        if (this.methodCalls == null) {
            this.buildMethodCalls();
        }
        int size = this.methodCalls.size();
        for (int i = size - 1; i >= 0; --i) {
            CmtMethodCall cmtCall;
            SourceMethodCallExpression jotCall;
            Object call = this.methodCalls.get(i);
            if (call == EXTENSION_MARKER || JbMethod.isASuperCall((SourceExpression)(jotCall = (cmtCall = (CmtMethodCall)call).getJotMethodCall())) || !jotCall.getName().equals(name)) continue;
            return cmtCall;
        }
        return null;
    }

    public synchronized void annotate() {
        Iterator eIter;
        if (this.supportExtensions) {
            this.settingsMap = new HashMap();
        }
        this.propertySettings = new ArrayList();
        this.methodCalls = new ArrayList();
        SourceMethod jMethod = this.getJotMethodSource();
        SourceBlock jCodeBlock = jMethod != null ? jMethod.getBlock() : null;
        List jBlockElems = jCodeBlock != null ? jCodeBlock.getCodeElements() : null;
        Iterator iterator = eIter = jBlockElems != null ? jBlockElems.iterator() : null;
        if (eIter != null) {
            while (eIter.hasNext()) {
                SourceElement jElem = (SourceElement)eIter.next();
                switch (jElem.getSymbolKind()) {
                    case 18: {
                        this.annotateVariableDecl((SourceLocalVariableDeclaration)jElem);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 40: {
                        this.annotateExpressionStatement((SourceExpressionStatement)jElem);
                    }
                }
            }
        }
        this.propertySettings.trimToSize();
        this.methodCalls.trimToSize();
    }

    private void annotateVariableDecl(SourceLocalVariableDeclaration jDecl) {
        Iterator vIter;
        List jVars = jDecl.getVariables();
        Iterator iterator = vIter = jVars != null ? jVars.iterator() : null;
        if (vIter != null) {
            while (vIter.hasNext()) {
                SourceVariable var = (SourceVariable)vIter.next();
                this.component.makeSubcomponent(var, 1);
            }
        }
    }

    private void annotateExpressionStatement(SourceExpressionStatement jExprStmt) {
        SourceExpression jStmtExpr;
        SourceExpression sourceExpression = jStmtExpr = jExprStmt != null ? jExprStmt.getExpression() : null;
        if (jStmtExpr == null) {
            return;
        }
        int eType = jStmtExpr.getSymbolKind();
        CmtSubcomponent subcomponent = null;
        JbMethodCall jbCall = null;
        SourceMethodCallExpression actualCall = null;
        CmtMethod extension = null;
        switch (eType) {
            case 57: {
                String name;
                actualCall = (SourceMethodCallExpression)jStmtExpr;
                SourceExpression jExpr = actualCall.getLhsOperand();
                int lhsType = jExpr != null ? jExpr.getSymbolKind() : -1;
                switch (lhsType) {
                    case 57: {
                        String str;
                        SourceMethodCallExpression outerCall = (SourceMethodCallExpression)jExpr;
                        jExpr = outerCall.getLhsOperand();
                        subcomponent = this.component.getSubcomponent(jExpr != null ? jExpr.getText() : null);
                        if (subcomponent == null || (str = subcomponent.getComponent().getContainerDelegate()) != null && str.equals(outerCall.getName())) break;
                        subcomponent = null;
                        break;
                    }
                    case -1: 
                    case 61: {
                        String caller = jExpr != null ? jExpr.getText() : null;
                        subcomponent = this.component.getSubcomponent(caller);
                        break;
                    }
                    case 53: {
                        SourceDotExpression jDot = (SourceDotExpression)jExpr;
                        if (!jDot.getLhsOperand().getText().equals("this")) break;
                        subcomponent = this.component.getSubcomponent(jDot.getName());
                        break;
                    }
                    case 51: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 68: {
                        break;
                    }
                    case 67: {
                        break;
                    }
                    default: {
                        Assert.printStackTrace((boolean)true, (String)"Unrecognized expression type");
                    }
                }
                jbCall = new JbMethodCall(this, actualCall);
                this.methodCalls.add(jbCall);
                if (!this.supportExtensions || this.component.getSubcomponent(null) != subcomponent || (name = jbCall.getMethodName()) == null || !name.startsWith("jbInit_") || (extension = this.component.getDeclaredMethod(name, new JavaType[0])) == null) break;
                if (this.extensions == null) {
                    this.extensions = new ArrayList();
                }
                this.extensions.add(extension);
                this.methodCalls.add(EXTENSION_MARKER);
                break;
            }
            case 52: {
                SourceAssignmentExpression jAssignment = (SourceAssignmentExpression)jStmtExpr;
                SourceExpression jExpression = jAssignment.getFirstOperand();
                String name = jExpression.getText();
                CmtSubcomponent cmtSub = this.component.getSubcomponent(name);
                if (cmtSub != null) {
                    cmtSub.setAssignment(jAssignment);
                    break;
                }
                if (jExpression.getSymbolKind() != 53) break;
                SourceDotExpression jDot = (SourceDotExpression)jExpression;
                if (jDot.getLhsOperand().getText().equals("this")) {
                    cmtSub = this.component.getSubcomponent(jDot.getName());
                    if (cmtSub == null) break;
                    cmtSub.setAssignment(jAssignment);
                    break;
                }
                try {
                    Field field;
                    Object obj = JbValue.getValue(jDot.getLhsOperand(), "java.lang.Object", this.component);
                    Class<?> cls = obj != null ? obj.getClass() : null;
                    Field field2 = field = cls != null ? cls.getField(jDot.getName()) : null;
                    if (field == null) break;
                    field.set(obj, JbValue.getValue(jAssignment.getSecondOperand(), field.getType().getName(), this.component));
                }
                catch (CmtParseException obj) {
                }
                catch (Exception obj) {}
                break;
            }
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: {
                break;
            }
            case 67: {
                break;
            }
            case 64: {
                break;
            }
            case 60: {
                break;
            }
            default: {
                Assert.printStackTrace((boolean)true, (String)"Unrecognized expression type");
            }
        }
        if (actualCall != null) {
            List<Object> list;
            String actualName = actualCall.getName();
            int args = actualCall.getArgumentCount();
            JbPropertySetting ps = null;
            if (actualName != null && subcomponent != null && args == 1) {
                CmtEventSet eventSet;
                CmtProperty prop = ((JbComponent)subcomponent.getComponent()).getPropertyForSetter(actualCall);
                if (prop != null) {
                    CmtPropertyState propState;
                    ps = new JbPropertySetting(subcomponent, prop, jbCall);
                    this.propertySettings.add(ps);
                    if (this.supportExtensions) {
                        ArrayList<JbPropertySetting> list2 = (ArrayList<JbPropertySetting>)this.settingsMap.get(subcomponent);
                        if (list2 != null) {
                            list2.add(ps);
                        } else {
                            list2 = new ArrayList<JbPropertySetting>();
                            list2.add(ps);
                            this.settingsMap.put(subcomponent, list2);
                        }
                    }
                    if ((propState = subcomponent.getPropertyState(prop.getName())) != null) {
                        propState.refresh(ps);
                    }
                }
                if (ps == null && (eventSet = ((JbComponent)subcomponent.getComponent()).getEventSetForSetter(actualCall)) != null) {
                    ps = new JbPropertySetting(subcomponent, eventSet, jbCall);
                    this.propertySettings.add(ps);
                    if (this.supportExtensions) {
                        list = (List)this.settingsMap.get(subcomponent);
                        if (list != null) {
                            list.add(ps);
                        } else {
                            list = new ArrayList<Object>();
                            list.add(ps);
                            this.settingsMap.put(subcomponent, list);
                        }
                    }
                    ((JbSubcomponent)subcomponent).setEventAdapter(eventSet, ps);
                }
            }
            if (ps == null) {
                if (extension == null) {
                    JbValue.callMethod(actualCall, this.component, true);
                } else {
                    this.propertySettings.add(EXTENSION_MARKER);
                    if (this.supportExtensions) {
                        Iterator iter;
                        Set keys = this.settingsMap.keySet();
                        Iterator iterator = iter = keys != null ? keys.iterator() : null;
                        if (iter != null) {
                            while (iter.hasNext()) {
                                list = (ArrayList<Object>)this.settingsMap.get(iter.next());
                                if (list == null) continue;
                                list.add(EXTENSION_MARKER);
                            }
                        }
                    }
                    ((JbMethod)extension).annotate();
                }
            }
        }
    }

    synchronized void buildMethodCalls() {
        this.annotate();
    }

    public static String signature(JbMethod jbMethod) {
        return jbMethod.toString();
    }

    public static String signature(String name, JavaType[] types) {
        StringBuffer signature = new StringBuffer(name);
        signature.append("(");
        if (types.length > 0) {
            String typeName = types[0].getName();
            signature.append(typeName);
        }
        for (int i = 1; i < types.length; ++i) {
            String typeName = types[i].getName();
            signature.append(", ");
            signature.append(typeName);
        }
        signature.append(")");
        return signature.toString();
    }

    public synchronized String toString() {
        if (this.signature == null) {
            Collection collection = Jot2Utils.getParameterTypes(this.getJotMethod());
            JavaType[] types = new JavaType[collection != null ? collection.size() : 0];
            if (types.length > 0) {
                collection.toArray(types);
            }
            this.signature = JbMethod.signature(this.getName(), types);
        }
        return this.signature;
    }

    public SourceAssignmentExpression addSubcomponentAssignment(CmtSubcomponent sub, String valueText) {
        int index;
        SourceMethod jMethod = this.getJotMethodSource();
        SourceElement jSibling = this.lastMarkerBeforeSettings();
        boolean isBefore = false;
        if (jSibling == null) {
            if (this.methodCalls == null) {
                this.buildMethodCalls();
            }
            CmtMethodCall cmtMethodCall = null;
            if (this.methodCalls != null && this.methodCalls.size() > 0) {
                cmtMethodCall = (CmtMethodCall)this.methodCalls.get(0);
            }
            if (cmtMethodCall != null) {
                jSibling = Jot2Utils.getEnclosingStatement((SourceExpression)cmtMethodCall.getJotMethodCall());
                isBefore = true;
            }
        }
        SourceFile jFile = (SourceFile)this.component.getFile();
        SourceFactory jFactory = jFile.getFactory();
        SourceExpression jExpr = jFactory.createExpression(sub.getName() + " = " + valueText);
        SourceExpressionStatement jExprStmt = jFactory.createExpressionStatement(jExpr);
        SourceBlock jCodeBlock = jMethod.getBlock();
        List list = jCodeBlock.getCodeElements();
        int n = index = jSibling != null ? list.indexOf(jSibling) : -1;
        if (isBefore) {
            index = index <= 0 ? 1 : index;
        } else if (index < 0) {
            index = list.size() - 1;
        }
        list.add(isBefore ? --index : ++index, jExprStmt);
        jFile.getTransaction().savepoint();
        return jExpr instanceof SourceAssignmentExpression ? (SourceAssignmentExpression)jExpr : null;
    }
}

