/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.BackgroundTask;

public final class TaskMultiplexer {
    private final String _name;
    private final AsyncScheduler MX_SCHEDULER;
    private final Map _taskMap = new HashMap(10);

    public TaskMultiplexer(String multiplexerName) {
        this._name = multiplexerName;
        this.MX_SCHEDULER = new AsyncScheduler(multiplexerName, 10000, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWrapper(TaskWrapper wrapper, BackgroundTask task) {
        Map map = this._taskMap;
        synchronized (map) {
            ArrayList<TaskWrapper> wrapperList = (ArrayList<TaskWrapper>)this._taskMap.get(task);
            if (wrapperList == null) {
                wrapperList = new ArrayList<TaskWrapper>(5);
                this._taskMap.put(task, wrapperList);
            }
            wrapperList.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterWrapper(TaskWrapper wrapper, BackgroundTask task) {
        Map map = this._taskMap;
        synchronized (map) {
            List wrapperList = (List)this._taskMap.get(task);
            if (wrapperList == null) {
                Assert.println((String)"Warning, unexpected empty wrapper list.");
                Assert.printStackTrace();
            } else {
                wrapperList.remove(wrapper);
                if (wrapperList.size() == 0) {
                    task.cancel();
                    this._taskMap.remove(task);
                }
            }
        }
    }

    public static abstract class TaskWrapper
    extends AbstractBackgroundTask {
        private TaskMultiplexer _multiplexer;

        protected TaskWrapper(TaskMultiplexer multiplexer) {
            this._multiplexer = multiplexer;
        }

        protected void initializeComplete() {
            this._multiplexer.MX_SCHEDULER.scheduleTask((AsyncTask)this);
        }

        @Override
        protected final AsyncScheduler getSchedulerImpl() {
            return this._multiplexer.MX_SCHEDULER;
        }

        protected abstract BackgroundTask getSharedBackgroundTask();

        protected abstract void saveResults(BackgroundTask var1);

        @Override
        protected Object runTaskImpl() throws AsyncTask.CancelledException {
            BackgroundTask sharedTask = this.getSharedBackgroundTask();
            this._multiplexer.registerWrapper(this, sharedTask);
            boolean bail = false;
            while (!sharedTask.isFinished()) {
                if (this.isCancelledImpl()) {
                    bail = true;
                    break;
                }
                TaskWrapper.sleep((int)25);
                this.setProgress(sharedTask.getProgress());
                this.setProgressText(sharedTask.getProgressText());
            }
            this._multiplexer.deregisterWrapper(this, sharedTask);
            if (bail) {
                return "cancelled";
            }
            this.saveResults(sharedTask);
            return null;
        }
    }
}

