/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.datatransfer;

import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import oracle.bali.xml.share.GroupingAction;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.uieditor.datatransfer.DataAndPositions;
import oracle.jdeveloper.uieditor.datatransfer.PerformOperationAction;
import oracle.jdeveloper.uieditor.datatransfer.UIPosition;

public abstract class Operation {
    public static final float STANDARD_OPERATIONS_RANK = 0.9f;
    public static final String OPERATION_ICON = "palettleItemIcon";

    public abstract int getSupportedActions();

    public boolean doesActionMutateModel() {
        return true;
    }

    public abstract List getApplicableDataAndPositions(CmtModel var1, List var2, ExtendedTransferable var3);

    public boolean apply(CmtModel model, UIPosition pos, TransferDataInfo data) throws IOException {
        return false;
    }

    public Action createAsAction(CmtModel model, List listOfDataAndPositions) {
        if (listOfDataAndPositions.size() == 1) {
            DataAndPositions dap = (DataAndPositions)listOfDataAndPositions.get(0);
            TransferDataInfo data = dap.getData();
            Object icon = data.getMetadata((Object)OPERATION_ICON);
            List positions = dap.getPositions();
            String dataDisplayName = this.getDisplayName(model, data);
            if (positions.size() == 1) {
                PerformOperationAction action = new PerformOperationAction(this, model, data, (UIPosition)positions.get(0));
                if (icon instanceof Icon) {
                    action.putValue("SmallIcon", icon);
                }
                action.putValue("Name", dataDisplayName);
                return action;
            }
            GroupingAction grouping = new GroupingAction();
            grouping.putValue("Name", (Object)dataDisplayName);
            for (UIPosition position : positions) {
                PerformOperationAction action = new PerformOperationAction(this, model, data, position);
                if (icon instanceof Icon) {
                    action.putValue("SmallIcon", icon);
                }
                action.putValue("Name", dataDisplayName);
                action.putValue("Name", this.getPositionDisplayName(model, position));
                grouping.addChildAction((Action)action);
            }
            return grouping;
        }
        GroupingAction grouping = new GroupingAction();
        grouping.putValue("Name", (Object)this.getDisplayName(model, null));
        for (DataAndPositions dap : listOfDataAndPositions) {
            Object md;
            TransferDataInfo data = dap.getData();
            Object icon = data.getMetadata((Object)OPERATION_ICON);
            PerformOperationAction action = new PerformOperationAction(this, model, data, (UIPosition)dap.getPositions().get(0));
            if (icon instanceof Icon) {
                action.putValue("SmallIcon", icon);
            }
            String desc = (md = data.getMetadata(TransferDataInfo.METADATA_SHORT_DESCRIPTION)) instanceof String ? (String)md : data.toString();
            action.putValue("Name", desc);
            grouping.addChildAction((Action)action);
        }
        return grouping;
    }

    public abstract String getDisplayName(CmtModel var1, TransferDataInfo var2);

    protected final String getPositionDisplayName(CmtModel model, UIPosition position) {
        return position.getModelNode().getName();
    }

    public abstract float getSuitabilityRank();
}

