/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.file.FileSet;
import oracle.ide.file.Path;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ApplicationClassLocator;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.DependencyProjectClassLocator;
import oracle.jdeveloper.java.locator.DeploymentClassLocator;
import oracle.jdeveloper.java.locator.DuplicateLocator;
import oracle.jdeveloper.java.locator.EndorsedStandardsClassLocator;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.util.ClassFileCache;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.java.types.JavaTypeTable;

public class ProjectClassLocator
extends BaseClassLocator {
    protected static final boolean EXPORTED_LIBRARIES = true;
    protected static final boolean ALL_LIBRARIES = false;
    private final Project _project;
    private final BaseClassLocator _endorsedStandardsLocator;
    private final BaseClassLocator _jdkLocator;
    private final BaseClassLocator _libraryLocator;
    private final BaseClassLocator _applicationLocator;
    private final BaseClassLocator _deploymentLocator;
    private final ArrayClassLocator _dependencyProjectLocator;
    private final BaseClassLocator _outputLocator;
    private final BaseClassLocator _addedClassLocator;
    private final BaseClassLocator _moduleConfigLocator;
    private final BaseClassLocator _sourceLocator;
    private final boolean _overrideAppLibraries;
    private static final ArrayClassLocator EMPTY_ARRAY_LOCATOR = new ArrayClassLocator(new BaseClassLocator[0]);

    protected static ProjectClassLocator getInstance(Workspace workspace, Project project) {
        try {
            return ProjectClassLocator.getInstanceImpl(workspace, project, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static ProjectClassLocator getInstanceInterruptibly(Workspace workspace, Project project) throws InterruptedException {
        return ProjectClassLocator.getInstanceImpl(workspace, project, true);
    }

    @Deprecated
    protected static ProjectClassLocator getInstance(Project project) {
        try {
            return ProjectClassLocator.getInstanceImpl(null, project, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    protected static ProjectClassLocator getInstanceInterruptibly(Project project) throws InterruptedException {
        return ProjectClassLocator.getInstanceImpl(null, project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectClassLocator getInstanceImpl(Workspace workspace, Project project, boolean checkInterrupt) throws InterruptedException {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        PerformanceLogger.get().startTiming("ProjectClassLocator.getInstanceImpl");
        try {
            BaseClassLocator applicationLocator;
            BaseClassLocator libraryLocator;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            BaseClassLocator endorsedStandardsLocator = ProjectClassLocator.ensureValid((BaseClassLocator)EndorsedStandardsClassLocator.getInstance(project));
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            Library jdkLibrary = ProjectClassLocator.getJDKFor(project);
            BaseClassLocator jdkLocator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(workspace, jdkLibrary));
            ArrayList<Library> libraries = new ArrayList<Library>();
            ArrayList<Library> deployments = new ArrayList<Library>();
            ArrayList<Project> projects = new ArrayList<Project>();
            ProjectClassLocator.processDependencies(project, checkInterrupt, libraries, deployments, projects);
            boolean overrideAppLibraries = ProjectClassLocator.getOverrideApplicationLibraries(project);
            HashMap<Object, BaseClassLocator> cache = new HashMap<Object, BaseClassLocator>();
            if (overrideAppLibraries) {
                if (checkInterrupt) {
                    ProjectClassLocator.checkInterrupt();
                }
                libraries.addAll(ProjectClassLocator.getLibrariesFor(project, false));
                libraryLocator = ProjectClassLocator.getLibraryLocator(workspace, libraries, checkInterrupt, cache);
                if (checkInterrupt) {
                    ProjectClassLocator.checkInterrupt();
                }
                applicationLocator = checkInterrupt ? ApplicationClassLocator.getInstanceInterruptibly(workspace, cache) : ApplicationClassLocator.getInstance(workspace, cache);
            } else {
                if (checkInterrupt) {
                    ProjectClassLocator.checkInterrupt();
                }
                BaseClassLocator baseClassLocator = applicationLocator = checkInterrupt ? ApplicationClassLocator.getInstanceInterruptibly(workspace, cache) : ApplicationClassLocator.getInstance(workspace, cache);
                if (checkInterrupt) {
                    ProjectClassLocator.checkInterrupt();
                }
                libraries.addAll(ProjectClassLocator.getLibrariesFor(project, false));
                libraryLocator = ProjectClassLocator.getLibraryLocator(workspace, libraries, checkInterrupt, cache);
            }
            ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URL outputURL = ProjectClassLocator.getOutputURLFor(project);
            BaseClassLocator outputLocator = ProjectClassLocator.getClassLocator(outputURL, cache, factory);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URLPath moduleConfigPath = ProjectClassLocator.getModuleConfigClassPathFor(project);
            BaseClassLocator moduleConfigLocator = ProjectClassLocator.getClassLocator(moduleConfigPath, checkInterrupt, cache, factory);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URLPath additionalPath = ProjectClassLocator.getAddedClassPathFor(project);
            BaseClassLocator addedClassLocator = ProjectClassLocator.getClassLocator(additionalPath, checkInterrupt, cache, factory);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            Path sourcePath = ProjectClassLocator.getSourcePath(project);
            BaseClassLocator sourceLocator = ProjectClassLocator.getSourceLocator(workspace, sourcePath, checkInterrupt, cache);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            BaseClassLocator deploymentLocator = ProjectClassLocator.getDeploymentLocator(workspace, deployments, checkInterrupt, cache);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            cache.put(project, EMPTY_LOCATOR);
            ArrayClassLocator dependencyProjectLocator = ProjectClassLocator.getDependencyProjectLocator(workspace, projects, checkInterrupt, cache);
            ProjectClassLocator projectClassLocator = new ProjectClassLocator(project, endorsedStandardsLocator, jdkLocator, libraryLocator, applicationLocator, outputLocator, moduleConfigLocator, addedClassLocator, sourceLocator, dependencyProjectLocator, deploymentLocator, overrideAppLibraries);
            return projectClassLocator;
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getInstanceImpl", "ProjectClassLocator() for " + project.getShortLabel());
        }
    }

    private ProjectClassLocator(Project project, BaseClassLocator endorsedStandardsLocator, BaseClassLocator jdkLocator, BaseClassLocator libraryLocator, BaseClassLocator applicationLocator, BaseClassLocator outputLocator, BaseClassLocator moduleConfigLocator, BaseClassLocator addedClassLocator, BaseClassLocator sourceLocator, ArrayClassLocator dependencyProjectLocator, BaseClassLocator deploymentLocator, boolean overrideAppLibraries) {
        this._project = project;
        this._endorsedStandardsLocator = endorsedStandardsLocator;
        this._jdkLocator = jdkLocator;
        this._libraryLocator = libraryLocator;
        this._applicationLocator = applicationLocator;
        this._outputLocator = outputLocator;
        this._moduleConfigLocator = moduleConfigLocator;
        this._addedClassLocator = addedClassLocator;
        this._sourceLocator = sourceLocator;
        this._dependencyProjectLocator = dependencyProjectLocator;
        this._deploymentLocator = deploymentLocator;
        this._overrideAppLibraries = overrideAppLibraries;
    }

    static void processDependencies(Project project, boolean checkInterrupt, List<Library> libraries, List<Library> deployments, List<Project> projects) throws InterruptedException {
        for (Object dependency : ProjectClassLocator.getDependentsFor(project)) {
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            if (dependency instanceof ProjectLibrary) {
                projects.add((Project)((ProjectLibrary)((Object)dependency)).getSource());
                continue;
            }
            if (!(dependency instanceof Library)) continue;
            Library library = (Library)dependency;
            Folder owner = ((Dependable)dependency).getSourceOwner();
            if (owner instanceof Project && library.getSourcePath() == null) {
                deployments.add(library);
                continue;
            }
            libraries.add((Library)dependency);
        }
    }

    public static Collection getDependentsFor(Project project) {
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((Project)project);
        List dependList = dependencyConfiguration.getDependencyList();
        return dependList == null ? EMPTY_COLLECTION : dependList;
    }

    protected static URLPath getAddedClassPathFor(Project project) {
        JProjectPaths projectPaths = JProjectPaths.getInstance((PropertyStorage)project);
        URLPath additionalPath = new URLPath(projectPaths.getAdditionalClassPath());
        JLibraryManager mgr = JLibraryManager.getInstance();
        String[] technologyKeys = ProjectClassLocator.getTechnologyKeys(project);
        for (DynamicLibraryProvider provider : mgr.getDynamicLibraryProviders(technologyKeys)) {
            provider.updateClassPath(project, additionalPath);
        }
        return additionalPath;
    }

    protected static URLPath getModuleConfigClassPathFor(Project project) {
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance((Project)project);
        if (moduleConfig != null) {
            return moduleConfig.getClassPath();
        }
        return null;
    }

    protected static URL getOutputURLFor(Project project) {
        JavaProject javaProject = JavaProject.getInstance(project);
        return javaProject.getOutputDirectory();
    }

    public static Path getSourcePath(Project project) {
        Path path = Path.getInstance();
        ContentSet javaContentSet = PathsConfiguration.getInstance((Project)project).getJavaContentSet();
        for (ContentSetRoot root : ContentSetRoot.getContentSetRoots((Project)project, (ContentSet)javaContentSet)) {
            path.add(root.asFileSet());
        }
        return path;
    }

    @Deprecated
    public static URLPath getSourcePathFor(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)project);
        return pathsConfiguration.getProjectSourcePath();
    }

    protected static Library getJDKFor(Project project) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        return projectLibraries.getJDK();
    }

    private static Path getDeploymentSourcePathFor(Project project) {
        Path path = ProjectClassLocator.getSourcePath(project);
        for (Object dependency : ProjectClassLocator.getDependentsFor(project)) {
            if (!(dependency instanceof ProjectLibrary)) continue;
            Project dependencyProject = ((ProjectLibrary)((Object)dependency)).getProject();
            path.addAll((Collection)ProjectClassLocator.getSourcePath(dependencyProject));
        }
        return path;
    }

    private static String[] getTechnologyKeys(Project project) {
        return TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys();
    }

    static List<Library> getLibrariesFor(Project project, boolean exportsOnly) {
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)project);
        return Arrays.asList(exportsOnly ? libs.getExports() : libs.getLibraries());
    }

    static BaseClassLocator getLibraryLocator(List<Library> libraries, boolean checkInterrupt, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        return ProjectClassLocator.getLibraryLocator(null, libraries, checkInterrupt, cache);
    }

    static BaseClassLocator getLibraryLocator(Workspace workspace, List<Library> libraries, boolean checkInterrupt, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        if (libraries.isEmpty()) {
            return EMPTY_LOCATOR;
        }
        ArrayList<BaseClassLocator> libraryLocators = new ArrayList<BaseClassLocator>();
        for (Library library : libraries) {
            BaseClassLocator cached;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            if ((cached = cache.get(library)) != null) {
                libraryLocators.add(cached);
                continue;
            }
            BaseClassLocator locator = JavaTypeTable.isEnabled() ? ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(workspace, library)) : ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(library));
            cache.put(library, DuplicateLocator.getInstance(locator, false));
            libraryLocators.add(locator);
        }
        return ProjectClassLocator.getArrayClassLocator(libraryLocators);
    }

    private static boolean getOverrideApplicationLibraries(Project project) {
        return JProjectLibraries.getInstance((PropertyStorage)project).getOverrideApplicationLibraries();
    }

    static BaseClassLocator getDeploymentLocator(Workspace workspace, List<Library> deployments, boolean checkInterrupt, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        if (deployments.isEmpty()) {
            return EMPTY_LOCATOR;
        }
        ArrayList<BaseClassLocator> deploymentLocators = new ArrayList<BaseClassLocator>();
        for (Library deployment : deployments) {
            BaseClassLocator cached;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            if ((cached = cache.get(deployment)) != null) {
                deploymentLocators.add(cached);
                continue;
            }
            DeploymentClassLocator.DeploymentPaths paths = ProjectClassLocator.getDeploymentPaths(workspace, deployment);
            BaseClassLocator locator = ProjectClassLocator.ensureValid((BaseClassLocator)DeploymentClassLocator.getInstance(deployment, paths));
            cache.put(deployment, DuplicateLocator.getInstance(locator, false));
            deploymentLocators.add(locator);
        }
        return ProjectClassLocator.getArrayClassLocator(deploymentLocators);
    }

    static DeploymentClassLocator.DeploymentPaths getDeploymentPaths(Workspace workspace, Library deployment) {
        Folder owner = ((Dependable)deployment).getSourceOwner();
        URLPath deploymentClassPath = deployment.getClassPath();
        Path deploymentSourcePath = ProjectClassLocator.getDeploymentSourcePathFor((Project)owner);
        return new DeploymentClassLocator.DeploymentPaths(workspace, deploymentSourcePath, deploymentClassPath);
    }

    static ArrayClassLocator getDependencyProjectLocator(Workspace workspace, List<Project> dependencies, boolean checkInterrupt, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        ArrayClassLocator locator;
        if (dependencies.isEmpty()) {
            locator = EMPTY_ARRAY_LOCATOR;
        } else {
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            BaseClassLocator[] dependencyProjectLocators = new BaseClassLocator[dependencies.size()];
            for (int i = 0; i < dependencyProjectLocators.length; ++i) {
                dependencyProjectLocators[i] = checkInterrupt ? DependencyProjectClassLocator.getInstanceInterruptibly(workspace, dependencies.get(i), cache) : DependencyProjectClassLocator.getInstance(workspace, dependencies.get(i), cache);
            }
            locator = new ArrayClassLocator(dependencyProjectLocators);
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BaseClassLocator getClassLocator(URLPath path, boolean checkInterrupt, Map<Object, BaseClassLocator> cache, ClassLocatorFactory factory) throws InterruptedException {
        if (path == null || path.size() == 0) {
            return EMPTY_ARRAY_LOCATOR;
        }
        ArrayList<BaseClassLocator> locators = new ArrayList<BaseClassLocator>();
        Object object = path.iteratorLock();
        synchronized (object) {
            for (URL url : path) {
                if (checkInterrupt) {
                    ProjectClassLocator.checkInterrupt();
                }
                locators.add(ProjectClassLocator.getClassLocator(url, cache, factory));
            }
        }
        return ProjectClassLocator.getArrayClassLocator(locators);
    }

    static BaseClassLocator getClassLocator(URL url, Map<Object, BaseClassLocator> cache, ClassLocatorFactory factory) {
        URLKey key = URLKey.getInstance((URL)url);
        BaseClassLocator locator = cache.get(key);
        if (locator != null) {
            return locator;
        }
        locator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(url));
        cache.put(key, DuplicateLocator.getInstance(locator, false));
        return locator;
    }

    static BaseClassLocator getSourceLocator(Workspace workspace, Path path, boolean checkInterrupt, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        if (path == null || path.size() == 0) {
            return EMPTY_ARRAY_LOCATOR;
        }
        ArrayList<BaseClassLocator> locators = new ArrayList<BaseClassLocator>();
        for (FileSet fileSet : path) {
            BaseClassLocator locator;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            if ((locator = cache.get(fileSet)) != null) {
                locators.add(locator);
                continue;
            }
            locator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocator(workspace, fileSet));
            cache.put(fileSet, DuplicateLocator.getInstance(locator, false));
            locators.add(locator);
        }
        return ProjectClassLocator.getArrayClassLocator(locators);
    }

    private static ArrayClassLocator getArrayClassLocator(List<BaseClassLocator> locators) {
        return new ArrayClassLocator(locators.toArray(new BaseClassLocator[locators.size()]));
    }

    public void buildIndex() {
        PerformanceLogger.get().startTiming("ProjectClassLocator.buildIndex");
        try {
            this._sourceLocator.buildIndex();
            this._outputLocator.buildIndex();
            this._moduleConfigLocator.buildIndex();
            this._addedClassLocator.buildIndex();
            this._libraryLocator.buildIndex();
            this._applicationLocator.buildIndex();
            this._endorsedStandardsLocator.buildIndex();
            this._jdkLocator.buildIndex();
            this._dependencyProjectLocator.buildIndex();
            this._deploymentLocator.buildIndex();
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.buildIndex", "ProjectClassLocator.buildIndex() for " + this._project.getShortLabel());
        }
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        PerformanceLogger.get().startTiming("ProjectClassLocator.buildIndex");
        try {
            ProjectClassLocator.checkInterrupt();
            this._sourceLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._outputLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._moduleConfigLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._addedClassLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._libraryLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._applicationLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._endorsedStandardsLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._jdkLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._dependencyProjectLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._deploymentLocator.buildIndexInterruptibly();
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.buildIndex", "ProjectClassLocator.buildIndex() for " + this._project.getShortLabel());
        }
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getPackages(packagePrefix, out);
        this._outputLocator.getPackages(packagePrefix, out);
        this._moduleConfigLocator.getPackages(packagePrefix, out);
        this._addedClassLocator.getPackages(packagePrefix, out);
        this._dependencyProjectLocator.getPackages(packagePrefix, out);
        this._deploymentLocator.getPackages(packagePrefix, out);
        this._libraryLocator.getPackages(packagePrefix, out);
        this._applicationLocator.getPackages(packagePrefix, out);
        this._endorsedStandardsLocator.getPackages(packagePrefix, out);
        this._jdkLocator.getPackages(packagePrefix, out);
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependencyProjectLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._applicationLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._endorsedStandardsLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
        this._outputLocator.getClassesInPackage(packagePrefix, out);
        this._moduleConfigLocator.getClassesInPackage(packagePrefix, out);
        this._addedClassLocator.getClassesInPackage(packagePrefix, out);
        this._dependencyProjectLocator.getClassesInPackage(packagePrefix, out);
        this._deploymentLocator.getClassesInPackage(packagePrefix, out);
        this._libraryLocator.getClassesInPackage(packagePrefix, out);
        this._applicationLocator.getClassesInPackage(packagePrefix, out);
        this._endorsedStandardsLocator.getClassesInPackage(packagePrefix, out);
        this._jdkLocator.getClassesInPackage(packagePrefix, out);
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependencyProjectLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._applicationLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._endorsedStandardsLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        PerformanceLogger.get().startTiming("ProjectClassLocator.getAllClasses");
        try {
            this._sourceLocator.getAllClasses(out, filter);
            this._outputLocator.getAllClasses(out, filter);
            this._moduleConfigLocator.getAllClasses(out, filter);
            this._addedClassLocator.getAllClasses(out, filter);
            this._dependencyProjectLocator.getAllClasses(out, filter);
            this._deploymentLocator.getAllClasses(out, filter);
            this._libraryLocator.getAllClasses(out, filter);
            this._applicationLocator.getAllClasses(out, filter);
            this._endorsedStandardsLocator.getAllClasses(out, filter);
            this._jdkLocator.getAllClasses(out, filter);
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getAllClasses", "ProjectClassLocator.getAllClasses() for " + this._project.getShortLabel() + ": " + out.size() + " classes found");
        }
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        PerformanceLogger.get().startTiming("ProjectClassLocator.getAllClassesInterruptibly");
        try {
            ProjectClassLocator.checkInterrupt();
            this._sourceLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._outputLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._moduleConfigLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._addedClassLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._dependencyProjectLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._deploymentLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._libraryLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._applicationLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._endorsedStandardsLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._jdkLocator.getAllClassesInterruptibly(out, filter);
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getAllClassesInterruptibly", "ProjectClassLocator.getAllClassesInterruptibly() for " + this._project.getShortLabel() + ": " + out.size() + " classes found");
        }
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._sourceLocator.getAllPackages(out, filter);
        this._outputLocator.getAllPackages(out, filter);
        this._moduleConfigLocator.getAllPackages(out, filter);
        this._addedClassLocator.getAllPackages(out, filter);
        this._dependencyProjectLocator.getAllPackages(out, filter);
        this._deploymentLocator.getAllPackages(out, filter);
        this._libraryLocator.getAllPackages(out, filter);
        this._applicationLocator.getAllPackages(out, filter);
        this._endorsedStandardsLocator.getAllPackages(out, filter);
        this._jdkLocator.getAllPackages(out, filter);
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._dependencyProjectLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._applicationLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._endorsedStandardsLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getAllPackagesInterruptibly(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL classURL = this._outputLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (classURL != null || sourceURL != null) {
            return ProjectClassLocator.chooseURL(fqClassName, classURL, sourceURL, this._sourceLocator);
        }
        classURL = this._endorsedStandardsLocator.getURL(fqClassName);
        if (classURL == null) {
            classURL = this._jdkLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependencyProjectLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getURL(fqClassName);
        }
        if (this._overrideAppLibraries) {
            if (classURL == null) {
                classURL = this._libraryLocator.getURL(fqClassName);
            }
            if (classURL == null) {
                classURL = this._applicationLocator.getURL(fqClassName);
            }
        } else {
            if (classURL == null) {
                classURL = this._applicationLocator.getURL(fqClassName);
            }
            if (classURL == null) {
                classURL = this._libraryLocator.getURL(fqClassName);
            }
        }
        return classURL;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        URL classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        ProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        if (classURL != null || sourceURL != null) {
            return ProjectClassLocator.chooseURL(fqClassName, classURL, sourceURL, this._sourceLocator);
        }
        ProjectClassLocator.checkInterrupt();
        classURL = this._endorsedStandardsLocator.getURLInterruptibly(fqClassName);
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._jdkLocator.getURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._addedClassLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._dependencyProjectLocator.getURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._deploymentLocator.getURLInterruptibly(fqClassName);
        }
        if (this._overrideAppLibraries) {
            if (classURL == null) {
                ProjectClassLocator.checkInterrupt();
                classURL = this._libraryLocator.getURLInterruptibly(fqClassName);
            }
            if (classURL == null) {
                ProjectClassLocator.checkInterrupt();
                classURL = this._applicationLocator.getURLInterruptibly(fqClassName);
            }
        } else {
            if (classURL == null) {
                ProjectClassLocator.checkInterrupt();
                classURL = this._applicationLocator.getURLInterruptibly(fqClassName);
            }
            if (classURL == null) {
                ProjectClassLocator.checkInterrupt();
                classURL = this._libraryLocator.getURLInterruptibly(fqClassName);
            }
        }
        return classURL;
    }

    static URL chooseURL(String fqClassName, URL classURL, URL sourceURL, BaseClassLocator sourceLocator) {
        if (classURL == null) {
            return sourceURL;
        }
        if (sourceURL == null && (sourceURL = ProjectClassLocator.getSourceURLfromClassFile(classURL, fqClassName, sourceLocator)) == null) {
            return classURL;
        }
        long classTime = URLFileSystem.lastModified((URL)classURL);
        Node node = NodeFactory.find((URL)sourceURL);
        long sourceTime = -1L;
        if (node != null && node.isOpen()) {
            sourceTime = node.getTimestampLoadedUnsafe();
        }
        if (sourceTime == -1L) {
            sourceTime = URLFileSystem.lastModified((URL)sourceURL);
        }
        if (classTime >= sourceTime) {
            return classURL;
        }
        return sourceURL;
    }

    public URL getProjectSourceURL(String fqClassName, boolean includeDependencies) {
        URL sourceURL;
        block1: {
            DependencyProjectClassLocator dependencyLocator;
            BaseClassLocator locator;
            sourceURL = this._sourceLocator.getSourceURL(fqClassName);
            if (sourceURL != null || !includeDependencies) break block1;
            Iterator iterator = this._dependencyProjectLocator.iterator();
            while (iterator.hasNext() && (!((locator = (BaseClassLocator)iterator.next()) instanceof DependencyProjectClassLocator) || (sourceURL = (dependencyLocator = (DependencyProjectClassLocator)locator).getProjectSourceURL(fqClassName)) == null)) {
            }
        }
        return sourceURL;
    }

    public URL getProjectSourceURLInterruptibly(String fqClassName, boolean includeDependencies) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        if (sourceURL == null && includeDependencies) {
            for (BaseClassLocator locator : this._dependencyProjectLocator) {
                DependencyProjectClassLocator dependencyLocator;
                ProjectClassLocator.checkInterrupt();
                if (!(locator instanceof DependencyProjectClassLocator) || (sourceURL = (dependencyLocator = (DependencyProjectClassLocator)locator).getSourceURLInterruptibly(fqClassName)) == null) continue;
                break;
            }
        }
        return sourceURL;
    }

    public URL getNonProjectSourceURL(String fqClassName) {
        URL sourceURL = this._endorsedStandardsLocator.getSourceURL(fqClassName);
        if (sourceURL == null) {
            sourceURL = this._jdkLocator.getSourceURL(fqClassName);
        }
        if (sourceURL == null) {
            DependencyProjectClassLocator dependencyLocator;
            BaseClassLocator locator;
            Iterator iterator = this._dependencyProjectLocator.iterator();
            while (iterator.hasNext() && (!((locator = (BaseClassLocator)iterator.next()) instanceof DependencyProjectClassLocator) || (sourceURL = (dependencyLocator = (DependencyProjectClassLocator)locator).getNonProjectSourceURL(fqClassName)) == null)) {
            }
        }
        if (sourceURL == null) {
            sourceURL = this._deploymentLocator.getSourceURL(fqClassName);
        }
        if (this._overrideAppLibraries) {
            if (sourceURL == null) {
                sourceURL = this._libraryLocator.getSourceURL(fqClassName);
            }
            if (sourceURL == null) {
                sourceURL = this._applicationLocator.getSourceURL(fqClassName);
            }
        } else {
            if (sourceURL == null) {
                sourceURL = this._applicationLocator.getSourceURL(fqClassName);
            }
            if (sourceURL == null) {
                sourceURL = this._libraryLocator.getSourceURL(fqClassName);
            }
        }
        return sourceURL;
    }

    public URL getNonProjectSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL = this._endorsedStandardsLocator.getSourceURLInterruptibly(fqClassName);
        if (sourceURL == null) {
            sourceURL = this._jdkLocator.getSourceURLInterruptibly(fqClassName);
        }
        if (sourceURL == null) {
            for (BaseClassLocator locator : this._dependencyProjectLocator) {
                DependencyProjectClassLocator dependencyLocator;
                ProjectClassLocator.checkInterrupt();
                if (!(locator instanceof DependencyProjectClassLocator) || (sourceURL = (dependencyLocator = (DependencyProjectClassLocator)locator).getNonProjectSourceURLInterruptibly(fqClassName)) == null) continue;
                break;
            }
        }
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this._deploymentLocator.getSourceURLInterruptibly(fqClassName);
        }
        if (this._overrideAppLibraries) {
            ProjectClassLocator.checkInterrupt();
            if (sourceURL == null) {
                sourceURL = this._libraryLocator.getSourceURLInterruptibly(fqClassName);
            }
            ProjectClassLocator.checkInterrupt();
            if (sourceURL == null) {
                sourceURL = this._applicationLocator.getSourceURLInterruptibly(fqClassName);
            }
        } else {
            ProjectClassLocator.checkInterrupt();
            if (sourceURL == null) {
                sourceURL = this._applicationLocator.getSourceURLInterruptibly(fqClassName);
            }
            ProjectClassLocator.checkInterrupt();
            if (sourceURL == null) {
                sourceURL = this._libraryLocator.getSourceURLInterruptibly(fqClassName);
            }
        }
        return sourceURL;
    }

    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this.getProjectSourceURL(fqClassName, true);
        if (sourceURL == null) {
            sourceURL = this.getNonProjectSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL = this.getProjectSourceURLInterruptibly(fqClassName, true);
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this.getNonProjectSourceURLInterruptibly(fqClassName);
        }
        return sourceURL;
    }

    public URL getClassURL(String fqClassName) {
        URL classURL = this._endorsedStandardsLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._jdkLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._outputLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependencyProjectLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getClassURL(fqClassName);
        }
        if (this._overrideAppLibraries) {
            if (classURL == null) {
                classURL = this._libraryLocator.getClassURL(fqClassName);
            }
            if (classURL == null) {
                classURL = this._applicationLocator.getClassURL(fqClassName);
            }
        } else {
            if (classURL == null) {
                classURL = this._applicationLocator.getClassURL(fqClassName);
            }
            if (classURL == null) {
                classURL = this._libraryLocator.getClassURL(fqClassName);
            }
        }
        return classURL;
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        URL classURL = this._endorsedStandardsLocator.getClassURLInterruptibly(fqClassName);
        if (classURL == null) {
            classURL = this._jdkLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependencyProjectLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getClassURLInterruptibly(fqClassName);
        }
        if (this._overrideAppLibraries) {
            if (classURL == null) {
                classURL = this._libraryLocator.getClassURLInterruptibly(fqClassName);
            }
            if (classURL == null) {
                classURL = this._applicationLocator.getClassURLInterruptibly(fqClassName);
            }
        } else {
            if (classURL == null) {
                classURL = this._applicationLocator.getClassURLInterruptibly(fqClassName);
            }
            if (classURL == null) {
                classURL = this._libraryLocator.getClassURLInterruptibly(fqClassName);
            }
        }
        return classURL;
    }

    public URL getResourceURL(String resourceName) {
        URL resourceURL = this._endorsedStandardsLocator.getResourceURL(resourceName);
        if (resourceURL == null) {
            resourceURL = this._jdkLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._outputLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._moduleConfigLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._addedClassLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._dependencyProjectLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._deploymentLocator.getResourceURL(resourceName);
        }
        if (this._overrideAppLibraries) {
            if (resourceURL == null) {
                resourceURL = this._libraryLocator.getResourceURL(resourceName);
            }
            if (resourceURL == null) {
                resourceURL = this._applicationLocator.getResourceURL(resourceName);
            }
        } else {
            if (resourceURL == null) {
                resourceURL = this._applicationLocator.getResourceURL(resourceName);
            }
            if (resourceURL == null) {
                resourceURL = this._libraryLocator.getResourceURL(resourceName);
            }
        }
        return resourceURL;
    }

    private static URL getSourceURLfromClassFile(URL classURL, String fqClassName, BaseClassLocator sourceLocator) {
        String sourceFileName;
        ClassFile classFile;
        int dot = fqClassName.lastIndexOf(46);
        if (dot > 0 && (classFile = ClassFileCache.getClassFile((URL)classURL)) != null && (sourceFileName = classFile.getSourceFilename()) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(fqClassName.substring(0, dot + 1));
            dot = sourceFileName.lastIndexOf(46);
            if (dot > 0) {
                buf.append(sourceFileName.substring(0, dot));
            } else {
                buf.append(sourceFileName);
            }
            return sourceLocator.getSourceURL(buf.toString());
        }
        return null;
    }

    protected Object getClasspathTreeNode() {
        return this._project;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(Arrays.asList(this._endorsedStandardsLocator, this._jdkLocator, this._outputLocator, this._moduleConfigLocator, this._addedClassLocator, this._dependencyProjectLocator, this._deploymentLocator, this._overrideAppLibraries ? this._libraryLocator : this._applicationLocator, this._overrideAppLibraries ? this._applicationLocator : this._libraryLocator));
        if (options.contains(ClasspathTreeVisitOptions.INCLUDE_SOURCE)) {
            list.add(this._sourceLocator);
        }
        return list;
    }

    protected BaseClassLocator getSourceLocator(BaseClassLocator locator) {
        if (locator == this._outputLocator || locator == this._moduleConfigLocator) {
            return this._sourceLocator;
        }
        return super.getSourceLocator(locator);
    }
}

