/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import oracle.ide.file.Path;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.library.Library;

final class DeploymentClassLocator
extends BaseClassLocator {
    private BaseClassLocator _sourceLocator;
    private BaseClassLocator _classLocator;
    private Library _library;

    public static DeploymentClassLocator getInstance(Library library, DeploymentPaths paths) {
        return new DeploymentClassLocator(library, paths);
    }

    private DeploymentClassLocator(Library library, DeploymentPaths paths) {
        this._library = library;
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._sourceLocator = DeploymentClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getSourceLocator(paths.workspace, paths.sourcePath));
        this._classLocator = DeploymentClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(paths.classPath));
    }

    public void buildIndex() {
        this._classLocator.buildIndex();
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.buildIndex();
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this._classLocator.getPackages(packagePrefix, out);
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._classLocator.getClassesInPackage(packagePrefix, out);
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this._classLocator.getAllClasses(out, filter);
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getAllClassesInterruptibly(out, filter);
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._classLocator.getAllPackages(out, filter);
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getAllPackagesInterruptibly(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL sourceURL;
        URL classURL = this.getClassURL(fqClassName);
        if (classURL != null && (sourceURL = this.getSourceURL(fqClassName)) != null) {
            return sourceURL;
        }
        return classURL;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL;
        URL classURL = this.getClassURLInterruptibly(fqClassName);
        if (classURL != null && (sourceURL = this.getSourceURLInterruptibly(fqClassName)) != null) {
            return sourceURL;
        }
        return classURL;
    }

    public URL getSourceURL(String fqClassName) {
        return this.getClassURL(fqClassName) != null ? this._sourceLocator.getSourceURL(fqClassName) : null;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getClassURLInterruptibly(fqClassName) != null ? this._sourceLocator.getSourceURLInterruptibly(fqClassName) : null;
    }

    public URL getClassURL(String fqClassName) {
        return this._classLocator.getClassURL(fqClassName);
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this._classLocator.getClassURLInterruptibly(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }

    protected Object getClasspathTreeNode() {
        return this._library;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(2);
        list.add(this._classLocator);
        if (options.contains(ClasspathTreeVisitOptions.INCLUDE_SOURCE)) {
            list.add(this._sourceLocator);
        }
        return list;
    }

    protected BaseClassLocator getSourceLocator(BaseClassLocator locator) {
        if (locator == this._classLocator) {
            return this._sourceLocator;
        }
        return super.getSourceLocator(locator);
    }

    static final class DeploymentPaths {
        private final Workspace workspace;
        private final Path sourcePath;
        private final URLPath classPath;

        DeploymentPaths(Workspace workspace, Path sourcePath, URLPath classPath) {
            this.workspace = workspace;
            this.sourcePath = sourcePath;
            this.classPath = classPath;
        }
    }
}

