/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.event;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.jdeveloper.builder.event.EventListenerBuilderModel;
import oracle.jdeveloper.builder.event.EventObjectBuilderModel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class EventSetModel
implements BaliWizardState {
    private String _eventSetName = "";
    private String _eventListenerClassName;
    private String _eventObjectClassName;
    static final String EVENT_LISTENER_CLASS_PROPERTY = "EventListenerClassName";
    static final String EVENT_OBJECT_CLASS_PROPERTY = "EventObjectClassName";
    private JEWTDialog _dlg;
    private EventObjectBuilderModel _eventObjectBuilder;
    private EventListenerBuilderModel _eventListenerBuilder;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public EventSetModel(Context context) {
        if (context == null) {
            throw new NullPointerException("The context must not be null.");
        }
        this._eventListenerBuilder = new EventListenerBuilderModel(context);
        this._eventObjectBuilder = new EventObjectBuilderModel(context);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getEventListenerClassName() {
        return this._eventListenerClassName;
    }

    public String getEventObjectClassName() {
        return this._eventObjectClassName;
    }

    public JEWTDialog getBuilderDialog() {
        return this._dlg;
    }

    public void setBuilderDialog(JEWTDialog dlg) {
        this._dlg = dlg;
    }

    public String getListenerName(String eventName) {
        return this.toEventName(eventName) + "Listener";
    }

    public String getEventObjectName(String eventName) {
        return this.toEventName(eventName) + "Event";
    }

    public void reportError(String title, String msg, String helpID) {
        this._eventListenerBuilder.reportError(title, msg, helpID);
    }

    public void commitWizardState() {
        String mask = "%s.%s";
        this.setEventListenerClassName(String.format(mask, this._eventListenerBuilder.getPackage(), this._eventListenerBuilder.getClassName()));
        this.setEventObjectClassName(String.format(mask, this._eventObjectBuilder.getPackage(), this._eventObjectBuilder.getClassName()));
        this._eventListenerBuilder.commitWizardState();
        this._eventObjectBuilder.commitWizardState();
    }

    public Project getProject() {
        return this._eventListenerBuilder.getProject();
    }

    public void setPackage(String pkg) throws IllegalArgumentException {
        this._eventListenerBuilder.setPackage(pkg);
        this._eventObjectBuilder.setPackage(pkg);
    }

    public String getPackage() {
        return this._eventListenerBuilder.getPackage();
    }

    public void setEvents(String[] events) {
        this._eventListenerBuilder.setEvents(events);
    }

    public String getEventSetName() {
        return this._eventSetName;
    }

    public void setEventSetName(String eventName) throws IllegalArgumentException {
        String eventPrefix;
        this._eventSetName = eventPrefix = this.toEventName(eventName.trim());
        String listenerName = this.getListenerName(eventPrefix);
        this._eventListenerBuilder.setClassName(listenerName);
        String eventObjectName = this.getEventObjectName(eventPrefix);
        this._eventObjectBuilder.setClassName(eventObjectName);
        this._eventListenerBuilder.setEventObject(String.format("%s.%s", this.getPackage(), eventObjectName));
    }

    public String toEventName(String text) {
        if (text.length() == 1) {
            return text.toUpperCase();
        }
        if (text.length() > 1) {
            return Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    private void setEventListenerClassName(String eventListenerClassName) {
        String oldEventListenerClassName = this._eventListenerClassName;
        this._eventListenerClassName = eventListenerClassName;
        this.propertyChangeSupport.firePropertyChange(EVENT_LISTENER_CLASS_PROPERTY, oldEventListenerClassName, eventListenerClassName);
    }

    private void setEventObjectClassName(String eventObjectClassName) {
        String oldEventObjectClassName = this._eventObjectClassName;
        this._eventObjectClassName = eventObjectClassName;
        this.propertyChangeSupport.firePropertyChange(EVENT_OBJECT_CLASS_PROPERTY, oldEventObjectClassName, eventObjectClassName);
    }
}

