/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg;

import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.svg.CustomShape;

public abstract class CustomShapesParser {
    private Map<String, List<CustomShape>> m_shapesMap = new HashMap<String, List<CustomShape>>();
    protected ErrorHandler m_eh;
    private boolean m_singleKey = false;

    public CustomShapesParser(ErrorHandler eh) {
        this.m_eh = eh;
    }

    protected void addShape(String compName, CustomShape shape) {
        List<CustomShape> list;
        if (this.m_singleKey) {
            compName = "";
        }
        if ((list = this.m_shapesMap.get(compName)) == null) {
            list = new ArrayList<CustomShape>();
        }
        list.add(shape);
        this.m_shapesMap.put(compName, list);
    }

    public boolean defines(String compName) {
        return this.m_shapesMap.get(compName) != null;
    }

    public Rectangle2D getBounds(String compName) {
        List<CustomShape> list = this.getShapes(compName);
        if (list == null) {
            return null;
        }
        Rectangle2D bounds = null;
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D shapeBounds = list.get(i).getShape().getBounds2D();
            bounds = bounds == null ? shapeBounds : bounds.createUnion(shapeBounds);
        }
        return bounds;
    }

    public Rectangle2D getFullBounds() {
        if (this.m_shapesMap == null) {
            return null;
        }
        Set<String> keySet = this.m_shapesMap.keySet();
        Iterator<String> keys = keySet.iterator();
        Rectangle2D bounds = null;
        while (keys.hasNext()) {
            String currKey = keys.next();
            Rectangle2D componentBounds = this.getBounds(currKey);
            if (bounds == null) {
                bounds = componentBounds;
                continue;
            }
            bounds = bounds.createUnion(componentBounds);
        }
        return bounds;
    }

    public List<CustomShape> getShapes(String compName) {
        List<CustomShape> shapesList = this.m_shapesMap.get(compName);
        if (shapesList == null) {
            shapesList = new ArrayList<CustomShape>();
        }
        return shapesList;
    }

    public Map<String, List<CustomShape>> getShapesMap() {
        return this.m_shapesMap;
    }

    public void setSingleKey(boolean yesNo) {
        this.m_singleKey = yesNo;
    }

    public abstract void parseFile(String var1);

    public abstract void parseFile(InputStream var1);
}

