/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Path;

public class DrawableObjectXMLGenerator {
    public static String generateXMLFromShape(Shape shp) {
        StringBuilder buf = new StringBuilder(2000);
        PathIterator pathIterator = shp.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] points = new double[6];
            int windingRule = pathIterator.currentSegment(points);
            if (windingRule == 0) {
                buf.append("M");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
            } else if (windingRule == 1) {
                buf.append("L");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
            } else if (windingRule == 4) {
                buf.append("Z");
            } else if (windingRule == 2) {
                buf.append("Q");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
                buf.append(",");
                buf.append(String.valueOf(points[2]));
                buf.append(",");
                buf.append(String.valueOf(points[3]));
            } else if (windingRule == 3) {
                buf.append("C");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
                buf.append(",");
                buf.append(String.valueOf(points[2]));
                buf.append(",");
                buf.append(String.valueOf(points[3]));
                buf.append(",");
                buf.append(String.valueOf(points[4]));
                buf.append(",");
                buf.append(String.valueOf(points[5]));
            } else {
                Logger.getLogger("oracle.dss.util.shapes").logp(Level.WARNING, DrawableObjectXMLGenerator.class.getName(), "generateXMLFromShape", "Winding rule " + windingRule + " not handled.");
            }
            pathIterator.next();
        }
        return buf.toString();
    }

    public static String generateRelativeXMLFromShape(Shape shp) {
        StringBuilder buf = new StringBuilder(2000);
        PathIterator pathIterator = shp.getPathIterator(null);
        int prevX = 0;
        int prevY = 0;
        int x = 0;
        int y = 0;
        char prevCmd = 'x';
        while (!pathIterator.isDone()) {
            double[] points = new double[6];
            int windingRule = pathIterator.currentSegment(points);
            if (windingRule == 0) {
                prevCmd = 'M';
                x = (int)points[0];
                y = (int)points[1];
                buf.append(prevCmd);
                buf.append(x);
                buf.append(" ");
                buf.append(y);
                prevX = x;
                prevY = y;
            } else if (windingRule == 1) {
                x = (int)points[0];
                y = (int)points[1];
                int relX = x - prevX;
                int relY = y - prevY;
                if (prevCmd == 'l') {
                    if (prevX == x) {
                        prevCmd = 'v';
                        buf.append(prevCmd);
                        buf.append(relY);
                        prevY = y;
                    } else if (prevY == y) {
                        prevCmd = 'h';
                        buf.append(prevCmd);
                        buf.append(relX);
                        prevX = x;
                    } else {
                        buf.append(" ");
                        buf.append(relX);
                        buf.append(" ");
                        buf.append(relY);
                        prevX = x;
                        prevY = y;
                    }
                } else {
                    prevCmd = 'l';
                    buf.append(prevCmd);
                    buf.append(relX);
                    buf.append(" ");
                    buf.append(relY);
                    prevX = x;
                    prevY = y;
                }
            } else if (windingRule == 4) {
                prevCmd = 'z';
                buf.append(prevCmd);
                prevX = 0;
                prevY = 0;
            } else {
                Logger.getLogger("oracle.dss.util.shapes").logp(Level.WARNING, DrawableObjectXMLGenerator.class.getName(), "generateRelativeXMLFromShape", "Winding rule " + windingRule + " not handled.");
            }
            pathIterator.next();
        }
        return buf.toString();
    }

    public static String generateXML(DrawableObject drawObject) {
        if (drawObject instanceof Path) {
            Shape shp = drawObject.getShape();
            return DrawableObjectXMLGenerator.generateXMLFromShape(shp);
        }
        return null;
    }
}

