/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.renderers;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import oracle.dss.util.shapes.CommonRenderer;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.Filter;
import oracle.dss.util.shapes.Stroke;

public abstract class BaseRenderer
implements CommonRenderer {
    @Override
    public void renderFill(Fill fill, Shape shape) {
        if (fill != null) {
            this.handleFill(fill, shape);
        }
    }

    @Override
    public void renderStroke(Stroke stroke, AffineTransform transform) {
    }

    @Override
    public void renderFilter(Filter filter) {
    }

    @Override
    public void drawShape(DrawableObject obj) {
        this.preDrawShape(obj);
        if (obj instanceof Container) {
            this.handleContainer((Container)obj);
        } else {
            this.handleDrawable(obj);
        }
        this.postDrawShape(obj);
    }

    protected void handleContainer(Container obj) {
        if (obj.getShape() != null) {
            this.drawShape(obj);
        }
        for (DrawableObject drawable : obj.getDrawables()) {
            this.drawShape(drawable);
        }
    }

    public abstract void preDrawShape(DrawableObject var1);

    public abstract void postDrawShape(DrawableObject var1);

    public abstract void defaultDrawableHandler(DrawableObject var1);

    public abstract void defaultFillHandler(Fill var1, Shape var2);

    public final void handleDrawable(Object obj) {
        block2: {
            try {
                Method m = this.getClass().getDeclaredMethod("handleDrawable", obj.getClass());
                m.invoke((Object)this, obj);
            }
            catch (Exception e) {
                if (!(obj instanceof DrawableObject)) break block2;
                this.defaultDrawableHandler((DrawableObject)obj);
            }
        }
    }

    public final void handleFill(Object fill, Object shape) {
        block2: {
            try {
                Method m = this.getClass().getDeclaredMethod("handleFill", fill.getClass(), Shape.class);
                m.invoke((Object)this, fill, shape);
            }
            catch (Exception e) {
                if (!(fill instanceof Fill) || !(shape instanceof Shape)) break block2;
                this.defaultFillHandler((Fill)fill, (Shape)shape);
            }
        }
    }
}

