/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import oracle.dss.legend.shared.style.LegendStyles;
import oracle.dss.legend.shared.util.LegendUtils;
import oracle.dss.presutil.FontMetricsResolver;

public class LegendSettings {
    protected Graphics m_graphics;
    protected LegendStyles m_styles;
    protected Locale m_locale = Locale.getDefault();

    public LegendSettings() {
    }

    public LegendSettings(Graphics graphics, LegendStyles styles) {
        this.m_graphics = graphics;
        this.m_styles = styles;
    }

    public Graphics getGraphics() {
        return this.m_graphics;
    }

    public LegendStyles getStyles() {
        return this.m_styles;
    }

    public boolean isBidi() {
        return LegendUtils.isBiDiLocale(this.getLocale());
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
    }

    public Locale getLocale() {
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        return this.m_locale;
    }

    private FontMetricsResolver getFontMetricsResolver() {
        return new FontMetricsResolver();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.m_graphics.getFontMetrics(font);
    }

    public int getStringWidth(Font font, String text) {
        FontMetrics fm = this.getFontMetrics(font);
        FontMetricsResolver fmr = this.getFontMetricsResolver();
        return fmr.stringWidth(text, fm);
    }
}

