/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.impl;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.legend.LegendItem;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Ellipse;
import oracle.dss.util.shapes.Line;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Stroke;

public class LegendMarker
extends LegendItem {
    protected MarkerType m_type;
    protected MarkerShape m_shape;
    protected Shape m_path;
    protected String m_image;
    protected int m_markerSize = 10;
    protected boolean m_markerWithLine;
    protected Stroke m_markerLineBorder;

    public LegendMarker(MarkerShape shape) {
        this(shape, false, null);
    }

    public LegendMarker(MarkerShape shape, boolean markerWithLine, Stroke markerLineBorder) {
        this.m_type = MarkerType.SHAPE;
        this.m_shape = shape;
        this.m_markerWithLine = markerWithLine;
        this.m_markerLineBorder = markerLineBorder;
    }

    public LegendMarker(Shape path) {
        this(path, false, null);
    }

    public LegendMarker(Shape path, boolean markerWithLine, Stroke markerLineBorder) {
        this.m_type = MarkerType.PATH;
        this.m_path = path;
        this.m_markerWithLine = markerWithLine;
        this.m_markerLineBorder = markerLineBorder;
    }

    public LegendMarker(String imageUrl) {
        this.m_type = MarkerType.IMAGE;
        this.m_image = imageUrl;
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> item = new ArrayList<DrawableObject>();
        DrawableObject marker = null;
        if (this.m_type == MarkerType.PATH && this.m_path != null) {
            Rectangle bounds = this.m_path.getBounds();
            int x = this.m_x;
            if (this.m_markerWithLine) {
                --x;
            }
            Rectangle markerBounds = new Rectangle(x, this.m_y, this.m_width - 1, this.m_height - 1);
            double sx = markerBounds.getWidth() / ((RectangularShape)bounds).getWidth();
            double sy = markerBounds.getHeight() / ((RectangularShape)bounds).getHeight();
            double scaleFactor = Math.min(sx, sy);
            AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
            Shape path = scale.createTransformedShape(this.m_path);
            Rectangle2D scaledMarkerBounds = path.getBounds2D();
            double tx = markerBounds.getCenterX() - scaledMarkerBounds.getCenterX();
            double ty = markerBounds.getCenterY() - scaledMarkerBounds.getCenterY();
            AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
            marker = new Path(translate.createTransformedShape(path));
        } else if (this.m_type != MarkerType.IMAGE) {
            if (this.m_markerWithLine) {
                this.setPosition(this.m_x + 2, this.m_y + 2);
                this.m_width = (int)((double)this.m_markerSize * 0.6);
                this.m_height = (int)((double)this.m_markerSize * 0.6);
            }
            if (this.m_shape == MarkerShape.RECTANGLE || this.m_shape == null) {
                marker = new oracle.dss.util.shapes.Rectangle(this.m_x, this.m_y, this.m_width, this.m_height);
            } else if (this.m_shape == MarkerShape.CIRCLE) {
                marker = new Ellipse(this.m_x, this.m_y, this.m_width, this.m_height);
            } else if (this.m_shape == MarkerShape.LINE) {
                marker = new Line(this.m_x, this.m_y + this.m_height / 2, this.m_x + this.m_width, this.m_y + this.m_height / 2);
            } else {
                Polygon scaledPolygon = new Polygon();
                int side = this.m_width;
                int cx = this.m_x + this.m_width / 2;
                int cy = this.m_y + this.m_width / 2;
                if (this.m_shape == MarkerShape.DIAMOND) {
                    scaledPolygon.addPoint(cx + side / 2, cy);
                    scaledPolygon.addPoint(cx, cy - side / 2);
                    scaledPolygon.addPoint(cx - side / 2, cy);
                    scaledPolygon.addPoint(cx, cy + side / 2);
                } else if (this.m_shape == MarkerShape.PLUS) {
                    int depth = 1;
                    boolean done = false;
                    while (!done) {
                        if (side >= (depth += 2) * 3 + 2) continue;
                        done = true;
                        depth -= 2;
                    }
                    int halfDepth = (depth + 1) / 2;
                    scaledPolygon.addPoint(cx - halfDepth, cy - side / 2);
                    scaledPolygon.addPoint(cx + halfDepth, cy - side / 2);
                    scaledPolygon.addPoint(cx + halfDepth, cy - halfDepth);
                    scaledPolygon.addPoint(cx + side / 2, cy - halfDepth);
                    scaledPolygon.addPoint(cx + side / 2, cy + halfDepth);
                    scaledPolygon.addPoint(cx + halfDepth, cy + halfDepth);
                    scaledPolygon.addPoint(cx + halfDepth, cy + side / 2);
                    scaledPolygon.addPoint(cx - halfDepth, cy + side / 2);
                    scaledPolygon.addPoint(cx - halfDepth, cy + halfDepth);
                    scaledPolygon.addPoint(cx - side / 2, cy + halfDepth);
                    scaledPolygon.addPoint(cx - side / 2, cy - halfDepth);
                    scaledPolygon.addPoint(cx - halfDepth, cy - halfDepth);
                    scaledPolygon.addPoint(cx - halfDepth, cy - side / 2);
                } else if (this.m_shape == MarkerShape.TRIANGLE_DN) {
                    scaledPolygon.addPoint(cx, cy + side / 2);
                    scaledPolygon.addPoint(cx + side / 2, cy - side / 2);
                    scaledPolygon.addPoint(cx - side / 2, cy - side / 2);
                    scaledPolygon.addPoint(cx, cy + side / 2);
                } else if (this.m_shape == MarkerShape.TRIANGLE_UP) {
                    scaledPolygon.addPoint(cx, cy - side / 2);
                    scaledPolygon.addPoint(cx + side / 2, cy + side / 2);
                    scaledPolygon.addPoint(cx - side / 2, cy + side / 2);
                    scaledPolygon.addPoint(cx, cy - side / 2);
                }
                marker = new Path(scaledPolygon);
            }
        }
        if (this.m_markerWithLine) {
            int x = this.m_x - 2;
            int y = this.m_y - 2;
            if (this.m_type == MarkerType.PATH) {
                y += 2;
            }
            int height = this.m_markerSize;
            int width = this.m_markerSize;
            Line linemarker = new Line(x, y + height / 2, x + width, y + height / 2);
            IdentObj id = new IdentObj(-3, ((IdentObj)this.m_id).getSeriesID());
            linemarker.setProperty(LEGEND_ID_KEY, id);
            linemarker.setFill(this.m_fill);
            linemarker.setStroke(this.m_markerLineBorder);
            item.add(linemarker);
        }
        marker.setProperty(LEGEND_ID_KEY, this.m_id);
        marker.setFill(this.m_fill);
        marker.setStroke(this.m_border);
        item.add(marker);
        return item;
    }

    @Override
    public void calc() {
    }

    public static enum MarkerType {
        SHAPE,
        PATH,
        IMAGE;

    }

    public static enum MarkerShape {
        RECTANGLE,
        CIRCLE,
        TRIANGLE_UP,
        TRIANGLE_DN,
        DIAMOND,
        PLUS,
        LINE;

    }
}

