/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGDataWriter;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGDataChunk
extends PNGChunk {
    private byte[] compressedData;
    private static final int MIN_BUFFER_SIZE = 256;
    private static final int MAX_BUFFER_SIZE = 20480;
    private static final int COMPRESSION_FACTOR = 20;

    PNGDataChunk() {
    }

    @Override
    int getDataLength() throws PNGException {
        this.compressData();
        return this.compressedData.length;
    }

    @Override
    String getChunkType() {
        return "IDAT";
    }

    @Override
    byte[] getData() throws PNGException {
        if (this.compressedData == null) {
            this.compressData();
        }
        return this.compressedData;
    }

    @Override
    boolean isCriticalChunk() {
        return true;
    }

    private void compressData() throws PNGException {
        PNGInfo info = this.getPNGInfo();
        if (info.getFilterType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG filter type specified");
        }
        if (info.getCompressionType() != 0) {
            throw new PNGException(this, 6, "compressData()", "unknown PNG compression type specified");
        }
        if (info.getColorType() != 6 && info.getColorType() != 2) {
            throw new PNGException(this, 6, "compressData()", "color type specified is not standard java color type: 8 bps RGB with alpha channel");
        }
        if (info.getInterlaceType() != 0) {
            throw new PNGException(this, 6, "compressData()", "interlacing value other than NO_INTERLACING specified; this encoder does not interlace image data");
        }
        int pixels = info.getImageWidth() * info.getImageHeight();
        double total_size = (double)pixels / 20.0;
        int adjusted = (int)Math.ceil(total_size / 256.0) * 256;
        if (adjusted > 20480) {
            adjusted = 20480;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(adjusted);
        Image image = info.getImage();
        DeflaterOutputStream deflater_stream = new DeflaterOutputStream((OutputStream)stream, new Deflater(), 1024);
        try {
            PNGDataWriter helper = new PNGDataWriter(image, deflater_stream, info.getColorType());
            helper.encode();
            deflater_stream.finish();
        }
        catch (IOException err) {
            System.err.println("IO exception occured in PNGDataChunk.java");
        }
        this.compressedData = stream.toByteArray();
    }
}

