/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRibbonSeriesSolid
extends Model3DFlatFace {
    private static final long serialVersionUID = 1L;
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    public static final int BEVEL = 6;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected Point3d[] m_points;
    private static int[][] m_myfaces = new int[][]{{0, 1, 3, 2}, {0, 2, 8, 6, 4}, {2, 3, 9, 8}, {6, 8, 9, 7}, {1, 5, 7, 9, 3}, {0, 4, 5, 1}, {4, 6, 7, 5}};

    public Model3DRibbonSeriesSolid(JChart_3D chart, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, Point3d[] points, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, 7, 10, bGridStatus, bAutoshading);
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_points = points;
        this.m_faces = m_myfaces;
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_vertices[i] = new Point3d(this.m_points[i]);
        }
    }

    public Model3DRibbonSeriesSolid(Model3DRibbonSeriesSolid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_points, model.m_bGridStatus, model.m_bAutoshading);
        this.m_distance = model.m_distance;
    }

    @Override
    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y, this.m_origin.z + this.m_size.z / 2.0);
    }

    @Override
    public int getNumPtsPerFace(int f) {
        if (f == 1 || f == 4) {
            return 5;
        }
        return 4;
    }

    @Override
    protected Point3d getGridLineStart(int nAxis, int nFace, double fGridValue) {
        Point3d pt3DGridLineStart = null;
        block0 : switch (nAxis) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 2: {
                        pt3DGridLineStart = this.getGridLineStartAxisYTop(fGridValue);
                        break block0;
                    }
                    case 0: {
                        pt3DGridLineStart = this.getGridLineStartAxisYFront(fGridValue);
                        break block0;
                    }
                    case 4: {
                        pt3DGridLineStart = this.getGridLineStartAxisYRight(fGridValue);
                    }
                }
            }
        }
        return pt3DGridLineStart;
    }

    @Override
    protected Point3d getGridLineEnd(int nAxis, int nFace, double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        block0 : switch (nAxis) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                switch (nFace) {
                    case 2: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYTop(fGridValue);
                        break block0;
                    }
                    case 0: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYFront(fGridValue);
                        break block0;
                    }
                    case 4: {
                        pt3DGridLineEnd = this.getGridLineEndAxisYRight(fGridValue);
                    }
                }
            }
        }
        return pt3DGridLineEnd;
    }

    protected Point3d getGridLineStartAxisYTop(double fGridValue) {
        double fBotLeftX = this.m_vertices[2].x;
        double fBotLeftY = this.m_vertices[2].y;
        double fBotLeftZ = this.m_vertices[2].z;
        double fBotRightX = this.m_vertices[3].x;
        double fBotRightY = this.m_vertices[3].y;
        double fBotRightZ = this.m_vertices[3].z;
        double fTopRightX = this.m_vertices[9].x;
        double fTopRightY = this.m_vertices[9].y;
        double fTopLeftX = this.m_vertices[8].x;
        double fTopLeftY = this.m_vertices[8].y;
        double fTopLeftZ = this.m_vertices[8].z;
        Point3d pt3DGridLineStart = null;
        if (fGridValue > fBotLeftY && fGridValue < fTopLeftY) {
            double fZIntercept = MathExt.getIntercept(fBotLeftZ, fBotLeftY, fTopLeftZ, fTopLeftY, fGridValue);
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fZIntercept);
        } else if (fGridValue > fBotLeftY) {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYTop(double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        double fBotLeftX = this.m_vertices[2].x;
        double fBotLeftY = this.m_vertices[2].y;
        double fBotLeftZ = this.m_vertices[2].z;
        double fBotRightX = this.m_vertices[3].x;
        double fBotRightY = this.m_vertices[3].y;
        double fBotRightZ = this.m_vertices[3].z;
        double fTopRightX = this.m_vertices[9].x;
        double fTopRightY = this.m_vertices[9].y;
        double fTopRightZ = this.m_vertices[9].z;
        double fTopLeftX = this.m_vertices[8].x;
        double fTopLeftY = this.m_vertices[8].y;
        double fTopLeftZ = this.m_vertices[8].z;
        Object pt3DGridLineStart = null;
        if (fGridValue > fBotRightY && fGridValue < fTopRightY) {
            double fZIntercept = MathExt.getIntercept(fBotRightZ, fBotRightY, fTopRightZ, fTopRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fZIntercept);
        } else {
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fBotRightZ);
        }
        return pt3DGridLineEnd;
    }

    protected Point3d getGridLineStartAxisYFront(double fGridValue) {
        double fBotLeftX = this.m_vertices[0].x;
        double fBotLeftY = this.m_vertices[0].y;
        double fBotLeftZ = this.m_vertices[0].z;
        double fTopLeftX = this.m_vertices[2].x;
        double fTopLeftY = this.m_vertices[2].y;
        Point3d pt3DGridLineStart = null;
        if (fGridValue > fBotLeftY && fGridValue < fTopLeftY) {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYFront(double fGridValue) {
        double fBotRightX = this.m_vertices[1].x;
        double fBotLeftZ = this.m_vertices[0].z;
        return new Point3d(fBotRightX, fGridValue, fBotLeftZ);
    }

    protected Point3d getGridLineStartAxisYRight(double fGridValue) {
        Point3d pt3DGridLineStart = null;
        double fBotLeftX = this.m_vertices[1].x;
        double fBotLeftY = this.m_vertices[1].y;
        double fBotLeftZ = this.m_vertices[1].z;
        double fTopLeftY = this.m_vertices[3].y;
        double fTopLeftZ = this.m_vertices[3].z;
        double fBotRightY = this.m_vertices[7].y;
        double fBotRightZ = this.m_vertices[7].z;
        double fTopRightY = this.m_vertices[9].y;
        double fTopRightZ = this.m_vertices[9].z;
        double fBotLeftFlrX = this.m_vertices[5].x;
        double fBotLeftFlrY = this.m_vertices[5].y;
        double fBotLeftFlrZ = this.m_vertices[5].z;
        if (fGridValue > fBotLeftFlrY && fGridValue < fBotLeftY) {
            double fZIntercept = MathExt.getIntercept(fBotLeftZ, fBotLeftY, fBotLeftFlrZ, fBotLeftFlrY, fGridValue);
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fZIntercept);
        } else if (fGridValue > fTopLeftY && fGridValue < fTopRightY) {
            double fZIntercept = MathExt.getIntercept(fTopLeftZ, fTopLeftY, fTopRightZ, fTopRightY, fGridValue);
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fZIntercept);
        } else {
            pt3DGridLineStart = new Point3d(fBotLeftX, fGridValue, fBotLeftZ);
        }
        return pt3DGridLineStart;
    }

    protected Point3d getGridLineEndAxisYRight(double fGridValue) {
        Point3d pt3DGridLineEnd = null;
        double fBotRightX = this.m_vertices[7].x;
        double fBotRightY = this.m_vertices[7].y;
        double fBotRightZ = this.m_vertices[7].z;
        double fTopRightX = this.m_vertices[9].x;
        double fTopRightY = this.m_vertices[9].y;
        double fTopRightZ = this.m_vertices[9].z;
        double fTopLeftY = this.m_vertices[3].y;
        double fTopLeftZ = this.m_vertices[3].z;
        double fBotLeftY = this.m_vertices[1].y;
        double fBotLeftZ = this.m_vertices[1].z;
        double fBotLeftFlrX = this.m_vertices[5].x;
        double fBotLeftFlrY = this.m_vertices[5].y;
        double fBotLeftFlrZ = this.m_vertices[5].z;
        if (fGridValue < fTopLeftY && fGridValue > fTopRightY) {
            double fZIntercept = MathExt.getIntercept(fTopLeftZ, fTopLeftY, fTopRightZ, fTopRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fZIntercept);
        } else if (fGridValue > fBotLeftFlrY && fGridValue < fBotRightY) {
            double fZIntercept = MathExt.getIntercept(fBotLeftFlrZ, fBotLeftFlrY, fBotRightZ, fBotRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fZIntercept);
        } else if (fGridValue > fBotLeftY && fGridValue < fBotRightY) {
            double fZIntercept = MathExt.getIntercept(fBotLeftZ, fBotLeftY, fBotRightZ, fBotRightY, fGridValue);
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fZIntercept);
        } else {
            pt3DGridLineEnd = new Point3d(fBotRightX, fGridValue, fBotRightZ);
        }
        return pt3DGridLineEnd;
    }
}

