/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetShape
extends DetObj {
    private static final long serialVersionUID = 1L;
    private Rectangle m_clipRect;
    private double m_fIntensity = 1.0;
    Shape m_shape = null;
    DetLabel m_detLabel = null;

    private DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox) {
        super(detectiv, id, blackBox);
    }

    public DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Area destArea) {
        this(detectiv, id, blackBox);
        this.m_shape = destArea;
    }

    public DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Arc2D destArc) {
        this(detectiv, id, blackBox);
        this.m_shape = destArc;
    }

    public DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Polygon destPoly) {
        this(detectiv, id, blackBox);
        this.m_shape = destPoly;
    }

    public DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Ellipse2D destOval) {
        this(detectiv, id, blackBox);
        this.m_shape = destOval;
    }

    public DetShape(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Rectangle2D destRect) {
        this(detectiv, id, blackBox);
        this.m_shape = destRect;
    }

    public DetShape intensity(double fIntensity) {
        this.m_fIntensity = fIntensity;
        return this;
    }

    public DetShape hiliteable(boolean hiliteable) {
        this.m_bHiliteable = hiliteable;
        return this;
    }

    public DetShape clipRect(Rectangle clipRect) {
        this.m_clipRect = clipRect;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetShape)) {
            return false;
        }
        DetShape detShape = (DetShape)obj;
        return this.m_id.equals(detShape.m_id);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        if (this.m_shape != null) {
            bounds = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_shape.getBounds());
            if (this.m_clipRect != null) {
                bounds = bounds.intersection(this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_clipRect));
            }
        }
        return bounds;
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        Shape oldClip = null;
        if (this.m_clipRect != null) {
            oldClip = g.getClip();
            g.setClip(this.m_clipRect);
        }
        g.setXORMode(Color.yellow);
        Graphics2D g2 = (Graphics2D)g;
        if (this.m_shape != null) {
            g2.draw(this.m_shape);
        }
        g.setPaintMode();
        if (this.m_clipRect != null) {
            g.setClip(oldClip);
        }
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        return this.m_bDetectable && this.m_shape != null && this.m_shape.contains(vc.virtToDestX(x), vc.virtToDestY(y)) && (this.m_clipRect == null || this.m_clipRect != null && this.m_clipRect.contains(vc.virtToDestX(x), vc.virtToDestY(y)));
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        if (this.m_clipRect != null && this.m_shape != null) {
            return this.getShape(this.m_shape.getBounds().intersection(this.m_clipRect), vc, false);
        }
        if (this.m_shape instanceof Area) {
            return this.getShape(this.m_shape, vc, ((Area)this.m_shape).isSingular());
        }
        if (this.m_shape instanceof Arc2D) {
            return this.getShape(this.m_shape, vc, true);
        }
        if (this.m_shape instanceof Ellipse2D) {
            return this.getShape(this.m_shape, vc, true);
        }
        if (this.m_shape instanceof Polygon) {
            return vc.destToVirt((Polygon)this.m_shape);
        }
        if (this.m_shape instanceof Rectangle2D) {
            return this.getShape(this.m_shape, vc, false);
        }
        Area area = new Area(this.m_shape);
        return this.getShape(area, vc, area.isSingular());
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        Shape oldClip = null;
        if (this.m_clipRect != null) {
            oldClip = g.getClip();
            g.setClip(this.m_clipRect);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.paint(g, this.m_shape);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.paint(g, this.m_shape);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.paint(g, this.m_shape);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
        if (this.m_clipRect != null) {
            g.setClip(oldClip);
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToSVG(context, this.m_shape);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToSVG(context, this.m_shape);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToSVG(context, this.m_shape);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    private void renderToSVG(Map context, Shape shape) throws IOException, Exception {
        Rectangle frameRect;
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bBubbleGraph = (Boolean)context.get("svgIsBubble");
        String sPlotAreaClip = null;
        if (bBubbleGraph && ObjClassID.stripExceptionalOffset(this.getObjectID()) == 259 && (sPlotAreaClip = (String)context.get("svgPlotAreaClip")) == null && (frameRect = (Rectangle)context.get("svgPlotAreaRect")) != null) {
            writer.startElement("clipPath");
            String clipID = writer.getFilteredBeanName() + "_plotAreaClip";
            writer.writeAttribute("id", clipID);
            StringBuilder sb = new StringBuilder("url(#");
            sb.append(clipID);
            sb.append(")");
            sPlotAreaClip = sb.toString();
            context.put("svgPlotAreaClip", sPlotAreaClip);
            if (writer.startRectElement(frameRect)) {
                writer.endElement();
            }
            writer.endElement();
        }
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bElementStarted = false;
        if (shape != null) {
            bElementStarted = this.startSVGElement(writer, shape);
        }
        if (bElementStarted) {
            if (this.m_id.getObjectID() == 357) {
                writer.writeAttribute("id", writer.getReferenceObjectId(this.m_id.getMiscID()));
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("visibility", "hidden");
                }
                writer.writeAttribute("pointer-events", "none");
            }
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (sPlotAreaClip != null) {
                writer.writeAttribute("clip-path", sPlotAreaClip);
            }
            if (bTooltips) {
                int rbMode;
                List l;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
                if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.renderToXML(context, this.m_shape);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.renderToXML(context, this.m_shape);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB), colorOrig.getAlpha()));
                this.renderToXML(context, this.m_shape);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    private void renderToXML(Map context, Shape shape) throws IOException, Exception {
        String drillJS;
        boolean bDrilling;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        String[] tooltipsArray = null;
        boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
        if (!bTooltipTemplate) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean bLiveScroll = this.m_Detectiv.getPerspective().getZoomAndScroll() == 0;
        boolean bZoomed = (this.m_Detectiv.getPerspective().getHorzRangeSlider() != null || this.m_Detectiv.getPerspective().getY1RangeSlider() != null || this.m_Detectiv.getPerspective().getY2RangeSlider() != null) && context.get("xmlVC") != this.m_Detectiv.getPerspective().getVC();
        boolean bBubbleGraph = this.m_Detectiv.getPerspective().getJGraphType().isBubble();
        String sPlotAreaClip = null;
        if (!(!bBubbleGraph || bLiveScroll && bZoomed || ObjClassID.stripExceptionalOffset(this.getObjectID()) != 259 || (sPlotAreaClip = (String)context.get("xmlPlotAreaClip")) != null)) {
            Rectangle frameRect = null;
            JChart_Base chart = this.m_Detectiv.getPerspective().getGraphObject();
            frameRect = chart instanceof JChart_2D ? this.m_Detectiv.getPerspective().getVC().virtToDest(((JChart_2D)chart).getFrameObj().calcAdjustedFrameRect()) : this.m_Detectiv.getPerspective().getVC().virtToDest(this.m_Detectiv.getPerspective().getFrameRect(false));
            if (frameRect != null) {
                writer.startElement("clipPath");
                String clipID = "plotAreaClip";
                writer.writeAttribute("id", clipID);
                StringBuilder sb = new StringBuilder("(#");
                sb.append(clipID);
                sb.append(")");
                sPlotAreaClip = sb.toString();
                context.put("xmlPlotAreaClip", sPlotAreaClip);
                if (writer.startRectElement(frameRect)) {
                    writer.endElement();
                }
                writer.endElement();
            }
        }
        boolean bElementStarted = false;
        Rectangle gradRect = null;
        if (shape != null) {
            bElementStarted = this.startXMLElement(writer, shape);
            gradRect = shape.getBounds();
        }
        if (bElementStarted) {
            boolean threeDEffect;
            if (this.m_id.getObjectID() == 357) {
                int graphID = this.m_Detectiv.getPerspective().getReferenceAssociation(this.m_id);
                int display = this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID);
                if (display == 2) {
                    writer.writeAttribute("v", "h");
                }
            }
            if (sPlotAreaClip != null) {
                writer.writeAttribute("clip", sPlotAreaClip);
            }
            writer.writeDataZoomAndScrollEventJsAttributes(this);
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (!writer.hasAlt()) {
                if (bTooltips && tooltipsArray != null) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            int graphType = this.m_Detectiv.getPerspective().getGraphType();
            boolean visualEffect = this.m_Detectiv.getPerspective().getVisualEffects() == 1 || this.m_Detectiv.getPerspective().getVisualEffects() == 2 || this.m_Detectiv.getPerspective().getVisualEffects() == 15;
            boolean bl2 = threeDEffect = this.m_Detectiv.getPerspective().getPieDepth() != 0;
            if (!(graphType != 55 && graphType != 93 && graphType != 57 && graphType != 56 && graphType != 94 && graphType != 58 || this.m_id.getObjectID() != 298 && this.m_id.getObjectID() != 332 || this.m_id.getMiscID() != 1000 || threeDEffect || !visualEffect)) {
                if (this.m_visualEffectsMap == null) {
                    this.m_visualEffectsMap = new HashMap();
                }
                Color sColor = new Color(78, 87, 101, 102);
                double sDistance = 4.0;
                double sStrength = 1.0;
                double sAngle = 45.0;
                double sBlurX = 5.0;
                double sBlurY = 5.0;
                int sQuality = 3;
                int sInner = 0;
                int sKnockout = 0;
                int sHide = 0;
                this.m_visualEffectsMap.put("shadowColor", sColor);
                this.m_visualEffectsMap.put("shadowDistance", sDistance);
                this.m_visualEffectsMap.put("shadowStrength", sStrength);
                this.m_visualEffectsMap.put("shadowAngle", sAngle);
                this.m_visualEffectsMap.put("shadowBlurX", sBlurX);
                this.m_visualEffectsMap.put("shadowBlurY", sBlurY);
                this.m_visualEffectsMap.put("shadowQuality", sQuality);
                this.m_visualEffectsMap.put("shadowInner", sInner);
                this.m_visualEffectsMap.put("shadowKnockout", sKnockout);
                this.m_visualEffectsMap.put("shadowHide", sHide);
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeCustomPropertyAttribute();
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, gradRect);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, gradRect);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            if (this.m_detLabel != null) {
                this.m_detLabel.renderXML(context);
            }
            writer.endElement();
        }
    }

    private void _writeShapeAttributes(GraphSVGWriter writer, boolean bShapeAttributes, boolean bTooltips, String saTitle, String[] tooltipsArray) throws IOException, Exception {
        if (bShapeAttributes) {
            writer.writeShapeAttributes();
        }
        if (bTooltips) {
            writer.writeTooltip(tooltipsArray);
        } else if (saTitle != null) {
            writer.writeTitleElement(saTitle);
        }
        writer.endElement();
    }

    public void setMarkerLabel(DetLabel detLabel) {
        this.m_detLabel = detLabel;
    }

    private Polygon getShape(Shape shape, VC vc, boolean bSingular) {
        PathIterator pi;
        if (bSingular && (pi = shape.getPathIterator(null, 2.0)) != null) {
            double[] coords = new double[6];
            int segType = 0;
            Polygon poly = new Polygon();
            while (!pi.isDone()) {
                segType = pi.currentSegment(coords);
                if (segType == 0 || segType == 1) {
                    poly.addPoint((int)coords[0], (int)coords[1]);
                    pi.next();
                    continue;
                }
                if (segType != 4) break;
                return vc.destToVirt(poly);
            }
        }
        Rectangle bounds = shape.getBounds();
        Polygon poly = new Polygon();
        poly.addPoint(bounds.x, bounds.y);
        poly.addPoint(bounds.x + bounds.width, bounds.y);
        poly.addPoint(bounds.x + bounds.width, bounds.y + bounds.height);
        poly.addPoint(bounds.x, bounds.y + bounds.height);
        return vc.destToVirt(poly);
    }

    private void paint(Graphics g, Shape shape) {
        if (shape instanceof Area) {
            this.m_blackBox.paint(g, (Area)shape);
        } else if (shape instanceof Arc2D) {
            this.m_blackBox.paint(g, (Arc2D)shape);
        } else if (shape instanceof Ellipse2D) {
            this.m_blackBox.paint(g, shape.getBounds(), true, false);
        } else if (shape instanceof Polygon) {
            this.m_blackBox.paint(g, (Polygon)shape);
        } else if (shape instanceof Rectangle2D) {
            this.m_blackBox.paint(g, shape.getBounds());
        }
    }

    private boolean startSVGElement(GraphSVGWriter writer, Shape shape) throws IOException, Exception {
        if (shape instanceof Area) {
            return writer.startElement(this.m_id, this.m_blackBox, (Area)shape);
        }
        if (shape instanceof Arc2D) {
            return writer.startElement(this.m_id, this.m_blackBox, (Arc2D)shape);
        }
        if (shape instanceof Ellipse2D) {
            return writer.startElement(this.m_id, this.m_blackBox, shape.getBounds(), true, false);
        }
        if (shape instanceof Polygon) {
            return writer.startElement(this.m_id, this.m_blackBox, (Polygon)shape);
        }
        if (shape instanceof Rectangle2D) {
            return writer.startElement(this.m_id, this.m_blackBox, shape.getBounds());
        }
        return false;
    }

    private boolean startXMLElement(GraphExportXMLWriter writer, Shape shape) throws IOException, Exception {
        if (shape instanceof Area) {
            return writer.startElement(this.m_id, this.m_blackBox, (Area)shape);
        }
        if (shape instanceof Arc2D) {
            return writer.startElement(this.m_id, this.m_blackBox, (Arc2D)shape);
        }
        if (shape instanceof Ellipse2D) {
            return writer.startElement(this.m_id, this.m_blackBox, shape.getBounds(), true, false);
        }
        if (shape instanceof Polygon) {
            return writer.startElement(this.m_id, this.m_blackBox, (Polygon)shape);
        }
        if (shape instanceof Rectangle2D) {
            return writer.startElement(this.m_id, this.m_blackBox, shape.getBounds());
        }
        return false;
    }
}

