/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphDrawUtils;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ReferenceLineObj;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.ScatterGraphDataStyle;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.legend.LegendSection;
import oracle.dss.legend.impl.ListLegend;
import oracle.dss.legend.impl.ListLegendItem;
import oracle.dss.presutil.PresUtils;

public class LegendMarkersLabels
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LEFT_OF_TEXT = 0;
    public static final int RIGHT_OF_TEXT = 1;
    public static final int ABOVE_TEXT = 2;
    public static final int BELOW_TEXT = 3;
    public static final int UNDER_TEXT = 4;
    public static final boolean LEFT_TO_RIGHT = false;
    public static final boolean RIGHT_TO_LEFT = true;
    public static final int VERT_LABEL_SPACING = 2;
    public static final int MIN_CHARS_FOR_TRUNCATION = 1;
    public int MKR_MARGIN;
    public int MIN_V_GAP;
    public int MIN_H_GAP;
    public int DOUBLE_MKR_MARGIN;
    protected static final int MIN_LABEL_HEIGHT = 1000;
    protected static final int ACCEPTABLE_TEXT_HEIGHT = 2000;
    protected static final int MIN_WIDTH_FOR_TEXT = 400;
    protected static final int MIN_HEIGHT_FOR_TEXT = 200;
    protected Perspective m_Perspective;
    protected Detectiv m_Detectiv;
    protected JChart_Base m_Chart;
    protected JGraphType m_gt;
    protected LegendObj m_Legend;
    protected Access m_Access;
    protected boolean m_nBiDirectionalText;
    protected Map<Integer, Dimension> labelCellDim = new HashMap<Integer, Dimension>();
    protected Map<Integer, Dimension> markerCellDim = new HashMap<Integer, Dimension>();
    protected List m_vectStrLabels;
    protected List m_vectLabelID;
    protected List m_vectMarkerID;
    protected List m_vectMarkerTemplate;
    protected List m_vectMarkerBlackBox;
    RelativeAxisObj m_axis;
    protected boolean m_bTextAutofit;
    protected String m_szFontName;
    protected int m_nFontStyle;
    protected int m_nFontSize;
    protected int m_nFontSizeVC;
    protected int m_nMarkerPos;
    protected boolean m_bLabelsExist;
    protected boolean m_connectLineMarkers;
    protected int[] m_wrappedLines;
    protected TextStyleObj m_textStyle;
    protected int m_nMarkerSizePercentX;
    protected int m_nMarkerSizePercentY;
    protected boolean m_labelsTruncated = false;
    protected boolean m_drawLabels = true;
    protected static final int markerMargin = 3;
    protected static final int minMarkerGap = 1;
    protected SeriesEnumerator m_sEnumForward;
    protected SeriesEnumerator m_sEnumReverse;

    public LegendMarkersLabels(Perspective perspective, Access access, JChart_Base chart, LegendObj legend) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = chart;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_Legend = legend;
        this.MKR_MARGIN = this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.updateMargin(3, false));
        this.MIN_V_GAP = this.m_Perspective.getVC().destToVirtHeight(1);
        this.MIN_H_GAP = this.m_Perspective.getVC().destToVirtWidth(1);
        this.DOUBLE_MKR_MARGIN = 2 * this.MKR_MARGIN;
        this.m_wrappedLines = null;
        this.m_sEnumForward = new SeriesEnumerator(perspective, access, true, false);
        this.m_sEnumReverse = new SeriesEnumerator(perspective, access, false, false);
    }

    public void init() {
        this.init(true);
    }

    protected void initMultiSection() {
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_connectLineMarkers = this.m_Perspective.getConnectLineMarkers();
    }

    protected void init(boolean clearVectors) {
        if (clearVectors) {
            this.initVectors(0);
        }
        this.m_nMarkerPos = this.m_Perspective.getLegendMarkerPosition();
        this.m_connectLineMarkers = this.m_Perspective.getConnectLineMarkers();
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_nBiDirectionalText = this.m_Perspective.getBiDirectional();
        if (this.m_nBiDirectionalText) {
            if (this.m_nMarkerPos == 0) {
                this.m_nMarkerPos = 1;
            } else if (this.m_nMarkerPos == 1) {
                this.m_nMarkerPos = 0;
            }
        }
        this.m_bTextAutofit = this.m_Perspective.getLegendTextAutofit();
        IdentObj idLegendText = this.m_Perspective.getLegendText();
        boolean bLegendFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(this.m_Perspective.getLegendText());
        if (bLegendFontSizeAbsolute) {
            this.m_nFontSize = this.m_Perspective.getFontSize(idLegendText);
            this.m_nFontSizeVC = this.m_Perspective.m_VC.destToVirtHeight(this.m_nFontSize);
        } else {
            this.m_nFontSizeVC = this.m_Perspective.getFontSizeVC(idLegendText);
            this.m_nFontSize = this.m_Perspective.m_VC.virtToDestHeight(this.m_nFontSizeVC);
        }
        this.m_nFontStyle = this.m_Perspective.getFontStyle(idLegendText);
        this.m_szFontName = this.m_Perspective.getFontName(idLegendText);
        this.m_textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_szFontName, this.m_nFontStyle, bLegendFontSizeAbsolute, this.m_nFontSize, this.m_nFontSizeVC, this.m_Perspective.getTextRotation(idLegendText), this.m_Perspective.getTextJustHoriz(idLegendText), this.m_Perspective.getTextJustVert(idLegendText), false, false, this.m_Perspective.getTextWrap(idLegendText), this.m_Perspective.getLocale());
        if (this.m_Perspective.getTextWrap(idLegendText)) {
            this.m_textStyle.setTextTruncate(true, -1, 1);
        }
    }

    public int[] getWrappedLines() {
        return this.m_wrappedLines;
    }

    public void setWrappedLines(int[] lines, boolean truncatedText) {
        this.m_wrappedLines = lines;
        this.m_labelsTruncated = truncatedText;
    }

    public void calcLabels() {
        if (this.m_bLabelsExist && this.m_drawLabels) {
            Font font;
            IdentObj id = new IdentObj(14);
            BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
            int nSeriesStart = this.m_Legend.getSeriesStart();
            int nSeriesRange = this.m_Legend.getSeriesRange();
            VC vc = this.m_Perspective.getVC();
            int nCell = 0;
            IdentObj idLgText = this.m_Perspective.getLegendText();
            int fontSize = !this.m_Perspective.getFontSizeAbsolute(idLgText) ? vc.virtToDestHeight(this.m_Perspective.getFontSizeVC(idLgText)) : this.m_Perspective.getFontSize(idLgText);
            int fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(idLgText));
            String fontName = this.m_Perspective.getFontName(idLgText);
            Graphics g = this.m_Perspective.getGraphicsContext();
            FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(g, font = new Font(fontName, fontStyle, fontSize));
            int fontHeight = TextStyleObj.getFontHeight(fm, this.m_Perspective.getFontMetricsResolver());
            int fontHeightVc = vc.destToVirtHeight(fontHeight);
            int displayLines = this.getDisplayLines(fontHeightVc, vc);
            if (displayLines == 0) {
                displayLines = 1;
            }
            boolean wordwrap = this.m_Perspective.getTextWrap(idLgText);
            boolean truncate = true;
            if (!this.m_Perspective.getFontSizeAbsolute(idLgText) && this.m_Perspective.getLegendTextAutofit()) {
                truncate = false;
            }
            for (int nLabel = nSeriesStart; nLabel < nSeriesRange; ++nLabel) {
                String szLabel = (String)this.m_vectStrLabels.get(nLabel);
                IdentObj idLegendText = (IdentObj)this.m_vectLabelID.get(nLabel);
                Rectangle rCell = this.m_Legend.getCellRect(nCell);
                Rectangle rLabel = this.calcLabelRect(rCell, nLabel);
                if (truncate && !wordwrap && fm != null && szLabel != null && rLabel.width < vc.destToVirtWidth(this.m_Perspective.getFontMetricsResolver().stringWidth(szLabel, fm))) {
                    this.m_labelsTruncated = true;
                    szLabel = rLabel.width < 0 ? "" : PresUtils.truncateText(szLabel, fm, 1, vc.virtToDestWidth(rLabel.width), this.m_Perspective.getFontMetricsResolver());
                }
                if (truncate && wordwrap) {
                    boolean wordWrapWhenPossible;
                    ArrayList strs = new ArrayList();
                    int actualLines = 0;
                    if (this.m_wrappedLines == null) {
                        actualLines = this.m_textStyle.extractLinesWordWrap(szLabel, strs, vc.virtToDestWidth(rLabel.width), fm, this.m_Perspective.getFontMetricsResolver());
                        if (this.m_textStyle.isTextTruncated()) {
                            this.m_labelsTruncated = true;
                        }
                    } else {
                        actualLines = this.m_wrappedLines[nCell];
                    }
                    if (wordWrapWhenPossible = "whenPossible".equals(this.m_Perspective.getLegendAreaWordWrapBehavior())) {
                        this.m_textStyle.setTextTruncate(true, actualLines, 1);
                    } else if (displayLines < actualLines) {
                        this.m_textStyle.setTextTruncate(true, displayLines, 1);
                        this.m_labelsTruncated = true;
                    }
                }
                ++nCell;
                if (nLabel == nSeriesStart) {
                    IdentObj idText = new IdentObj(235);
                    if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(idText) != null && this.m_Perspective.getDisplay(idText)) {
                        int style;
                        int oldStyle = style = this.m_textStyle.getFontStyle();
                        this.m_textStyle.setFontStyle(style |= 4);
                        new DetLabel(this.m_Detectiv, idLegendText, szLabel, rLabel, this.m_textStyle, blackBoxLabel, false);
                        this.m_textStyle.setFontStyle(oldStyle);
                        continue;
                    }
                }
                if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                    int underline = this.m_Perspective.getFontStyle(idLegendText) & 4;
                    this.m_textStyle.setFontStyle(this.m_textStyle.getFontStyle() & 0xFFFFFFFB | underline);
                }
                new DetLabel(this.m_Detectiv, idLegendText, szLabel, rLabel, this.m_textStyle, blackBoxLabel, false);
            }
        } else {
            this.m_labelsTruncated = true;
        }
    }

    public void calcMarkers() {
        int nSeriesStart = this.m_Legend.getSeriesStart();
        int nSeriesRange = this.m_Legend.getSeriesRange();
        int nCell = 0;
        for (int nMarker = nSeriesStart; nMarker < nSeriesRange; ++nMarker) {
            IdentObj idLegendMarker = (IdentObj)this.m_vectMarkerID.get(nMarker);
            MarkerTemplate markerTemplate = (MarkerTemplate)this.m_vectMarkerTemplate.get(nMarker);
            BlackBoxIF blackBox = (BlackBoxIF)this.m_vectMarkerBlackBox.get(nMarker);
            this.calcOneMarker(nCell, idLegendMarker, markerTemplate, blackBox, nMarker);
            ++nCell;
        }
    }

    protected void calcOneMarker(int nCell, IdentObj id, MarkerTemplate markerTemplate, BlackBoxIF blackBox, int nMarker) {
        Color color;
        boolean bSeriesHidden;
        Rectangle rCell = this.m_Legend.getCellRect(nCell);
        Rectangle rMarker = this.calcMarkerRect(rCell, nMarker);
        boolean bl = bSeriesHidden = this.m_Perspective.getSeriesVisibility(id.getSeriesID()) == 1 || this.m_Perspective.isNoRescaleHiddenSeries(id.getSeriesID()) && !this.m_Perspective.isExportingToXML();
        if (bSeriesHidden) {
            blackBox.setTransparentFillColor(true);
        }
        if (this.m_Perspective.getMarkerDisplay() && this.m_Perspective.getUseSeriesShapes() == 1 && this.m_Perspective.getSeriesType(id) != 3 && this.m_Perspective.getSeriesType(id) != 1 && (color = this.m_Perspective.getFillColor(new IdentObj(259, id.getSeriesID()), false)) != null) {
            blackBox.setFillColor(color);
        }
        GraphStyle style = blackBox.getGraphStyle(id.getSeriesID(), -3);
        blackBox = blackBox.runRules(id.getSeriesID(), -3);
        if ((this.m_Perspective.getJGraphType().isScatter() || this.m_Perspective.getJGraphType().isPolar() || this.m_Perspective.getJGraphType().isLineSelectPoint()) && style != null && style.isMarkerShapeUsed() && style.getMarkerShape() != markerTemplate.getMarkerType()) {
            markerTemplate = new MarkerTemplateArray().getMarkerTemplate(style.getMarkerShape());
        }
        if (this.m_nMarkerPos == 4) {
            new DetRect(this.m_Detectiv, id, rMarker.x, rMarker.y, rMarker.width, rMarker.height, blackBox);
        } else {
            if (markerTemplate.getMarkerType() == 4 || markerTemplate.getMarkerType() == 10) {
                IdentObj seriesId = this.m_Perspective.getSeries(nMarker);
                if (this.m_Perspective.getTransparentFillColor(seriesId)) {
                    blackBox.setTransparentBorderColor(true);
                } else if (style != null && style.getFillColor() != null) {
                    blackBox.setBorderColor(style.getFillColor());
                } else {
                    blackBox.setBorderColor(markerTemplate.getLineColor());
                }
            }
            if (bSeriesHidden && markerTemplate.getMarkerType() == 10) {
                markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
            }
            int nXCenter = rMarker.x + rMarker.width / 2;
            int nYCenter = rMarker.y + rMarker.height / 2;
            Point ptCenter = new Point(nXCenter, nYCenter);
            if (markerTemplate.getMarkerType() == 8) {
                int fontSize;
                IdentObj idLgText = this.m_Perspective.getLegendText();
                if (!this.m_Perspective.getFontSizeAbsolute(idLgText)) {
                    fontSize = this.m_Perspective.getFontSizeVC(idLgText);
                    fontSize = this.m_Perspective.m_VC.virtToDestHeight(fontSize);
                } else {
                    fontSize = this.m_Perspective.getFontSize(idLgText);
                }
                Rectangle rDefaultMarkerCell = new Rectangle(MarkerTemplate.MARKER_SQUARE);
                int markerSize = 8;
                if (fontSize >= 18) {
                    markerSize = 16;
                }
                IdentObj idMarker = new IdentObj(234);
                MarkerObj.createMarker(this.m_Detectiv, idMarker, markerTemplate, ptCenter, markerSize, markerSize, blackBox, null, false);
            } else {
                boolean markerWithLine = true;
                if (this.m_Perspective.getCommonGraph().getContext() != null) {
                    Object withLine = this.m_Perspective.getCommonGraph().getContext().get(Perspective.legend_marker_with_line);
                    boolean bl2 = markerWithLine = withLine == null || !((String)withLine).trim().equalsIgnoreCase("false");
                }
                if (this.m_Perspective.getMarkerDisplay() && markerWithLine && (this.m_Perspective.getJGraphType().isBLAType() || this.m_Perspective.getJGraphType().isRadarType()) && this.m_Perspective.getUseSeriesShapes() == 1 && (this.m_Perspective.getSeriesType(id) == 2 || this.m_Perspective.getBaseRiserType() == 2 && this.m_Perspective.getSeriesType(id) != 1 && this.m_Perspective.getSeriesType(id) != 3)) {
                    int nLineWidth = this.getMarkerLineWidth(2);
                    MarkerTemplate lineMarkerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 10, nLineWidth, Color.red);
                    nLineWidth = lineMarkerTemplate.getLineWidth();
                    lineMarkerTemplate.setLineWidthVC(nLineWidth);
                    BlackBoxIF bb = this.m_Chart.assignSeriesColor(id.getSeriesID()).copy();
                    IdentObj seriesId = this.m_Perspective.getSeries(id.getSeriesID());
                    lineMarkerTemplate.setLineStyle(this.m_Perspective.getLineStyle(seriesId));
                    if (this.m_Perspective.getTransparentFillColor(seriesId)) {
                        bb.setTransparentBorderColor(true);
                    } else if (style != null && style.getFillColor() != null) {
                        bb.setBorderColor(style.getFillColor());
                    } else {
                        bb.setBorderColor(this.m_Perspective.getFillColor(seriesId));
                    }
                    MarkerObj.createMarker(this.m_Detectiv, id, lineMarkerTemplate, ptCenter, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, bb, null, false);
                    if (markerTemplate.getMarkerType() == 11) {
                        MarkerObj.createMarker(this.m_Detectiv, id, markerTemplate, ptCenter, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, blackBox, null, false);
                    } else {
                        MarkerObj.createMarker(this.m_Detectiv, id, markerTemplate, ptCenter, (int)((double)this.m_nMarkerSizePercentX * 0.6), (int)((double)this.m_nMarkerSizePercentY * 0.6), blackBox, null, false);
                    }
                } else {
                    MarkerObj.createMarker(this.m_Detectiv, id, markerTemplate, ptCenter, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, blackBox, null, false);
                }
            }
        }
    }

    protected void calcMarkerSize() {
        int nSeriesStart = this.m_Legend.getSeriesStart();
        int nSeriesRange = this.m_Legend.getSeriesRange();
        this.markerCellDim.clear();
        for (int seriesIndex = nSeriesStart; seriesIndex < nSeriesRange; ++seriesIndex) {
            int markerSize = this.m_Perspective.getLegendMarkerSize();
            int nMaxMarkerWidthVC = this.m_Perspective.m_VC.destToVirtWidth(markerSize);
            int nMaxMarkerHeightVC = this.m_Perspective.m_VC.destToVirtHeight(markerSize);
            Rectangle rMarkerCell = new Rectangle(MarkerTemplate.MARKER_SQUARE);
            rMarkerCell.width = nMaxMarkerWidthVC;
            rMarkerCell.height = nMaxMarkerHeightVC;
            Dimension dimMarkerCell = new Dimension(rMarkerCell.width, rMarkerCell.height);
            Dimension dimCell = this.m_Legend.getDimCell(seriesIndex);
            int maxHeight = dimCell.height;
            if (this.m_nMarkerPos == 2 || this.m_nMarkerPos == 3) {
                maxHeight = dimCell.height / 2;
            }
            if (rMarkerCell.height + this.MIN_V_GAP > maxHeight) {
                rMarkerCell.height = maxHeight;
                if (rMarkerCell.height > 2 * this.MIN_V_GAP) {
                    rMarkerCell.height = maxHeight - this.MIN_V_GAP;
                }
                int markerH = this.m_Perspective.m_VC.virtToDestHeight(rMarkerCell.height);
                rMarkerCell.width = this.m_Perspective.m_VC.destToVirtWidth(markerH);
            }
            if (rMarkerCell.width + this.MIN_H_GAP > dimCell.width) {
                rMarkerCell.width = dimCell.width;
                if (rMarkerCell.width > 2 * this.MIN_H_GAP) {
                    rMarkerCell.width = dimCell.width - this.MIN_H_GAP;
                }
                int markerW = this.m_Perspective.m_VC.virtToDestWidth(rMarkerCell.width);
                rMarkerCell.height = this.m_Perspective.m_VC.destToVirtHeight(markerW);
            }
            switch (this.m_nMarkerPos) {
                case 2: 
                case 3: {
                    dimMarkerCell = new Dimension(dimCell.width, dimCell.height / 2);
                    break;
                }
                case 0: 
                case 1: {
                    dimMarkerCell = new Dimension(rMarkerCell.width, rMarkerCell.height);
                    break;
                }
                default: {
                    dimMarkerCell = new Dimension(dimCell);
                }
            }
            this.markerCellDim.put(seriesIndex, dimMarkerCell);
            this.calcMarkerSizePercent(rMarkerCell);
        }
    }

    public void calcMarkerSizePercent(Rectangle rMarkerCell) {
        boolean bSquareMarkers;
        Rectangle rDefaultMarkerCell = new Rectangle(MarkerTemplate.MARKER_SQUARE);
        double fWidthPercent = rMarkerCell.width;
        fWidthPercent /= (double)rDefaultMarkerCell.width;
        this.m_nMarkerSizePercentX = (int)(fWidthPercent *= 100.0);
        double fHeightPercent = rMarkerCell.height;
        fHeightPercent /= (double)rDefaultMarkerCell.height;
        this.m_nMarkerSizePercentY = (int)(fHeightPercent *= 100.0);
        if (this.m_nMarkerSizePercentX < 1) {
            this.m_nMarkerSizePercentX = 1;
        }
        if (this.m_nMarkerSizePercentY < 1) {
            this.m_nMarkerSizePercentY = 1;
        }
        if ((bSquareMarkers = this.m_Perspective.getSquareMarkers()) && this.m_nMarkerPos != 4) {
            double fDestY;
            double fDestX = this.m_Perspective.m_VC.virtToDestWidth((double)this.m_nMarkerSizePercentX);
            if (fDestX > (fDestY = this.m_Perspective.m_VC.virtToDestHeight((double)this.m_nMarkerSizePercentY))) {
                this.m_nMarkerSizePercentX = (int)((double)this.m_nMarkerSizePercentX * fDestY / fDestX);
            } else {
                this.m_nMarkerSizePercentY = (int)((double)this.m_nMarkerSizePercentY * fDestX / fDestY);
            }
            if (this.m_nMarkerSizePercentX < 1) {
                this.m_nMarkerSizePercentX = 1;
            }
            if (this.m_nMarkerSizePercentY < 1) {
                this.m_nMarkerSizePercentY = 1;
            }
        }
    }

    public Rectangle calcMarkerRect(Rectangle rCell, int itemIndex) {
        Dimension dimCell = this.m_Legend.getDimCell(itemIndex);
        Point ptOffsets = this.calcMarkerOffsets(itemIndex);
        int nDx = rCell.x + ptOffsets.x;
        int nDy = rCell.y + ptOffsets.y;
        Rectangle rMarker = new Rectangle(this.markerCellDim.get(itemIndex));
        rMarker.translate(nDx, nDy);
        return rMarker;
    }

    public Point calcMarkerOffsets(int itemIndex) {
        Dimension dimCell = this.m_Legend.getDimCell(itemIndex);
        int markerCellHeight = this.markerCellDim.get((Object)Integer.valueOf((int)itemIndex)).height;
        int nXMarkerOffset = 0;
        int nYMarkerOffset = (dimCell.height - markerCellHeight) / 2;
        if (nYMarkerOffset < 0) {
            nYMarkerOffset = 0;
        }
        if (this.m_bLabelsExist) {
            switch (this.m_nMarkerPos) {
                default: {
                    break;
                }
                case 1: {
                    nXMarkerOffset = this.labelCellDim.get((Object)Integer.valueOf((int)itemIndex)).width + this.MKR_MARGIN;
                    break;
                }
                case 2: {
                    nYMarkerOffset = markerCellHeight;
                    break;
                }
                case 3: {
                    nYMarkerOffset = (dimCell.height / 2 - markerCellHeight) / 2;
                }
                case 4: 
            }
            PfjAssert.pfjAssert(nXMarkerOffset >= 0);
            PfjAssert.pfjAssert(nYMarkerOffset >= 0);
        }
        return new Point(nXMarkerOffset, nYMarkerOffset);
    }

    public void setDrawLabels(boolean draw) {
        this.m_drawLabels = draw;
    }

    public boolean isLabelsTruncated() {
        return this.m_labelsTruncated;
    }

    protected void calcLabelSize() {
        int nSeriesStart = this.m_Legend.getSeriesStart();
        int nSeriesRange = this.m_Legend.getSeriesRange();
        this.labelCellDim.clear();
        for (int itemIndex = nSeriesStart; itemIndex < nSeriesRange; ++itemIndex) {
            Dimension dimCell = this.m_Legend.getDimCell(itemIndex);
            if (dimCell.width < this.DOUBLE_MKR_MARGIN || dimCell.height < 200) {
                this.m_bLabelsExist = false;
                continue;
            }
            Dimension dimLabelCell = null;
            switch (this.m_nMarkerPos) {
                default: {
                    int nWidth = dimCell.width - this.markerCellDim.get((Object)Integer.valueOf((int)itemIndex)).width - this.DOUBLE_MKR_MARGIN;
                    if (nWidth <= 0) {
                        nWidth = 0;
                        this.m_bLabelsExist = false;
                    }
                    dimLabelCell = new Dimension(nWidth, dimCell.height);
                    if (!this.m_nBiDirectionalText) break;
                    switch (this.m_textStyle.getHorizAlign()) {
                        case 2: {
                            this.m_textStyle.setHorizAlign(4);
                            break;
                        }
                        case 4: {
                            this.m_textStyle.setHorizAlign(2);
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    dimLabelCell = new Dimension(dimCell.width - this.DOUBLE_MKR_MARGIN, dimCell.height / 2);
                    break;
                }
                case 4: {
                    dimLabelCell = new Dimension(dimCell.width - this.DOUBLE_MKR_MARGIN, dimCell.height);
                }
            }
            if (dimLabelCell != null) {
                this.labelCellDim.put(itemIndex, dimLabelCell);
            }
            ArrayList<String> m_szLargeDummyLabels = new ArrayList<String>(1);
            m_szLargeDummyLabels.add("THIS IS A VERY VERY LONG DUMMY LABEL SO THE TEXT BOXSIZE FOR THE LEGEND IS MAXIMIZED");
            List szLabelJust = null;
            szLabelJust = this.m_bTextAutofit ? this.m_vectStrLabels : this.m_vectStrLabels;
            Graphics gx = this.m_Perspective.getGraphicsContext();
            this.m_textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_bTextAutofit, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), this.m_nFontSizeVC, szLabelJust, this.labelCellDim.get(itemIndex), this.m_Perspective.m_VC);
        }
    }

    private Point calcLabelOffsets(int itemIndex) {
        Dimension dimCell = this.m_Legend.getDimCell(itemIndex);
        int nXLabelOffset = (dimCell.width - this.labelCellDim.get((Object)Integer.valueOf((int)itemIndex)).width) / 2;
        int nYLabelOffset = dimCell.height / 2 - this.labelCellDim.get((Object)Integer.valueOf((int)itemIndex)).height / 2;
        switch (this.m_nMarkerPos) {
            default: {
                nXLabelOffset = this.markerCellDim.get((Object)Integer.valueOf((int)itemIndex)).width + this.MKR_MARGIN;
                break;
            }
            case 1: {
                nXLabelOffset = 0;
                break;
            }
            case 2: {
                nYLabelOffset = (dimCell.height / 2 - this.labelCellDim.get((Object)Integer.valueOf((int)itemIndex)).height) / 2;
                break;
            }
            case 3: {
                nYLabelOffset = this.markerCellDim.get((Object)Integer.valueOf((int)itemIndex)).height;
            }
            case 4: 
        }
        if (nXLabelOffset < 0) {
            nXLabelOffset = 0;
        }
        if (nYLabelOffset < 0) {
            nYLabelOffset = 0;
        }
        return new Point(nXLabelOffset, nYLabelOffset);
    }

    public Rectangle calcLabelRect(Rectangle rCell, int itemIndex) {
        Point ptLabelOffset = this.calcLabelOffsets(itemIndex);
        int nDx = rCell.x + ptLabelOffset.x;
        int nDy = rCell.y + ptLabelOffset.y;
        Rectangle rLabel = new Rectangle(this.labelCellDim.get(itemIndex));
        rLabel.translate(nDx, nDy);
        return rLabel;
    }

    public void initVectors(int nSize) {
        this.m_bLabelsExist = false;
        this.m_vectStrLabels = new ArrayList(nSize);
        this.m_vectLabelID = new ArrayList(nSize);
        this.m_vectMarkerID = new ArrayList(nSize);
        this.m_vectMarkerTemplate = new ArrayList(nSize);
        this.m_vectMarkerBlackBox = new ArrayList(nSize);
    }

    public void loadReferenceObjects() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble() || gt.isParetoType() || gt.isStockType())) {
            return;
        }
        if (this.m_Perspective.m_referenceObjects == null) {
            return;
        }
        int count = this.m_Perspective.m_referenceObjects.size();
        for (int i = 0; i < count; ++i) {
            IdentObj idObj = (IdentObj)this.m_Perspective.m_referenceObjects.get(i);
            int nIdx = idObj.getMiscID();
            IdentObj idText = this.m_Perspective.getReferenceLegendText(idObj);
            if (!this.m_Perspective.getDisplay(idText)) continue;
            this.m_vectLabelID.add(idText);
            String szLabel = this.m_Perspective.getReferenceObjectTextString(idObj);
            this.m_vectStrLabels.add(szLabel);
            IdentObj idLegendMarker = new IdentObj(504, -3, -3, -3, idObj.getMiscID());
            this.m_vectMarkerID.add(idLegendMarker);
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idObj);
            Color clr = this.m_Perspective.getFillColor(idObj);
            blackBox.setTransparentBorderColor(true);
            this.m_vectMarkerBlackBox.add(blackBox);
            MarkerTemplate markerTemplate = this.m_Perspective.getReferenceObjectType(idObj) == 1 ? MarkerTemplateArray.PRESET_SQUARE : new MarkerTemplate(MarkerTemplate.MARKER_LINE, 4, this.getMarkerLineWidth(this.m_Perspective.getLineWidth(idObj)), clr);
            int nLineWidth = markerTemplate.getLineWidth();
            markerTemplate.setLineWidthVC(this.m_Perspective.m_VC.destToVirtWidth(nLineWidth));
            markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(idObj));
            this.m_vectMarkerTemplate.add(markerTemplate);
        }
    }

    public void loadReferenceLineVectors() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble() || gt.isParetoType() || gt.isStockType())) {
            return;
        }
        List rlv = this.m_Perspective.getReferenceLineVector();
        if (rlv != null && !rlv.isEmpty()) {
            for (int i = 0; i < rlv.size(); ++i) {
                ReferenceLineObj rli = (ReferenceLineObj)rlv.get(i);
                IdentObj idObj = rli.getIdentObj();
                int nIdx = rli.getIndex();
                int axis = rli.getAxisLineObjID();
                if (!this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLine(idObj, nIdx)) || !rli.IsValidAxis() || !this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLineLegendText(idObj, nIdx))) continue;
                IdentObj idText = new IdentObj(503, nIdx, axis);
                idText.setMiscID(i);
                this.m_vectLabelID.add(idText);
                String szLabel = this.m_Perspective.getTextString(this.m_Perspective.getReferenceLine(idObj, nIdx));
                this.m_vectStrLabels.add(szLabel);
                IdentObj idLegendMarker = new IdentObj(504, nIdx, axis);
                idLegendMarker.setMiscID(i);
                this.m_vectMarkerID.add(idLegendMarker);
                BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLegendMarker);
                Color clr = this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(idObj, nIdx));
                blackBox.setFillColor(clr);
                this.m_vectMarkerBlackBox.add(blackBox);
                MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 4, this.getMarkerLineWidth(this.m_Perspective.getLineWidth(this.m_Perspective.getReferenceLine(idObj, nIdx))), clr);
                int nLineWidth = markerTemplate.getLineWidth();
                markerTemplate.setLineWidthVC(this.m_Perspective.m_VC.destToVirtWidth(nLineWidth));
                markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(this.m_Perspective.getReferenceLine(idObj, nIdx)));
                this.m_vectMarkerTemplate.add(markerTemplate);
            }
        }
    }

    public void loadSelectPointMarker() {
        IdentObj idText = new IdentObj(509);
        this.m_vectLabelID.add(idText);
        String szLabel = this.m_Perspective.getTextString(idText);
        this.m_vectStrLabels.add(szLabel);
        IdentObj idSelectPointMarker = new IdentObj(510, 1);
        this.m_vectMarkerID.add(idSelectPointMarker);
        IdentObj idSeries = new IdentObj(-3, 1 % this.m_Perspective.getSeriesLooping());
        MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
        idSeries.setSeriesID(1);
        this.m_vectMarkerTemplate.add(markerTemplate);
        BlackBoxIF blackBox = this.m_Chart.assignSeriesColor(1);
        this.m_vectMarkerBlackBox.add(blackBox);
    }

    public void loadDrillMarker() {
        IdentObj idText = new IdentObj(235);
        if (!this.m_Perspective.getDrillCallback().isDrillingEnabled() || this.m_Perspective.getTextString(idText) == null || !this.m_Perspective.getDisplay(idText)) {
            return;
        }
        this.m_vectLabelID.add(idText);
        String szLabel = this.m_Perspective.getTextString(idText);
        this.m_vectStrLabels.add(szLabel);
        IdentObj idDrillMarker = new IdentObj(234);
        this.m_vectMarkerID.add(idDrillMarker);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idDrillMarker);
        this.m_vectMarkerBlackBox.add(blackBox);
        MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 8);
        this.m_vectMarkerTemplate.add(markerTemplate);
    }

    public void setDisplayInLegend(int series, boolean show) {
        this.m_Perspective.setDisplayInLegend(show, series);
    }

    public boolean getDisplayInLegend(int series) {
        return this.m_Perspective.getDisplayInLegend(series);
    }

    boolean seriesShowing() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        PfjAssert.pfjAssert(sEnum != null);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            if (!this.getDisplayInLegend(nSeries)) continue;
            return true;
        }
        return false;
    }

    public void loadSeriesVectors() {
        boolean bOther = false;
        JChart_2D_Pie chart = null;
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isPieType()) {
            chart = (JChart_2D_Pie)this.m_Chart;
            bOther = chart.getOtherPercentageFlag();
        }
        boolean singleSeries = this.m_Chart.isSingleSeriesOnly();
        boolean bReverseSeries = this.m_Perspective.getReverseSeries();
        boolean bForwardSeries = this.m_Legend.getLegendReverse() == bReverseSeries;
        int nSeriesLooping = this.m_Perspective.getSeriesLooping();
        SeriesEnumerator sEnum = bForwardSeries ? this.m_sEnumForward : this.m_sEnumReverse;
        PfjAssert.pfjAssert(sEnum != null);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            boolean bDrawSeries = this.getDisplayInLegend(nSeries);
            if (chart != null) {
                boolean bl = bDrawSeries = !chart.isSeriesPartOfOther(nSeries);
                if (!this.getDisplayInLegend(nSeries) || gt.isPieType() && !chart.m_Perspective.getLegendZeroSeriesDisplay() && chart.getDataValue(nSeries, 0) != null && chart.getDataValue((int)nSeries, (int)0).m_fValue == 0.0) {
                    bDrawSeries = false;
                }
            }
            if (this.m_Chart.m_gt.isWaterfall() && nSeries == 0 || singleSeries && nSeries != 0 || !bDrawSeries) continue;
            int nSeriesID = nSeries;
            String szLabel = this.m_Perspective.getSeriesLabel(nSeries);
            this.m_vectStrLabels.add(szLabel);
            if (szLabel != null && !szLabel.equals("")) {
                this.m_bLabelsExist = true;
            }
            IdentObj idLegendText = new IdentObj(14, nSeriesID);
            this.m_vectLabelID.add(idLegendText);
            IdentObj idLegendMarker = new IdentObj(13, nSeriesID);
            this.m_vectMarkerID.add(idLegendMarker);
            IdentObj idSeries = new IdentObj(-3, nSeriesID);
            if (this.m_Perspective.getMarkerShapeObj(idSeries) == null) {
                idSeries = new IdentObj(-3, nSeriesID % nSeriesLooping);
            }
            MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
            idSeries.setSeriesID(nSeriesID);
            if (gt.isBubble() && (!this.m_Perspective.getUseDefaultBubbleMarker(idSeries) && markerTemplate.m_markerType != 11 && markerTemplate.m_markerType != 12 && markerTemplate.m_markerType != 0 || this.m_Perspective.getUseDefaultBubbleMarker(idSeries))) {
                markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
            }
            this.m_vectMarkerTemplate.add(markerTemplate);
            BlackBoxIF blackBox = this.m_Chart.assignSeriesColor(nSeries);
            if ((this.m_Perspective.getSeriesType(nSeries) == 2 || this.m_Perspective.getBaseRiserType() == 2) && !this.m_connectLineMarkers || this.m_gt.isScatter() || this.m_gt.isPolar()) {
                IdentObj lineMarkerID = new IdentObj(259, nSeries % nSeriesLooping);
                BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
                if (nSeries >= nSeriesLooping) {
                    this.m_Perspective.m_getDefault = false;
                    IdentObj idS = new IdentObj(-3, nSeries);
                    Color c = this.m_Perspective.getFillColor(idS);
                    this.m_Perspective.m_getDefault = true;
                    if (c != null) {
                        lineMarkerID = new IdentObj(259, nSeries);
                        bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
                    }
                }
                if (blackBox.getBorderColor() != null) {
                    bb.setBorderColor(blackBox.getBorderColor());
                }
                bb.setTransparentBorderColor(blackBox.getTransparentBorderColor());
                this.m_vectMarkerBlackBox.add(bb);
                continue;
            }
            this.m_vectMarkerBlackBox.add(blackBox);
        }
        if (bOther) {
            this.loadPieOtherVectors();
        }
    }

    private void loadPieOtherVectors() {
        String szLabel = "other";
        this.m_vectStrLabels.add(szLabel);
        IdentObj idLegendText = new IdentObj(14, -1);
        this.m_vectLabelID.add(idLegendText);
        IdentObj idSeries = new IdentObj(-3, -1);
        idSeries.setSeriesID(-1);
        MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker(idSeries)) {
            markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
        }
        this.m_vectMarkerTemplate.add(markerTemplate);
        IdentObj idLegendMarker = new IdentObj(-3, -1);
        this.m_vectMarkerID.add(idLegendMarker);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLegendMarker);
        this.m_vectMarkerBlackBox.add(blackBox);
        this.m_bLabelsExist = true;
    }

    MarkerTemplate getSeriesMarkerTemplate(IdentObj idSeries) {
        boolean iDisplayScatterLines;
        MarkerTemplate markerTemplate = null;
        int iUseSeriesShapes = this.m_Perspective.getUseSeriesShapes();
        boolean bl = iDisplayScatterLines = this.m_Perspective.getScatterLineType() != GraphConstants.ScatterLineType.NONE;
        if (iUseSeriesShapes == 2) {
            markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            return markerTemplate;
        }
        if ((this.m_Perspective.getSeriesType(idSeries) == 2 || this.m_Perspective.getBaseRiserType() == 2) && iUseSeriesShapes != 1 && (!this.m_gt.isScatter() || this.m_gt.isScatter() && iDisplayScatterLines) && !this.m_gt.isPolar() && !this.m_gt.isLineSelectPoint() && this.m_connectLineMarkers) {
            int nLineWidth;
            IdentObj idS;
            Color c = null;
            int s = idSeries.getSeriesID();
            if (s >= this.m_Perspective.getSeriesLooping()) {
                this.m_Perspective.m_getDefault = false;
                idS = new IdentObj(-3, s);
                c = this.m_Perspective.getFillColor(idS);
                this.m_Perspective.m_getDefault = true;
            }
            if (c == null) {
                idS = new IdentObj(-3, s % this.m_Perspective.getSeriesLooping());
                c = this.m_Perspective.getFillColor(idS);
            }
            if ((nLineWidth = this.m_Perspective.getLineWidth(idSeries)) == (Integer)Attr.SeriesLineWidthDefault.getDefault()) {
                nLineWidth = this.m_Perspective.updateMargin(nLineWidth, true);
            }
            markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 10, this.getMarkerLineWidth(nLineWidth), c);
            nLineWidth = markerTemplate.getLineWidth();
            markerTemplate.setLineWidthVC(nLineWidth);
            markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(idSeries));
            return markerTemplate;
        }
        if (iUseSeriesShapes == 1) {
            if (this.m_Perspective.getMarkerShape(idSeries) == 0) {
                markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            } else if (this.m_Perspective.getSeriesType(idSeries) == 2 || this.m_Perspective.getBaseRiserType() == 2 && this.m_Perspective.getSeriesType(idSeries) != 1 && this.m_Perspective.getSeriesType(idSeries) != 3) {
                markerTemplate = this.m_Perspective.getMarkerTemplate(idSeries);
                markerTemplate.setLineColor(this.m_Perspective.getFillColor(idSeries));
                markerTemplate.setLineWidth(this.getMarkerLineWidth(2));
                markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(idSeries));
            } else {
                markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            }
        } else {
            markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
        }
        return markerTemplate;
    }

    public void loadSpectralVectors() {
        boolean bExactColor = this.m_Perspective.getExactColorByHeight();
        if (bExactColor) {
            this.m_vectStrLabels = this.m_axis.getNumericLabels();
            int nNumLabels = this.m_vectStrLabels.size();
            for (int nLabel = 0; nLabel < nNumLabels; ++nLabel) {
                IdentObj idLegendText = new IdentObj(14, nLabel);
                this.m_vectLabelID.add(idLegendText);
            }
        } else {
            IdentObj idLegendText;
            String szLabel;
            double fMid;
            double fCurr;
            double fPrev;
            int nLabel;
            List dLabels = this.m_axis.getNumericLabelsAsDouble();
            int nNumLabels = dLabels.size();
            PfjAssert.pfjAssert(nNumLabels > 1);
            for (nLabel = 0; nLabel < nNumLabels - 1; ++nLabel) {
                fPrev = (Double)dLabels.get(nLabel);
                fCurr = (Double)dLabels.get(nLabel + 1);
                fMid = (fPrev + fCurr) / 2.0;
                if (nLabel == 0) {
                    szLabel = "< " + fMid;
                } else {
                    double fOldPrev = (Double)dLabels.get(nLabel - 1);
                    double fOldMid = (fOldPrev + fPrev) / 2.0;
                    szLabel = fOldMid + " - " + fMid;
                }
                this.m_vectStrLabels.add(szLabel);
                idLegendText = new IdentObj(14, nLabel);
                this.m_vectLabelID.add(idLegendText);
            }
            fPrev = (Double)dLabels.get(nNumLabels - 2);
            fCurr = (Double)dLabels.get(nNumLabels - 1);
            fMid = (fPrev + fCurr) / 2.0;
            szLabel = "> " + fMid;
            this.m_vectStrLabels.add(szLabel);
            idLegendText = new IdentObj(14, nLabel);
            this.m_vectLabelID.add(idLegendText);
        }
        this.loadSpectralMarkerVectors();
        if (this.m_vectStrLabels.size() > 0) {
            this.m_bLabelsExist = true;
        }
    }

    public void loadThresholdVectors() {
        int nNumLabels = this.m_Perspective.getThresholdCount();
        PfjAssert.pfjAssert(nNumLabels > 1);
        for (int nLabel = 0; nLabel < nNumLabels; ++nLabel) {
            String szLabel = this.m_Perspective.getThresholdText(nLabel);
            this.m_vectStrLabels.add(szLabel);
            IdentObj idLegendText = new IdentObj(14, nLabel);
            this.m_vectLabelID.add(idLegendText);
        }
        this.loadThresholdMarkerVectors();
        if (this.m_vectStrLabels.size() > 0) {
            this.m_bLabelsExist = true;
        }
    }

    public void loadSpectralMarkerVectors() {
        JChart_Base chart = this.m_Perspective.getGraphObject();
        List vectStrLabels = this.m_axis.getNumericLabelsAsDouble();
        for (int nLabel = 0; nLabel < this.m_vectStrLabels.size(); ++nLabel) {
            IdentObj idLegendMarker = new IdentObj(18);
            idLegendMarker.setMiscID(nLabel);
            this.m_vectMarkerID.add(idLegendMarker);
            Double dLabel = (Double)vectStrLabels.get(nLabel);
            double fValue = dLabel;
            double fRatio = this.m_axis.getValueRelCoord(fValue);
            BlackBoxIF blackBox = chart.getBlackBox(idLegendMarker, fRatio);
            this.m_vectMarkerBlackBox.add(blackBox);
            MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            this.m_vectMarkerTemplate.add(markerTemplate);
        }
    }

    public void loadThresholdMarkerVectors() {
        if (!this.m_Perspective.isFunnel()) {
            return;
        }
        int nNumLabels = this.m_Perspective.getThresholdCount();
        for (int nLabel = 0; nLabel < nNumLabels; ++nLabel) {
            IdentObj idLegendMarker = new IdentObj(73);
            idLegendMarker.setMiscID(nLabel);
            this.m_vectMarkerID.add(idLegendMarker);
            IdentObj thresholdId = this.m_Perspective.getThreshold(nLabel);
            BlackBoxIF blackBox = this._assignThresholdColor(nLabel);
            this.m_vectMarkerBlackBox.add(blackBox);
            MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            this.m_vectMarkerTemplate.add(markerTemplate);
        }
    }

    private BlackBoxIF _assignThresholdColor(int label) {
        IdentObj thresholdId = this.m_Perspective.getThreshold(label);
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, thresholdId);
        bb.setFillType(1);
        Color c = bb.getFillColor();
        bb.setFillType(2);
        FillGradientObj fillObj = new FillGradientObj(this.m_Perspective, 3);
        Color topColor = this.m_Perspective.getBrighter(c, 0.75);
        Color bottomColor = this.m_Perspective.getBrighter(c, 0.9);
        fillObj.insertPin(0.0, topColor, topColor);
        fillObj.insertPin(1.0, bottomColor, bottomColor);
        bb.setFillGradientObj(fillObj);
        return bb;
    }

    public int getMinWidth() {
        int nMinWidth = 0;
        if (this.m_Legend.getLayoutOrient() == 0) {
            FontMetrics fm = this.getLegendFontMetrics();
            Dimension dimlargeText = new Dimension(0, 0);
            for (int i = 0; i < this.m_vectStrLabels.size(); ++i) {
                String strText = (String)this.m_vectStrLabels.get(i);
                if (strText == null || strText.length() <= 0) continue;
                int nWidth = this.m_Perspective.getFontMetricsResolver().stringWidth(strText, fm);
                int nHeight = this.m_Perspective.getFontMetricsResolver().getMaxAscent(fm) + this.m_Perspective.getFontMetricsResolver().getMaxDescent(fm) + this.m_Perspective.getFontMetricsResolver().getLeading(fm) - this.m_Perspective.getFontMetricsResolver().getLeading(fm);
                dimlargeText.width = Math.max(dimlargeText.width, nWidth);
                dimlargeText.height = Math.max(dimlargeText.height, nHeight);
            }
            nMinWidth = this.m_Perspective.m_VC.destToVirtWidth(dimlargeText.width) * 3 / 2 + this.m_Legend.DOUBLE_BOX_MARGIN_W + 200;
        }
        return nMinWidth;
    }

    private FontMetrics getLegendFontMetrics() {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        if (gx == null) {
            Image imageOfChart = this.m_Perspective.createOffscreenImage(1, 1);
            gx = imageOfChart.getGraphics();
        }
        int nStyle = 0;
        nStyle += (this.m_nFontStyle & 1) != 0 ? 2 : 0;
        Font font = this.m_Perspective.m_fontCache.getFont(this.m_szFontName, nStyle += (this.m_nFontStyle & 2) != 0 ? 1 : 0, this.m_nFontSize);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        return fm;
    }

    private int getDisplayLines(int fontHeightVc, VC vc) {
        int vspace = vc.destToVirtHeight(this.m_Perspective.updateMargin(2, true));
        int legendHt = this.m_Perspective.getLegendRect().height - this.m_Perspective.updateMargin(this.m_Legend.DOUBLE_BOX_MARGIN_HT, true);
        int totalSpace = legendHt - (this.m_Legend.getNumOfRows() - 1) * vspace;
        int lineSpace = fontHeightVc * this.m_Legend.getNumOfRows();
        return totalSpace / lineSpace;
    }

    public int getNumLabels() {
        int nNumLabels = 0;
        if (this.m_vectStrLabels != null) {
            nNumLabels = this.m_vectStrLabels.size();
        }
        return nNumLabels;
    }

    public List getLabels() {
        return this.m_vectStrLabels;
    }

    public double getPinPosFromMarker(IdentObj id) {
        int s = id.getSeriesID();
        if (s == -3) {
            s = 0;
        }
        double fInterval = this.getNumLabels() == 1 ? 1.0 : 1.0 / (double)(this.getNumLabels() - 1);
        double fPin = (double)s * fInterval;
        PfjAssert.pfjAssert(fPin >= 0.0 && fPin <= 1.0);
        return fPin;
    }

    public void setY1Axis(RelativeAxisObj Y1Axis2) {
        this.m_axis = Y1Axis2;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public Dimension getDimLabelCell() {
        return this.labelCellDim.isEmpty() ? null : this.labelCellDim.get(0);
    }

    public TextStyleObj getTextStyleObj() {
        return this.m_textStyle;
    }

    public void loadReferenceObjectsSection() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble() || gt.isParetoType() || gt.isStockType())) {
            return;
        }
        if (this.m_Perspective.m_referenceObjects == null) {
            return;
        }
        int count = this.m_Perspective.m_referenceObjects.size();
        if (count == 0) {
            return;
        }
        LegendSection refSection = null;
        for (int i = 0; i < count; ++i) {
            IdentObj idObj = (IdentObj)this.m_Perspective.m_referenceObjects.get(i);
            int nIdx = idObj.getMiscID();
            IdentObj idText = this.m_Perspective.getReferenceLegendText(idObj);
            if (!this.m_Perspective.getDisplay(idText)) continue;
            if (refSection == null) {
                refSection = this.m_Legend.m_legendArea.createListSection();
            }
            String szLabel = this.m_Perspective.getReferenceObjectTextString(idObj);
            IdentObj idLegendMarker = new IdentObj(504, -3, -3, -3, idObj.getMiscID());
            IdentObj idLegendText = new IdentObj(503, -3, -3, -3, idObj.getMiscID());
            Color color = this.m_Perspective.getFillColor(idObj);
            MarkerTemplate markerTemplate = this.m_Perspective.getReferenceObjectType(idObj) == 1 ? MarkerTemplateArray.PRESET_SQUARE : new MarkerTemplate(MarkerTemplate.MARKER_LINE, 4, this.getMarkerLineWidth(this.m_Perspective.getLineWidth(idObj)), color);
            int nLineWidth = markerTemplate.getLineWidth();
            markerTemplate.setLineWidthVC(this.m_Perspective.m_VC.destToVirtWidth(nLineWidth));
            markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(idObj));
            ListLegendItem item = GraphDrawUtils.createMarker(markerTemplate, szLabel, idLegendMarker, idLegendText, null, null);
            item.setLocale(this.m_Perspective.getLocale());
            refSection.addItem(item);
        }
        if (refSection != null && this.m_Perspective.m_blegendSectionTitle) {
            refSection.setTitle(GraphDrawUtils.createSectionTitle("Reference Objects"));
        }
    }

    public void loadDataStyleVectorsSection(DataStyleType styleType) {
        boolean isUnderlay;
        ScatterGraphDataStyle dataStyle = this.m_Perspective.m_ScatterGraphDataStyle;
        Set keys = dataStyle.getStyleKeys(styleType);
        if (keys == null) {
            return;
        }
        boolean bMarkerShape = styleType == DataStyleType.MARKER_SHAPE;
        boolean bMarkerColor = styleType == DataStyleType.MARKER_COLOR;
        boolean bUnderlayShape = styleType == DataStyleType.UNDERLAY_SHAPE;
        boolean bUnderlayColor = styleType == DataStyleType.UNDERLAY_COLOR;
        boolean isShape = bMarkerShape || bUnderlayShape;
        boolean isColor = bMarkerColor || bUnderlayColor;
        boolean bl = isUnderlay = bUnderlayShape || bUnderlayColor;
        if (!isShape && !isColor) {
            return;
        }
        ListLegend layerSection = this.m_Legend.m_legendArea.createListSection();
        String title = "Layer Name";
        Comparator<Object> comp = null;
        if (bMarkerShape) {
            title = this.m_Perspective.getCommonGraph().getMarkerShapeAttribute();
            comp = this.m_Perspective.getCommonGraph().getMarkerShapeComparator();
        } else if (bMarkerColor) {
            title = this.m_Perspective.getCommonGraph().getMarkerColorAttribute();
            comp = this.m_Perspective.getCommonGraph().getMarkerColorComparator();
        } else if (bUnderlayShape) {
            title = this.m_Perspective.getCommonGraph().getMarkerUnderlayShapeAttribute();
            comp = this.m_Perspective.getCommonGraph().getMarkerUnderlayShapeComparator();
        } else if (bUnderlayColor) {
            title = this.m_Perspective.getCommonGraph().getMarkerUnderlayColorAttribute();
            comp = this.m_Perspective.getCommonGraph().getMarkerUnderlayColorComparator();
        }
        if (this.m_Perspective.m_blegendSectionTitle) {
            layerSection.setTitle(GraphDrawUtils.createSectionTitle(title));
        }
        ArrayList keyList = new ArrayList(keys);
        Collections.sort(keyList, comp);
        for (Object styleKey : keyList) {
            int styleId = dataStyle.getStyleId(styleType, styleKey);
            IdentObj idLegendText = new IdentObj(344, -3, -3, -3, styleId);
            IdentObj idLegendMarker = new IdentObj(343, -3, -3, -3, styleId);
            Object styleValue = dataStyle.getContext(styleType, styleKey).getStyle();
            if (styleValue == null) continue;
            MarkerTemplate markerTemplate = isShape ? DetMarker.getMarkerTemplate((DataStyleType.Shape)((Object)styleValue)) : DetMarker.getMarkerTemplate(dataStyle.getDefaultShape());
            Color fillColor = null;
            Color borderColor = null;
            fillColor = isColor ? (Color)styleValue : dataStyle.getDefaultColor();
            borderColor = fillColor;
            if (this.m_Perspective.m_filteredKeys.contains(String.valueOf(dataStyle.getStyleId(styleType, styleKey)))) {
                fillColor = null;
            }
            ListLegendItem item = GraphDrawUtils.createMarker(markerTemplate, styleKey.toString(), idLegendMarker, idLegendText, fillColor, borderColor);
            item.setLocale(this.m_Perspective.getLocale());
            layerSection.addItem(item);
        }
    }

    public void loadSeriesVectorsSection() {
        ListLegend seriesSection = this.m_Legend.m_legendArea.createListSection();
        if (this.m_Perspective.m_blegendSectionTitle) {
            seriesSection.setTitle(GraphDrawUtils.createSectionTitle("Series Data"));
        }
        boolean bOther = false;
        JChart_2D_Pie chart = null;
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isPieType()) {
            chart = (JChart_2D_Pie)this.m_Chart;
            bOther = chart.getOtherPercentageFlag();
        }
        boolean singleSeries = this.m_Chart.isSingleSeriesOnly();
        boolean bReverseSeries = this.m_Perspective.getReverseSeries();
        boolean bForwardSeries = this.m_Legend.getLegendReverse() == bReverseSeries;
        int nSeriesLooping = this.m_Perspective.getSeriesLooping();
        SeriesEnumerator sEnum = bForwardSeries ? this.m_sEnumForward : this.m_sEnumReverse;
        PfjAssert.pfjAssert(sEnum != null);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            boolean bDrawSeries = this.getDisplayInLegend(nSeries);
            if (chart != null) {
                boolean bl = bDrawSeries = !chart.isSeriesPartOfOther(nSeries);
                if (!this.getDisplayInLegend(nSeries) || gt.isPieType() && !chart.m_Perspective.getLegendZeroSeriesDisplay() && chart.getDataValue(nSeries, 0) != null && chart.getDataValue((int)nSeries, (int)0).m_fValue == 0.0) {
                    bDrawSeries = false;
                }
            }
            if (this.m_Chart.m_gt.isWaterfall() && nSeries == 0 || singleSeries && nSeries != 0 || !bDrawSeries) continue;
            int nSeriesID = nSeries;
            String label = this.m_Perspective.getSeriesLabel(nSeries);
            IdentObj idSeries = new IdentObj(-3, nSeriesID);
            if (this.m_Perspective.getMarkerShapeObj(idSeries) == null) {
                idSeries = new IdentObj(-3, nSeriesID % nSeriesLooping);
            }
            MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
            Color fillColor = null;
            Color borderColor = null;
            boolean bSeriesHidden = this.m_Perspective.getSeriesVisibility(nSeriesID) == 1 || this.m_Perspective.isNoRescaleHiddenSeries(nSeriesID) && !this.m_Perspective.isExportingToXML();
            BlackBoxIF bb = this.m_Perspective.getGraphObject().assignSeriesColor(nSeriesID, false);
            bb = bb.runRules(nSeries, -3);
            if (bSeriesHidden) {
                fillColor = new Color(-1);
                borderColor = bb.getFillColor();
                if (markerTemplate.getMarkerType() == 10) {
                    markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
                }
            } else if (bb.getFillType() == 1) {
                markerTemplate.setLineColor(bb.getFillColor());
            }
            IdentObj idLegendText = new IdentObj(14, nSeriesID);
            IdentObj idLegendMarker = new IdentObj(13, nSeriesID);
            boolean markerWithLine = false;
            String withLine = null;
            if (this.m_Perspective.getCommonGraph().getContext() != null) {
                Object o = this.m_Perspective.getCommonGraph().getContext().get(Perspective.legend_marker_with_line);
                if (o != null) {
                    withLine = (String)o;
                }
            }
            if (this.m_Perspective.getMarkerDisplay() && (withLine == null || withLine.trim().equalsIgnoreCase("true")) && (this.m_Perspective.getJGraphType().isBLAType() || this.m_Perspective.getJGraphType().isRadarType()) && this.m_Perspective.getUseSeriesShapes() == 1 && (this.m_Perspective.getSeriesType(idSeries) == 2 || this.m_Perspective.getBaseRiserType() == 2 && this.m_Perspective.getSeriesType(idSeries) != 1 && this.m_Perspective.getSeriesType(idSeries) != 3)) {
                markerWithLine = true;
            }
            ListLegendItem item = GraphDrawUtils.createMarker(markerTemplate, label, idLegendMarker, idLegendText, fillColor, borderColor, markerWithLine);
            item.setLocale(this.m_Perspective.getLocale());
            seriesSection.addItem(item);
        }
    }

    private int getMarkerLineWidth(int lineWidth) {
        if (this.m_Perspective.getCommonGraph().getContext() != null) {
            Object nLineWidth = this.m_Perspective.getCommonGraph().getContext().get(Perspective.line_width);
            if (nLineWidth != null) {
                return Integer.parseInt((String)nLineWidth);
            }
            return lineWidth;
        }
        return lineWidth;
    }
}

