/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.ArrayList;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Model3DSurface;
import oracle.dss.graph.pfj.model3d.Point3d;

public class JChart_3D_Surf
extends JChart_3D {
    private static final long serialVersionUID = 1L;
    private static final boolean FIRST_RISER_FOR_ID = true;
    static final int FIRST_OFFSET = 100;

    @Override
    public void calcLegend() {
        if (this.m_Legend == null) {
            return;
        }
        if (!this.m_Perspective.isPlotAreaDisplayed(this)) {
            return;
        }
        if (this.m_Legend.isSpectralLegend()) {
            this.m_Legend.setY1Axis(this.m_Y1Axis);
        }
        this.m_Legend.calc();
    }

    @Override
    public void createLegend() {
        if (this.m_nEffColorMode == 3) {
            this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void define3DMatrixObjects() {
        int gFirstRel;
        int sFirstRel;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Point3d[] vertice = new Point3d[6];
        boolean bSides = false;
        boolean bTop = false;
        this.m_objectList = new ArrayList(this.m_nSeries * this.m_nGroups);
        double y0 = this.m_Y1Axis.getBaseCoord();
        for (int i = 0; i < 6; ++i) {
            vertice[i] = new Point3d(0.0, 0.0, 0.0);
        }
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        if (this.m_gt.equals(12)) {
            bTop = true;
        } else if (this.m_gt.equals(13)) {
            bTop = true;
            bSides = true;
        } else if (this.m_gt.equals(14)) {
            bSides = true;
        } else {
            throw new AssertionException("Unknown type of Surface!");
        }
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        if (sEnum.hasMoreElements()) {
            PfjAssert.pfjAssert(sFirst >= 0 && sLast >= 0);
        }
        PfjAssert.pfjAssert((sFirstRel = sEnum.getRelativeSeries(sFirst)) >= 0 && sFirstRel < this.m_nSeries);
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        if (gEnum.hasMoreElements()) {
            PfjAssert.pfjAssert(gFirst >= 0 && gLast >= 0);
        }
        PfjAssert.pfjAssert((gFirstRel = gEnum.getRelativeGroup(gFirst)) >= 0 && gFirstRel < this.m_nGroups);
        double hx = this.m_O2Axis.getCenterCoord(sFirstRel);
        while (sEnum.hasMoreElements()) {
            void var7_19;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (!sEnum.hasMoreElements()) continue;
            int sNext = sEnum.peekAtNextSeries();
            PfjAssert.pfjAssert(sNext >= 0 && sNext < this.m_nTotalSeries);
            int sNextRel = sEnum.getRelativeSeries(sNext);
            PfjAssert.pfjAssert(sNextRel >= 0 && sNextRel < this.m_nSeries);
            double lx = hx;
            hx = this.m_O2Axis.getCenterCoord((int)var7_19);
            double hz = this.m_O1Axis.getCenterCoord(gFirstRel);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                Model3DFlatFace riser;
                void var6_18;
                void var9_21;
                void var10_22;
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                int gNext = gEnum.peekAtNextGroup();
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                int gNextRel = gEnum.getRelativeGroup(gNext);
                PfjAssert.pfjAssert(gNextRel >= 0 && gNextRel < this.m_nGroups);
                double lz = hz;
                hz = this.m_O1Axis.getCenterCoord((int)var10_22);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][var9_21] || !this.m_dataOK[var6_18][g] || !this.m_dataOK[var6_18][var9_21]) continue;
                double y1 = this.m_numYCoords[s][g];
                double y2 = this.m_numYCoords[var6_18][g];
                double y3 = this.m_numYCoords[var6_18][var9_21];
                double y4 = this.m_numYCoords[s][var9_21];
                IdentObj id = new IdentObj(606, s, g);
                vertice[0].x = vertice[3].x = lx;
                vertice[4].x = vertice[5].x = hx;
                vertice[2].x = vertice[5].x;
                vertice[1].x = vertice[5].x;
                vertice[2].z = vertice[5].z = hz;
                vertice[3].z = vertice[4].z = lz;
                vertice[1].z = vertice[4].z;
                vertice[0].z = vertice[4].z;
                vertice[1].y = vertice[2].y = y0;
                vertice[0].y = vertice[2].y;
                vertice[3].y = y1;
                vertice[4].y = y2;
                vertice[5].y = y3;
                if (bTop && bSides && s > sFirst && s < sLast && g > gFirst && g < gLast) {
                    bSides = false;
                }
                if ((riser = this.defineRiserObject(sEnum, gEnum, id, vertice, bGridStatus, true, bTop, bSides, true)) != null) {
                    this.m_objectList.add(riser);
                }
                vertice[1].x = vertice[4].x = lx;
                vertice[1].z = vertice[4].z = hz;
                vertice[4].y = y4;
                riser = this.defineRiserObject(sEnum, gEnum, id, vertice, bGridStatus, false, bTop, bSides);
                if (riser == null) continue;
                this.m_objectList.add(riser);
            }
        }
    }

    public Model3DFlatFace defineRiserObject(SeriesEnumerator sEnum, GroupsEnumerator gEnum, IdentObj id, Point3d[] corner, boolean[][] bGridStatus, boolean bFrontTriangle, boolean bTop, boolean bSides, boolean bFirstRiserForID) {
        IdentObj newID = new IdentObj(id);
        if (bFirstRiserForID) {
            newID.setMiscID(100);
        }
        Model3DSurface riser = new Model3DSurface(this, newID, null, corner, bSides, bTop, sEnum, gEnum, bGridStatus, bFrontTriangle, this.m_bColorAutoshading);
        riser.calcGrids();
        return riser;
    }

    public Model3DFlatFace defineRiserObject(SeriesEnumerator sEnum, GroupsEnumerator gEnum, IdentObj id, Point3d[] corner, boolean[][] bGridStatus, boolean bFrontTriangle, boolean bTop, boolean bSides) {
        return this.defineRiserObject(sEnum, gEnum, id, corner, bGridStatus, bFrontTriangle, bTop, bSides, false);
    }

    @Override
    protected int getYCoordForHeight(int s, int g) {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int yCoord = 0;
        int sNext = sEnum.peekAtSeriesAfter(s);
        int gNext = gEnum.peekAtGroupAfter(g);
        if (this.m_dataOK[s][g]) {
            yCoord = this.m_numYCoords[s][g];
        }
        if (sNext != -1 && this.m_dataOK[sNext][g] && this.m_numYCoords[sNext][g] > yCoord) {
            yCoord = this.m_numYCoords[sNext][g];
        }
        if (gNext != -1 && this.m_dataOK[s][gNext] && this.m_numYCoords[s][gNext] > yCoord) {
            yCoord = this.m_numYCoords[s][gNext];
        }
        if (sNext != -1 && gNext != -1 && this.m_dataOK[sNext][gNext] && this.m_numYCoords[sNext][gNext] > yCoord) {
            yCoord = this.m_numYCoords[sNext][gNext];
        }
        return yCoord;
    }

    @Override
    public boolean wantLegend() {
        return this.m_nEffColorMode == 3;
    }
}

