/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.CircularFrameObj;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.IdentObj;

public abstract class JChart_2D_Circular
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;

    @Override
    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Point ptCoord = new Point(0, 0);
        double fRadius = 0.0;
        double fAngle = 0.0;
        boolean bUseLabels = false;
        String[] dataItemStringArray = new String[nItems];
        String sDataTextTemplate = "";
        boolean bPolar = this.m_gt.isPolar();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        bUseLabels = this.m_bDataTextDisplay;
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseLabels) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if (this.m_bDataTextDisplay && bPolar && bPolar) {
            sDataTextTemplate = this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                this.m_dataOK[s][g] = true;
                boolean bGotAngle = false;
                for (int i = 0; i < nItems; ++i) {
                    RelativeAxisObj axisObj;
                    DataItem item;
                    block16: {
                        item = df.getDataItem(i);
                        axisObj = this.whichAxisForSeries(s, item);
                        if (axisObj == null) continue;
                        try {
                            DatumObj dObj = this.getDataValue(s, g, item);
                            fValue = dObj.m_fValue;
                            if (!dObj.m_bOK) {
                                this.m_dataOK[s][g] = dObj.m_bOK;
                            }
                            if (bUseLabels) {
                                if (bNumberFormatCallBackActive) {
                                    int nAxisID = this.axisAssignedToSeries(s, item);
                                    this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                    dataItemStringArray[i] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                                } else {
                                    dataItemStringArray[i] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fValue, this.m_Perspective.getDataTextFormatPattern());
                                }
                                this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                            }
                            if (this.isBadValueInLogscale(axisObj, fValue)) {
                                this.m_dataOK[s][g] = false;
                            }
                            if (this.isIgnoredOffScale(axisObj, fValue)) {
                                this.m_dataOK[s][g] = false;
                            }
                        }
                        catch (AssertionException e) {
                            if (!item.isRequired()) break block16;
                            this.m_dataOK[s][g] = false;
                        }
                    }
                    if (item.isLabel()) continue;
                    if (item.getAssocAxis() == 0 || item.getAssocAxis() == 1) {
                        fRadius = axisObj.getValueCoord(fValue);
                        continue;
                    }
                    fAngle = axisObj.getValueCoord(fValue);
                }
                if (!bGotAngle && nItems == 1) {
                    fAngle = this.m_O1Axis.getCenterCoord(g);
                }
                Rectangle rFrame = this.m_Perspective.getFrameRect(true);
                Dimension frameDim = new Dimension(rFrame.width, rFrame.height);
                Point frameCenter = new Point(rFrame.x + rFrame.width / 2, rFrame.y + rFrame.height / 2);
                if (!this.m_dataOK[s][g] && this.m_gt.equals(68)) {
                    fRadius = 0.0;
                }
                CircularAxisObj.polarToCartesian(ptCoord, fAngle, fRadius, frameDim, frameCenter, this.m_Perspective.m_VC);
                this.m_numXCoords[s][g] = ptCoord.x;
                this.m_numYCoords[s][g] = ptCoord.y;
            }
        }
    }

    @Override
    public void createFrame() {
        this.m_Frame = new CircularFrameObj(this.m_Perspective);
    }

    @Override
    protected void createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        this.m_O1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, bAscending, 0, 100, false);
    }

    @Override
    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        this.m_X1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bAscending, false, 0, 100, false);
    }

    @Override
    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bAscending, true, nOffset, nSize, true);
    }

    @Override
    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        this.m_Y2Axis = new CircularAxisObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bAscending, true, nOffset, nSize, true);
    }

    protected void drawRisers() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int x0 = 0;
        int y0 = 0;
        int baseCoord = (int)this.m_Y1Axis.getBaseCoord();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            Polygon polygon = new Polygon();
            boolean bFirst = true;
            gEnum.reset();
            if (!gEnum.hasMoreElements()) continue;
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                int x = this.m_numXCoords[s][g];
                int y = this.m_numYCoords[s][g];
                polygon.addPoint(x, y);
                if (!bFirst) continue;
                x0 = x;
                y0 = y;
                bFirst = false;
            }
            polygon.addPoint(x0, y0);
            BlackBoxIF blackBox = this.assignSeriesColor(s, 0);
            blackBox = blackBox.runRules(s, -3);
            new DetPolygon(this.m_Detectiv, new IdentObj(256, s), polygon, blackBox, this.m_rClip);
        }
    }

    @Override
    protected Point getCoords(int s, int g) {
        return new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]);
    }
}

