/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphFont;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ToolTips
extends BaseText {
    protected IdentObj m_identObj2;

    public ToolTips(CommonGraph graph) {
        super(graph);
        this.m_identObj = graph.getPFJ().getToolTip();
        this.m_identObj2 = graph.getPFJ().getToolTipFrame();
        this.m_commonGraph = graph;
        this.m_font = new GraphFont(graph, this.m_identObj);
    }

    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this.getXML(allProperties, true);
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        Color color;
        boolean nodeExists = false;
        ObjectNode node = new ObjectNode(this.getComponentName());
        Color val = this.getBorderColor();
        if (this.getBorderColor() != null) {
            color = val;
            node.addProperty("borderColor", ToolTips.toHexString(color.getRGB()));
            nodeExists = true;
        }
        if ((val = this.getFillColor()) != null) {
            color = val;
            node.addProperty("fillColor", ToolTips.toHexString(color.getRGB()));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Override
    public void setXML(ObjectNode node) {
        this.setXML(node, true);
    }

    protected void setXML(ObjectNode node, boolean allProperties) {
        PropertyNode pNode = node.getProperty("borderColor");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderColor", new Color(ToolTips.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setBorderColor(new Color(ToolTips.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty("fillColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", new Color(ToolTips.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(ToolTips.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextJustHorizObj(this.m_identObj);
        if (val != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    protected void resetStyle() {
        super.resetStyle();
        this.setBorderColor(this.m_pfj.getBorderColor(this.m_identObj2));
        this.setFillColor(this.m_pfj.getFillColor(this.m_identObj2));
        this.getGraphFont().setGraphFontColor(this.m_pfj.getFillColor(this.m_identObj));
        this.getGraphFont().setGraphFontSize(this.m_pfj.getFontSize(this.m_identObj));
        this.getGraphFont().setGraphFontTypeface(this.m_pfj.getFontName(this.m_identObj));
        this.getGraphFont().setGraphFontStyle(this.m_pfj.getFontStyle(this.m_identObj));
        this.getGraphFont().setGraphProportionalFontSize(this.m_pfj.getFontSizeVC(this.m_identObj));
        this.setHorizontalAlignment(this.m_pfj.getTextJustHoriz(this.m_identObj));
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("horizontalAlignment");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("horizontalAlignment", new Integer(ToolTips.convertHorizontalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this.setHorizontalAlignment(ToolTips.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj2);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj2, newColor);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj2);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj2, newColor);
    }

    @Override
    protected String getComponentName() {
        return "ToolTips";
    }
}

