/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dss.dataView.UISeriesColor;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Series
extends BaseGraphComponent
implements UISeriesColor {
    protected int m_startSeries = 0;
    protected int m_seriesCount;
    protected SFX[] m_sfx;
    protected boolean m_isMarkerShapeSet = false;
    private int m_numSeries = 0;

    public Series(CommonGraph graph) {
        super(graph);
        this.m_sfx = new SFX[graph.getSeriesObjectCount()];
        this.m_seriesCount = this.m_pfj.getSeriesLooping();
    }

    private int _getNumberOfSeries() {
        int series = this.m_pfj.getSeriesLooping();
        try {
            int seriesCount;
            int n = seriesCount = this.m_commonGraph.isDataRowShownAsASeries() ? this.m_commonGraph.getRowCount() : this.m_commonGraph.getColumnCount();
            if (seriesCount > series) {
                series = seriesCount;
            }
        }
        catch (EdgeOutOfRangeException eor) {
            this.m_commonGraph.getErrorHandler().log(" edge is out of range ", this.getClass().getName(), "_getNumberOfSeries()");
        }
        this.m_seriesCount = series;
        return series;
    }

    private int _getLineType(int markerType) {
        int type = 0;
        switch (markerType) {
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                type = 2;
                break;
            }
            case 6: {
                type = 3;
            }
        }
        return type;
    }

    private int _getMarkerType(int lineType) {
        int type = 2;
        switch (lineType) {
            case 1: {
                type = 4;
                break;
            }
            case 2: {
                type = 5;
                break;
            }
            case 3: {
                type = 6;
            }
        }
        return type;
    }

    private IdentObj _getID(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getSeries(series);
    }

    private IdentObj _getMarkerID(int series) throws SeriesOutOfRangeException {
        return new IdentObj(259, series);
    }

    private IdentObj _getFitlineID(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getCurveFitLineRiser(series);
    }

    void clearSFX() {
        this.m_sfx = new SFX[this.m_commonGraph.getSeriesObjectCount()];
    }

    public SFX getSFX(int series) throws SeriesOutOfRangeException {
        SFX sfx;
        if (this.m_commonGraph.getSeriesEffect() == 1) {
            this.m_commonGraph.getErrorHandler().log("Can't use SFX when SeriesEffect equals SE_GRADIENT", this.getClass().toString(), "getSFX( int series )");
            this.m_sfx = null;
            return null;
        }
        if (series >= this.m_sfx.length) {
            SFX[] oldSFX = this.m_sfx;
            this.m_sfx = new SFX[series + 1];
            System.arraycopy(oldSFX, 0, this.m_sfx, 0, oldSFX.length);
        }
        if ((sfx = this.m_sfx[series]) == null) {
            this.m_sfx[series] = new SFX(this.m_commonGraph, this._getID(series), this._getFitlineID(series));
            sfx = this.m_sfx[series];
        }
        return sfx;
    }

    public boolean isAssignedToY2(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getAxisAssignment(this._getID(series)) == 1;
    }

    public void setAssignedToY2(boolean yesNo, int series) throws SeriesOutOfRangeException {
        IdentObj id = this._getID(series);
        if (yesNo) {
            this.m_pfj.setAxisAssignment(id, 1);
        } else {
            this.m_pfj.setAxisAssignment(id, 0);
        }
        this.m_pfj.setHighWaterMark(series);
    }

    public Color getBorderColor(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getBorderColor(this._getID(series));
    }

    public void setBorderColor(Color newColor, int series) throws SeriesOutOfRangeException {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this._getID(series), newColor);
        this.m_pfj.setHighWaterMark(series);
    }

    public boolean isBorderTransparent(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getTransparentBorderColor(this._getID(series));
    }

    public void setBorderTransparent(boolean yesNo, int series) throws SeriesOutOfRangeException {
        this.m_pfj.setTransparentBorderColor(this._getID(series), yesNo);
        this.m_pfj.setHighWaterMark(series);
    }

    @Override
    public Color getColor(int series) throws SeriesOutOfRangeException {
        if (!this.isTransparent(series)) {
            return this.m_pfj.getFillColor(this._getID(series));
        }
        return null;
    }

    @Override
    public void setColor(Color newColor, int series) throws SeriesOutOfRangeException {
        if (newColor == null) {
            this.setTransparent(true, series);
            return;
        }
        this.m_pfj.setFillColor(this._getID(series), newColor);
        this.m_pfj.setFillColor(this._getFitlineID(series), newColor);
        this.m_pfj.setHighWaterMark(series);
        this.m_pfj.setNoXMLMode(true);
        this.m_pfj.setFillColor(this._getMarkerID(series), newColor);
        this.m_pfj.setNoXMLMode(false);
    }

    public Color getMarkerColor(int series) throws SeriesOutOfRangeException {
        if (!this.isTransparent(series)) {
            return this.m_pfj.getFillColor(this._getMarkerID(series));
        }
        return null;
    }

    public void setMarkerColor(Color newColor, int series) throws SeriesOutOfRangeException {
        if (newColor == null) {
            this.setTransparent(true, series);
            return;
        }
        this.m_pfj.setFillColor(this._getMarkerID(series), newColor);
        this.m_pfj.setHighWaterMark(series);
    }

    public Color getDefaultBorderColor() {
        return this.m_pfj.getSeriesDefaultBorderColor();
    }

    public void setDefaultBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setDefaultBorderColor( Color newColor )");
            return;
        }
        this.m_pfj.setSeriesDefaultBorderColor(newColor);
    }

    public boolean isDefaultBorderTransparent() {
        return this.m_pfj.getSeriesDefaultTransparentBorderColor();
    }

    public void setDefaultBorderTransparent(boolean yesNo) {
        this.m_pfj.setSeriesDefaultTransparentBorderColor(yesNo);
    }

    public void setFitlineType(int type, int series) throws SeriesOutOfRangeException {
        if (type < 0 || type > 8) {
            this.m_commonGraph.getErrorHandler().log("invalid fit line type", this.getClass().getName(), "setFitlineType (int type, int series)");
            return;
        }
        this.m_pfj.setCurveFitType(series, type);
        this.m_pfj.setHighWaterMark(series);
    }

    public int getFitlineType(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getCurveFitType(series);
    }

    public int getLineWidth(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getLineWidth(this._getID(series));
    }

    public void setLineWidth(int width, int series) throws SeriesOutOfRangeException {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width, int series)");
        } else {
            this.m_pfj.setLineWidth(this._getID(series), width);
            this.m_pfj.setHighWaterMark(series);
        }
    }

    public void setLineStyle(int style, int iSeries) throws SeriesOutOfRangeException {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style, int series)");
        } else {
            this.m_pfj.setLineStyle(this._getID(iSeries), style);
            this.m_pfj.setHighWaterMark(iSeries);
        }
    }

    public int getLineStyle(int iSeries) throws SeriesOutOfRangeException {
        return this.m_pfj.getLineStyle(this._getID(iSeries));
    }

    public int getMarkerShape(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getMarkerShape(this._getID(series));
    }

    public void setMarkerShape(int shape, int series) throws SeriesOutOfRangeException {
        this.m_pfj.setUseDefaultBubbleMarker(this._getID(series), shape == -1);
        this.m_pfj.setMarkerShape(this._getID(series), shape);
        this.m_isMarkerShapeSet = true;
        this.m_pfj.setHighWaterMark(series);
    }

    public void setShape(String shape, int series) throws SeriesOutOfRangeException {
        if (BaseGraphComponent.CONV_MAP.containsKey(shape)) {
            int iShape = BaseGraphComponent.CONV_MAP.get(shape);
            boolean isOverridden = this.m_pfj.getOverrideMap().containsKey(iShape);
            if (!isOverridden) {
                this.setMarkerShape(iShape, series);
            } else {
                this.setMarkerShape(12, series);
                String path = this.m_pfj.getOverrideMap().get(iShape);
                this.setShapePath(path, series);
            }
        } else {
            this.setMarkerShape(12, series);
        }
    }

    public void setShapePath(String path, int series) throws SeriesOutOfRangeException {
        this.setMarkerShape(12, series);
        this.m_pfj.setShapePath(this._getID(series), path);
    }

    public int getMarkerType(int series) throws SeriesOutOfRangeException {
        int type = this.m_pfj.getSeriesType(this._getID(series));
        if (type == 2 && this.m_pfj.getLineType(this._getID(series)) != 0) {
            type = this._getMarkerType(this.m_pfj.getLineType(this._getID(series)));
        }
        return type;
    }

    public void setMarkerType(int type, int series) throws SeriesOutOfRangeException {
        if (type < 0 || type > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid marker type", this.getClass().getName(), "setMarkerType (int type, int series)");
        } else {
            this.m_pfj.setLineType(this._getID(series), this._getLineType(type));
            switch (type) {
                case 4: 
                case 5: 
                case 6: {
                    type = 2;
                }
            }
            this.m_pfj.setSeriesType(this._getID(series), type);
            this.m_pfj.setHighWaterMark(series);
            if (type == 2) {
                this.m_commonGraph.setMarkerShapeInLegend(1);
                if (this.m_commonGraph.getSeriesEffect() != 0) {
                    this.m_pfj.setSeriesGradientEffect(series, 0);
                }
            } else {
                int seriesEffect;
                if (type == 0) {
                    this.m_commonGraph.setMarkerShapeInLegend(0);
                }
                if ((seriesEffect = this.m_commonGraph.getSeriesEffect()) != 0 && seriesEffect != 3) {
                    this.m_pfj.setSeriesGradientEffect(series, this.m_commonGraph.getSeriesEffect());
                }
            }
        }
    }

    public int getPieSliceExplode(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getPieSliceDetach(this._getID(series));
    }

    public void setPieSliceExplode(int explode, int series) throws SeriesOutOfRangeException {
        if (explode < 0 || explode > 100) {
            this.m_commonGraph.getErrorHandler().log("invalid pie slice explode", this.getClass().getName(), "setPieSliceExplode (int explode, int series)");
        } else {
            this.m_pfj.setPieSliceDetach(this._getID(series), explode);
            this.m_pfj.setHighWaterMark(series);
        }
    }

    public boolean isTransparent(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getTransparentFillColor(this._getID(series));
    }

    public void setTransparent(boolean yesNo, int series) throws SeriesOutOfRangeException {
        this.m_pfj.setTransparentFillColor(this._getID(series), yesNo);
        this.m_pfj.setTransparentFillColor(this._getMarkerID(series), yesNo);
        this.m_pfj.setTransparentFillColor(this._getFitlineID(series), yesNo);
        this.m_pfj.setHighWaterMark(series);
    }

    public boolean isBorderUsingDefaults() {
        return this.m_pfj.getUseSeriesBorderDefaults();
    }

    public void setBorderUsingDefaults(boolean yesNo) {
        this.m_pfj.setUseSeriesBorderDefaults(yesNo);
    }

    public void setDefaultColor(Color color) {
        boolean noXMLMode = this.m_pfj.isNoXMLMode();
        this.m_pfj.setNoXMLMode(true);
        if (color == null) {
            int i2;
            try {
                for (i2 = this.m_startSeries; i2 < this._getNumberOfSeries(); ++i2) {
                    if (!this.isTransparent(i2)) continue;
                    this.setTransparent(false, i2);
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            this.m_pfj.removeSeriesColors(0, this._getNumberOfSeries());
            if (this.m_commonGraph.getSeriesEffect() != 0) {
                for (i2 = 0; i2 < this.m_pfj.getSeriesLooping(); ++i2) {
                    this.m_pfj.setSeriesGradientEffect(this.m_pfj.getSeries(i2).getSeriesID(), this.m_commonGraph.getSeriesEffect());
                }
            }
        } else {
            for (int i = 0; i < this.m_pfj.getSeriesLooping(); ++i) {
                this.m_pfj.setFillColor(this.m_pfj.getSeries(i), color);
                this.m_pfj.setFillColor(this.m_pfj.getCurveFitLineRiser(i), color);
            }
        }
        this.m_pfj.setNoXMLMode(noXMLMode);
        this.m_pfj.setObjProp(color, Attr.DefaultColor);
    }

    public Color getDefaultColor() {
        return (Color)this.m_pfj.getObjProp(Attr.DefaultColor);
    }

    public void setDefaultMarkerColor(Color color) {
        boolean noXMLMode = this.m_pfj.isNoXMLMode();
        this.m_pfj.setNoXMLMode(true);
        if (color == null) {
            try {
                for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                    if (!this.isTransparent(i)) continue;
                    this.setTransparent(false, i);
                }
            }
            catch (Exception i) {}
        } else {
            for (int i = 0; i < this.m_pfj.getSeriesLooping(); ++i) {
                this.m_pfj.setFillColor(new IdentObj(259, i), color);
            }
        }
        this.m_pfj.setNoXMLMode(noXMLMode);
        this.m_pfj.setObjProp(color, Attr.DefaultMarkerColor);
    }

    public Color getDefaultMarkerColor() {
        return (Color)this.m_pfj.getObjProp(Attr.DefaultMarkerColor);
    }

    public void setDefaultMarkerType(int markerType) {
        if (markerType < 0 || markerType > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid marker type", this.getClass().getName(), "setMarkerType (int type, int series)");
            return;
        }
        this.m_pfj.setIntegerProp(markerType, Attr.DefaultMarkerType);
        this.m_pfj.setNoXMLMode(true);
        if (markerType == 2 || markerType >= 4 && markerType <= 6) {
            this.m_commonGraph.setMarkerShapeInLegend(1);
            for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                this.m_pfj.setLineType(this.m_pfj.getSeries(i), this._getLineType(markerType));
                this.m_pfj.setSeriesType(this.m_pfj.getSeries(i), 2);
                if (this.m_commonGraph.getSeriesEffect() == 0) continue;
                this.m_pfj.setSeriesGradientEffect(i, 0);
            }
        } else {
            if (markerType == 0) {
                this.m_commonGraph.setMarkerShapeInLegend(0);
            }
            int seriesEffect = this.m_commonGraph.getSeriesEffect();
            for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                this.m_pfj.setSeriesType(this.m_pfj.getSeries(i), markerType);
                if (seriesEffect == 0 || seriesEffect == 3) continue;
                this.m_pfj.setSeriesGradientEffect(i, this.m_commonGraph.getSeriesEffect());
            }
        }
        this.m_pfj.setNoXMLMode(false);
    }

    public int getDefaultMarkerType() {
        return this.m_pfj.getIntegerProp(Attr.DefaultMarkerType);
    }

    public void setDefaultMarkerShape(int markerShape) {
        int i;
        if (markerShape < -1 || markerShape > 7) {
            this.m_commonGraph.getErrorHandler().log("invalid marker shape", this.getClass().getName(), "setDefaultMarkerShape(int markerShape)");
            return;
        }
        this.m_pfj.setNoXMLMode(true);
        for (i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
            this.m_pfj.setUseDefaultBubbleMarker(this.m_pfj.getSeries(i), markerShape == -1);
        }
        if (markerShape == 0) {
            this.m_pfj.removeMarkerShapes(0, this._getNumberOfSeries() - 1);
        } else if (markerShape == -1) {
            this.m_pfj.loopMarkerShapes(0, this._getNumberOfSeries() - 1);
        } else {
            for (i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                this.m_pfj.setMarkerShape(this.m_pfj.getSeries(i), markerShape);
            }
        }
        this.m_pfj.setNoXMLMode(false);
        this.m_pfj.setIntegerProp(markerShape, Attr.DefaultMarkerShape);
        this.m_isMarkerShapeSet = true;
    }

    public int getDefaultMarkerShape() {
        return this.m_pfj.getIntegerProp(Attr.DefaultMarkerShape);
    }

    public void setDefaultLineWidth(int lineWidth) {
        this.m_pfj.removeLineWidths(this.m_startSeries, this._getNumberOfSeries());
        boolean noXMLMode = this.m_pfj.isNoXMLMode();
        this.m_pfj.setNoXMLMode(true);
        for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
            this.m_pfj.setLineWidth(this.m_pfj.getSeries(i), lineWidth);
        }
        this.m_pfj.setNoXMLMode(noXMLMode);
        this.m_pfj.setIntegerProp(lineWidth, Attr.DefaultLineWidth);
    }

    public int getDefaultLineWidth() {
        return this.m_pfj.getIntegerProp(Attr.DefaultLineWidth);
    }

    public int getDefaultLineStyle() {
        return this.m_pfj.getIntegerProp(Attr.LineStyle);
    }

    public void setDefaultAssignedToY2(int assignedToY2) {
        if (assignedToY2 < 0 || assignedToY2 > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid value for AssignedToY2", this.getClass().getName(), "setDefaultAssignedToY2(int assignedToY2)");
            return;
        }
        this.m_pfj.setNoXMLMode(true);
        if (assignedToY2 == 2) {
            for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                if (i == 1) {
                    this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(i), 1);
                    continue;
                }
                this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(i), 0);
            }
        } else {
            int assignment = assignedToY2 == 1 ? 1 : 0;
            for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
                this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(i), assignment);
            }
        }
        this.m_pfj.setNoXMLMode(false);
        this.m_pfj.setIntegerProp(assignedToY2, Attr.DefaultAssignedToY2);
    }

    public int getDefaultAssignedToY2() {
        return this.m_pfj.getIntegerProp(Attr.DefaultAssignedToY2);
    }

    public void setDefaultFitlineType(int type) {
        if (type < 0 || type > 8) {
            this.m_commonGraph.getErrorHandler().log("invalid fit line type", this.getClass().getName(), "setDefaultFitlineType(int type)");
            return;
        }
        this.m_pfj.setNoXMLMode(true);
        for (int i = this.m_startSeries; i < this._getNumberOfSeries(); ++i) {
            this.m_pfj.setCurveFitType(this.m_pfj.getSeries(i), type);
        }
        this.m_pfj.setNoXMLMode(false);
        this.m_pfj.setIntegerProp(type, Attr.DefaultFitlineType);
    }

    public int getDefaultFitlineType() {
        return this.m_pfj.getIntegerProp(Attr.DefaultFitlineType);
    }

    public void setDisplayInLegend(String display, int series) {
        if ("off".equals(display)) {
            this.m_pfj.setDisplayInLegend(false, series);
        } else {
            this.m_pfj.setDisplayInLegend(true, series);
        }
    }

    public String getDisplayInLegend(int series) {
        if (this.m_pfj.getDisplayInLegend(series)) {
            return "on";
        }
        return "off";
    }

    @Deprecated
    public void setDefaultFirstMarkerColor(Color color) {
        this.m_pfj.setDefaultMarkerColor(GraphConstants.Markers.FIRST, color);
    }

    @Deprecated
    public Color getDefaultFirstMarkerColor() {
        return this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.FIRST);
    }

    @Deprecated
    public void setDefaultLastMarkerColor(Color color) {
        this.m_pfj.setDefaultMarkerColor(GraphConstants.Markers.LAST, color);
    }

    @Deprecated
    public Color getDefaultLastMarkerColor() {
        return this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.LAST);
    }

    @Deprecated
    public void setDefaultHighMarkerColor(Color color) {
        this.m_pfj.setDefaultMarkerColor(GraphConstants.Markers.HIGH, color);
    }

    @Deprecated
    public Color getDefaultHighMarkerColor() {
        return this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.HIGH);
    }

    @Deprecated
    public void setDefaultLowMarkerColor(Color color) {
        this.m_pfj.setDefaultMarkerColor(GraphConstants.Markers.LOW, color);
    }

    @Deprecated
    public Color getDefaultLowMarkerColor() {
        return this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.LOW);
    }

    @Deprecated
    public void setDefaultMarkers(EnumSet<GraphConstants.Markers> markers) {
        this.m_pfj.setDefaultMarkers(markers);
    }

    @Deprecated
    public EnumSet<GraphConstants.Markers> getDefaultMarkers() {
        return this.m_pfj.getDefaultMarkers();
    }

    public void setVisibility(int visibility, int series) throws SeriesOutOfRangeException {
        if (visibility < 0 || visibility > 1) {
            this.m_commonGraph.getErrorHandler().log("invalid series visibility", this.getClass().getName(), "setVisibility(int visibility, int series)");
        } else {
            this.m_pfj.setSeriesVisibility(series, visibility);
            this.m_pfj.setHighWaterMark(series);
        }
    }

    public int getVisibility(int series) throws SeriesOutOfRangeException {
        if (this.m_pfj.getIntegerProp(Attr.HideAndShowBehavior) != 2) {
            return this.m_pfj.getSeriesVisibility(series);
        }
        return this.m_pfj.isNoRescaleHiddenSeries(series) ? 1 : 0;
    }

    public void setEffect(int effect, int series) throws SeriesOutOfRangeException {
        this.m_pfj.setEffect(this._getID(series), effect);
    }

    public int getEffect(int series) throws SeriesOutOfRangeException {
        return this.m_pfj.getEffect(this._getID(series));
    }

    public static int convertMarkerShapeToInt(String string) {
        if (string.equals("MS_NONE")) {
            return 0;
        }
        if (string.equals("MS_CIRCLE")) {
            return 2;
        }
        if (string.equals("MS_DIAMOND")) {
            return 3;
        }
        if (string.equals("MS_PLUS")) {
            return 4;
        }
        if (string.equals("MS_SQUARE")) {
            return 1;
        }
        if (string.equals("MS_TRIANGLE_DOWN")) {
            return 5;
        }
        if (string.equals("MS_TRIANGLE_UP")) {
            return 6;
        }
        if (string.equals("MS_HUMAN")) {
            return 7;
        }
        return -1;
    }

    public static int convertMarkerTypeToInt(String string) {
        if (string.equals("MT_DEFAULT")) {
            return 0;
        }
        if (string.equals("MT_BAR")) {
            return 1;
        }
        if (string.equals("MT_MARKER") || string.equals("MT_LINE")) {
            return 2;
        }
        if (string.equals("MT_AREA")) {
            return 3;
        }
        if (string.equals("MT_CURVE_LINE")) {
            return 4;
        }
        if (string.equals("MT_STEPPED_LINE")) {
            return 5;
        }
        if (string.equals("MT_CENTERED_STEPPED_LINE")) {
            return 6;
        }
        return -1;
    }

    public static int convertFitlineTypeToInt(String string) {
        int fitlineType = 0;
        if (string.equals("FT_NONE")) {
            fitlineType = 0;
        } else if (string.equals("FT_LINEAR")) {
            fitlineType = 1;
        } else if (string.equals("FT_LOGARITHMIC")) {
            fitlineType = 5;
        } else if (string.equals("FT_EXPONENTIAL")) {
            fitlineType = 8;
        }
        return fitlineType;
    }

    public static int convertAssignedToY2ToInt(String string) {
        if (string.equals("DY2_AUTO_ASSIGN")) {
            return 2;
        }
        if (string.equals("DY2_TRUE")) {
            return 1;
        }
        if (string.equals("DY2_FALSE")) {
            return 0;
        }
        return 2;
    }

    public static String convertMarkerShapeToString(int value) {
        String mShape = "MS_AUTOMATIC";
        switch (value) {
            case -1: {
                mShape = "MS_AUTOMATIC";
                break;
            }
            case 0: {
                mShape = "MS_NONE";
                break;
            }
            case 2: {
                mShape = "MS_CIRCLE";
                break;
            }
            case 3: {
                mShape = "MS_DIAMOND";
                break;
            }
            case 4: {
                mShape = "MS_PLUS";
                break;
            }
            case 1: {
                mShape = "MS_SQUARE";
                break;
            }
            case 5: {
                mShape = "MS_TRIANGLE_DOWN";
                break;
            }
            case 6: {
                mShape = "MS_TRIANGLE_UP";
                break;
            }
            case 7: {
                mShape = "MS_HUMAN";
            }
        }
        return mShape;
    }

    protected String convertMarkerTypeToString(int value) {
        String mType = "MT_DEFAULT";
        switch (value) {
            case 0: {
                mType = "MT_DEFAULT";
                break;
            }
            case 1: {
                mType = "MT_BAR";
                break;
            }
            case 2: {
                mType = "MT_LINE";
                break;
            }
            case 3: {
                mType = "MT_AREA";
                break;
            }
            case 4: {
                mType = "MT_CURVE_LINE";
                break;
            }
            case 5: {
                mType = "MT_STEPPED_LINE";
                break;
            }
            case 6: {
                mType = "MT_CENTERED_STEPPED_LINE";
            }
        }
        return mType;
    }

    protected String convertFitlineTypeToString(int value) {
        String fType = "FT_NONE";
        switch (value) {
            case 0: {
                fType = "FT_NONE";
                break;
            }
            case 1: {
                fType = "FT_LINEAR";
                break;
            }
            case 5: {
                fType = "FT_LOGARITHMIC";
                break;
            }
            case 8: {
                fType = "FT_EXPONENTIAL";
            }
        }
        return fType;
    }

    protected String convertAssignedToY2ToString(int value) {
        String dy2 = "DY2_AUTO_ASSIGN";
        switch (value) {
            case 2: {
                dy2 = "DY2_AUTO_ASSIGN";
                break;
            }
            case 1: {
                dy2 = "DY2_TRUE";
                break;
            }
            case 0: {
                dy2 = "DY2_FALSE";
            }
        }
        return dy2;
    }

    public static int convertVisibilityToInt(String string) {
        if (string.equals("SV_VISIBLE")) {
            return 0;
        }
        if (string.equals("SV_HIDDEN")) {
            return 1;
        }
        return -1;
    }

    protected String convertVisibilityToString(int value) {
        String sv = "SV_VISIBLE";
        switch (value) {
            case 0: {
                sv = "SV_VISIBLE";
                break;
            }
            case 1: {
                sv = "SV_HIDDEN";
            }
        }
        return sv;
    }

    @Override
    protected String getComponentName() {
        return "SeriesItems";
    }

    protected ContainerNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode node = new ContainerNode(this.getComponentName());
        boolean nodeExists = this.getSeriesItemsXML(allProperties, allOverriddenProperties, node);
        int[] highW = this.m_pfj.getHighWaterMark();
        int count = this.m_pfj.getSeriesLooping();
        for (int i = 0; i < highW.length; ++i) {
            if (i >= count && highW[i] != 1) continue;
            ObjectNode seriesNode = new ObjectNode("Series");
            seriesNode.addProperty("id", i);
            if (!this.getSeriesXML(allProperties, allOverriddenProperties, seriesNode, i)) continue;
            node.addContainedObject((BaseNode)seriesNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected boolean getSeriesItemsXML(boolean allProperties, boolean allOverriddenProperties, ContainerNode node) {
        boolean styleOverridden = false;
        Object val = this.getDefaultBorderColor();
        if (val != null) {
            node.addProperty("defaultBorderColor", Series.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.SeriesDefaultTransparentBorderColor)) != null) {
            node.addProperty("defaultBorderTransparent", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.UseSeriesBorderDefaults)) != null) {
            node.addProperty("borderUsingDefaults", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        val = this.m_pfj.getObjProp(Attr.DefaultColor);
        if (allProperties || val != null) {
            if (this.getDefaultColor() == null) {
                node.addProperty("defaultColor", "");
            } else {
                node.addProperty("defaultColor", Series.toHexString(((Color)val).getRGB()));
            }
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DefaultMarkerColor)) != null) {
            if (this.getDefaultMarkerColor() == null) {
                node.addProperty("defaultMarkerColor", "");
            } else {
                node.addProperty("defaultMarkerColor", Series.toHexString(((Color)val).getRGB()));
            }
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.FIRST, false)) != null) {
            node.addProperty("defaultFirstMarkerColor", Series.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.LAST, false)) != null) {
            node.addProperty("defaultLastMarkerColor", Series.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.HIGH, false)) != null) {
            node.addProperty("defaultHighMarkerColor", Series.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDefaultMarkerColor(GraphConstants.Markers.LOW, false)) != null) {
            node.addProperty("defaultLowMarkerColor", Series.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.Markers)) != null) {
            EnumSet enumSet = (EnumSet)val;
            node.addProperty("defaultMarkers", GraphConstants.Markers.convertEnumSetToString(enumSet));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DefaultMarkerShape)) != null) {
            node.addProperty("defaultMarkerShape", Series.convertMarkerShapeToString((Integer)val));
            styleOverridden = true;
        }
        val = this.m_pfj.getObjProp(Attr.DefaultMarkerType);
        if (allOverriddenProperties && val != null) {
            node.addProperty("defaultMarkerType", this.convertMarkerTypeToString((Integer)val));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DefaultLineWidth)) != null) {
            node.addProperty("defaultLineWidth", ((Integer)val).intValue());
            styleOverridden = true;
        }
        val = this.m_pfj.getObjProp(Attr.DefaultAssignedToY2);
        if (allOverriddenProperties && val != null) {
            node.addProperty("defaultAssignedToY2", this.convertAssignedToY2ToString((Integer)val));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.DefaultFitlineType)) != null) {
            node.addProperty("defaultFitlineType", this.convertFitlineTypeToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    protected boolean getSeriesXML(boolean allProperties, boolean allOverriddenProperties, ObjectNode seriesNode, int i) {
        boolean styleOverridden = false;
        try {
            int effect;
            ContainerNode sfxNode;
            if (this.m_commonGraph.getSeriesEffect() != 1 && (sfxNode = this.getSFX(i).getXML(allProperties, allOverriddenProperties)) != null) {
                seriesNode.addContainer(sfxNode);
                styleOverridden = true;
            }
            Object val = this.m_pfj.getSeriesTypeObj(this._getID(i));
            if (allOverriddenProperties && val != null) {
                int intVal = (Integer)val;
                if (intVal == 2) {
                    int lineval = this.m_pfj.getLineType(this._getID(i));
                    intVal = this._getMarkerType(lineval);
                }
                seriesNode.addProperty("markerType", this.convertMarkerTypeToString(intVal));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getMarkerShapeObj(this._getID(i))) != null) {
                seriesNode.addProperty("markerShape", Series.convertMarkerShapeToString((Integer)val));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getLineWidthObj(this._getID(i))) != null) {
                seriesNode.addProperty("lineWidth", ((Integer)val).intValue());
                styleOverridden = true;
            }
            val = this.m_pfj.getAxisAssignmentObj(this._getID(i));
            if (allOverriddenProperties && val != null) {
                seriesNode.addProperty("assignedToY2", (Integer)val == 1);
            }
            if ((val = this.m_pfj.getFillColor(this._getID(i))) != null) {
                seriesNode.addProperty("color", Series.toHexString(((Color)val).getRGB()));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getFillColor(this._getMarkerID(i))) != null) {
                seriesNode.addProperty("markerColor", Series.toHexString(((Color)val).getRGB()));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getBorderColor(this._getID(i))) != null) {
                seriesNode.addProperty("borderColor", Series.toHexString(((Color)val).getRGB()));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getTransparentBorderColorObj(this._getID(i))) != null) {
                seriesNode.addProperty("borderTransparent", ((Boolean)val).booleanValue());
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getCurveFitTypeObj(this._getID(i))) != null) {
                seriesNode.addProperty("fitlineType", this.convertFitlineTypeToString((Integer)val));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getPieSliceDetachObj(this._getID(i))) != null) {
                seriesNode.addProperty("pieSliceExplode", ((Integer)val).intValue());
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getTransparentFillColorObj(this._getID(i))) != null) {
                seriesNode.addProperty("transparent", ((Boolean)val).booleanValue());
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getLineStyleObj(this._getID(i))) != null) {
                seriesNode.addProperty("lineStyle", Series.convertLineStyleToString((Integer)val));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getSeriesVisibilityObj(i)) != null) {
                seriesNode.addProperty("visibility", this.convertVisibilityToString((Integer)val));
                styleOverridden = true;
            }
            if ((val = this.m_pfj.getShapePath(this._getID(i))) != null) {
                seriesNode.addProperty("shapePath", val.toString());
                styleOverridden = true;
            }
            if ((effect = this.m_pfj.getEffect(this._getID(i))) != -1) {
                if (effect == 0) {
                    seriesNode.addProperty("effect", "SE_NONE");
                } else {
                    seriesNode.addProperty("effect", "SE_GRADIENT");
                }
                styleOverridden = true;
            }
            if ((val = Boolean.valueOf(this.m_pfj.getDisplayInLegend(i))) != null && "false".equals(val)) {
                seriesNode.addProperty("displayInLegend", val.toString());
                styleOverridden = true;
            }
        }
        catch (SeriesOutOfRangeException sore) {
            this.m_commonGraph.getErrorHandler().log(" series is out of range ", this.getClass().getName(), "getSeriesStyleXML(boolean allProperties, ObjectNode seriesNode, int i)");
        }
        return styleOverridden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXML(ContainerNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    protected void setXML(ContainerNode node, boolean allProperties) {
        this.setSeriesItemsXML(node);
        Enumeration e = node.getContainedObject();
        while (e.hasMoreElements()) {
            ObjectNode seriesNode = (ObjectNode)e.nextElement();
            PropertyNode sNode = seriesNode.getProperty("id");
            if (sNode == null) continue;
            int series = sNode.getValueAsInteger();
            HashMap map = new HashMap();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(new Integer(series), map);
            }
            this.setSeriesXML(seriesNode, series, allProperties, map);
        }
    }

    protected void setSeriesItemsXML(ContainerNode node) {
        Color c;
        PropertyNode pNode = node.getProperty("defaultBorderColor");
        if (pNode != null) {
            this.setDefaultBorderColor(new Color(Series.hexStringToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("defaultBorderTransparent")) != null) {
            this.setDefaultBorderTransparent(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("borderUsingDefaults")) != null) {
            this.setBorderUsingDefaults(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("defaultColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultColor", c);
            } else {
                this.setDefaultColor(c);
            }
        }
        if ((pNode = node.getProperty("defaultMarkerColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultMarkerColor", c);
            } else {
                this.setDefaultMarkerColor(c);
            }
        }
        if ((pNode = node.getProperty("defaultMarkerShape")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultMarkerShape", new Integer(Series.convertMarkerShapeToInt(pNode.getValueAsString())));
            } else {
                this.setDefaultMarkerShape(Series.convertMarkerShapeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("defaultMarkerType")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultMarkerType", new Integer(Series.convertMarkerTypeToInt(pNode.getValueAsString())));
            } else {
                this.setDefaultMarkerType(Series.convertMarkerTypeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("defaultLineWidth")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultLineWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setDefaultLineWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("defaultAssignedToY2")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultAssignedToY2", new Integer(Series.convertAssignedToY2ToInt(pNode.getValueAsString())));
            } else {
                this.setDefaultAssignedToY2(Series.convertAssignedToY2ToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("defaultFitlineType")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultFitlineType", new Integer(Series.convertFitlineTypeToInt(pNode.getValueAsString())));
            } else {
                this.setDefaultFitlineType(Series.convertFitlineTypeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("defaultMarkers")) != null) {
            String markers = pNode.getValueAsString();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultMarkers", markers.toLowerCase());
            } else {
                this.setDefaultMarkers(GraphConstants.Markers.convertStringToEnumSet(markers));
            }
        }
        if ((pNode = node.getProperty("defaultFirstMarkerColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultFirstMarkerColor", c);
            } else {
                this.setDefaultFirstMarkerColor(c);
            }
        }
        if ((pNode = node.getProperty("defaultLastMarkerColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultLastMarkerColor", c);
            } else {
                this.setDefaultLastMarkerColor(c);
            }
        }
        if ((pNode = node.getProperty("defaultHighMarkerColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultHighMarkerColor", c);
            } else {
                this.setDefaultHighMarkerColor(c);
            }
        }
        if ((pNode = node.getProperty("defaultLowMarkerColor")) != null) {
            c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Series.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("defaultLowMarkerColor", c);
            } else {
                this.setDefaultLowMarkerColor(c);
            }
        }
    }

    protected void setSeriesXML(ObjectNode seriesNode, int series, boolean allProperties, HashMap map) {
        try {
            ContainerNode sfx;
            PropertyNode pNode = seriesNode.getProperty("markerType");
            if (pNode != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("markerType", new Integer(Series.convertMarkerTypeToInt(pNode.getValueAsString())));
                } else {
                    this.setMarkerType(Series.convertMarkerTypeToInt(pNode.getValueAsString()), series);
                }
            }
            if ((pNode = seriesNode.getProperty("markerShape")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("markerShape", new Integer(Series.convertMarkerShapeToInt(pNode.getValueAsString())));
                } else {
                    this.setMarkerShape(Series.convertMarkerShapeToInt(pNode.getValueAsString()), series);
                }
            }
            if ((pNode = seriesNode.getProperty("lineWidth")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("lineWidth", new Integer(pNode.getValueAsInteger()));
                } else {
                    this.setLineWidth(pNode.getValueAsInteger(), series);
                }
            }
            if ((pNode = seriesNode.getProperty("assignedToY2")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("assignedToY2", pNode.getValueAsBoolean());
                } else {
                    this.setAssignedToY2(pNode.getValueAsBoolean(), series);
                }
            }
            if ((pNode = seriesNode.getProperty("color")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("color", new Color(Series.hexStringToInt(pNode.getValueAsString()), true));
                } else {
                    this.setColor(new Color(Series.hexStringToInt(pNode.getValueAsString()), true), series);
                }
            }
            if ((pNode = seriesNode.getProperty("markerColor")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("color", new Color(Series.hexStringToInt(pNode.getValueAsString()), true));
                } else {
                    this.setMarkerColor(new Color(Series.hexStringToInt(pNode.getValueAsString()), true), series);
                }
            }
            if ((sfx = seriesNode.getContainer("SFX")) != null) {
                this.getSFX(series).setXML(sfx, allProperties);
            }
            if ((pNode = seriesNode.getProperty("borderColor")) != null) {
                this.setBorderColor(new Color(Series.hexStringToInt(pNode.getValueAsString()), true), series);
            }
            if ((pNode = seriesNode.getProperty("borderTransparent")) != null) {
                this.setBorderTransparent(pNode.getValueAsBoolean(), series);
            }
            if ((pNode = seriesNode.getProperty("fitlineType")) != null) {
                if (this.m_jsfHashMap != null) {
                    map.put("fitlineType", new Integer(Series.convertFitlineTypeToInt(pNode.getValueAsString())));
                } else {
                    this.setFitlineType(Series.convertFitlineTypeToInt(pNode.getValueAsString()), series);
                }
            }
            if ((pNode = seriesNode.getProperty("pieSliceExplode")) != null) {
                this.setPieSliceExplode(pNode.getValueAsInteger(), series);
            }
            if ((pNode = seriesNode.getProperty("transparent")) != null) {
                this.setTransparent(pNode.getValueAsBoolean(), series);
            }
            if ((pNode = seriesNode.getProperty("lineStyle")) != null) {
                this.setLineStyle(Series.convertLineStyleToInt(pNode.getValueAsString()), series);
            }
            if ((pNode = seriesNode.getProperty("visibility")) != null) {
                this.setVisibility(Series.convertVisibilityToInt(pNode.getValueAsString()), series);
            }
            if ((pNode = seriesNode.getProperty("shapePath")) != null) {
                this.setShapePath(pNode.getValueAsString(), series);
            }
            if ((pNode = seriesNode.getProperty("effect")) != null) {
                this.setEffect(CommonGraph.convertSeriesEffectToInt(pNode.getValueAsString()), series);
            }
            if ((pNode = seriesNode.getProperty("displayInLegend")) != null) {
                this.setDisplayInLegend(pNode.getValueAsString(), series);
            }
        }
        catch (SeriesOutOfRangeException sore) {
            this.m_commonGraph.getErrorHandler().log(" series is out of range ", this.getClass().getName(), "setSeriesStyleXML(ObjectNode seriesNode)");
        }
    }

    protected void displayMarkers(int oldType) {
        if (this.m_isMarkerShapeSet) {
            return;
        }
        boolean oldTypeIsScatter = false;
        if (oldType >= 61 && oldType <= 64 || oldType >= 65 && oldType <= 66 || oldType == 99) {
            oldTypeIsScatter = true;
        }
        boolean isScatter = this.m_pfj.isChartScatter() || this.m_pfj.getJGraphType().isPolar() || this.m_pfj.getJGraphType().isLineSelectPoint();
        this.m_pfj.setNoXMLMode(true);
        if (!oldTypeIsScatter && isScatter) {
            this.loopMarkerShapes();
        } else if (oldTypeIsScatter && !isScatter) {
            this.m_pfj.removeMarkerShapes(0, this._getNumberOfSeries());
            this.m_numSeries = 0;
        }
        this.m_pfj.setNoXMLMode(false);
    }

    protected void displayMarkers() {
        boolean isScatter = this.m_pfj.isChartScatter() || this.m_pfj.getJGraphType().isPolar() || this.m_pfj.getJGraphType().isLineSelectPoint();
        this.m_pfj.setNoXMLMode(true);
        if (isScatter) {
            this.loopMarkerShapes();
        }
        this.m_pfj.setNoXMLMode(false);
    }

    private void loopMarkerShapes() {
        int numSeries = this._getNumberOfSeries();
        if (numSeries > this.m_numSeries) {
            this.m_pfj.loopMarkerShapes(0, numSeries);
            this.m_numSeries = numSeries;
        }
    }

    protected void resetStyle() {
        int i;
        this.setDefaultBorderColor(Color.black);
        this.setDefaultBorderTransparent(false);
        this.setBorderUsingDefaults(false);
        this.setDefaultLineWidth(1);
        this.setDefaultFitlineType(0);
        int[] highW = this.m_pfj.getHighWaterMark();
        for (i = 0; i < highW.length; ++i) {
            if (i >= 12 && highW[i] != 1) continue;
            this.m_pfj.setFillColor(this.m_pfj.getSeries(i), null);
            this.m_pfj.setFillColor(this.m_pfj.getCurveFitLineRiser(i), null);
            this.m_pfj.setSeriesGradientEffect(i, 2);
        }
        try {
            for (i = 0; i < this.m_pfj.getSeriesLooping(); ++i) {
                this.setTransparent(false, i);
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
    }
}

