/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;

public class VennGauge
extends GaugeType {
    private Rectangle2D.Double _aBounds = null;
    private Rectangle2D.Double _bBounds = null;
    private double _midPtAx;
    private double _midPtBx;
    private double _midPtIntx;
    private static String ELEMENTA = "A";
    private static String ELEMENTB = "AB";
    private static String INTERSECTIONAB = "INTAB";
    protected static int LABEL_GAP = 5;
    private static double MAX_SCALEFACTOR = 0.25;
    private static int HORIZONTAL_GAP = 5;
    private static int VERTICAL_GAP = 5;

    public VennGauge(GaugeEngine engine) {
        super(engine);
    }

    @Override
    public int getGaugeType() {
        return 3;
    }

    @Override
    protected Collection getPlotAreaObject(Map map, int type) {
        double intValue;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        Object aValObj = map.get("ElementAValue");
        double aValue = aValObj != null ? Double.valueOf(aValObj.toString()) : 0.0;
        Object bValObj = map.get("ElementBValue");
        double bValue = bValObj != null ? Double.valueOf(bValObj.toString()) : 0.0;
        Object intValObj = map.get("IntersectionABValue");
        double d = intValue = intValObj != null ? Double.valueOf(intValObj.toString()) : 0.0;
        if (aValObj == null && bValObj == null && intValObj == null) {
            this._engine.getErrorHandler().trace("No Venn values to process", this.getClass().getName(), "VennGauge.getPlotAreaObject");
            return null;
        }
        if (aValObj != null && bValObj != null && intValObj != null && aValue > 0.0 && bValue > 0.0 && intValue > 0.0 && intValue <= aValue && intValue <= bValue) {
            this._calcCircleBounds(aValue, bValue, intValue);
        } else {
            this._calcCircleBoundsIrregular(aValue, bValue, intValue);
        }
        this._updateMidpoints();
        this._checkMidpoints(map);
        Ellipse2D.Double aEllipse = new Ellipse2D.Double(this._aBounds.x, this._aBounds.y, this._aBounds.width, this._aBounds.height);
        Ellipse2D.Double bEllipse = new Ellipse2D.Double(this._bBounds.x, this._bBounds.y, this._bBounds.width, this._bBounds.height);
        Area aArea = new Area(aEllipse);
        Area bArea = new Area(bEllipse);
        Object color = map.get("ElementAFillColor");
        Color elemAFillColor = color != null ? (Color)color : GaugeDefaultValues.getElementAFillColor();
        HashMap elemASFXMap = (HashMap)map.get("ElementASFX");
        color = map.get("ElementBFillColor");
        Color elemBFillColor = color != null ? (Color)color : GaugeDefaultValues.getElementBFillColor();
        HashMap elemBSFXMap = (HashMap)map.get("ElementBSFX");
        color = map.get("IntersectionABFillColor");
        Color intABFillColor = color != null ? (Color)color : GaugeDefaultValues.getIntersectionABFillColor();
        HashMap intABSFXMap = (HashMap)map.get("IntersectionABSFX");
        objects.add(new DrawableObject.Shape(20, bArea, null, elemBFillColor, elemASFXMap, null));
        objects.add(new DrawableObject.Shape(19, aArea, null, elemAFillColor, elemBSFXMap, null));
        Area intArea = (Area)aArea.clone();
        intArea.intersect(bArea);
        objects.add(new DrawableObject.Shape(21, intArea, null, intABFillColor, intABSFXMap, null));
        return objects;
    }

    @Override
    protected Collection getIndicatorObject(Map map, int metricIndex) {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Collection getTickLabelObjects(Map map) {
        return null;
    }

    @Override
    protected Collection getTickMarkObjects(Map map) {
        return null;
    }

    @Override
    protected Collection getLabelObjects(Map map, Rectangle outerBounds) {
        Color metricFontColor;
        Color bottomFontColor;
        Font bottomFont;
        double lblY;
        double lblX;
        String vennLabel;
        Color topFontColor;
        double intValue;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        Graphics2D g2d = this._engine.getGraphics();
        Object aValObj = map.get("ElementAValue");
        double aValue = aValObj != null ? Double.valueOf(aValObj.toString()) : 0.0;
        Object bValObj = map.get("ElementBValue");
        double bValue = bValObj != null ? Double.valueOf(bValObj.toString()) : 0.0;
        Object abValObj = map.get("IntersectionABValue");
        double d = intValue = abValObj != null ? Double.valueOf(abValObj.toString()) : 0.0;
        if (aValObj == null && bValObj == null && abValObj == null) {
            String noDataLabel = this._engine.getIntlStringFromUtilBundle("af_dvt_util.NO_DATA");
            Dimension dim = DrawableObject.getLabelDimensions(g2d, GaugeDefaultValues.getNoDataLabelFont(), noDataLabel);
            if (dim.width > this._innerBounds.width || dim.height > this._innerBounds.height) {
                return null;
            }
            Rectangle bounds = new Rectangle();
            bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
            bounds.y = this._innerBounds.y + this._innerBounds.height / 2 - dim.height / 2;
            bounds.width = dim.width;
            bounds.height = dim.height;
            objects.add(DrawableObject.getLabelObject(g2d, noDataLabel, GaugeDefaultValues.getNoDataLabelFont(), GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel"));
            return objects;
        }
        Rectangle2D.Double lblRect = new Rectangle2D.Double();
        Rectangle2D.Double intBounds = (Rectangle2D.Double)this._aBounds.createIntersection(this._bBounds);
        double midPtInty = intBounds.height > 0.0 ? intBounds.y + intBounds.height / 2.0 : this._bBounds.y + this._bBounds.height / 2.0;
        Font metricFont = (Font)map.get("MetricLabelFont");
        if (metricFont == null) {
            metricFont = GaugeDefaultValues.getMetricLabelFont();
        }
        Dimension lblDim = DrawableObject.getLabelDimensions(g2d, metricFont, "W");
        double midYOffset = lblDim.height / 2;
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        if ((vennLabel = (String)map.get("IntersectionABTopLabel")) != null) {
            lblDim = DrawableObject.getLabelDimensions(g2d, topFont, vennLabel);
            lblX = this._midPtIntx - (double)(lblDim.width / 2);
            lblY = midPtInty - midYOffset - (double)(VERTICAL_GAP + lblDim.height);
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, topFont, topFontColor, lblRect.getBounds(), "IntersectionABTopLabel"));
        }
        if ((vennLabel = (String)map.get("ElementBTopLabel")) != null && vennLabel instanceof String) {
            lblDim = DrawableObject.getLabelDimensions(g2d, topFont, vennLabel);
            lblX = this._midPtBx - (double)(lblDim.width / 2);
            lblY = midPtInty - midYOffset - (double)(VERTICAL_GAP + lblDim.height);
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, topFont, topFontColor, lblRect.getBounds(), "ElementBTopLabel"));
        }
        if ((vennLabel = (String)map.get("ElementATopLabel")) != null) {
            lblDim = DrawableObject.getLabelDimensions(g2d, topFont, vennLabel);
            lblX = this._midPtAx - (double)(lblDim.width / 2);
            lblY = midPtInty - midYOffset - (double)(VERTICAL_GAP + lblDim.height);
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, topFont, topFontColor, lblRect.getBounds(), "ElementATopLabel"));
        }
        if ((bottomFont = (Font)map.get("BottomLabelFont")) == null) {
            bottomFont = GaugeDefaultValues.getBottomLabelFont();
        }
        if ((bottomFontColor = (Color)map.get("BottomLabelColor")) == null) {
            bottomFontColor = GaugeDefaultValues.getBottomLabelFontColor();
        }
        if ((vennLabel = (String)map.get("IntersectionABBottomLabel")) != null) {
            lblDim = DrawableObject.getLabelDimensions(g2d, bottomFont, vennLabel);
            lblX = this._midPtIntx - (double)(lblDim.width / 2);
            midYOffset = lblDim.height / 2;
            lblY = midPtInty - midYOffset;
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, bottomFont, bottomFontColor, lblRect.getBounds(), "IntersectionABBottomLabel"));
        }
        if ((vennLabel = (String)map.get("ElementBBottomLabel")) != null && vennLabel instanceof String) {
            lblDim = DrawableObject.getLabelDimensions(g2d, bottomFont, vennLabel);
            lblX = this._midPtBx - (double)(lblDim.width / 2);
            midYOffset = lblDim.height / 2;
            lblY = midPtInty - midYOffset;
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, bottomFont, bottomFontColor, lblRect.getBounds(), "ElementBBottomLabel"));
        }
        if ((vennLabel = (String)map.get("ElementABottomLabel")) != null && vennLabel instanceof String) {
            lblDim = DrawableObject.getLabelDimensions(g2d, bottomFont, vennLabel);
            midYOffset = lblDim.height / 2;
            lblX = this._midPtAx - (double)(lblDim.width / 2);
            lblY = midPtInty - midYOffset;
            lblRect.x = lblX;
            lblRect.y = lblY;
            lblRect.width = lblDim.width;
            lblRect.height = lblDim.height;
            objects.add(DrawableObject.getLabelObject(g2d, vennLabel, bottomFont, bottomFontColor, lblRect.getBounds(), "ElementABottomLabel"));
        }
        if ((metricFontColor = (Color)map.get("MetricLabelColor")) == null) {
            metricFontColor = GaugeDefaultValues.getMetricLabelFontColor();
        }
        lblDim = DrawableObject.getLabelDimensions(g2d, metricFont, String.valueOf(intValue));
        lblX = this._midPtIntx - (double)(lblDim.width / 2);
        lblY = midPtInty + midYOffset * 2.0 + (double)VERTICAL_GAP;
        lblRect.x = lblX;
        lblRect.y = lblY;
        lblRect.width = lblDim.width;
        lblRect.height = lblDim.height;
        objects.add(DrawableObject.getLabelObject(g2d, String.valueOf(intValue), metricFont, metricFontColor, lblRect.getBounds(), "MetricLabelPosition"));
        lblDim = DrawableObject.getLabelDimensions(g2d, metricFont, String.valueOf(bValue));
        lblX = this._midPtBx - (double)(lblDim.width / 2);
        lblY = midPtInty + midYOffset * 2.0 + (double)VERTICAL_GAP;
        lblRect.x = lblX;
        lblRect.y = lblY;
        lblRect.width = lblDim.width;
        lblRect.height = lblDim.height;
        objects.add(DrawableObject.getLabelObject(g2d, String.valueOf(bValue), metricFont, metricFontColor, lblRect.getBounds(), "MetricLabelPosition"));
        lblDim = DrawableObject.getLabelDimensions(g2d, metricFont, String.valueOf(aValue));
        lblX = this._midPtAx - (double)(lblDim.width / 2);
        lblY = midPtInty + midYOffset * 2.0 + (double)VERTICAL_GAP;
        lblRect.x = lblX;
        lblRect.y = lblY;
        lblRect.width = lblDim.width;
        lblRect.height = lblDim.height;
        objects.add(DrawableObject.getLabelObject(g2d, String.valueOf(aValue), metricFont, metricFontColor, lblRect.getBounds(), "MetricLabelPosition"));
        return objects;
    }

    @Override
    protected DrawableObject getNoDataLabelObject(Map map) {
        return null;
    }

    @Override
    protected int getSpaceAboveGauge(Map map, Graphics2D g) {
        return VERTICAL_GAP;
    }

    @Override
    protected int getSpaceBelowGauge(Map map, Graphics2D g) {
        return VERTICAL_GAP;
    }

    @Override
    protected int getSpaceLeftOfGauge(Map map, Graphics2D g) {
        return HORIZONTAL_GAP;
    }

    @Override
    protected int getSpaceRightOfGauge(Map map, Graphics2D g) {
        return HORIZONTAL_GAP;
    }

    @Override
    protected int getGaugeRadius(int availWidth, int availHeight) {
        return availWidth;
    }

    @Override
    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        int radius = this.getGaugeRadius(availHeight, availWidth);
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        if (bounds.width < 10) {
            bounds.width = 10;
            bounds.x = rect.x + (rect.width - bounds.width) / 2;
        }
        if (bounds.height < 5) {
            bounds.height = 5;
            bounds.y = rect.y + (rect.height - bounds.height) / 2;
        }
        return bounds;
    }

    @Override
    protected int getMaxNumberOfSteps() {
        return 0;
    }

    @Override
    protected Collection getGaugeFrameObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList list = new ArrayList();
        return list;
    }

    private void _calcCircleBounds(double aValue, double bValue, double intValue) {
        double distBtwCtrs;
        boolean aLTb = aValue < bValue;
        double smArea = aLTb ? aValue : bValue;
        double lgArea = aLTb ? bValue : aValue;
        double smRadius = Math.sqrt(smArea / Math.PI);
        double lgRadius = smRadius * Math.sqrt(lgArea / smArea);
        double pctOverlap = intValue / smArea;
        if (pctOverlap == 1.0) {
            distBtwCtrs = lgRadius - smRadius;
        } else {
            double cross = 0.5 + 0.2 * smArea / lgArea + 0.3 * smRadius / lgRadius;
            double sf = this._calcOne(pctOverlap, cross);
            distBtwCtrs = smRadius + lgRadius - sf * 2.0 * smRadius;
        }
        double vennConcWidth = smRadius + distBtwCtrs + lgRadius;
        double scaleAcross = vennConcWidth / (double)this._innerBounds.width;
        double scaleDown = lgRadius * 2.0 / (double)this._innerBounds.height;
        int constraintSpan = scaleAcross > scaleDown ? this._innerBounds.width : this._innerBounds.height;
        double smDiam = (double)constraintSpan * smRadius * 2.0 / vennConcWidth;
        double lgDiam = (double)constraintSpan * lgRadius * 2.0 / vennConcWidth;
        double aDiam = aLTb ? smDiam : lgDiam;
        double bDiam = aLTb ? lgDiam : smDiam;
        double vennDiam = aDiam / 2.0 + (double)constraintSpan * distBtwCtrs / vennConcWidth + bDiam / 2.0;
        this._applyBoundsCentered(aDiam, bDiam, vennDiam);
    }

    private void _calcCircleBoundsIrregular(double aValue, double bValue, double intValue) {
        double aPerc = 0.5;
        double bPerc = 0.5;
        double intPerc = 0.0;
        if (intValue == 0.0 && (aValue > 0.0 || bValue > 0.0)) {
            if (aValue != bValue) {
                aPerc = aValue > bValue ? 1.0 - bValue / aValue : aValue / bValue;
                bPerc = 1.0 - aPerc;
            }
        } else if (aValue > intValue && aValue > bValue && intValue > bValue) {
            aPerc = 0.8;
            bPerc = 0.6;
            intPerc = 0.5;
        } else if (intValue > bValue && intValue > aValue && aValue > bValue) {
            aPerc = 0.7;
            bPerc = 0.65;
            intPerc = 0.8;
        } else if (intValue > bValue && intValue > aValue && bValue > aValue) {
            aPerc = 0.65;
            bPerc = 0.7;
            intPerc = 0.8;
        } else if (bValue > intValue && bValue > aValue && intValue > aValue) {
            aPerc = 0.6;
            bPerc = 0.8;
            intPerc = 0.5;
        }
        boolean widthConstraint = this._innerBounds.width <= this._innerBounds.height;
        double aDiam = widthConstraint ? (double)this._innerBounds.width * aPerc : (double)this._innerBounds.height * aPerc;
        double bDiam = widthConstraint ? (double)this._innerBounds.width * bPerc : (double)this._innerBounds.height * bPerc;
        double vennDiam = aDiam + bDiam - (double)(widthConstraint ? this._innerBounds.width : this._innerBounds.height) * intPerc;
        this._applyBoundsCentered(aDiam, bDiam, vennDiam);
    }

    private double _calcOne(double pctOverlap, double cross) {
        double maxpt;
        double va = 0.125;
        double sf = pctOverlap > 0.0 && pctOverlap < cross ? (pctOverlap < (maxpt = 0.25 * cross) ? pctOverlap + va * (1.0 - (maxpt - pctOverlap) * (maxpt - pctOverlap) / (maxpt * maxpt)) : pctOverlap + (va *= Math.sqrt(cross)) * (1.0 - (pctOverlap - maxpt) / (cross - maxpt))) : (pctOverlap > cross && pctOverlap < 1.0 ? (pctOverlap < (maxpt = 0.75 + 0.25 * cross) ? pctOverlap - va * (1.0 - (maxpt - pctOverlap) / (maxpt - cross)) : pctOverlap - (va *= 0.5 * Math.sqrt(1.0 - cross)) * (1.0 - (pctOverlap - maxpt) / (1.0 - maxpt))) : cross);
        return sf;
    }

    private void _applyBoundsCentered(double aDiam, double bDiam, double vennDiam) {
        double aX = (double)(this._innerBounds.x + this._innerBounds.width / 2) - vennDiam / 2.0;
        double aY = (double)(this._innerBounds.y + this._innerBounds.height / 2) - aDiam / 2.0;
        double bX = (double)(this._innerBounds.x + this._innerBounds.width / 2) + vennDiam / 2.0 - bDiam;
        double bY = (double)(this._innerBounds.y + this._innerBounds.height / 2) - bDiam / 2.0;
        this._aBounds = new Rectangle2D.Double(aX, aY, aDiam, aDiam);
        this._bBounds = new Rectangle2D.Double(bX, bY, bDiam, bDiam);
    }

    private double _getMaxLabelLength(Map map, String elem) {
        double maxLen;
        double len = maxLen = 0.0;
        Graphics2D g2d = this._engine.getGraphics();
        if (elem.equals(ELEMENTA)) {
            Font font;
            Object lblObj = map.get("ElementATopLabel");
            if (lblObj != null && lblObj instanceof String) {
                font = (Font)map.get("TopLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getTopLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((lblObj = map.get("ElementABottomLabel")) != null && lblObj instanceof String) {
                font = (Font)map.get("BottomLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getBottomLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((map.get("MetricLabelPosition") == null || (Integer)map.get("MetricLabelPosition") == 0) && (lblObj = map.get("ElementAValue")) != null && lblObj instanceof String) {
                font = (Font)map.get("MetricLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getMetricLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
        } else if (elem.equals(ELEMENTB)) {
            Font font;
            Object lblObj = map.get("ElementBTopLabel");
            if (lblObj != null && lblObj instanceof String) {
                font = (Font)map.get("TopLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getTopLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((lblObj = map.get("ElementBBottomLabel")) != null && lblObj instanceof String) {
                font = (Font)map.get("BottomLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getBottomLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((map.get("MetricLabelPosition") == null || (Integer)map.get("MetricLabelPosition") == 0) && (lblObj = map.get("ElementBValue")) != null && lblObj instanceof String) {
                font = (Font)map.get("MetricLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getMetricLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
        } else if (elem.equals(INTERSECTIONAB)) {
            Font font;
            Object lblObj = map.get("IntersectionABTopLabel");
            if (lblObj != null && lblObj instanceof String) {
                font = (Font)map.get("TopLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getTopLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((lblObj = map.get("IntersectionABBottomLabel")) != null && lblObj instanceof String) {
                font = (Font)map.get("BottomLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getBottomLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
            if ((map.get("MetricLabelPosition") == null || (Integer)map.get("MetricLabelPosition") == 0) && (lblObj = map.get("IntersectionABValue")) != null && lblObj instanceof String) {
                font = (Font)map.get("MetricLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getMetricLabelFont();
                }
                if ((len = DrawableObject.getLabelDimensions(g2d, font, (String)lblObj).getWidth()) > maxLen) {
                    maxLen = len;
                }
            }
        }
        return maxLen;
    }

    private void _checkMidpoints(Map map) {
        double longestIntLbl = this._getMaxLabelLength(map, INTERSECTIONAB);
        double longestALbl = this._getMaxLabelLength(map, ELEMENTA);
        double longestBLbl = this._getMaxLabelLength(map, ELEMENTB);
        double aintOverlap = this._midPtAx + longestALbl / 2.0 - (this._midPtIntx - longestIntLbl / 2.0);
        double aScale = 0.0;
        if (aintOverlap > 0.0) {
            this._midPtAx -= aintOverlap + (double)LABEL_GAP;
        }
        if (this._midPtAx - longestALbl / 2.0 < (double)this._innerBounds.x) {
            aScale = ((double)this._innerBounds.x - (this._midPtAx - longestALbl / 2.0)) / longestALbl;
        }
        double bintOverlap = this._midPtIntx + longestIntLbl / 2.0 - (this._midPtBx - longestALbl / 2.0);
        double bScale = 0.0;
        if (bintOverlap > 0.0) {
            this._midPtBx += bintOverlap + (double)LABEL_GAP;
        }
        if (this._midPtBx + longestBLbl / 2.0 > (double)(this._innerBounds.x + this._innerBounds.width)) {
            bScale = (this._midPtBx + longestBLbl / 2.0 - (double)(this._innerBounds.x + this._innerBounds.width)) / longestALbl;
        }
        if (aScale > 0.0 || bScale > 0.0) {
            double overage;
            double factor = Math.min(Math.max(aScale, bScale), MAX_SCALEFACTOR);
            double intDiam = (this._aBounds.x + this._aBounds.width - this._bBounds.x) * (1.0 - factor);
            double aDiam = this._aBounds.width * (1.0 - factor);
            double bDiam = this._bBounds.width * (1.0 - factor);
            this._applyBoundsCentered(aDiam, bDiam, aDiam + bDiam - intDiam);
            this._updateMidpoints();
            if (aScale > 0.0 && (overage = (double)this._innerBounds.x - (this._midPtAx - longestALbl / 2.0)) > 0.0) {
                this._midPtAx += overage;
                this._midPtBx += overage;
                if (this._midPtBx - longestBLbl / 2.0 < this._midPtIntx + longestIntLbl / 2.0) {
                    this._midPtBx = this._midPtIntx + longestIntLbl / 2.0 + (double)LABEL_GAP;
                }
            }
            if (bScale > 0.0 && (overage = this._midPtBx + longestBLbl / 2.0 - (double)(this._innerBounds.x + this._innerBounds.width)) > 0.0) {
                this._midPtBx -= overage;
                this._midPtAx -= overage;
                if (this._midPtAx - longestBLbl / 2.0 < (double)this._innerBounds.x) {
                    this._midPtAx = (double)this._innerBounds.x + longestBLbl / 2.0;
                }
            }
        }
    }

    private void _updateMidpoints() {
        Rectangle2D.Double intBounds = (Rectangle2D.Double)this._aBounds.createIntersection(this._bBounds);
        this._midPtAx = this._aBounds.x + (this._aBounds.width - intBounds.width) / 2.0;
        this._midPtIntx = intBounds.width > 0.0 ? intBounds.x + intBounds.width / 2.0 : this._bBounds.x;
        this._midPtBx = this._bBounds.x + (intBounds.width > 0.0 ? this._bBounds.width - (this._bBounds.x + this._bBounds.width - (intBounds.x + intBounds.width)) / 2.0 : this._bBounds.width / 2.0);
    }
}

