/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.SFX;

public class ThresholdSFX
extends SFX {
    private int m_index = -1;

    public ThresholdSFX(CommonGauge gauge, int index) {
        super(gauge, 15);
        this.m_index = index;
    }

    @Override
    protected HashMap getAttributeMapNoDefault() {
        HashMap map = null;
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList != null && this.m_index < tList.size()) {
            map = (HashMap)tList.get(this.m_index);
        }
        if (map != null) {
            map = (HashMap)map.get("ThresholdSFX");
        }
        return map;
    }

    @Override
    protected HashMap getAttributeMap() {
        HashMap tAttrMap;
        ArrayList tList = (ArrayList)this.m_commonGauge.getAttribute("THRESHOLD_ATTRIBUTES");
        if (tList == null) {
            tList = new ArrayList(this.m_index + 1);
            this.m_commonGauge.setAttribute("THRESHOLD_ATTRIBUTES", tList);
        }
        if (this.m_index >= tList.size()) {
            for (int i = tList.size(); i <= this.m_index; ++i) {
                HashMap<String, Serializable> tMap = new HashMap<String, Serializable>(2);
                tList.add(tMap);
                if (i < GaugeDefaultValues.getThresholdCount()) {
                    tMap.put("ThresholdFillColor", GaugeDefaultValues.getThresholdColors()[i]);
                } else {
                    tMap.put("ThresholdFillColor", Color.white);
                }
                tMap.put("ThresholdSFX", ThresholdSFX.cloneDefaultMap());
            }
        }
        if ((tAttrMap = (HashMap)tList.get(this.m_index)).get("ThresholdSFX") == null) {
            tAttrMap.put("ThresholdSFX", ThresholdSFX.cloneDefaultMap());
        }
        return (HashMap)tAttrMap.get("ThresholdSFX");
    }
}

