/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.presutil.GradientObj;
import oracle.dss.util.ErrorHandler;

public class Graphics2DRenderer
implements GaugeRenderer {
    private Graphics2D m_graphics;
    private ErrorHandler m_errorHandler;

    public Graphics2DRenderer(Graphics2D g, ErrorHandler eh) {
        this.m_graphics = g;
        this.m_errorHandler = eh;
    }

    @Override
    public void drawShape(Shape shape, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(shape);
        }
    }

    @Override
    public void fillShape(Shape shape, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, shape);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(shape);
    }

    @Override
    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillShape(shape, fillColor, gradient, sfxMap);
        }
        if (borderColor != null) {
            this.drawShape(shape, borderColor);
        }
    }

    @Override
    public void drawArc(Arc2D arc, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(arc);
        }
    }

    @Override
    public void fillArc(Arc2D arc, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, arc);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(arc);
    }

    @Override
    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArc(arc, fillColor, gradient, sfxMap);
        }
        if (borderColor != null) {
            this.drawArc(arc, borderColor);
        }
    }

    @Override
    public void drawArea(Area area, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(area);
        }
    }

    @Override
    public void fillArea(Area area, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, area);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(area);
    }

    public void fillArea(Area area, Rectangle outer, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, area);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(area);
    }

    @Override
    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this.drawAndFillArea(area, null, borderColor, fillColor, gradient, sfxMap);
    }

    public void drawAndFillArea(Area area, Rectangle outer, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArea(area, outer, fillColor, gradient, sfxMap);
        }
        if (borderColor != null) {
            this.drawArea(area, borderColor);
        }
    }

    @Override
    public void drawPolygon(Polygon poly, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(poly);
        }
    }

    @Override
    public void fillPolygon(Polygon poly, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, poly);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(poly);
    }

    @Override
    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillPolygon(polygon, fillColor, gradient, sfxMap);
        }
        if (borderColor != null) {
            this.drawPolygon(polygon, borderColor);
        }
    }

    @Override
    public void drawRect(Rectangle rect, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void fillRect(Rectangle rect, Color c, GradientObj gradient, Map sfxMap) {
        boolean handled = this.handleSFX(gradient, rect);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(rect);
    }

    @Override
    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillRect(rect, fillColor, gradient, sfxMap);
        }
        if (borderColor != null) {
            this.drawRect(rect, borderColor);
        }
    }

    private void drawRoundedRect(RoundRectangle2D roundRect, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(roundRect);
        }
    }

    private void fillRoundedRect(RoundRectangle2D roundRect, Color c, GradientObj gradient) {
        boolean handled = this.handleSFX(gradient, roundRect);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(roundRect);
    }

    @Override
    public void drawAndFillRoundedRect(RoundRectangle2D roundRect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (fillColor != null || gradient != null) {
            this.fillRoundedRect(roundRect, fillColor, gradient);
        }
        if (borderColor != null) {
            this.drawRoundedRect(roundRect, borderColor);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        Stroke oldStroke = this.m_graphics.getStroke();
        BasicStroke stroke = new BasicStroke(thickness, 0, 0);
        this.m_graphics.setStroke(stroke);
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.drawLine(x1, y1, x2, y2);
        this.m_graphics.setStroke(oldStroke);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawString(DrawableObject.Label labelObj, int x, int y, Font f, Color c, double angle) {
        String label = labelObj.getTruncatedText();
        if (label == null) {
            label = labelObj.getText();
        }
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.setFont(f);
        AffineTransform saveAT = null;
        if (angle != 0.0) {
            double rx = x + this.m_graphics.getFontMetrics(f).stringWidth(label) / 2;
            double ry = y - this.m_graphics.getFontMetrics(f).getHeight() / 2;
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), rx, ry);
            saveAT = this.m_graphics.getTransform();
            this.m_graphics.transform(rotate);
        }
        this.m_graphics.drawString(label, x, y);
        if (saveAT != null) {
            this.m_graphics.setTransform(saveAT);
        }
    }

    @Override
    public void drawImage(String strURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            boolean imgLoaded = false;
            if (image == null) {
                URL url = new URL(strURL);
                image = Toolkit.getDefaultToolkit().getImage(url);
                imgLoaded = true;
            }
            this.m_graphics.drawImage(image, x, y, width, height, imgObs);
            if (imgLoaded) {
                image.flush();
            }
        }
        catch (MalformedURLException murle) {
            this.m_errorHandler.error((Throwable)murle, this.getClass().getName(), "public void drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    @Override
    public void applyTransform(AffineTransform transform) {
        this.m_graphics.transform(transform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.m_graphics.getTransform();
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.m_graphics.setTransform(transform);
    }

    private boolean handleSFX(GradientObj gradient, Shape shape) {
        if (gradient == null) {
            return false;
        }
        Paint paint = gradient.getPaint(shape);
        if (paint != null) {
            this.m_graphics.setPaint(paint);
            return true;
        }
        return false;
    }
}

