/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.CustomToolTipCallback;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeConstants;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.GaugeXMLWriterCallback;
import oracle.dss.presutil.GradientObj;
import oracle.dss.util.ErrorHandler;

public class GaugeExportXMLWriter
extends ImageViewExportXMLWriter
implements GaugeRenderer {
    private GaugeXMLWriterCallback m_xmlCallback;
    private GaugeEngine m_gaugeEngine = null;
    private Map m_map = null;
    protected int m_compType = -1;
    protected int m_index = -1;
    protected String m_compName = null;
    protected boolean m_visible = true;
    protected int m_column = -1;
    protected int m_row = -1;
    private Graphics m_graphics = null;
    public static final String ELEM_GAUGE_SET = "gaugeSet";
    public static final String ATTR_GAUGE_TYPE = "gaugeType";
    public static final String ATTR_POINT_OF_ROTATION = "por";
    public static final String ATTR_THRESHOLD_VALUES = "tv";
    public static final String ATTR_THRESHOLD_COLORS = "tc";
    public static final String ATTR_INDICATOR_USE_THRESHOLD_FILLCOLOR = "ac";
    public static final String ATTR_CURRENT_DATA = "cd";
    public static final String ATTR_FLASH_BIDI_TEXT = "fbt";
    protected CommonGauge m_gauge;
    protected ComponentHandle m_handle = null;

    public GaugeExportXMLWriter(CommonGauge cg, OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.init(cg);
    }

    public GaugeExportXMLWriter(CommonGauge cg, OutputStream os, ErrorHandler eh) {
        super(os, eh);
        this.init(cg);
    }

    public GaugeExportXMLWriter(CommonGauge cg, Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.init(cg);
    }

    public GaugeExportXMLWriter(CommonGauge cg, Writer writer, ErrorHandler eh) {
        super(writer, eh);
        this.init(cg);
    }

    private void init(CommonGauge cg) {
        this.m_gauge = cg;
        this.m_xmlCallback = this.m_gauge.getXMLWriterCallback();
        this.initXMLWriterCallback(this.m_xmlCallback);
    }

    protected void init(GaugeEngine engine) {
        this.m_gaugeEngine = engine;
        this.writeMetadataElement();
        if (this.m_xmlCallback != null) {
            int row = (Integer)this.m_gaugeEngine.getAttribute("DS_ROW");
            this.m_xmlCallback.setRowIndex(row);
            int column = (Integer)this.m_gaugeEngine.getAttribute("DS_COLUMN");
            this.m_xmlCallback.setColumnIndex(column);
        }
    }

    protected void writeToolTipFormatting() throws IOException, Exception {
        boolean toolTipNodeExist;
        Font font = this.m_gauge.getToolTips().getFont();
        Color fontColor = this.m_gauge.getToolTips().getFontColor();
        int fontStyle = this.m_gauge.getToolTips().getFont().getStyle();
        Map<TextAttribute, ?> map = this.m_gauge.getToolTips().getFont().getAttributes();
        Integer underlineStyle = (Integer)map.get(TextAttribute.UNDERLINE);
        boolean bUnderlined = false;
        if (underlineStyle != null && underlineStyle == TextAttribute.UNDERLINE_ON) {
            bUnderlined = true;
        }
        Font defaultFont = GaugeDefaultValues.getToolTipFont();
        Color defaultFontColor = GaugeDefaultValues.getToolTipFontColor();
        GaugeConstants.HorizontalAlignment halign = GaugeConstants.HorizontalAlignment.getType(this.m_gauge.getToolTips().getHorizontalAlignment());
        if (this.m_gauge.getGaugeSetAttribute("toolTipHorizontalAlignment") == null && this.isBIDILocale()) {
            halign = GaugeConstants.HorizontalAlignment.RIGHT;
        }
        boolean fontNodeExist = !font.equals(defaultFont) || !fontColor.equals(defaultFontColor);
        boolean alignmentExist = halign != GaugeConstants.HorizontalAlignment.getDefault();
        boolean bl = toolTipNodeExist = alignmentExist || fontNodeExist;
        if (toolTipNodeExist) {
            int fid = 0;
            if (fontNodeExist) {
                String fontString = GaugeExportXMLWriter.getFontAttributes(font, fontColor, bUnderlined, this.m_eh);
                fid = this.getFontID(fontString);
            }
            this.startElement("ttf");
            if (fontNodeExist) {
                this.writeFontIndexAttribute(fid);
            }
            if (alignmentExist) {
                this.writeCachedAttribute("j", halign.getFieldName(), null);
            }
            this.endElement();
        }
    }

    protected void writeMetadataElement() {
        if (this.m_gaugeEngine == null) {
            return;
        }
        try {
            String tt;
            Integer extent;
            this.startElement("md");
            if (this.m_gaugeEngine.getId() != null) {
                this.writeAttribute("id", this.m_gaugeEngine.getId());
            }
            if ((extent = (Integer)this.m_gaugeEngine.getAttribute("AngleExtent")) == null) {
                extent = GaugeDefaultValues.getAngleExtent();
            }
            double angleStart = 90 - extent / 2;
            double angleExtent = extent.intValue();
            this.writeAttribute("ang", angleStart + "," + angleExtent);
            this.m_gaugeEngine.prepareViewFormats();
            String metricLabel = this.m_gaugeEngine.formatValue(this.m_gaugeEngine.getMetric(), "MetricLabelViewFormat");
            String topLabel = this.m_gaugeEngine.getTopLabel();
            String btmLabel = this.m_gaugeEngine.getBottomLabel();
            StringBuilder s = DataviewUtils.getSharedStringBuilder();
            s.append(this.m_gaugeEngine.getMin()).append("~:");
            s.append(this.m_gaugeEngine.getMax()).append("~:");
            s.append(this.m_gaugeEngine.getMetric()).append("~:");
            if (metricLabel != null) {
                s.append(metricLabel);
            }
            s.append("~:");
            if (topLabel != null) {
                s.append(topLabel);
            }
            s.append("~:");
            if (btmLabel != null) {
                s.append(btmLabel);
            }
            this.writeAttribute("d", s.toString());
            String[] tooltipsArray = this.m_gaugeEngine._getFlashToolTipText(17, 14, -1);
            if (tooltipsArray != null && tooltipsArray.length > 0 && (tt = GaugeExportXMLWriter._buildTooltipString(tooltipsArray)) != null && tt.length() > 0) {
                this.writeAttribute("t", tt);
            }
            boolean autoColor = GaugeDefaultValues.isIndicatorUseThresholdFillColor();
            boolean[] autoColors = new boolean[this.m_gauge.getIndicator().size()];
            Integer index = 0;
            while (index < this.m_gauge.getIndicator().size()) {
                Object autoColorIndividual = (Boolean)this.m_gaugeEngine.getIndicatorAttr("IndicatorUseThresholdFillColor", index);
                if (autoColorIndividual == null) {
                    autoColorIndividual = GaugeDefaultValues.isIndicatorUseThresholdFillColor();
                }
                autoColor |= ((Boolean)autoColorIndividual).booleanValue();
                autoColors[index.intValue()] = (Boolean)autoColorIndividual;
                autoColorIndividual = index;
                Integer n = index = Integer.valueOf(index + 1);
            }
            if (autoColor && this.m_gaugeEngine.getMetricSize() <= 1) {
                this.writeAttribute(ATTR_INDICATOR_USE_THRESHOLD_FILLCOLOR, "t");
                double[] tValues = (double[])this.m_gaugeEngine.getAttribute("ThresholdValues");
                if (tValues != null) {
                    s.setLength(0);
                    for (Object val : (Object)tValues) {
                        if (s.length() > 0) {
                            s.append(",");
                        }
                        s.append((double)val);
                    }
                    this.writeAttribute(ATTR_THRESHOLD_VALUES, s.toString());
                    s.setLength(0);
                    ArrayList tList = (ArrayList)this.m_gaugeEngine.getAttribute("THRESHOLD_ATTRIBUTES");
                    HashMap tMap = null;
                    for (int i = 0; i <= tValues.length; ++i) {
                        Color tColor;
                        if (tList != null && i < tList.size()) {
                            tMap = (HashMap)tList.get(i);
                            tColor = (Color)GaugeType.getThresholdAttribute(tMap, i, "ThresholdFillColor");
                        } else {
                            Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                            Color color = tColor = i < defFillColors.length ? defFillColors[i] : Color.white;
                        }
                        if (s.length() > 0) {
                            s.append(",");
                        }
                        s.append(GaugeExportXMLWriter.colorToHexWithAlpha(tColor));
                    }
                    this.writeAttribute(ATTR_THRESHOLD_COLORS, s.toString());
                }
            }
            this.endElement();
        }
        catch (Exception e) {
            this.m_gaugeEngine.getErrorHandler().trace("Problem writing GaugeEngine xml information", "GaugeExportXMLWriter", "init(GaugeEngine engine)");
        }
    }

    protected void init(int compType, int index, Map map, boolean visible) {
        this.m_compType = compType;
        this.m_index = index;
        this.m_compName = GaugeEngine.getCompNameForImagemapEnumeration(compType);
        this.m_map = map;
        this.m_visible = visible;
        this.m_column = -1;
        this.m_row = -1;
        if (this.m_map != null) {
            if (compType == 14) {
                this.m_row = GaugeEngine.getIndicatorRow(this.m_map, this.m_index);
                this.m_column = GaugeEngine.getIndicatorColumn(this.m_map, index);
            } else if (compType == 15) {
                this.m_row = GaugeEngine.getThresholdRow(this.m_map, this.m_index);
                this.m_column = GaugeEngine.getThresholdColumn(this.m_map, index);
            } else {
                Object colObj;
                Object rowObj = this.m_map.get("DS_ROW");
                if (rowObj != null && rowObj instanceof Integer) {
                    this.m_row = (Integer)rowObj;
                }
                if ((colObj = this.m_map.get("DS_COLUMN")) != null && colObj instanceof Integer) {
                    this.m_column = (Integer)colObj;
                }
            }
        }
        if (this.m_xmlCallback != null && (this.m_compType == 28 || this.m_compType == 15 || this.m_compType == 14 || this.m_compType == 17 || this.m_compType == 12 || this.m_compType == 11)) {
            this.m_xmlCallback.setCompType(this.m_compType);
        }
        this.m_handle = this.m_compType == 30 ? this.m_gauge.getGaugeComponentHandle(11, this.m_index, this.m_row, this.m_column) : this.m_gauge.getGaugeComponentHandle(this.m_compType, this.m_index, this.m_row, this.m_column);
    }

    public boolean startGaugeSetElement(Dimension size, int gaugeType) throws IOException, Exception {
        this.startElement(ELEM_GAUGE_SET);
        this.writeAttribute("w", size.width);
        this.writeAttribute("h", size.height);
        this.writeAttribute(ATTR_GAUGE_TYPE, CommonGauge.convertGaugeTypeToString(gaugeType));
        if (this.isActiveDataService() || this.isPPRAnimation()) {
            this.writeAttribute("ads", "on");
        }
        this.writeAnimationAttributes();
        if (this.m_gauge.getAttribute("flashBidiText") != null && this.m_gauge.getAttribute("flashBidiText").equals("true")) {
            this.writeAttribute(ATTR_FLASH_BIDI_TEXT, "t");
        }
        return true;
    }

    protected void endGaugeSetElement() throws IOException, Exception {
        this.endElement();
    }

    @Override
    public void drawShape(Shape shape, Color c) {
        this._writeShape(shape, c, null, null, null);
    }

    @Override
    public void fillShape(Shape shape, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(shape, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(shape, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawArc(Arc2D arc, Color c) {
        this._writeShape(arc, c, null, null, null);
    }

    @Override
    public void fillArc(Arc2D arc, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(arc, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(arc, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawArea(Area area, Color c) {
        this._writeShape(area, c, null, null, null);
    }

    @Override
    public void fillArea(Area area, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(area, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(area, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawPolygon(Polygon poly, Color c) {
        this._writeShape(poly, c, null, null, null);
    }

    @Override
    public void fillPolygon(Polygon poly, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(poly, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(polygon, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawRect(Rectangle rect, Color c) {
        this._writeShape(rect, c, null, null, null);
    }

    @Override
    public void fillRect(Rectangle rect, Color c, GradientObj gradient, Map sfxMap) {
        this._writeShape(rect, null, c, gradient, sfxMap);
    }

    @Override
    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        this._writeShape(rect, borderColor, fillColor, gradient, sfxMap);
    }

    @Override
    public void drawAndFillRoundedRect(RoundRectangle2D roundRect, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        try {
            boolean ret = this.startRectElement(roundRect.getBounds(), (int)roundRect.getArcWidth(), (int)roundRect.getArcHeight());
            if (ret) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (borderColor != null) {
                    this.writeAttribute("bc", borderColor);
                }
                this.writeFillAttributes(sfxMap, roundRect, fillColor, gradient);
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeCustomPropertyAttribute();
                this.writeShapeAttributesElement();
                this.writeFillChildren(roundRect, gradient);
                this.endElement();
            }
        }
        catch (Exception ioe) {
            this.m_eh.log(ioe.getMessage(), this.getClass().getName(), "drawAndFillRoundedRect(Rectangle rect, Color borderColor, Color fillColor, int arcWidth, int arcHeight, Hashmap sfxMap)");
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        try {
            boolean ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (thickness != 1) {
                    this.writeAttribute("bw", thickness);
                }
                if (c != null) {
                    this.writeCachedAttribute("c", c, "l");
                }
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeCustomPropertyAttribute();
                this.writeShapeAttributesElement();
                this.writeCachedAttribute("sh", "", null);
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawLine(int x1, int y1, int x2, int y2, int thickness, Color c)");
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        this.drawLine(x1, y1, x2, y2, 1, c);
    }

    @Override
    public void drawString(DrawableObject.Label labelObj, int x, int y, Font f, Color c, double angle) {
        String s;
        String label = labelObj.getTruncatedText();
        if (label == null) {
            label = labelObj.getText();
        }
        if (label != null && label.length() > 0 && (s = label.trim()) != null && s.length() > 0) {
            try {
                Graphics graphics;
                Map<TextAttribute, ?> map = f.getAttributes();
                Integer underlineStyle = (Integer)map.get(TextAttribute.UNDERLINE);
                boolean bUnderlined = false;
                if (underlineStyle != null && underlineStyle == TextAttribute.UNDERLINE_ON) {
                    bUnderlined = true;
                }
                String fontString = GaugeExportXMLWriter.getFontAttributes(f, c, bUnderlined, this.m_eh);
                int fid = this.getFontID(fontString);
                if (this.m_gaugeEngine != null) {
                    graphics = this.m_gaugeEngine.getGraphics();
                } else if (this.m_graphics != null) {
                    graphics = this.m_graphics;
                } else {
                    BufferedImage image = new BufferedImage(1, 1, 2);
                    this.m_graphics = graphics = ((Image)image).getGraphics();
                }
                if (this.startTextElement(x, y, graphics.getFontMetrics(f).stringWidth(label))) {
                    this.writeFontIndexAttribute(fid);
                    this.writeCompTypeAttributes();
                    if (!this.hasAlt()) {
                        String[] tooltipsArray = this._getTooltips();
                        String fullText = labelObj.getText();
                        if (tooltipsArray == null && !label.equals(fullText)) {
                            tooltipsArray = new String[]{fullText};
                        }
                        if (tooltipsArray != null && tooltipsArray.length > 0) {
                            this.writeTooltipAttribute(tooltipsArray);
                        }
                    }
                    this.writeCustomPropertyAttribute();
                    this.writeShapeAttributesElement();
                    this.writeText(label);
                    this.endElement();
                }
            }
            catch (Exception e) {
                this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawString(String label, int x, int y, Font f, Color c)");
            }
        }
    }

    @Override
    public void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            if (this.startImageElement(x, y, width, height, imgURL)) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeCustomPropertyAttribute();
                this.writeShapeAttributesElement();
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    @Override
    public void applyTransform(AffineTransform transform) {
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public void setTransform(AffineTransform transform) {
    }

    protected boolean startImageElement(int x, int y, int width, int height, String url) throws IOException, Exception {
        if (url != null) {
            this.startElement("img");
            this.writeAttribute("url", url);
            this.writeAttribute("x", x);
            this.writeAttribute("y", y);
            this.writeAttribute("w", width);
            this.writeAttribute("h", height);
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("url null", this.getClass().getName(), "protected boolean startImageElement(int x, int y, int width, int height, String url)");
        }
        return false;
    }

    @Override
    protected Locale getLocale() {
        return this.m_gauge.getLocale();
    }

    private String[] _getTooltips() {
        String[] tooltipsArray = null;
        int compType = this.m_compType;
        if (compType == 30) {
            compType = 11;
        }
        if ((compType == 11 || compType == 14 || compType == 15 || compType == 16 || compType == 17) && this.m_gaugeEngine != null) {
            tooltipsArray = this.m_gaugeEngine._getFlashToolTipText(17, compType, this.m_index);
        }
        if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
            tooltipsArray = new String[]{((Double)this.m_map.get("Metric")).toString()};
        }
        return tooltipsArray;
    }

    private boolean _writeShape(Shape shape, Color borderColor, Color fillColor, GradientObj gradient, Map sfxMap) {
        boolean ret = true;
        try {
            boolean bElementStarted;
            boolean bLink = false;
            String link = null;
            String id = null;
            if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
                bLink = true;
                link = (String)this.m_map.get("Link");
                Object rowObj = this.m_map.get("DS_ROW");
                int row = rowObj != null ? (Integer)rowObj : -1;
                Object colObj = this.m_map.get("DS_COLUMN");
                int column = colObj != null ? (Integer)colObj : -1;
                id = row + "," + column;
            }
            if (bElementStarted = this.startElement(shape)) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                this.writeFillAttributes(sfxMap, shape, fillColor, gradient);
                if (borderColor != null && borderColor.getAlpha() != 0) {
                    this.writeAttribute("bc", borderColor);
                }
                if (bLink) {
                    this.writeAttribute("link", link);
                }
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeCustomPropertyAttribute();
                this.writeShapeAttributesElement();
                this.writeFillChildren(shape, gradient);
                this.endElement();
            }
            if (bLink) {
                this._writeLinkBorder(shape, Color.blue, id);
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "private boolean _writeShape");
            ret = false;
        }
        return ret;
    }

    @Override
    public void writeTooltipAttribute(String[] tooltipsArray) throws IOException, Exception {
        CustomToolTipCallback customToolTipCallback = this.m_gauge.getCustomToolTipCallback();
        if (customToolTipCallback != null) {
            String tooltip = customToolTipCallback.getToolTipText(GaugeExportXMLWriter._buildTooltipString(tooltipsArray), this.m_handle);
            this.writeAttribute("t", tooltip);
        } else {
            super.writeTooltipAttribute(tooltipsArray);
        }
    }

    protected boolean startElement(Shape shape) throws IOException, Exception {
        boolean bElementStarted = false;
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
        } else {
            bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : (shape instanceof Arc2D ? this.startCircleOrOvalElement((Arc2D)shape) : this.startPathElement(shape));
        }
        return bElementStarted;
    }

    protected void writeFillAttributes(Map sfxMap, Shape shape, Color fillColor, GradientObj gradient) throws IOException, Exception {
        if (!this.m_visible) {
            this.writeAttribute("v", "h");
        }
        if (sfxMap != null || gradient != null) {
            int direction;
            String sDirection;
            this.writeVisualEffectsAttributes(sfxMap);
            if (gradient != null && (sDirection = GaugeExportXMLWriter.convertGradientDirectionToXMLString(direction = gradient.getDirectionConstant())) != null && sDirection.length() > 0) {
                this.writeCachedAttribute("ft", "ftG", null);
                return;
            }
        } else {
            this.writeCachedAttribute("sh", "", null);
        }
        this.writeCachedAttribute("ft", "ftC", null);
        if (fillColor == null) {
            this.writeCachedAttribute("fc", "", null);
        } else {
            this.writeCachedAttribute("fc", fillColor, null);
        }
    }

    protected void writeFillChildren(Shape shape, GradientObj gradient) throws IOException, Exception {
        String sDirection;
        if (gradient != null && (sDirection = GaugeExportXMLWriter.convertGradientDirectionToXMLString(gradient.getDirectionConstant())) != null && sDirection.length() > 0) {
            this.writeGradientElement(gradient, shape);
        }
    }

    protected void writeGradientElement(GradientObj gradient, Shape shape) throws IOException, Exception {
        this.startElement("g");
        if (gradient.getType() == GradientObj.GradientType.LINEAR) {
            if (gradient.getDirectionConstant() != 20) {
                this.writeCachedAttribute("dir", "", null);
                this.writeAttribute("ang", gradient.getAngle());
            } else {
                this.writeCachedAttribute("dir", "gdC", null);
                Point2D start = gradient.getStartPoint();
                Point2D end = gradient.getEndPoint();
                int x1 = (int)start.getX();
                int y1 = (int)start.getY();
                int x2 = (int)end.getX();
                int y2 = (int)end.getY();
                StringBuilder sb = new StringBuilder();
                sb.append(x1).append(",").append(y1).append(",").append(x2).append(",").append(y2);
                this.writeAttribute("pts", sb.toString());
            }
        } else {
            this.writeCachedAttribute("dir", "gdR", null);
        }
        if (shape != null) {
            Rectangle2D bounds = shape.getBounds2D();
            this.writeAttribute("b", bounds.getX() + "," + bounds.getY() + "," + bounds.getWidth() + "," + bounds.getHeight());
            if (gradient.getType() == GradientObj.GradientType.RADIAL) {
                GradientObj.RadialGradientDef radial = gradient.getRadialGradientDef(shape);
                this.writeAttribute("cx", radial.cx);
                this.writeAttribute("cy", radial.cy);
                this.writeAttribute("r", radial.radius);
            }
        }
        this.writeGradientStopAttributes(gradient);
        this.endElement();
    }

    protected void writeCompTypeAttributes() throws IOException, Exception {
        if (this.m_compType >= 0) {
            Point2D center;
            String s = GaugeExportXMLWriter.convertCompTypeToString(this.m_compType);
            if (s != null && s.length() > 0) {
                this.writeCachedAttribute("O", s, null);
            }
            if (this.m_compType == 14 && (center = (Point2D)this.m_gaugeEngine.getAttribute("MetadataPointOfRotation")) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(center.getX()).append(",").append(center.getY());
                this.writeAttribute(ATTR_POINT_OF_ROTATION, sb.toString());
            }
            if (this.m_compType == 34 || this.m_compType == 13 || this.m_compType == 12) {
                this.writeCachedAttribute("go", "t", null);
            } else {
                this.writeCachedAttribute("go", "f", null);
            }
        }
    }

    public void writeVisualEffectsAttributes(Map map) throws IOException, Exception {
        if (map == null) {
            this.writeCachedAttribute("sh", "", null);
            return;
        }
        int vfx = 1;
        if (map.get("SFX_VISUAL_EFFECTS") != null) {
            vfx = (Integer)map.get("SFX_VISUAL_EFFECTS");
        }
        if (vfx == 0) {
            this.writeCachedAttribute("sh", "", null);
            return;
        }
        boolean bShadow = (vfx & 2) > 0;
        boolean bBevel = (vfx & 4) > 0;
        boolean bGlow = (vfx & 8) > 0;
        Color sColor = (Color)map.get("shadowColor");
        Double sDistance = (Double)map.get("shadowDistance");
        Double sStrength = (Double)map.get("shadowStrength");
        Double sAngle = (Double)map.get("shadowAngle");
        Double sBlurX = (Double)map.get("shadowBlurX");
        Double sBlurY = (Double)map.get("shadowBlurY");
        Integer sQuality = (Integer)map.get("shadowQuality");
        Integer sInner = (Integer)map.get("shadowInner");
        Integer sKnockout = (Integer)map.get("shadowKnockout");
        Integer sHide = (Integer)map.get("shadowHide");
        if (sColor != null || sDistance != null || sStrength != null || sAngle != null || sBlurX != null || sBlurY != null || sQuality != null || sInner != null || sKnockout != null || sHide != null || bShadow) {
            this.writeShadowAttribute(sColor, sDistance, sStrength, sAngle, sBlurX, sBlurY, sQuality, sInner, sKnockout, sHide);
        } else {
            this.writeCachedAttribute("sh", "", null);
        }
        Color bHighlightColor = (Color)map.get("bevelHighlightColor");
        Color bShadowColor = (Color)map.get("bevelShadowColor");
        Double bDistance = (Double)map.get("bevelDistance");
        Double bStrength = (Double)map.get("bevelStrength");
        Double bAngle = (Double)map.get("bevelAngle");
        Double bBlurX = (Double)map.get("bevelBlurX");
        Double bBlurY = (Double)map.get("bevelBlurY");
        Integer bQuality = (Integer)map.get("bevelQuality");
        String bType = (String)map.get("bevelType");
        if (bHighlightColor != null || bShadowColor != null || bDistance != null || bStrength != null || bAngle != null || bBlurX != null || bBlurY != null || bQuality != null || bType != null || bBevel) {
            this.writeBevelAttribute(bHighlightColor, bShadowColor, bDistance, bStrength, bAngle, bBlurX, bBlurY, bQuality, bType);
        }
        Color gColor = (Color)map.get("glowColor");
        Double gBlurX = (Double)map.get("glowBlurX");
        Double gBlurY = (Double)map.get("glowBlurY");
        Double gStrength = (Double)map.get("glowStrength");
        Integer gQuality = (Integer)map.get("glowQuality");
        Integer gInner = (Integer)map.get("glowInner");
        Integer gKnockout = (Integer)map.get("glowKnockout");
        if (gColor != null || gBlurX != null || gBlurY != null || gStrength != null || gQuality != null || gInner != null || gKnockout != null || bGlow) {
            this.writeGlowAttribute(gColor, gBlurX, gBlurY, gStrength, gQuality, gInner, gKnockout);
        }
    }

    protected static String convertCompTypeToString(int compType) {
        switch (compType) {
            case 10: {
                return "GB";
            }
            case 11: {
                return "PA";
            }
            case 12: {
                return "TickLabel";
            }
            case 13: {
                return "TickMark";
            }
            case 14: {
                return "Indicator";
            }
            case 15: {
                return "Threshold";
            }
            case 16: {
                return "TopLabel";
            }
            case 17: {
                return "BottomLabel";
            }
            case 18: {
                return "ML";
            }
            case 19: {
                return "ElementA";
            }
            case 20: {
                return "ElementB";
            }
            case 21: {
                return "IntersectionAB";
            }
            case 23: {
                return "GSB";
            }
            case 36: {
                return "GaugeSetTitle";
            }
            case 24: {
                return "GaugeFrame";
            }
            case 25: {
                return "UpperLabelFrame";
            }
            case 26: {
                return "LowerLabelFrame";
            }
            case 27: {
                return "LA";
            }
            case 28: {
                return "LT";
            }
            case 29: {
                return "LegendTitle";
            }
            case 30: {
                return "IndicatorBase";
            }
            case 31: {
                return "IndicatorBar";
            }
            case 32: {
                return "TitleSeparator";
            }
            case 34: {
                return "Overlay";
            }
        }
        return null;
    }

    public static String convertGradientDirectionToXMLString(int direction) {
        switch (direction) {
            case 1: {
                return "gdRi";
            }
            case 3: {
                return "gdD";
            }
            case 5: {
                return "gdD45";
            }
            case 7: {
                return "gdD135";
            }
            case 20: {
                return "gdC";
            }
            case 9: {
                return "gdR";
            }
            case 10: {
                return "GD_RADIAL_TOP_LEFT";
            }
            case 11: {
                return "GD_RADIAL_TOP_RIGHT";
            }
            case 12: {
                return "GD_RADIAL_BOTTOM_LEFT";
            }
            case 13: {
                return "GD_RADIAL_BOTTOM_RIGHT";
            }
            case 14: {
                return "gdR";
            }
            case 21: {
                return "gdR";
            }
        }
        return null;
    }

    private void _writeLinkBorder(Shape shape, Color borderColor, String id) {
        try {
            boolean bElementStarted = this.startElement(shape);
            if (bElementStarted) {
                this.writeAttribute("bc", borderColor);
                this.writeAttribute("v", "h");
                this.writeAttribute("id", id);
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeCachedAttribute("fc", "", null);
                this.writeAttribute("bw", "2");
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "_writeLinkBorder(Shape shape, Color borderColor, Color fillColor)");
        }
    }

    @Override
    public void writeAnimationAttributes() throws IOException, Exception {
        Color animationDownColor;
        Color animationUpColor;
        int animationOnDisplay;
        int animationDuration;
        int animationIndicators;
        if (this.m_gauge == null) {
            return;
        }
        int animationOnDataChange = this.m_gauge.getAnimationOnDataChange();
        if (animationOnDataChange != GaugeDefaultValues.getAnimationOnDataChange()) {
            this.writeAttribute("aDC", CommonGauge.convertAnimationOnDataChangeToString(animationOnDataChange));
        }
        if ((animationIndicators = this.m_gauge.getAnimationIndicators()) != GaugeDefaultValues.getAnimationIndicators()) {
            this.writeAttribute("aI", CommonGauge.convertAnimationIndicatorsToString(animationIndicators));
        }
        if ((animationDuration = this.m_gauge.getAnimationDuration()) != GaugeDefaultValues.getAnimationDuration()) {
            this.writeAttribute("aDu", animationDuration);
        }
        if ((animationOnDisplay = this.m_gauge.getAnimationOnDisplay()) != GaugeDefaultValues.getAnimationOnDisplay()) {
            this.writeAttribute("aDi", CommonGauge.convertAnimationOnDisplayToString(animationOnDisplay));
        }
        if (!(animationUpColor = this.m_gauge.getAnimationUpColor()).equals(GaugeDefaultValues.getAnimationUpColor())) {
            this.writeAttribute("aU", animationUpColor);
        }
        if (!(animationDownColor = this.m_gauge.getAnimationDownColor()).equals(GaugeDefaultValues.getAnimationDownColor())) {
            this.writeAttribute("aD", animationDownColor);
        }
    }
}

