/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalPivotTableDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    private int[] edgeExtent = new int[]{4, 20};
    private int[] layerCount = new int[]{2, 2};
    private int[] branchingFactor = new int[]{2, 4};
    private ResourceBundle rBundle;
    private String rowStr;
    private String columnStr;
    private String cellStr;
    protected DataDirectorListener listener;
    private HashMap m_updatedValues = new HashMap();

    public LocalPivotTableDataSource() {
        this.rBundle = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        this.rowStr = this.rBundle.getString("LDSRow");
        this.columnStr = this.rBundle.getString("LDSColumn");
        this.cellStr = this.rBundle.getString("LDSCell");
    }

    public void setEdgeExtent(int edge, int extent) {
        if (extent < 0) {
            extent = 0;
        }
        this.edgeExtent[edge] = extent;
        this.m_updatedValues.clear();
    }

    public void setLayerCount(int edge, int layerCount) {
        if (layerCount < 0) {
            layerCount = 0;
        }
        this.layerCount[edge] = layerCount;
        this.m_updatedValues.clear();
    }

    public int getBranchingFactor(int edge) {
        return this.branchingFactor[edge];
    }

    public void setBranchingFactor(int edge, int branchingFactor) {
        if (branchingFactor <= 0) {
            branchingFactor = 1;
        }
        this.branchingFactor[edge] = branchingFactor;
        this.m_updatedValues.clear();
    }

    public DataDirector createDataDirector() {
        return this;
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        this.listener = l;
        l.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
    }

    public void removeDataDirectorListener(DataDirectorListener l) {
    }

    public Object clone() {
        return new LocalPivotTableDataSource();
    }

    public DataMap getDataMap() {
        return new DataMap("");
    }

    public MetadataMap getMetadataMap(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return new MetadataMap((String)null);
    }

    private void checkEdge(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge > 1) {
            throw new EdgeOutOfRangeException(edge, 1);
        }
    }

    private void checkLayer(int edge, int layer) throws LayerOutOfRangeException {
        if (layer < 0 || layer >= this.layerCount[edge]) {
            throw new LayerOutOfRangeException(layer, this.layerCount[edge] - 1);
        }
    }

    private void checkSlice(int edge, int slice) throws SliceOutOfRangeException {
        if (slice < 0 || slice >= this._getEdgeExtent(edge)) {
            throw new SliceOutOfRangeException(slice, this._getEdgeExtent(edge) - 1);
        }
    }

    private void checkRowColumn(int row, int column) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (row < 0 || row >= this._getEdgeExtent(1)) {
            throw new RowOutOfRangeException((long)row, (long)(this._getEdgeExtent(1) - 1));
        }
        if (column < 0 || column >= this._getEdgeExtent(0)) {
            throw new ColumnOutOfRangeException((long)column, (long)(this._getEdgeExtent(0) - 1));
        }
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        try {
            return this._getEdgeExtent(edge);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EdgeOutOfRangeException(edge, 1);
        }
    }

    private int _getEdgeExtent(int edge) {
        if (this.layerCount[edge] == 0 && this.edgeExtent[edge] > 1) {
            return 1;
        }
        return this.edgeExtent[edge];
    }

    public Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        String key;
        this.checkRowColumn(row, col);
        if (type != null && type.equals("dataValue") && this.m_updatedValues.containsKey(key = "r" + row + "c" + col)) {
            return this.m_updatedValues.get(key);
        }
        return MessageFormat.format(this.cellStr, row + ", " + col);
    }

    public boolean setValue(Object data, int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        if (type != null && type.equals("dataValue")) {
            String key = "r" + row + "c" + col;
            this.m_updatedValues.put(key, data);
            return true;
        }
        return false;
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        this.checkEdge(edge);
        return this._getLayerCount(edge);
    }

    private int _getLayerCount(int edge) {
        return this.layerCount[edge];
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkSlice(edge, slice);
        return this.layerCount[edge];
    }

    public int getSliceOutlineLayer(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkSlice(edge, slice);
        return 0;
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return this._getMemberDepth(edge, layer, slice);
    }

    private int _getMemberDepth(int edge, int layer, int slice) {
        return 1;
    }

    public int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return this._getMemberStartLayer(edge, layer, slice);
    }

    private int _getMemberStartLayer(int edge, int layer, int slice) {
        return layer;
    }

    public int getMemberLogicalLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return layer;
    }

    public Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        return this._getLayerMetadata(edge, layer, type);
    }

    private String _getLayerMetadata(int edge, int layer, String type) {
        String leadingZero = layer < 10 ? "0" : "";
        return "Edge" + edge + "Layer" + leadingZero + layer;
    }

    public int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        int extent = this._getMemberExtent(edge, layer, slice);
        int startSlice = slice - LocalPivotTableDataSource.mathMod(slice, extent);
        int maxExtent = this._getEdgeExtent(edge) - startSlice;
        return Math.min(extent, maxExtent);
    }

    private int _getMemberExtent(int edge, int layer, int slice) {
        return (int)Math.pow(this.branchingFactor[edge], this.layerCount[edge] - layer - 1);
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return this._getMemberStartSlice(edge, layer, slice);
    }

    private int _getMemberStartSlice(int edge, int layer, int slice) {
        return slice - LocalPivotTableDataSource.mathMod(slice, this._getMemberExtent(edge, layer, slice));
    }

    public Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("drillState")) {
            return 0;
        }
        int startLayer = this.getMemberStartLayer(edge, layer, slice);
        int startSlice = this.getMemberStartSlice(edge, layer, slice);
        switch (edge) {
            case 0: {
                String value = "";
                for (int i = 0; i < layer + 1; ++i) {
                    int count;
                    int leaves = (int)Math.pow(this.branchingFactor[0], this.getLayerCount(edge) - i - 1);
                    if (i != 0) {
                        for (count = slice / leaves; count >= this.branchingFactor[0]; count -= this.branchingFactor[0]) {
                        }
                    }
                    value = i == layer ? value + count : value + count + ", ";
                }
                return MessageFormat.format(this.columnStr, value);
            }
            case 1: {
                String value = "";
                for (int i = 0; i < layer + 1; ++i) {
                    int count;
                    int leaves = (int)Math.pow(this.branchingFactor[1], this.getLayerCount(edge) - i - 1);
                    if (i != 0) {
                        for (count = slice / leaves; count >= this.branchingFactor[1]; count -= this.branchingFactor[1]) {
                        }
                    }
                    value = i == layer ? value + count : value + count + ", ";
                }
                return MessageFormat.format(this.rowStr, value);
            }
        }
        throw new EdgeOutOfRangeException(edge, 1);
    }

    public boolean isFetched(int[] startSlice, int[] endSlice) throws SliceOutOfRangeException {
        return true;
    }

    public boolean forceFetch(int[] startSlice, int[] endSlice) throws SliceOutOfRangeException {
        return true;
    }

    public boolean isMemberExtentComplete(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return true;
    }

    public int getEdgeCount() {
        return 2;
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int getEdgeCurrentSlice(int edge) throws EdgeOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getEdgeCurrentHPos(int edge) throws EdgeOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getSlicesFromQDR(QDRInterface qdr, int[] startSlices, int[] endSlices) {
        TreeMap sortedMap = new TreeMap(qdr);
        int[] returnValue = new int[]{-1, -1};
        int parentEdge = -1;
        int parentLayer = -1;
        int parentSlice = -1;
        int parentDepth = -1;
        int parentExtent = -1;
        for (Map.Entry entry : sortedMap.entrySet()) {
            int slice;
            int layer;
            int edge;
            String key = (String)entry.getKey();
            if (!key.startsWith("Edge") || key.indexOf("Layer") != 5 || key.length() != 12) {
                return new int[]{-1, -1};
            }
            try {
                edge = Integer.valueOf(key.substring(4, 5));
                layer = Integer.valueOf(key.substring(10));
                slice = Integer.valueOf(entry.getValue().toString());
            }
            catch (NumberFormatException e) {
                return new int[]{-1, -1};
            }
            catch (IndexOutOfBoundsException e) {
                return new int[]{-1, -1};
            }
            if (edge < 0 || edge > 1 || layer < 0 || layer >= this._getLayerCount(edge) || layer != this._getMemberStartLayer(edge, layer, slice) || slice < 0 || slice >= this._getEdgeExtent(edge) || slice != this._getMemberStartSlice(edge, layer, slice)) {
                return new int[]{-1, -1};
            }
            if (parentEdge != edge) {
                if (layer != 0) {
                    return new int[]{-1, -1};
                }
                parentEdge = edge;
            } else if (parentLayer + parentDepth != layer || slice < parentSlice || slice >= parentSlice + parentExtent) {
                return new int[]{-1, -1};
            }
            parentLayer = layer;
            parentSlice = slice;
            parentDepth = this._getMemberDepth(edge, layer, slice);
            parentExtent = this._getMemberExtent(edge, layer, slice);
            returnValue[edge] = slice;
        }
        return returnValue;
    }

    public int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public int findMember(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public void release() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public void startGroupEdit() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public void endGroupEdit() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean submitChanges() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean undoEdit() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean redoEdit() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean dropChanges() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public void setAutoSubmit(boolean bValue) {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean isAutoSubmit() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public Vector getQDRoverrideCollection() {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public List getUniqueMemberMetadata(int edge, int layer, String[] types, int start, int count) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public List getUniqueMemberMetadata(String layerName, String[] types, int start, int count) throws LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public List getCorrespondingMemberMetadata(int edge, int layer, String[] values, String[] types, boolean inDataAccess) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public List getCorrespondingMemberMetadata(String layerName, String[] values, String[] types, boolean inDataAccess) throws LayerOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public List getUniqueDataValues(String name, String[] types, int start, int count) throws LayerOutOfRangeException, SliceOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean allSlicesFetched(int edge) throws EdgeOutOfRangeException {
        throw new UnsupportedOperationException("This test class does not implement this method.");
    }

    public boolean isFetched(int[] startSlice, int[] endSlice, int flag) throws SliceOutOfRangeException {
        return true;
    }

    public boolean forceFetch(int[] startSlice, int[] endSlice, int flag) throws SliceOutOfRangeException {
        return true;
    }

    public DataMap getSupportedDataMap() {
        String[] supported = new String[]{"dataValue"};
        return new DataMap(supported);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] supported = new String[]{"label", "drillState"};
        return new MetadataMap(supported);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] supported = new String[]{"layerLabel"};
        return new LayerMetadataMap(supported);
    }

    public QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkLayer(edge, layer);
        this.checkSlice(edge, slice);
        return this._getMemberQDR(edge, layer, slice, flags);
    }

    private QDR _getMemberQDR(int edge, int layer, int slice, int flags) {
        QDR qdr = new QDR();
        for (int lyr = 0; lyr <= layer; ++lyr) {
            if (this._getMemberStartLayer(edge, lyr, slice) != lyr) continue;
            String layerName = this._getLayerMetadata(edge, lyr, "layerLabel");
            int startSlice = this._getMemberStartSlice(edge, lyr, slice);
            qdr.addDimMemberPair(layerName, Integer.toString(startSlice));
        }
        return qdr;
    }

    public QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        this.checkRowColumn(row, column);
        QDR rowQdr = this._getSliceQDR(1, row, flags);
        QDR colQdr = this._getSliceQDR(0, column, flags);
        for (Object entryObj : colQdr.entrySet()) {
            Map.Entry entry = (Map.Entry)entryObj;
            rowQdr.addDimMemberPair((String)entry.getKey(), (String)entry.getValue());
        }
        return rowQdr;
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        this.checkEdge(edge);
        this.checkSlice(edge, slice);
        return this._getSliceQDR(edge, slice, flags);
    }

    private QDR _getSliceQDR(int edge, int slice, int flags) {
        return this._getMemberQDR(edge, this._getLayerCount(edge) - 1, slice, flags);
    }

    private static int mathMod(int a, int b) {
        int retVal = a % b;
        if (retVal < 0) {
            retVal += Math.abs(b);
        }
        return retVal;
    }
}

