/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.DataComponentHandle;

public class BoxPlotDataComponentHandle
extends DataComponentHandle {
    private static final long serialVersionUID = 1L;
    private int m_minIndex = -1;
    private int m_tenIndex = -1;
    private int m_q1Index = -1;
    private int m_medianIndex = -1;
    private int m_q3Index = -1;
    private int m_ninetyIndex = -1;
    private int m_maxIndex = -1;
    private int m_dataPointsPerMarker = 0;

    public BoxPlotDataComponentHandle(int id, String name, Object comp, int r, int c, int group, int series, int min, int t, int fq, int med, int lq, int n, int max) {
        super(id, name, comp, r, c, group, series);
        this.m_minIndex = min;
        this.m_tenIndex = t;
        this.m_q1Index = fq;
        this.m_medianIndex = med;
        this.m_q3Index = lq;
        this.m_ninetyIndex = n;
        this.m_maxIndex = max;
        this.m_dataPointsPerMarker = 5;
        if (this.m_tenIndex > -1 && this.m_ninetyIndex > -1) {
            this.m_dataPointsPerMarker = 7;
        }
    }

    @Override
    public int getGroup() {
        return super.getGroup() * this.m_dataPointsPerMarker;
    }

    public Object getMinValue(String attrName) {
        if (this.m_dataAccess != null && this.m_minIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_minIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_minIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getTenValue(String attrName) {
        if (this.m_dataAccess != null && this.m_tenIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_tenIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_tenIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getQ1Value(String attrName) {
        if (this.m_dataAccess != null && this.m_q1Index > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_q1Index, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_q1Index, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getMedianValue(String attrName) {
        if (this.m_dataAccess != null && this.m_medianIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_medianIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_medianIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getQ3Value(String attrName) {
        if (this.m_dataAccess != null && this.m_q3Index > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_q3Index, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_q3Index, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getNinetyValue(String attrName) {
        if (this.m_dataAccess != null && this.m_ninetyIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_ninetyIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_ninetyIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Object getMaxValue(String attrName) {
        if (this.m_dataAccess != null && this.m_maxIndex > -1) {
            try {
                if (this.m_seriesAreRows) {
                    return this.m_dataAccess.getValue(this.getRow(), this.getColumn() + this.m_maxIndex, attrName);
                }
                return this.m_dataAccess.getValue(this.getRow() + this.m_maxIndex, this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Attributes[] getMinAttributes() {
        if (this.m_minIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_minIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_minIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getTenAttributes() {
        if (this.m_tenIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_tenIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_tenIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getQ1Attributes() {
        if (this.m_q1Index == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_q1Index;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_q1Index;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getMedianAttributes() {
        if (this.m_medianIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_medianIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_medianIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getQ3Attributes() {
        if (this.m_q3Index == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_q3Index;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_q3Index;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getNinetyAttributes() {
        if (this.m_ninetyIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_ninetyIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_ninetyIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getMaxAttributes() {
        if (this.m_maxIndex == -1) {
            return null;
        }
        int edge = 1;
        int slice = this.getRow() + this.m_maxIndex;
        if (this.m_seriesAreRows) {
            edge = 0;
            slice = this.getColumn() + this.m_maxIndex;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, slice, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }
}

