/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.Map;
import oracle.dss.dataView.AttributeFormatter;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class AttributeFormatUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAttributeFormattedMemberMetadataValue(CommonDataview dataView, int edge, int slice, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        Object value = null;
        try {
            Object metadata = dataView.getDataAccess().getMemberMetadata(edge, layer, slice, "date");
            if (metadata == null) {
                metadata = dataView.getDataAccess().getMemberMetadata(edge, layer, slice, "dataValue");
            }
            if (metadata == null) {
                metadata = dataView.getDataAccess().getMemberMetadata(edge, layer, slice, "value");
            }
            value = AttributeFormatUtils.getAttributeFormattedValue(dataView, edge, layer, metadata);
            return value;
        }
        catch (Exception e) {
            dataView.getErrorHandler().log(e.getMessage(), "AttributeFormatUtils", "getAttributeFormattedMemberMetadataValue( CommonDataview, int, int, int )");
        }
        finally {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAttributeFormattedSliceValue(CommonDataview dataView, int edge, int slice, String memberLabelType) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        String trimmedLabel = null;
        Map<Object, Object> context = dataView.getContext();
        if (context == null || !Boolean.TRUE.equals(context.get(Perspective.faces_environment)) || !AttributeFormatUtils.isAtLeastOneFormatterPresent(dataView, edge, slice, memberLabelType)) {
            return trimmedLabel;
        }
        try {
            DataAccess dataAccess = dataView.getDataAccess();
            String label = "";
            int max = dataAccess.getLayerCount(edge);
            for (int i = 0; i < max; i += dataAccess.getMemberDepth(edge, i, slice)) {
                Object currentValue = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(dataView, edge, slice, i);
                if (currentValue == null) {
                    currentValue = dataAccess.getMemberMetadata(edge, i, slice, memberLabelType);
                }
                if (currentValue == null) continue;
                label = label + currentValue + " ";
            }
            trimmedLabel = label.trim();
            return trimmedLabel;
        }
        catch (Exception e) {
            dataView.getErrorHandler().log(e.getMessage(), "AttributeFormatUtils", "getAttributeFormattedSliceValue( CommonDataview, int, int, String )");
        }
        finally {
            return trimmedLabel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAttributeFormattedValue(CommonDataview dataView, int edge, int layer, Object value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        String formattedValue = null;
        try {
            AttributeFormatter attributeFormatter = dataView.getAttributeFormatter();
            if (value != null) {
                Object layerLabel = dataView.getDataAccess().getLayerMetadata(edge, layer, "layerName");
                if (attributeFormatter.hasAttributeFormatter(layerLabel)) {
                    formattedValue = attributeFormatter.formatAsString(layerLabel, value);
                    return formattedValue;
                }
            }
        }
        catch (Exception e) {
            dataView.getErrorHandler().log(e.getMessage(), "AttributeFormatUtils", "getAttributeFormattedValue( CommonDataview, int, int, Object )");
        }
        finally {
            return formattedValue;
        }
    }

    private static boolean isAtLeastOneFormatterPresent(CommonDataview dataView, int edge, int slice, Object value) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        try {
            DataAccess dataAccess = dataView.getDataAccess();
            int max = dataAccess.getLayerCount(edge);
            for (int i = 0; i < max; i += dataAccess.getMemberDepth(edge, i, slice)) {
                try {
                    Object layerLabel;
                    AttributeFormatter attributeFormatter = dataView.getAttributeFormatter();
                    if (value == null || !attributeFormatter.hasAttributeFormatter(layerLabel = dataView.getDataAccess().getLayerMetadata(edge, i, "layerName"))) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

