/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class AdornmentLayout
extends FlowLayout {
    private static final long serialVersionUID = 1L;

    public AdornmentLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getBounds().width - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(target.getBounds().width < d.width ? target.getBounds().width : d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += target.getBounds().width < d.width ? target.getBounds().width : d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i);
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.setLocation(x, y + (height - m.getBounds().height) / 2);
                x += this.getHgap() + m.getBounds().width;
            }
        }
    }
}

