/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency.extension;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.dependency.extension.DeclarationProviderInfo;
import oracle.ideimpl.dependency.extension.DependencyInfoConstants;
import oracle.ideimpl.dependency.extension.ReferenceProviderInfo;
import oracle.javatools.data.HashStructure;

public class DependencyInfo
implements DependencyInfoConstants {
    public static final ElementName DEPENDENCY_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "dependency-hook");
    private static final DependencyInfo INSTANCE = new DependencyInfo();
    private final List<DeclarationProviderInfo> declarationProviders = new CopyOnWriteArrayList<DeclarationProviderInfo>();
    private final List<ReferenceProviderInfo> referenceProviders = new CopyOnWriteArrayList<ReferenceProviderInfo>();

    public static DependencyInfo getInstance() {
        return INSTANCE;
    }

    private DependencyInfo() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HashStructureHook hook = (HashStructureHook)registry.getHook(DEPENDENCY_HOOK_NAME);
        if (hook != null) {
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                public void listenerAttached(HashStructureHookEvent e) {
                    DependencyInfo.this.processDependencyInfo(e.getCombinedHashStructure());
                }

                public void elementVisited(HashStructureHookEvent e) {
                    DependencyInfo.this.processDependencyInfo(e.getNewElementHashStructure());
                }
            });
        }
    }

    private void processDependencyInfo(HashStructure hash) {
        List data = hash.getAsList("declaration-provider");
        if (data != null) {
            for (HashStructure h : data) {
                this.declarationProviders.add(new DeclarationProviderInfo(h));
            }
        }
        if ((data = hash.getAsList("reference-provider")) != null) {
            for (HashStructure h : data) {
                this.referenceProviders.add(new ReferenceProviderInfo(h));
            }
        }
    }

    public List<DeclarationProviderInfo> getDelcarationProviders() {
        return Collections.unmodifiableList(this.declarationProviders);
    }

    public List<ReferenceProviderInfo> getReferenceProviders() {
        return Collections.unmodifiableList(this.referenceProviders);
    }
}

