/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.tint;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import oracle.ide.ceditor.tint.BlockPainter;
import oracle.ide.ceditor.tint.TintModel;
import oracle.ide.ceditor.tint.TintOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicEditorPainter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractTintPlugin
implements EditorPlugin {
    protected TintModel model;
    protected BlockPainter painter;
    protected BasicEditorPane editor;
    private TintOptionL tintOptionL;
    private BasicEditorPainter editorPainter = new PainterDelegator();

    public abstract TintModel createModel();

    public abstract BlockPainter createPainter();

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        this.painter = this.createPainter();
        this.model = this.createModel();
        editor.registerPainter(this.editorPainter);
        this.tintOptionL = new TintOptionL();
        TintOptions.getInstance((PropertyStorage)Preferences.getPreferences()).addStructureChangeListener(this.tintOptionL);
    }

    public void deinstall(BasicEditorPane editor) {
        editor.unregisterPainter(this.editorPainter);
        this.editor = null;
        TintOptions.getInstance((PropertyStorage)Preferences.getPreferences()).removeStructureChangeListener(this.tintOptionL);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void tintEnabled(boolean tintEnabled) {
        this.editor.repaint();
    }

    private class TintOptionL
    extends StructureChangeListener {
        private TintOptionL() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            try {
                TintOptions options = TintOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                AbstractTintPlugin.this.tintEnabled(options.isEnabled());
                AbstractTintPlugin.this.editor.repaint();
            }
            catch (ExpiredTextBufferException expiredTextBufferException) {
                // empty catch block
            }
        }
    }

    private class PainterDelegator
    implements BasicEditorPainter {
        private PainterDelegator() {
        }

        public void paint(Graphics g, BasicEditorPane editor) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setClip(g.getClip());
            AbstractTintPlugin.this.painter.paint(g2, editor, AbstractTintPlugin.this.model);
            g2.dispose();
        }

        public int getPriority() {
            return -50;
        }
    }
}

