/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.Random;
import oracle.spatial.geometry.PSSegment;
import oracle.spatial.geometry.SkipListData;

final class SkipList {
    private static final int INITIAL_HEIGHT = 10;
    private int topLayer = 0;
    private SkipListData head;
    private Random generator = new Random(1L);

    SkipList() {
        this.head = new SkipListData();
        this.head.forward = new SkipListData[10];
    }

    void add(PSSegment pSSegment) {
        int n;
        SkipListData skipListData;
        SkipListData skipListData2 = new SkipListData();
        skipListData2.payload = pSSegment;
        pSSegment.node = skipListData2;
        int n2 = this.LSBZeroes();
        skipListData2.forward = new SkipListData[n2 + 1];
        if (n2 > this.topLayer) {
            this.topLayer = n2;
            if (this.topLayer > this.head.forward.length - 1) {
                skipListData = new SkipListData();
                skipListData.forward = new SkipListData[this.topLayer + 5];
                for (n = 0; n < this.head.forward.length; ++n) {
                    skipListData.forward[n] = this.head.forward[n];
                }
                this.head = skipListData;
            }
        }
        skipListData = this.head;
        for (n = this.topLayer; n >= 0; --n) {
            while (skipListData.forward[n] != null && skipListData2.payload.compareTo(skipListData.forward[n].payload) >= 0) {
                skipListData = skipListData.forward[n];
            }
            if (n > n2) continue;
            skipListData2.forward[n] = skipListData.forward[n];
            skipListData.forward[n] = skipListData2;
        }
        if (skipListData2.forward[0] != null) {
            skipListData2.forward[0].back = skipListData2;
        }
        if (skipListData != this.head) {
            skipListData2.back = skipListData;
        }
    }

    void remove(SkipListData skipListData) {
        int n;
        SkipListData[] skipListDataArray = new SkipListData[this.topLayer + 1];
        SkipListData skipListData2 = skipListData;
        for (n = 0; n <= this.topLayer; ++n) {
            skipListDataArray[n] = skipListData2;
            while (skipListData2 != null && skipListData2.forward.length < n + 2) {
                skipListData2 = skipListData2.forward[n];
            }
        }
        skipListData2 = this.head;
        for (n = this.topLayer; n >= 0; --n) {
            while (skipListData2.forward[n] != skipListDataArray[n]) {
                skipListData2 = skipListData2.forward[n];
            }
            if (skipListData2.forward[n] != skipListData) continue;
            skipListData2.forward[n] = skipListData.forward[n];
        }
        if (skipListData.forward[0] != null) {
            skipListData.forward[0].back = skipListData.back;
        }
        skipListData.forward = null;
        skipListData.back = null;
    }

    int compareIndex(SkipListData skipListData, SkipListData skipListData2) {
        SkipListData skipListData3 = skipListData;
        SkipListData skipListData4 = skipListData2;
        int n = 0;
        while (skipListData3 != skipListData4 && skipListData3 != null && skipListData4 != null) {
            int n2 = skipListData3.forward.length - 1;
            int n3 = skipListData4.forward.length - 1;
            if (n2 < n3) {
                n = -1;
                skipListData3 = skipListData3.forward[n2];
                continue;
            }
            n = 1;
            skipListData4 = skipListData4.forward[n3];
        }
        if (skipListData3 == null) {
            return 1;
        }
        if (skipListData4 == null) {
            return -1;
        }
        return n;
    }

    SkipListData first() {
        return this.head.forward[0];
    }

    private final int LSBZeroes() {
        int n = 0;
        int n2 = this.generator.nextInt();
        while ((n2 & 1) == 1) {
            ++n;
            n2 /= 2;
        }
        return n;
    }
}

